$(document).ready(async function () {
    let modoInclusao = false;
    let modoAlteracao = false;

    $('#btnIncluiContato').on('click', async function () {
        modoAlteracao = false;
        modoInclusao = true;
        desbloqueiaCampos();
        limpaCampos();
        $('#txtNumeroContato').val('');
    });

    $('#btnCancelarAlteracao').on('click', async function () {
        modoAlteracao = false;
        modoInclusao = false;
        bloqueiaCampos();
        await retornaContatos();
        if (await existeRegistroNoDataTable()) {
            await selectPrimeiraLinha();
            await carregaContato();
        };
    });

    $('#btnAlteraContatoDentroModal').on('click', async function () {
        modoAlteracao = true;
        modoInclusao = false;
        desbloqueiaCampos();
    });

    $('#btnDuplicarContato').on('click', async function () {
        modoAlteracao = false;
        modoInclusao = true;
        desbloqueiaCampos();
    })

    $('#btnGravaContato').on('click', async function () {
        if (modoAlteracao) {
            await alteraContato()
        } else {
            await incluiContato();
        }
    });

    $('#btnConsultaSetorEntidade').pesquisa_serverside(['#txtSetorContatoEntidade'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CADFLUXO", "camposSelect":[ "DESCRICAO", "CODIGO"], "where": null}', 'Pesquisa de Setor');
    $('#txtSetorContatoEntidade').autocompleta(1, 'JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
    $('#btnConsultaCargoEntidade').pesquisa_serverside(['#txtCargoContatoEntidade'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CARGO", "camposSelect":[ "DESCRICAO", "CODIGO"], "where": null}', 'Pesquisa de Cargo');
    $('#txtCargoContatoEntidade').autocompleta(1, 'JSON={ "tabela":"CARGO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
    $('#btnConsultaFuncaoContato').pesquisa_serverside(['#txtFuncaoContatoEntidade'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"FUNCAO", "camposSelect":[ "DESCRICAO", "CODIGO"], "where": null}', 'Pesquisa de Função');
    $('#txtFuncaoContatoEntidade').autocompleta(1, 'JSON={ "tabela":"FUNCAO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');

    $('#btnExcluir').on('click', async function () {
        if (!await existeRegistroNoDataTable()) {
            msgErro("Não existe contato para exclusão! Verifique.");
            return;
        }
        msgAlerta('Você realmente deseja excluir o registro selecionado?', async () => {
            await excluiContato();
        })
    });

    $('#btnFormataNumero').on('click', async function () {

        const sCEPEntidade = $('#txtCep').val();
        const pesquisaDDD = {
            camposSelect: [
                "CIDADE.DDD"
            ],
            tabela: "CADCEP",
            innerJoin: [
                { tabela: 'CIDADE', alias: "CIDADE", condicao: 'CIDADE.CODIGO=CADCEP.CODMUN' },
            ],
            where: [`CADCEP.CEP = '${sCEPEntidade}'`],
        }
        const jsonStrDDD = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaDDD));
        let numeroCelular = $('#txtCelularContato').val();
        let numeroDDD = jsonStrDDD[0].DDD;
        if (numeroDDD === '') {
            numeroDDD = '47'
        }
        if (numeroCelular.length >= 9) {
            if (numeroCelular.substring(0, 2) !== '55') {
                if (numeroCelular.substring(0, 2) !== numeroDDD) {
                    numeroCelular = '55' + numeroDDD + numeroCelular;
                } else {
                    numeroCelular = '55' + numeroCelular;
                }
            } else if (numeroCelular.substring(2, 4) !== numeroDDD) {
                numeroCelular = numeroCelular.replace('55', '55' + numeroDDD);
            }
        } else {
            msgErro('Por favor, insira um número de celular válido! Ex.: 5547988888888.')
        }

        $('#txtCelularContato').val(numeroCelular);
    });

    $('#modal-cadcontato').on('hide.bs.modal', async function () {
        modoAlteracao = false;
        modoInclusao = false;
        bloqueiaCampos();
    });

    $('#modal-cadcontato').on('show.bs.modal', async function () {
        bloqueiaCampos();
        await retornaContatos();
        if (await existeRegistroNoDataTable()) {
            await selectPrimeiraLinha();
            await carregaContato();
        };
        const nomeEntidade = `[${$('#txtCodCli').val()}] - ${$('#txtNome').val()}`
        $('#txtClienteContato').val(`${nomeEntidade}`);
        $('#lblEmailContato').html('E-mail:');
    });

    let options = {
        onKeyPress(cpf, ev, el, op) {
            let masks = ["000.000.000-000", "00.000.000/0000-00"];
            $("#txtCPFCNPJContato").mask(cpf.length > 14 ? masks[1] : masks[0], op);
        },
    };

    if ($("#txtCPFCNPJContato").length > 11) {
        $("#txtCPFCNPJContato").mask("00.000.000/0000-00", options);
    } else {
        $("#txtCPFCNPJContato").mask("000.000.000-00#", options);
    }

    $('#cbMaladireta').on('click', async function () {
        if (!modoInclusao && !modoAlteracao) {
            msgErro('Para desabilitar o checkbox, precisa estar alterando! Favor verificar.');
            $('#cbMaladireta').prop('checked', true);
        };
    });

    $('#cbWhatsApp').on('click', async function () {
        if (!modoInclusao && !modoAlteracao) {
            msgErro('Para desabilitar o checkbox, precisa estar alterando! Favor verificar.');
            $('#cbWhatsApp').prop('checked', true);
        };
    });

    $('#cbEmail').on('click', async function () {
        if (!modoInclusao && !modoAlteracao) {
            msgErro('Para desabilitar o checkbox, precisa estar alterando! Favor verificar.');
            $('#cbEmail').prop('checked', true);
        };
    });

    $('#btnSobeNaPrimeiraLinha').on('click', async function () {
        if (!await existeRegistroNoDataTable()) {
            msgAlerta('Não existe contatos cadastrados! Verifique.');
            return;
        };

        $('tr.selected').removeClass('selected');
        $($('#tabelaContatos tr')[1]).trigger('click');
    });

    $('#btnDesceNaUltimaLinha').on('click', async function () {
        if (!await existeRegistroNoDataTable()) {
            msgAlerta('Não existe contatos cadastrados! Verifique.');
            return;
        };

        const qtdeRows = $('#tabelaContatos').DataTable().data().toArray().length;
        $('tr.selected').removeClass('selected');
        $($('#tabelaContatos tr')[qtdeRows]).trigger('click');

    });

    $('#btnSobeUmaLinha').on('click', async function () {
        if (!await existeRegistroNoDataTable()) {
            msgAlerta('Não existe contatos cadastrados! Verifique.');
            return;
        };

        const linhaSelected = $($('tr.selected')[0]).index();

        if ((linhaSelected - 1) < 0) {
            msgAlerta('Você já está no primeiro registro!');
            return;
        };

        $('tr.selected').removeClass('selected');
        $($('#tabelaContatos tr')[linhaSelected]).trigger('click');
    });

    $('#btnDesceUmaLinha').on('click', async function () {
        if (!await existeRegistroNoDataTable()) {
            msgAlerta('Não existe contatos cadastrados! Verifique.');
            return;
        };

        const linhaSelected = $($('tr.selected')[0]).index() + 1;
        const linhaAbaixo = linhaSelected + 1;
        const qtdeRows = $('#tabelaContatos').DataTable().data().toArray().length;

        if ((linhaAbaixo - 1) === qtdeRows) {
            msgAlerta('Você já está no último registro!');
            return;
        };

        $($('#tabelaContatos tr')[linhaAbaixo]).trigger('click');
    });

    $('#cbContatoAtivo').on('click', async function () {
        if (!modoInclusao && !modoAlteracao) {
            msgErro('Para desabilitar o checkbox, precisa estar alterando! Favor verificar.');
            $('#cbContatoAtivo').prop('checked', true);
        };
    });

    $('#cbSomenteXML').on('click', async function () {
        if (!modoInclusao && !modoAlteracao) {
            msgErro('Para desabilitar o checkbox, precisa estar alterando! Favor verificar.');
            $('#cbSomenteXML').prop('checked', true);
        };
    });

    $('#selectModificacao2').on('change', async function () {
        if ($('#selectModificacao2').val() === '6') {
            const codclipesquisa = $('#txtCodCli').val()
            const numeropesquisa = $('#txtNumeroContato').val();
            $('#lblSomenteXML').removeClass('d-none');
            const PesquisaSomenteXML = {
                tabela: "CONTATO",
                camposSelect: ["CONTATO.SOMENTE_XML"
                ],
                where: [
                    `1=1 AND CONTATO.CODCLI = '${codclipesquisa}' AND CONTATO.NUMERO = '${numeropesquisa}'`,
                ],

            };
            const jsonStrPesquisa = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaSomenteXML));

            if (jsonStrPesquisa[0].SOMENTE_XML === 'S') {
                $('#cbSomenteXML').prop('checked', true);
            } else {
                $('#cbSomenteXML').prop('checked', false);
            }
        } else {
            $('#lblSomenteXML').addClass('d-none');
            $('#cbSomenteXML').prop('checked', false);
        }
    });

    async function incluiContato() {

        $('#lblEmailContato').html('...');
        try {
            if ($('#txtNomeContato').val() === '') {
                msgAlerta('Campo nome é obrigatório! Favor verifique.');
                return;
            };

            if ($('#selectModificacao2').val() === '6') {
                $('#lblSomenteXML').removeClass('d-none');
                $('#cbSomenteXML').prop('checked', true);
            } else {
                $('#lblSomenteXML').addClass('d-none');
                $('#cbSomenteXML').prop('checked', false);
            }

            const emailcontato = $('#zezinho').val() //Alterado pra 'zezinho' devido a b.o q deu com o autocomplete do chrome kkkkkkk, funcionou e time que ta ganhando nao se mexe, olhar na funcao incluicontato alteracao do label - Bruno
            if (emailcontato !== '') {
                if (!await validaEmail(emailcontato)) {
                    msgErro('Por favor, insira um endereço de e-mail válido.');
                    $('#zezinho').val('');
                    return;
                }
            }

            const cepEntidade = $('#txtCep').val();
            const pesquisaPais = {
                camposSelect: [
                    "CADCEP.COD_PAIS"
                ],
                tabela: "CADCEP",
                where: [`CADCEP.CEP = '${cepEntidade}'`],
            }
            const jsonStrDDD = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaPais));

            const codPais = jsonStrDDD[0].COD_PAIS;

            const entidadeCodcliContato = pegaChave('#txtClienteContato');
            const nomeContato = $('#txtNomeContato').val();
            const telefoneContato = $('#txtTelefoneContato').val();
            const celularContato = $('#txtCelularContato').val();
            const cpfCnpjContato = $('#txtCPFCNPJContato').val();
            const inscricaoContato = $('#txtInscricaoIEContato').val();
            const emailContato = $('#zezinho').val();
            const funcaoContato = pegaChave('#txtFuncaoContatoEntidade');
            const cargoContato = pegaChave('#txtCargoContatoEntidade');
            const setorContato = pegaChave('#txtSetorContatoEntidade');
            const textoContato = $('#txtDoContato').val();
            const observacaoContato = $('#txtObsContatoEntidade').val();
            const malaDiretaContato = $('#cbMaladireta').is(':checked');
            const ativoContato = $('#cbContatoAtivo').is(':checked');
            const tipoContatoCont = $('#cbPessoaJuridica').is(':checked') ? '1' : '0';
            const tipoCont = $('#selectModificacao2').val();
            const dtNascContato = $('#txtDataNascContato').val() == '' ? '1899-12-30' : $('#txtDataNascContato').val();
            const somenteXML = $('#cbSomenteXML').is(':checked');
            const autorizaWhatsApp = $('#cbWhatsApp').prop('checked') ? 'S' : 'N'
            const autorizaEmail = $('#cbEmail').prop('checked') ? 'S' : 'N'

            let dadosContatoNovo = {};

            dadosContatoNovo.ENTIDADECONTATONOVO = entidadeCodcliContato;
            dadosContatoNovo.NOMECONTATONOVO = nomeContato;
            dadosContatoNovo.TELEFONECONTATONOVO = telefoneContato;
            dadosContatoNovo.CELULARCONTATONOVO = celularContato;
            dadosContatoNovo.CPFCNPJCONTATONOVO = cpfCnpjContato;
            dadosContatoNovo.INSCRICAOCONTATONOVO = inscricaoContato;
            dadosContatoNovo.EMAILCONTATONOVO = emailContato;
            dadosContatoNovo.FUNCAOCONTATONOVO = funcaoContato;
            dadosContatoNovo.CARGOCONTATONOVO = cargoContato;
            dadosContatoNovo.SETORCONTATONOVO = setorContato;
            dadosContatoNovo.TEXTOCONTATONOVO = textoContato;
            dadosContatoNovo.OBSERVACAOCONTATONOVO = observacaoContato;
            dadosContatoNovo.MALADIRETACONTATONOVO = malaDiretaContato;
            dadosContatoNovo.ATIVOCONTATONOVO = ativoContato;
            dadosContatoNovo.TIPOCONTATONOVO = tipoContatoCont;
            dadosContatoNovo.TIPONOVO = tipoCont;
            dadosContatoNovo.DATANASCCONTATONOVO = dtNascContato;
            dadosContatoNovo.NUMEROCONTATOID = 0;
            dadosContatoNovo.SOMENTEXML = somenteXML;
            dadosContatoNovo.COD_PAIS = codPais;
            dadosContatoNovo.AUTORIZA_WHATSAPP = autorizaWhatsApp
            dadosContatoNovo.AUTORIZA_EMAIL = autorizaEmail

            const url = `/sisplan/cliente/v1/incluicontato?`;
            const response = await requisicao("POST", url, `JSON=${JSON.stringify(dadosContatoNovo)}`, '', 60000);

            if (response.status == 400 || response.status == 404) {
                const jsonMsg = await response.json();
                msgAlerta(jsonMsg.mensagem);
                return;
            };

            if (response.status === 200) {
                criaMensagemSucesso('Contato foi incluído com sucesso!',
                    setTimeout(() => {
                        $("#modal-cadcontato").modal("hide")
                    }, 2000));
                return;
            };

        } finally {
            $('#lblEmailContato').html('E-mail:');
        }
    };

    async function alteraContato() {

        if ($('#txtNomeContato').val() === '') {
            msgAlerta('Campo nome é obrigatório! Favor verifique.');
            return;
        };

        if ($('#selectModificacao2').val() === '6') {
            $('#lblSomenteXML').removeClass('d-none');
            $('#cbSomenteXML').prop('checked', true);
        } else {
            $('#lblSomenteXML').addClass('d-none');
            $('#cbSomenteXML').prop('checked', false);
        };

        const emailcontato = $('#zezinho').val() //Alterado pra 'zezinho' devido a b.o q deu com o autocomplete do chrome kkkkkkk, funcionou e time que ta ganhando nao se mexe, olhar na funcao incluicontato alteracao do label - Bruno
        if (emailcontato !== '') {
            if (!await validaEmail(emailcontato)) {
                msgErro('Por favor, insira um endereço de e-mail válido.');
                $('#zezinho').val('');
                return;
            }
        }

        const entidadeAlteracao = pegaChave('#txtClienteContato');
        const nomeContatoAlteracao = $('#txtNomeContato').val();
        const telefoneContatoAlteracao = $('#txtTelefoneContato').val();
        const celularContatoAlteracao = $('#txtCelularContato').val();
        const cpfCnpjContatoAlteracao = $('#txtCPFCNPJContato').val();
        const inscricaoContatoAlteracao = $('#txtInscricaoIEContato').val();
        const emailContatoAlteracao = $('#zezinho').val();
        const funcaoContatoAlteracao = pegaChave('#txtFuncaoContatoEntidade');
        const cargoContatoAlteracao = pegaChave('#txtCargoContatoEntidade');
        const setorContatoAlteracao = pegaChave('#txtSetorContatoEntidade');
        const textoContatoAlteracao = $('#txtDoContato').val();
        const observacaoContatoAlteracao = $('#txtObsContatoEntidade').val();
        const malaDiretaContatoAlteracao = $('#cbMaladireta').is(':checked');
        const ativoContatoAlteracao = $('#cbContatoAtivo').is(':checked');
        const tipoContatoContAlteracao = $('#cbPessoaJuridica').is(':checked') ? '1' : '0';
        const tipoContAlteracao = $('#selectModificacao2').val();
        const dtNascContatoAlteracao = $('#txtDataNascContato').val() == '' ? '1899-12-30' : $('#txtDataNascContato').val();
        const somenteXMLAlteracao = $('#cbSomenteXML').is(':checked');
        const numeroAlteracao = $('#txtNumeroContato').val();
        const autorizaWhatsApp = $('#cbWhatsApp').prop('checked') ? 'S' : 'N'
        const autorizaEmail = $('#cbEmail').prop('checked') ? 'S' : 'N'

        let dadosContatoAlterado = {};

        dadosContatoAlterado.ENTIDADECONTATONOVO = entidadeAlteracao;
        dadosContatoAlterado.NOMECONTATONOVO = nomeContatoAlteracao;
        dadosContatoAlterado.TELEFONECONTATONOVO = telefoneContatoAlteracao;
        dadosContatoAlterado.CELULARCONTATONOVO = celularContatoAlteracao;
        dadosContatoAlterado.CPFCNPJCONTATONOVO = cpfCnpjContatoAlteracao;
        dadosContatoAlterado.INSCRICAOCONTATONOVO = inscricaoContatoAlteracao;
        dadosContatoAlterado.EMAILCONTATONOVO = emailContatoAlteracao;
        dadosContatoAlterado.FUNCAOCONTATONOVO = funcaoContatoAlteracao;
        dadosContatoAlterado.CARGOCONTATONOVO = cargoContatoAlteracao;
        dadosContatoAlterado.SETORCONTATONOVO = setorContatoAlteracao;
        dadosContatoAlterado.TEXTOCONTATONOVO = textoContatoAlteracao;
        dadosContatoAlterado.OBSERVACAOCONTATONOVO = observacaoContatoAlteracao;
        dadosContatoAlterado.MALADIRETACONTATONOVO = malaDiretaContatoAlteracao;
        dadosContatoAlterado.ATIVOCONTATONOVO = ativoContatoAlteracao;
        dadosContatoAlterado.TIPOCONTATONOVO = tipoContatoContAlteracao;
        dadosContatoAlterado.TIPONOVO = tipoContAlteracao;
        dadosContatoAlterado.DATANASCCONTATONOVO = dtNascContatoAlteracao;
        dadosContatoAlterado.NUMEROCONTATOID = numeroAlteracao;
        dadosContatoAlterado.SOMENTEXML = somenteXMLAlteracao;
        dadosContatoAlterado.AUTORIZA_WHATSAPP = autorizaWhatsApp
        dadosContatoAlterado.AUTORIZA_EMAIL = autorizaEmail

        const url = `/sisplan/cliente/v1/alteracontato?`;
        const response = await requisicao("PUT", url, `JSON=${JSON.stringify(dadosContatoAlterado)}`, '', 60000);

        if (response.status == 400 || response.status == 404) {
            const jsonMsg = await response.json();
            msgAlerta(jsonMsg.mensagem);
            return;
        };

        if (response.status === 200) {
            criaMensagemSucesso('Contato foi alterado com sucesso!',
                setTimeout(() => {
                    $("#modal-cadcontato").modal("hide")
                }, 2000));
            return;
        };

    };


    async function excluiContato() {
        const codcliCliente = pegaChave('#txtClienteContato');
        const numeroCliente = $('#txtNumeroContato').val();
        let response = await requisicao("DELETE", "/sisplan/cliente/v1/deletacontato?", `CODCLI=${codcliCliente}&NUMERO=${numeroCliente}`, null);

        if (response.status === 400) {
            msgAlerta('Não foi possível fazer a exclusão do contato!');
            return;
        }
        if (response.status === 200) {
            criaMensagemSucesso('Contato selecionado foi excluído com sucesso!',
                setTimeout(() => {
                    $("#modal-cadcontato").modal("hide")
                }, 2000)
            );
            return;
        }
    };

    async function carregaContato() {

        const indiceSelecionado = $($('#tabelaContatos tr.selected')[0]).index();
        const linhaSelecionada = $('#tabelaContatos').DataTable().row(indiceSelecionado).data();

        linhaSelecionada.NOME !== '' && linhaSelecionada.NOME !== null ? $('#txtNomeContato').val(linhaSelecionada.NOME) : $('#txtNomeContato').val('');
        linhaSelecionada.TELEFONE !== '' && linhaSelecionada.TELEFONE !== null ? $('#txtTelefoneContato').val(linhaSelecionada.TELEFONE) : $('#txtTelefoneContato').val('');
        linhaSelecionada.CELULAR !== '' && linhaSelecionada.CELULAR !== null ? $('#txtCelularContato').val(linhaSelecionada.CELULAR) : $('#txtCelularContato').val('');
        linhaSelecionada.CPF_CNPJ !== '' && linhaSelecionada.CPF_CNPJ !== null ? $('#txtCPFCNPJContato').val(linhaSelecionada.CPF_CNPJ) : $('#txtCPFCNPJContato').val('');
        linhaSelecionada.INSCRICAO !== '' && linhaSelecionada.INSCRICAO !== null ? $('#txtInscricaoIEContato').val(linhaSelecionada.INSCRICAO) : $('#txtInscricaoIEContato').val('');
        linhaSelecionada.EMAIL !== '' && linhaSelecionada.EMAIL !== null ? $('#zezinho').val(linhaSelecionada.EMAIL) : $('#zezinho').val('');
        linhaSelecionada.DATA_NASC !== '' && linhaSelecionada.DATA_NASC !== null ? $('#txtDataNascContato').val(linhaSelecionada.DATA_NASC) : $('#txtDataNascContato').val('');
        linhaSelecionada.FUNCAO !== '' && linhaSelecionada.FUNCAO !== null ? $('#txtFuncaoContatoEntidade').val(`[${linhaSelecionada.FUNCAO}] - ${linhaSelecionada.DESC_FUNCAO}`) : $('#txtFuncaoContatoEntidade').val('');
        linhaSelecionada.CARGO !== '' && linhaSelecionada.CARGO !== null ? $('#txtCargoContatoEntidade').val(`[${linhaSelecionada.CARGO}] - ${linhaSelecionada.DESC_CARGO}`) : $('#txtCargoContatoEntidade').val('');
        linhaSelecionada.ID_SETOR !== '' && linhaSelecionada.ID_SETOR !== null ? $('#txtSetorContatoEntidade').val(`[${linhaSelecionada.ID_SETOR}] -  ${linhaSelecionada.DESC_SETOR}`) : $('#txtSetorContatoEntidade').val('');
        linhaSelecionada.TEXTO !== '' && linhaSelecionada.TEXTO !== null ? $('#txtDoContato').val(linhaSelecionada.TEXTO) : $('#txtDoContato').val('');
        linhaSelecionada.OBSERVACAO !== '' && linhaSelecionada.OBSERVACAO !== null ? $('#txtObsContatoEntidade').val(linhaSelecionada.OBSERVACAO) : $('#txtObsContatoEntidade').val('');
        linhaSelecionada.NUMERO !== '' && linhaSelecionada.NUMERO !== null ? $('#txtNumeroContato').val(linhaSelecionada.NUMERO) : $('#txtNumeroContato').val('');
        linhaSelecionada.MALA_DIRETA === 'S' ? ($('#cbMaladireta').prop('checked', true), $('#cbMaladireta').prop('disabled', false)) : ($('#cbMaladireta').prop('checked', false), $('#cbMaladireta').prop('disabled', true));
        linhaSelecionada.TIPO_CONTATO === '1' ? ($('#cbPessoaJuridica').prop('checked', true), $('#cbPessoaFisica').prop('checked', false), $('#cbPessoaJuridica').prop('disabled', false), $('#cbPessoaFisica').prop('disabled', true)) : ($('#cbPessoaJuridica').prop('checked', false), $('#cbPessoaFisica').prop('checked', true), $('#cbPessoaFisica').prop('disabled', false), $('#cbPessoaJuridica').prop('disabled', true));
        linhaSelecionada.ATIVO === 'S' ? ($('#cbContatoAtivo').prop('checked', true), $('#cbContatoAtivo').prop('disabled', false)) : ($('#cbContatoAtivo').prop('checked', false), $('#cbContatoAtivo').prop('disabled', true));
        linhaSelecionada.SOMENTE_XML === 'S' ? ($('#cbSomenteXML').prop('checked', true), $('#cbSomenteXML').prop('disabled', false)) : ($('#cbSomenteXML').prop('checked', false), $('#cbSomenteXML').prop('disabled', true));
        linhaSelecionada.AUTORIZA_WHATSAPP === 'S' ? ($('#cbWhatsApp').prop('checked', true), $('#cbWhatsApp').prop('disabled', false)) : ($('#cbWhatsApp').prop('checked', false), $('#cbWhatsApp').prop('disabled', true))
        linhaSelecionada.AUTORIZA_EMAIL === 'S' ? ($('#cbEmail').prop('checked', true), $('#cbEmail').prop('disabled', false)) : ($('#cbEmail').prop('checked', false), $('#cbEmail').prop('disabled', true))

        if (linhaSelecionada.TIPO === 'Agendamento') {
            $('#selectModificacao2').val(0);
        } else if (linhaSelecionada.TIPO === 'Comercial') {
            $('#selectModificacao2').val(1);
        } else if (linhaSelecionada.TIPO === 'Compras') {
            $('#selectModificacao2').val(2);
        } else if (linhaSelecionada.TIPO === 'Estilista') {
            $('#selectModificacao2').val(3);
        } else if (linhaSelecionada.TIPO === 'Financeiro') {
            $('#selectModificacao2').val(4);
        } else if (linhaSelecionada.TIPO === 'Laboratório') {
            $('#selectModificacao2').val(5);
        } else if (linhaSelecionada.TIPO === 'NFe') {
            $('#selectModificacao2').val(6);
        } else if (linhaSelecionada.TIPO === 'Orçamento') {
            $('#selectModificacao2').val(7);
        } else if (linhaSelecionada.TIPO === 'Ord.Produção') {
            $('#selectModificacao2').val(8);
        } else if (linhaSelecionada.TIPO === 'Pagar') {
            $('#selectModificacao2').val(9);
        } else if (linhaSelecionada.TIPO === 'Receber') {
            $('#selectModificacao2').val(10);
        } else if (linhaSelecionada.TIPO === 'SAC') {
            $('#selectModificacao2').val(11);
        } else if (linhaSelecionada.TIPO === 'Serviço') {
            $('#selectModificacao2').val(12);
        } else if (linhaSelecionada.TIPO === 'Sócio/Gerente') {
            $('#selectModificacao2').val(13);
        } else if (linhaSelecionada.TIPO === 'Vendas') {
            $('#selectModificacao2').val(14);
        } else if (linhaSelecionada.TIPO === 'Qualidade') {
            $('#selectModificacao2').val(15);
        } else if (linhaSelecionada.TIPO === 'Marketing') {
            $('#selectModificacao2').val(16);
        } else if (linhaSelecionada.TIPO === 'Ref.Comerciais') {
            $('#selectModificacao2').val(17);
        } else if (linhaSelecionada.TIPO === 'CTe') {
            $('#selectModificacao2').val(18);
        } else if (linhaSelecionada.TIPO === 'Representante') {
            $('#selectModificacao2').val(19);
        } else if (linhaSelecionada.TIPO === 'Facção') {
            $('#selectModificacao2').val(20);
        } else if (linhaSelecionada.TIPO === 'RH') {
            $('#selectModificacao2').val(21);
        } else if (linhaSelecionada.TIPO === 'Tecelagem') {
            $('#selectModificacao2').val(22);
        };

        if (linhaSelecionada.TIPO === 'NFe') {
            $('#lblSomenteXML').removeClass('d-none');
        } else {
            $('#lblSomenteXML').addClass('d-none');
        }
    };

    async function retornaContatos() {

        if ($.fn.DataTable.isDataTable('#tabelaContatos')) {
            $('#tabelaContatos').DataTable().destroy();
            $('#tabelaContatos').empty();
        };

        const codcliEntidadeContato = $('#txtCodCli').val()

        const PesquisaContatosJaCad = {
            tabela: "CONTATO",
            camposSelect: ["CONTATO.NUMERO",
                "CONTATO.CODCLI",
                "CONTATO.NOME",
                "CONTATO.DT_NASC AS DATA_NASC",
                "CONTATO.FONE AS TELEFONE",
                "CONTATO.CELULAR",
                "CONTATO.EMAIL",
                "CONTATO.TIPO",
                "CONTATO.TEXTO",
                "CONTATO.OBS AS OBSERVACAO",
                "CONTATO.CPF_CNPJ",
                "CONTATO.INSCRICAO",
                "CONTATO.TIPO_CONTATO",
                "CONTATO.MALA_DIRETA",
                "CONTATO.FUNCAO",
                "FUNCAO.DESCRICAO DESC_FUNCAO",
                "CONTATO.CARGO",
                "CARGO.DESCRICAO DESC_CARGO",
                "CONTATO.SOMENTE_XML",
                "CONTATO.ID_SETOR",
                "SETOR.DESCRICAO AS DESC_SETOR",
                "CONTATO.ID_ENT",
                "CONTATO.ATIVO",
                "CONTATO.AUTORIZA_WHATSAPP",
                "CONTATO.AUTORIZA_EMAIL"
            ],
            leftJoin: [
                { tabela: "FUNCAO", alias: "FUNCAO", "condicao": "FUNCAO.CODIGO = CONTATO.FUNCAO" },
                { tabela: "CARGO", alias: "CARGO", "condicao": "CARGO.CODIGO = CONTATO.CARGO" },
                { tabela: "CADFLUXO", alias: "SETOR", "condicao": "SETOR.ID = CONTATO.ID_SETOR" },
            ],
            where: [
                `1=1 AND CONTATO.CODCLI = '${codcliEntidadeContato}'`,
            ],
            orderBy: [
                "CONTATO.NUMERO",
            ]

        };

        const jsonStrContatosPesquisa = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaContatosJaCad));

        const FormatoDtNovo = 'DD/MM/YYYY';

        const dataSetColsModal = [];

        dataSetColsModal.push({
            title: 'Número',
            data: 'NUMERO',
        });

        dataSetColsModal.push({
            title: 'Código',
            data: 'CODCLI',
        });

        dataSetColsModal.push({
            title: 'Nome',
            data: 'NOME',
        });

        dataSetColsModal.push({
            title: 'Data Nasc.',
            data: 'DATA_NASC',
        });

        dataSetColsModal.push({
            title: 'Telefone',
            data: 'TELEFONE',
        });

        dataSetColsModal.push({
            title: 'Celular',
            data: 'CELULAR',
        });

        dataSetColsModal.push({
            title: 'E-mail',
            data: 'EMAIL',
        });

        dataSetColsModal.push({
            title: 'Tipo',
            data: 'TIPO',
        });

        dataSetColsModal.push({
            title: 'Observações',
            data: 'OBSERVACAO',
        });

        dataSetColsModal.push({
            title: 'CPF/CNPJ',
            data: 'CPF_CNPJ',
        });

        dataSetColsModal.push({
            title: 'Inscrição',
            data: 'INSCRICAO',
        });

        dataSetColsModal.push({
            title: 'Cargo',
            data: 'CARGO',
        });

        dataSetColsModal.push({
            title: 'Desc Cargo',
            data: 'DESC_CARGO',
        });

        dataSetColsModal.push({
            title: 'Função',
            data: 'FUNCAO',
        });

        dataSetColsModal.push({
            title: 'Desc Função',
            data: 'DESC_FUNCAO',
        });

        dataSetColsModal.push({
            title: 'Setor',
            data: 'ID_SETOR',
        });

        dataSetColsModal.push({
            title: 'Desc Setor',
            data: 'DESC_SETOR',
        });

        dataSetColsModal.push({
            title: 'ID Ent',
            data: 'ID_ENT',
        });

        dataSetColsModal.push({
            title: 'Autoriza WhatsApp',
            data: 'AUTORIZA_WHATSAPP',
        });

        dataSetColsModal.push({
            title: 'Autoriza E-mail',
            data: 'AUTORIZA_EMAIL',
        });

        $('#tabelaContatos').DataTable({
            bPaginate: false,
            destroy: true,
            search: false,
            filter: false,
            info: true,
            order: false,
            columns: dataSetColsModal,
            data: jsonStrContatosPesquisa,
            columnDefs: [{
                type: 'date-br',
                targets: [3],
                render(data) {
                    if (data) {
                        return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                    } else {
                        return '';
                    }

                },
            }]
        });

        $("#tabelaContatos tbody").on("click", "tr", async function () {
            if (!modoAlteracao && !modoInclusao) {
                $("#tabelaContatos").dataTable().$("tr.selected").removeClass("selected");
                $(this).addClass("selected");
                await carregaContato();
            } else {
                msgErro('Você já está alterando/incluindo um registro! Favor verificar.');
            }

        });
    };

    async function validaEmail(emaildoContato) {
        const regex = /^[\w-\.]+@([\w-]+\.)+[\w-]{2,4}$/;
        return regex.test(emaildoContato)
    };

    async function existeRegistroNoDataTable() {

        const qtde = $('#tabelaContatos').DataTable().data().toArray().length;

        let existeRegistro;

        if (qtde > 0) {
            existeRegistro = true
        } else {
            existeRegistro = false;
        }

        return existeRegistro;
    };

    async function selectPrimeiraLinha() {

        if (!await existeRegistroNoDataTable()) {
            return;
        };

        $($('#tabelaContatos tbody tr')[0]).addClass('selected');
    };

    function desbloqueiaCampos() {
        $('#txtNomeContato').prop('disabled', false);
        $('#txtObsContatoEntidade').prop('disabled', false);
        $('#txtTelefoneContato').prop('disabled', false);
        $('#txtCelularContato').prop('disabled', false);
        $('#txtCPFCNPJContato').prop('disabled', false);
        $('#txtInscricaoIEContato').prop('disabled', false);
        $('#zezinho').prop('disabled', false);
        $('#zezinho').prop('readonly', false);
        $('#selectModificacao2').prop('disabled', false);
        $('#txtDataNascContato').prop('disabled', false);
        $('#txtFuncaoContatoEntidade').prop('disabled', false);
        $('#btnConsultaFuncaoContato').prop('disabled', false);
        $('#btnLimpaFuncaoContato').prop('disabled', false);
        $('#txtCargoContatoEntidade').prop('disabled', false);
        $('#btnConsultaCargoEntidade').prop('disabled', false);
        $('#btnLimpaCargoEntidade').prop('disabled', false);
        $('#txtSetorContatoEntidade').prop('disabled', false);
        $('#btnConsultaSetorEntidade').prop('disabled', false);
        $('#btnLimpaSetorEntidade').prop('disabled', false);
        $('#txtDoContato').prop('disabled', false);
        $('#btnFormataNumero').prop('disabled', false);
        $('#cbMaladireta').prop('disabled', false);
        $('#cbContatoAtivo').prop('disabled', false);
        $('#cbPessoaJuridica').prop('disabled', false);
        $('#cbPessoaFisica').prop('disabled', false);
        $('#cbSomenteXML').prop('disabled', false);
        $('#btnGravaContato').removeClass('d-none');
        $('#btnCancelarAlteracao').removeClass('d-none');
        $('#btnIncluiContato').addClass('d-none');
        $('#btnExcluir').addClass('d-none');
        $('#btnDuplicarContato').addClass('d-none');
        $('#btnAlteraContatoDentroModal').addClass('d-none');
        $('#cbWhatsApp').prop('disabled', false);
        $('#cbEmail').prop('disabled', false);
    };

    function bloqueiaCampos() {
        $('#txtNomeContato').val('');
        $('#txtTelefoneContato').val('');
        $('#txtCelularContato').val('');
        $('#txtCPFCNPJContato').val('');
        $('#txtInscricaoIEContato').val('');
        $('#zezinho').val('');
        $('#selectModificacao2').val(0);
        $('#txtDataNascContato').val('');
        $('#txtFuncaoContatoEntidade').val('');
        $('#txtCargoContatoEntidade').val('');
        $('#txtSetorContatoEntidade').val('');
        $('#txtDoContato').val('');
        $('#txtObsContatoEntidade').val('');
        $('#txtObsContatoEntidade').prop('disabled', true);
        $('#txtNomeContato').prop('disabled', true);
        $('#txtTelefoneContato').prop('disabled', true);
        $('#txtCelularContato').prop('disabled', true);
        $('#txtCPFCNPJContato').prop('disabled', true);
        $('#txtInscricaoIEContato').prop('disabled', true);
        $('#zezinho').prop('disabled', true);
        $('#zezinho').prop('readonly', true);
        $('#selectModificacao2').prop('disabled', true);
        $('#txtDataNascContato').prop('disabled', true);
        $('#txtFuncaoContatoEntidade').prop('disabled', true);
        $('#btnConsultaFuncaoContato').prop('disabled', true);
        $('#btnLimpaFuncaoContato').prop('disabled', true);
        $('#txtCargoContatoEntidade').prop('disabled', true);
        $('#btnConsultaCargoEntidade').prop('disabled', true);
        $('#btnLimpaCargoEntidade').prop('disabled', true);
        $('#txtSetorContatoEntidade').prop('disabled', true);
        $('#btnConsultaSetorEntidade').prop('disabled', true);
        $('#btnLimpaSetorEntidade').prop('disabled', true);
        $('#txtDoContato').prop('disabled', true);
        $('#btnFormataNumero').prop('disabled', true);
        $('#cbMaladireta').prop('disabled', true);
        $('#cbContatoAtivo').prop('disabled', true);
        $('#cbContatoAtivo').prop('checked', true);
        $('#cbPessoaJuridica').prop('disabled', true);
        $('#cbPessoaFisica').prop('disabled', true);
        $('#cbSomenteXML').prop('disabled', true);
        $('#btnGravaContato').addClass('d-none');
        $('#btnCancelarAlteracao').addClass('d-none');
        $('#btnIncluiContato').removeClass('d-none');
        $('#btnExcluir').removeClass('d-none');
        $('#btnDuplicarContato').removeClass('d-none');
        $('#btnAlteraContatoDentroModal').removeClass('d-none');
        $('#cbWhatsApp').prop('disabled', true);
        $('#cbEmail').prop('disabled', true);
    };

    function limpaCampos() {
        $('#txtNomeContato').val('');
        $('#txtTelefoneContato').val('');
        $('#txtCelularContato').val('');
        $('#txtCPFCNPJContato').val('');
        $('#txtInscricaoIEContato').val('');
        $('#zezinho').val('');
        $('#selectModificacao2').val(0);
        $('#txtDataNascContato').val('');
        $('#txtFuncaoContatoEntidade').val('');
        $('#txtCargoContatoEntidade').val('');
        $('#txtSetorContatoEntidade').val('');
        $('#txtDoContato').val('');
        $('#txtObsContatoEntidade').val('');
        $('#cbContatoAtivo').prop('checked', true);
        $('#cbMalaDireta').prop('checked', false);
        $('#cbPessoaJuridica').prop('checked', false);
        $('#cbPessoaFisica').prop('checked', true);
        $('#cbWhatsApp').prop('checked', false);
        $('#cbEmail').prop('checked', false);
    };
});