$(document).ready(async function () {
    const paramCadastraSemCPF = await CopiaParametro('VENDA', 40);

    function validarCaracteres(value) {
        if (value === "") return 0; // Permite que o valor vazio passe na validação
        const regex = /^[a-zA-ZÀ-ÿ0-9&@#\*\.,'"\-()!\s]+$/;
        const valido = regex.test(value);
        return valido ? 0 : 1;
    }

    await criaPesquisa()

    async function limpaCampos(bLimparCnpj = true) {
        $('#txtCodigoClienteEntidSimpl').val('');
        $('#txtCodCli').val('create');
        if (bLimparCnpj) {
            $('#txtCNPJEntidSimpl').val('');
        }
        $('#rgIEEntidSimpl').val('9').change();
        $('#txtRazaoSocialEntidSimpl').val('');
        $('#txtIEEntidSimpl').val('');
        $('#txtDDDEntidSimpl').val('');
        $('#txtTelefoneEntidSimpl').val('');
        $('#txtEmailEntidSimpl').val('');
        $('#txtPaisEntidSimpl').val('');
        $('#txtCepEntidSimpl').val('');
        $('#txtCidadeEntidSimpl').val('');
        $('#txtUFEntidSimpl').val('');
        $('#txtRuaEntidSimpl').val('');
        $('#txtNumeroEntidSimpl').val('');
        $('#txtBairroEntidSimpl').val('');
        $('#dtCadastroEntidSimpl').val('')
    }

    $('#btnModalNovaEntidSimpl').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            await limpaCampos()
            insereValor('#txtPaisEntidSimpl', '1058', 'BRASIL');
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    async function BuscaECadastraCep(cepInput) {
        try {
            $.LoadingOverlay("show");
            try {
                const cep = cepInput.val().replace('-', '').trim();
                const response = await requisicao('GET', '/sisplan/cep/v1/CEP?', `CEP=${cep}`, null);

                if (!response) {
                    return;
                }

                const jsonStr = await response.json();
                if (response.status != 200) {
                    msgAlerta(jsonStr.mensagem, () => {
                        abreCadastroCep(cepInput)
                    }, undefined, undefined);
                    return;
                }

                return [jsonStr.nOMCIDADE, jsonStr.eSTCEP, jsonStr.nOMCEP, jsonStr.bAIRRO];

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    };

    $('#txtCepEntidSimpl').on('blur', async function () {
        $.LoadingOverlay('show')
        try {
            let infoCep = $('#txtCepEntidSimpl');
            try {
                let retorno = await BuscaECadastraCep(infoCep);
                if (retorno != undefined) {
                    if (retorno[0] != '') {
                        $("#txtCidadeEntidSimpl").val(retorno[0]);
                    }
                    if (retorno[1] != '') {
                        $("#txtUFEntidSimpl").val(retorno[1]);
                    }
                    if (retorno[2] != '') {
                        $("#txtRuaEntidSimpl").val(retorno[2]);
                    }
                    if (retorno[3] != '') {
                        $("#txtBairroEntidSimpl").val(retorno[3]);
                    }
                }
            } catch (error) {
                console.error(error);
            }
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#txtCNPJEntidSimpl').change(async function () {
        try {
            if ($(this).val() == '') {
                return;
            }
            $.LoadingOverlay("show");

            let validaCNPJ = formata_cpf_cnpj($('#txtCNPJEntidSimpl').val());
            if (validaCNPJ != false) {
                $("#txtCNPJEntidSimpl").val(validaCNPJ);
            }

            let response = await requisicao('GET', '/Sisplan/Cliente/V1/Entidade?', `CNPJ=${$('#txtCNPJEntidSimpl').val()}`);

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.mensagem);
                return;
            }

            if (jsonStr.length > 0) {
                $.LoadingOverlay("hide");
                toastr.warning(
                    'CNPJ/CPF informado já existe!',
                    'Atenção', {
                    toastClass: 'alert',
                    iconClasses: {
                        error: 'alert-error',
                        info: 'alert-info',
                        success: 'alert-success',
                        warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden: async function () {
                        const clienteJson = jsonStr[0];
                        $('#txtCodigoClienteEntidSimpl').val(clienteJson.CODCLI);
                        $('#txtCodCli').val(clienteJson.CODCLI);
                        await carregaDadosCliente(clienteJson);
                    }
                }
                ).css({
                    "margin-top": "20%",
                    "width": "500px",
                    "max-width": "500px",
                    "color": "black"
                });
                return;
            }

            await limpaCampos(false)
            insereValor('#txtPaisEntidSimpl', '1058', 'BRASIL');

            $.LoadingOverlay("hide");

            if ((!valida_cpf_cnpj($('#txtCNPJEntidSimpl').val())) && (paramCadastraSemCPF != 1 ?? 0)) {
                $("#txtCNPJEntidSimpl").rules('add', 'valida_cpf_cnpj');
                $('#txtCNPJEntidSimpl').focus();
            }
            let cliente = $('#txtCodCli').val();
            const verifica_CPF_CNPJ = verifica_cpf_cnpj($('#txtCNPJEntidSimpl').val()) == 'CNPJ';
            if ((verifica_CPF_CNPJ) && ((cliente == 'create') && ($('#txtNome').val() == ''))) {
                await buscaDadosCliente(cliente, $('#txtCNPJEntidSimpl').val().replace(/[^0-9]/g, ''));
                if ($('#txtCodCli').val() == '') {
                    $('#txtCodCli').val('create');
                }
            }

        } catch (error) {
            console.log(error);
            $.LoadingOverlay("hide");
        }
    })

    jQuery.validator.addMethod('valida_cpf_cnpj', function (value, element) {
        return valida_cpf_cnpj(value);
    });

    jQuery.validator.addMethod("validarCaracteres", function (value) {
        return validarCaracteres(value) === 0;
    });

    async function carregaDadosCliente(clienteJson) {
        $.LoadingOverlay('show')
        try {
            let cliente = $('#txtCodigoClienteEntidSimpl').val()
            let codigoPais = '';
            try {
                let response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"ENTIDADE", "camposSelect":["ENTIDADE.COD_PAIS", "CADPAIS.NOME"], "leftJoin": [{"tabela": "CADPAIS", "condicao": "ENTIDADE.COD_PAIS = CADPAIS.CODIGO"}], "where": ["ENTIDADE.CODCLI = '${cliente}'"]}`, null);
                if (!response) {
                    codigoPais = '';
                    return;
                }
                let jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                codigoPais = jsonStr.RESULT[0][0].COD_PAIS === '' ? '' : `[${jsonStr.RESULT[0][0].COD_PAIS}] - ${jsonStr.RESULT[0][0].NOME}`;

            } catch (error) {
                codigoPais = '';
            }

            $('#rgIEEntidSimpl').val(clienteJson.IE_DESTINATARIO)
            $('#txtRazaoSocialEntidSimpl').val(clienteJson.NOME);
            $('#txtIEEntidSimpl').val(clienteJson.INSCRICAO);
            $('#txtDDDEntidSimpl').val(clienteJson.DDD_FONE);
            $('#txtTelefoneEntidSimpl').val(clienteJson.TELEFONE);
            $('#txtEmailEntidSimpl').val(clienteJson.EMAIL);
            $('#txtPaisEntidSimpl').val(codigoPais ? codigoPais : '[1058] - BRASIL');
            $('#txtCepEntidSimpl').val(clienteJson.CEP);

            let retorno = await BuscaCep($('#txtCepEntidSimpl'));
            $('#txtCidadeEntidSimpl').val(retorno[0]);
            $('#txtUFEntidSimpl').val(retorno[1]);

            $('#txtRuaEntidSimpl').val(clienteJson.ENDERECO);
            $('#txtNumeroEntidSimpl').val(clienteJson.NUMERO);
            $('#txtBairroEntidSimpl').val(clienteJson.BAIRRO);

            $('#dtCadastroEntidSimpl').val(clienteJson.DATA_CAD);
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    $('#form-entidSimpl').validate({
        debug: false,
        ignore: "",
        rules: {
            txtCNPJEntidSimpl: {
                required: paramCadastraSemCPF != '1',
                valida_cpf_cnpj: paramCadastraSemCPF != '1',
            },
            txtRazaoSocialEntidSimpl: {
                required: true,
                validarCaracteres: true,
            },
            txtPaisEntidSimpl: {
                required: true,
            },
            txtCepEntidSimpl: {
                required: true,
            },
            txtRuaEntidSimpl: {
                required: true,
            },
            txtNumeroEntidSimpl: {
                required: true,
            },
            txtBairroEntidSimpl: {
                required: true,
            },
            txtDDDEntidSimpl: {
                required: true,
            },
            txtTelefoneEntidSimpl: {
                required: true,
            }
        },
        messages: {
            txtCNPJEntidSimpl: {
                required: paramCadastraSemCPF != '1' ? "Informe um CNPJ/CPF válido." : '',
                valida_cpf_cnpj: paramCadastraSemCPF != '1' ? "Informe um CNPJ/CPF válido." : '',
            },
            txtRazaoSocialEntidSimpl: {
                required: "Informe uma razão social válida.",
                validarCaracteres: "Razão social não pode conter caracteres especiais",
            },
            txtPaisEntidSimpl: {
                required: "Informe um País válido."
            },
            txtCepEntidSimpl: {
                required: "Informe um CEP válido."
            },
            txtRuaEntidSimpl: {
                required: "Informe uma Rua válida.",
            },
            txtNumeroEntidSimpl: {
                required: "Informe um Número válido.",
            },
            txtBairroEntidSimpl: {
                required: "Informe um Bairro válido.",
            },
            txtDDDEntidSimpl: {
                required: "Informe um DDD válido"
            },
            txtTelefoneEntidSimpl: {
                required: "Informe um Telefone válido"
            }
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        },
        invalidHandler: function (e, validator) {
            if (validator.errorList.length) {
                let id = $(
                    $(`#${$(validator.errorList[0].element).prop("id")}`)
                        .closest(".card-body")
                        .closest(".collapse")
                ).prop("id");
                if ((!$(`#${id}`).hasClass('show'))) {
                    $(`a[href='#${id}']`).trigger("click");
                }
            }
        },
        submitHandler: async function (form, event) {
            event.preventDefault();

            const cliente = $('#txtCodCli').val();
            if (cliente == 'create') {
                try {
                    $.LoadingOverlay("show");
                    if (paramCadastraSemCPF != '1') {
                        let validaCNPJ = formata_cpf_cnpj($('#txtCNPJEntidSimpl').val());
                        if (validaCNPJ != false) {
                            $("#txtCNPJEntidSimpl").val(validaCNPJ)
                        }

                        let response = await requisicao('GET', '/Sisplan/Cliente/V1/Entidade?',
                            `CNPJ=${$('#txtCNPJEntidSimpl').val()}`);

                        let jsonStr = await response.json();
                        if (response.status != 200) {
                            $.LoadingOverlay("hide");
                            msgErro(jsonStr.mensagem);
                            return;
                        }

                        if (jsonStr.length > 0) {
                            $.LoadingOverlay("hide");
                            msgAlerta('CNPJ/CPF informado já existe');
                            return;
                        }
                    }

                    $.LoadingOverlay("hide");
                } catch (error) {
                    console.log(error);
                    $.LoadingOverlay("hide");
                }
            }

            try {
                $.LoadingOverlay("show");

                //replace nos cep
                var cep = $('#txtCepEntidSimpl').val().replace(/\D/g, '');

                let response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?',
                    `JSON={"tabela":"CADCEP", "camposSelect":["CEP"], "where": ["CEP = '${cep}'"]}`, null);

                let jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr['RESULT'][0].mensagem);
                    return;
                }

                if (jsonStr['RESULT'][0].length <= 0) {
                    $.LoadingOverlay("hide");
                    msgAlerta('Cep não informado ou inválido.');
                    $('#txtCep').focus();
                    return;
                }

                $.LoadingOverlay("hide");
            } catch (error) {
                console.log(error);
                $.LoadingOverlay("hide");
            }

            try {
                $.LoadingOverlay("show");

                let entidade = new Object();

                let validaCNPJ = formata_cpf_cnpj($('#txtCNPJEntidSimpl').val());
                if (validaCNPJ != false) {
                    $("#txtCNPJEntidSimpl").val(validaCNPJ)
                }

                const temCaracteresEspeciais = validarCaracteres($("#txtRazaoSocialEntidSimpl").val()) > 0;
                if (temCaracteresEspeciais) {
                    msgErro("Nome não pode conter caracteres especiais");
                    return;
                }

                if (($('#rgIEEntidSimpl').val() == '1') && ($('#txtIEEntidSimpl').val() == '')) {
                    msgErro("IE não preenchida e Indicador de IE está como Contribuinte, necessário infromar IE!")
                    return
                }

                entidade.CNPJ = $('#txtCNPJEntidSimpl').val();
                entidade.DATA_CAD = $('#dtCadastroEntidSimpl').val() == '' ? retornaDataAtual() : $('#dtCadastroEntidSimpl').val() + 'T00:00:00Z'
                entidade.IE_DESTINATARIO = $('#rgIEEntidSimpl').val();
                entidade.INSCRICAO = $('#txtIEEntidSimpl').val();
                entidade.NOME = $('#txtRazaoSocialEntidSimpl').val()
                entidade.DDD_FONE = $('#txtDDDEntidSimpl').val()
                entidade.TELEFONE = $('#txtTelefoneEntidSimpl').val()
                entidade.EMAIL = $('#txtEmailEntidSimpl').val()
                entidade.PAIS = pegaChave('#txtPaisEntidSimpl')
                entidade.CEP = pegaChave('#txtCepEntidSimpl')
                entidade.CEP = cep;
                entidade.ENDERECO = $('#txtRuaEntidSimpl').val();
                entidade.NUMERO = $('#txtNumeroEntidSimpl').val();
                entidade.BAIRRO = $('#txtBairroEntidSimpl').val();
                validaCNPJ = verifica_cpf_cnpj(entidade.CNPJ);
                entidade.SIMPLES = validaCNPJ == 'CNPJ' ? 'N' : 'S';
                entidade.SIMPLES = $('#txtCNPJEntidSimpl').val().length == 14 ? 'S' : 'A';
                entidade.ATIVO = 'S'
                entidade.TIPO = $('#txtCNPJEntidSimpl').val().length == 14 ? '1' : '2';
                entidade.STATUS = 0

                if (cliente != 'create') {
                    entidade.CODCLI = cliente
                }

                let response = await requisicao(cliente != 'create' ? 'PUT' : 'POST',
                    '/Sisplan/Cliente/V1/Entidade?', `CODUSUARIO=${getCookie('cod_usuario')}&MOEDAS=&SETORES=`, `LISTADIAS=${encodeURIComponent(JSON.stringify({ ARR_DIAS_VENCTO: [] }))}&JSON=${encodeURIComponent(JSON.stringify(entidade))}&CLICOM=`, 30000)

                if (!response) {
                    $.LoadingOverlay("hide");
                    return;
                }

                var jsonStr = await response.json()
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.mensagem)
                    return
                }

                $.LoadingOverlay("hide");
                toastr.success(
                    'Cadastro efetuado com sucesso!',
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                        error: 'alert-error',
                        info: 'alert-info',
                        success: 'alert-success',
                        warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden: function () {
                        try {
                            $('#modal-entid-simpl').modal('hide');
                            $('#txt-cliente').val();
                            insereValor('#txtCliente', jsonStr[0].CODCLI, jsonStr[0].NOME);
                            insereValor('#txt-cliente', jsonStr[0].CODCLI, jsonStr[0].NOME);
                            $('#btn_confirmar_cliente').trigger('click');
                        } catch {
                            console.log('erro ao fechar o modal cliente');
                        }
                    }
                }
                ).css({
                    "margin-top": "20%",
                    "width": "500px",
                    "max-width": "500px"
                });

            } catch (error) {
                console.error(error);
                $.LoadingOverlay("hide");
                msgErro('Não foi possível gravar os dados do cliente: ' + error)
            }
        }
    });

    async function criaPesquisa() {
        $(`#btnCepEntidSimpl`).pesquisa_serverside([`#txtCepEntidSimpl`], ["CADCEP.CEP", "CIDADE.NOME"], ["CADCEP.CEP", "CIDADE.NOME"], '{"tabela":"CADCEP", "camposSelect":["CADCEP.CEP", "CIDADE.NOME", "CIDADE.COD_UF"], "leftJoin": [{"tabela": "CIDADE", "condicao": "CADCEP.CODMUN = CIDADE.CODIGO"}], "where": null}', 'Pesquisa de CEP', '', [true, true]);
        $('#btn-pais-entidSimpl').pesquisa_serverside(['#txtPaisEntidSimpl'], ['CODIGO'], ['NOME'], `{ "tabela":"CADPAIS", "camposSelect":["CODIGO", "NOME"], "where": null}`, 'Pesquisa de País');

        $('#txtPaisEntidSimpl').autocompleta(1, `JSON={ "tabela":"CADPAIS", "camposSelect":["CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`);
        $('#txtCodigoImportarFluxoProduto').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);

        $('#btn-limpar-pais-entidSimpl').on('click', function () {
            $('#txtPaisEntidSimpl').val('');
        });

        $('#btnLimpaCepEntidSimpl').on('click', function () {
            $('#txtCepEntidSimpl').val('');
            $('#txtCidadeEntidSimpl').val('');
            $('#txtUFEntidSimpl').val('');
            $('#txtRuaEntidSimpl').val('');
            $('#txtBairroEntidSimpl').val('');
        });
    }
})