
$(document).ready(async function () {
  $("#tutorial").on("click", function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#tutorialConteudo",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#btnGravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar as informações.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });

  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let registro = parametros[parametros.length - 1];

  $("#btnVoltar").on("click", async function () {
    registro = new URLSearchParams(descriptografaUrl(parametros[parametros.length - 1]));
    await deletaRegistro("AGENDAMENTO_GUIA", getCookie("usuario"), registro.get('SENHA'));
    window.location.href = `${BASE_URI}/agendamento_guia`;
  });

  $("#msform").validate({
    debug: false,
    ignore: "",
    rules: {
      txtGuia: {
        required: true,
      },
      txtAgencia: {
        required: true,
      },
    },
    messages: {
      txtGuia: {
        required: "Informe um guia.",
      },
      txtAgencia: {
        required: "Informe uma agência.",
      },
    },
    errorElement: "span",
    errorPlacement(error, element) {
      error.addClass("invalid-feedback");
      element.closest(".form-group").append(error);
    },
    highlight(element) {
      $(element).addClass("is-invalid");
    },
    unhighlight(element) {
      $(element).removeClass("is-invalid");
    },
  });

  if (registro != "" && registro != "create") {
    registro = new URLSearchParams(descriptografaUrl(parametros[parametros.length - 1]));
    if ((await liberarRegistro("AGENDAMENTO_GUIA", registro.get('SENHA'))) == false) {
      window.location.href = "../agendamento_guia";
    } else {
      carregaDados(registro.get('SENHA'), registro.get('DATA'));
    }
  } else if (registro == 'create') {
    setarDataAtual('dtData');
    const horaAtual = formataDataCompleta(new Date()).slice('11', '19');
    const hora = horaAtual.split(':')[0];
    const horaTratada = hora.length == 1 ? `0${horaAtual}` : horaAtual;
    insereValor('#dtDataHora', horaTratada);
    $('#dtData').prop('disabled', false);
    await proximaSenha();
  }

  componentePesquisa();
  mascaras();

  async function carregaDados(senha, data) {
    $.LoadingOverlay("show");
    try {
      const url = '/sisplan/cadastros/v1/agendamento_guia?';
      const filtros = `SENHA=${senha}&DATA=${data}&DATA_ATE=2500-12-31`;
      const response = await requisicao('GET', url, filtros);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status != 200) {
        msgErro(jsonStr.mensagem)
        return;
      }

      if (jsonStr.length == 0) {
        msgAlerta('Nenhum registro encontrado!');
        return;
      }

      $("#dtData").val(jsonStr[0].DATA != undefined ? jsonStr[0].DATA.slice(0, 10) : 0);
      insereValor('#dtDataHora', jsonStr[0].DATA.slice(11, 19));
      insereValor('#dtHoraEntrada', jsonStr[0].HORA_ENTRADA?.slice(11, 19));
      insereValor('#dtHoraSaida', jsonStr[0].HORA_SAIDA?.slice(11, 19));
      insereValor('#txtSenha', jsonStr[0].SENHA);
      insereValor('#txtQtdePassageiros', jsonStr[0].QTDE_PASSAGEIRO);
      insereValor('#txtGuia', jsonStr[0].GUIA, jsonStr[0].NOME_GUIA);
      insereValor('#txtAgencia', jsonStr[0].AGENCIA, jsonStr[0].NOME_AGENCIA);
      insereValor('#txtComissaoGuia', jsonStr[0].COMISSAO_GUIA.toFixed(2).replace('.', ','));
      insereValor('#txtComissaoGuia2', jsonStr[0].COMISSAO_GUIA2.toFixed(2).replace('.', ','));
      insereValor('#txtComissaoAgencia', jsonStr[0].COMISSAO_AGENCIA.toFixed(2).replace('.', ','));
      insereValor('#txtComissaoAgencia2', jsonStr[0].COMISSAO_AGENCIA2.toFixed(2).replace('.', ','));
    } catch (error) {
      console.error(error);
      msgErro(`Não foi possível buscar os dados do agendamento: ${error}`);
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $("#btnGravar").click(async function () {
    await gravarAgendaGuia();
  });

  $('.camposInteiro').on('focusout', function () {
    const inputValue = $(this).val();
    if (!Number.isInteger(parseFloat(inputValue))) {
      msgAlerta('Permitido apenas números inteiros!');
      $(this).val(0);
    } else {
      $(this).val(parseInt(inputValue));
    }
  });

  function mascaras() {
    $('.maskDecimais').maskMoney({
      decimal: ",",
      thousands: ".",
      precision: 2,
    });

    $(function () {
      $("#timepickerDataHora").datetimepicker({
        format: "HH:mm:ss"
      });
      $("#timepickerHoraEntrada").datetimepicker({
        format: "HH:mm:ss"
      });
      $("#timepickerHoraSaida").datetimepicker({
        format: "HH:mm:ss"
      });
    });
    $("#dtDataHora").mask("00:00:00");
    $("#dtHoraEntrada").mask("00:00:00");
    $("#dtHoraSaida").mask("00:00:00");
  }

  function componentePesquisa() {
    $('#txtGuia').autocompleta(2, `JSON={ "tabela": "REPRESEN", "camposSelect": ["CODREP CHAVE", "NOME DESCRICAO"], "where": [] }`);
    $('#btnGuia').pesquisa('#txtGuia', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "REPRESEN", "camposSelect": ["CODREP", "NOME"] }`, `Pesquisa de Guia`, 'REPRESEN');
    $('#txtAgencia').autocompleta(2, `JSON={ "tabela": "REPRESEN", "camposSelect": ["CODREP CHAVE", "NOME DESCRICAO"], "where": [] }`);
    $('#btnAgencia').pesquisa('#txtAgencia', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "REPRESEN", "camposSelect": ["CODREP", "NOME"] }`, `Pesquisa de Agência`, 'REPRESEN');
    $('#btnLimpaGuia').on('click', function () {
      $('#txtGuia').val('');
    });
    $('#btnLimpaAgencia').on('click', function () {
      $('#txtAgencia').val('');
    });
  }

  async function gravarAgendaGuia() {
    $.LoadingOverlay("show");
    try {
      let validator = $("#msform").validate();
      validator.form();
      let erros = 0;
      erros = validator.numberOfInvalids();

      if (erros == 0) {

        const Agenda_Guia = {};

        Agenda_Guia.DATA = `${pegaValor('#dtData')}T${pegaValor('#dtDataHora')}Z`;
        Agenda_Guia.HORA_ENTRADA = `1899-12-30T${pegaValor('#dtHoraEntrada') == '' ? '00:00:00' : pegaValor('#dtHoraEntrada')}Z`;
        Agenda_Guia.HORA_SAIDA = `1899-12-30T${pegaValor('#dtHoraSaida') == '' ? '00:00:00' : pegaValor('#dtHoraSaida')}Z`;
        Agenda_Guia.SENHA = parseInt(pegaValor('#txtSenha'));
        Agenda_Guia.QTDE_PASSAGEIRO = pegaValor('#txtQtdePassageiros');
        Agenda_Guia.GUIA = pegaChave('#txtGuia');
        Agenda_Guia.AGENCIA = pegaChave('#txtAgencia');
        Agenda_Guia.COMISSAO_GUIA = parseFloat($('#txtComissaoGuia').val().replace('.', '').replace(',', '.'));
        Agenda_Guia.COMISSAO_GUIA2 = parseFloat($('#txtComissaoGuia2').val().replace('.', '').replace(',', '.'));
        Agenda_Guia.COMISSAO_AGENCIA = parseFloat($('#txtComissaoAgencia').val().replace('.', '').replace(',', '.'));
        Agenda_Guia.COMISSAO_AGENCIA2 = parseFloat($('#txtComissaoAgencia2').val().replace('.', '').replace(',', '.'));
        Agenda_Guia.BINCLUINDO = registro == 'create';

        let response = await requisicao(
          "POST",
          "/Sisplan/cadastros/v1/agendamento_guia?",
          `JSON=${encodeURIComponent(JSON.stringify(Agenda_Guia))}`,
          null
        );

        if (!response) {
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.mensagem);
          return;
        }
        $.LoadingOverlay("hide");
        toastr
          .success("Cadastro efetuado com sucesso!", "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              window.location.href = `${BASE_URI}/agendamento_guia`;
            },
          })
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      } else {
        msgAlerta('Necessário informar os campos obrigatórios.')
      }
    } catch (error) {
      console.error(error);
      msgErro(`Não foi possível gravar os dados do agendamento: ${error}`);
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('.camposInteiro').on('focusout', function () {
    const inputValue = $(this).val();
    if (!Number.isInteger(parseFloat(inputValue))) {
      msgAlerta('Permitido apenas números inteiros!');
      $(this).val(0);
    } else {
      $(this).val(parseInt(inputValue));
    }
  });

  async function proximaSenha() {
    $.LoadingOverlay("show");
    try {
      const url = '/sisplan/cadastros/v1/proximasenha?';
      const filtros = `DATA=${pegaValor('#dtData')}`;
      const response = await requisicao('GET', url, filtros);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status != 200) {
        msgErro(jsonStr.mensagem)
        return;
      }
      $('#txtSenha').val(jsonStr);      
    } catch (error) {
      console.error(error);
      msgErro(`Não foi possível buscar os dados do agendamento: ${error}`);
    } finally {
      $.LoadingOverlay("hide");
    }
  }
});
