$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnNovoTemplate',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de uma nova Aplicação do PCP.',
          position: 'right'
        }
      },
      {
        element: '#tabelaAplicacaoPCP',
        popover: {
          title: 'Tabela Aplicação do PCP',
          description: 'Aqui estão os dados das Aplicações do PCP cadastrados.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});
//Grid Acesso//,
$(document).ready(async function () {

  $('#txtConsultaAplicacao').autocompleta(1, `JSON={ "tabela":"PCPAPL", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#txtConsultaTipo').autocompleta(1, `JSON={ "tabela":"TIPO_APL", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);

  $('#btn-ConsultaAplicacao').pesquisa('#txtConsultaAplicacao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PCPAPL", "camposSelect":["CODIGO", "DESCRICAO", "TIPOAPL", "TIPO"]}`, 'Consulta Aplicação', 'APLICACAO_PCP');
  $('#btn-ConsultaTipo').pesquisa('#txtConsultaTipo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TIPO_APL", "camposSelect":["CODIGO", "DESCRICAO", "ATIVO"]}`, 'Consulta Tipo', 'TIPO_APL');

  $('#btnLimparFiltros').on('click', function () {
    $('#txtConsultaTipo, #txtConsultaAplicacao').val('');
  });

  $('#btn-limpa-ConsultaAplicacao').on('click', function () {
    $('#txtConsultaAplicacao').val('');
  });

  $('#btn-limpa-ConsultaTipo').on('click', function () {
    $('#txtConsultaTipo').val('');
  });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnConsultar').on('click', async function () {
    let colunas = [];
    $.LoadingOverlay("show");
    let sWhere = '';

    try {
      if ($.fn.DataTable.isDataTable('#tabelaAplicacaoPCP')) {
        $("#tabelaAplicacaoPCP").DataTable().destroy();
        $("#tabelaAplicacaoPCP").empty();
      }

      sWhere += $("#txtConsultaTipo").val() != '' ? `AND PCPAPL.TIPOAPL='${pegaChave("#txtConsultaTipo")}'` : '';
      sWhere += $("#txtConsultaAplicacao").val() != '' ? `AND PCPAPL.CODIGO='${pegaChave("#txtConsultaAplicacao")}'` : '';
      let ajaxData = {};

      if ($("#txtConsultaAplicacao").val() == '') {
        camposSelect = `["PCPAPL.CODIGO", "PCPAPL.DESCRICAO", "PCPAPL.TIPO", "PCPAPL.TIPOAPL"]`;
        colunas = ["CODIGO", "DESCRICAO", "TIPOAPL", "DESC_TIPOAPL"];

        ajaxData = `{ "tabela":"PCPAPL", "camposSelect":["PCPAPL.CODIGO", "PCPAPL.DESCRICAO",` +
          `"PCPAPL.TIPOAPL", "TIPO_APL.DESCRICAO DESC_TIPOAPL"],` +
          `"leftjoin": [{"tabela": "TIPO_APL", "condicao": "TIPO_APL.CODIGO = PCPAPL.TIPOAPL"}],` +
          `"where": ["1=1 ${sWhere}"]}`;
      } else {
        camposSelect = `["PCPAPL.CODIGO", "PCPAPL.DESCRICAO", "PCPAPL.TIPO", "PCPAPL.TIPOAPL"]`;
        colunas = ["CODIGO", "DESCRICAO", "TIPOAPL", "DESC_TIPOAPL"];

        ajaxData = `{ "tabela":"PCPAPL", "camposSelect":["PCPAPL.CODIGO", "PCPAPL.DESCRICAO",` +
          `"PCPAPL.TIPOAPL", "TIPO_APL.DESCRICAO DESC_TIPOAPL"],` +
          `"leftjoin": [{"tabela": "TIPO_APL", "condicao": "TIPO_APL.CODIGO = PCPAPL.TIPOAPL"}],` +
          `"where": ["1=1 ${sWhere}"]}`;
      };

      let response = await requisicao("GET", "/sisplan/funcoes/v1/pesquisa?", `JSON=${ajaxData}`, null);
      if (!response) { return; }
      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      const dataSetCols = [
        { 'title': 'Código', 'data': 'CODIGO' },
        { 'title': 'Descrição', 'data': 'DESCRICAO' },
        { 'title': 'Tipo Aplicação', 'data': 'TIPOAPL' },
        { 'title': 'Descrição Tipo Aplicação', 'data': 'DESC_TIPOAPL' }
      ];

      let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      if (colunasInvisiveis == null || colunasInvisiveis.cadAplicacaoPCP == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, cadAplicacaoPCP: ['EMPRESA'] }));
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      }

      if (jsonStr.RESULT[0].length > 0) {
        $('#tabelaAplicacaoPCP').DataTable({
          paging: true,
          lengthChange: true,
          searching: true,
          scrollX: true,
          scrollY: '350px',
          filter: false,
          info: true,
          order: false,
          autoWidth: true,
          destroy: true,
          data: jsonStr.RESULT[0],
          columns: dataSetCols,
          columnDefs: [{
            targets: [0],
            render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          }]
        });

        $('#tabelaAplicacaoPCP_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaAplicacaoPCP_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const dados = $("#tabelaAplicacaoPCP").DataTable().data().toArray();
          await exportaCSV("", "", undefined, null, 'Relatório da aba de cadastro de aplicação do pcp', '', '', 999, false, false, dados);
        });

        $('#tabelaAplicacaoPCP').DataTable().columns().every(function () {
          if ((colunasInvisiveis.cadAplicacaoPCP).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        });
      }
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados dos itens.');
    } finally {
      $.LoadingOverlay("hide");
      $('#modal-filtros').modal('hide');
    }
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaAplicacaoPCP').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      });
    });

    adicionaColunas(cols, colunasInvisiveis.cadAplicacaoPCP ?? ['EMPRESA']);
  });

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      removeColunasFixas(novasColunas, ["CODIGO"]);
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, cadAplicacaoPCP: novasColunas }));

      $('#tabelaAplicacaoPCP').DataTable().columns().visible(true);

      $('#tabelaAplicacaoPCP').DataTable().columns().every(function () {
        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  });

  $('#btnConsultar').trigger('click');

  function retornaBotaoOpcoes(data) {
    let retorno = ''
    retorno = '<div style="text-align:start;"> ' +
      '    <button id="editaOpcoes" class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu" > ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  $('#tabelaAplicacaoPCP').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaAplicacaoPCP').DataTable().row($(this).parents('tr')).data();
      let registroLiberado = await verificarRegistro('APLICACAO_PCP', data.CODIGO);
      if (registroLiberado) {
        window.location.href = `aplicacao_pcp/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaAplicacaoPCP').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      const data = $('#tabelaAplicacaoPCP').DataTable().row($(this).parents('tr')).data();
      msgAlerta(`Você realmente deseja excluir o registro ${data.CODIGO}?`, async () => {
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {

        let response = await requisicao('DELETE', '/Sisplan/cadastros/V1/cadaplicacaopcp?', `CODIGO=${encodeURIComponent(data.CODIGO)}`, null)
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/aplicacao_pcp`;
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function permissaoAcessos(tela) {
    try {
      $.LoadingOverlay("show");

      let object = new Object();
      object.resultado = true;
      object.mensagem = "";

      if (getCookie("cod_usuario") == "0000") {
        object.ALTERA = "S";
        object.CONSULTA = 'S';
        object.EXCLUI = 'S';
        object.INCLUI = 'S';
        return object;
      }

      try {
        const codusuario = `'${getCookie("cod_usuario")}'`;
        const response = await requisicao(
          "GET",
          `/Sisplan/AcessoMenu/v1/Acesso?`,
          `codusuarios=${codusuario}&telas='${tela}'`,
          null,
          60000
        );

        if (!response) {
          msgErro("Erro ao buscar permissões da tela.");
          return;
        }

        let valida = await response.json();
        if (response.status != 200) {
          console.error(valida.RESULT[0].mensagem);
          msgErro("Erro ao buscar permissões da tela.");
          return;
        }

        if (valida.length <= 0) {
          object.ALTERA = "N";
          object.CONSULTA = 'N';
          object.EXCLUI = 'N';
          object.INCLUI = 'N';
          return object;
        }

        return valida[0];
      } catch (error) {
        console.error(error);
        msgErro("Erro ao buscar permissões da tela.");
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  const permissaoUsuarioLogado = await permissaoAcessos("APLICACAO_PCP");

  $('#tabelaAplicacaoPCP').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaAplicacaoPCP').DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro('APLICACAO_PCP', data.CODIGO);
      if (registroLiberado) {
        window.location.href = `aplicacao_pcp/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });
});
