function criaTabelaTecidos(data) {
    function retornaBotaoOpcoes(data) {
        var retorno = '<div> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes tecidosDatatableButtonControl" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button type="button" class="dropdown-item tecidosDatatableButtonControl" title="Alterar" id="btnAlterar">Alterar</button>     ' +
            '    <button type="button" class="dropdown-item tecidosDatatableButtonControl" title="Excluir" id="btnExcluir">Excluir</button>     ' +
            '</div>';
        return retorno;
    }

    if ($.fn.DataTable.isDataTable('#tabelaTecidos')) {
        $('#tabelaTecidos').DataTable().destroy();
        $('#tabelaTecidos').empty();
    }

    const columns = [
        {
            data: 'ORDEM',
            title: 'Ordem'
        },
        {
            data: 'CODIGO',
            title: 'Código'
        },
        {
            data: 'DESCRICAO',
            title: 'Descrição'
        }
    ];

    $("#tabelaTecidos").DataTable({
        sort: false,
        paging: false,
        destroy: true,
        lengthChange: false,
        filter: false,
        info: false,
        columnDefs: [
            {
                targets: [0],
                render: function (data) {
                    return retornaBotaoOpcoes(data);
                }
            }
        ],
        autoWidth: true,
        data,
        columns
    }).draw(false);
}

function habilitaEdicaoTecido() {
    $('.tecidoControl').prop('disabled', false)
    $('#btnIncluirTecido').addClass('d-none')
    $('#btnConfirmarTecido').removeClass('d-none')
    $('#btnDesistirTecido').removeClass('d-none')
}

function desabilitaEdicaoTecido() {
    $('.tecidoControl').prop('disabled', true)
    $('#btnIncluirTecido').removeClass('d-none')
    $('#btnConfirmarTecido').addClass('d-none')
    $('#btnDesistirTecido').addClass('d-none')
    $('#txtMaterialTecido').val('')
    $("#tabelaTecidos tr").removeClass("selected")
}

function insereValoresEdicaoTecido(data) {
    insereValor('#txtMaterialTecido', data.CODIGO, data.DESCRICAO)
}

function adicionaRegistroTecido(data) {
    try {
        const datatable = $("#tabelaTecidos").DataTable()
        const selectedRow = datatable.rows(".selected")
        const datatableData = datatable.data().toArray()
        const editingRegister = selectedRow.data().toArray()

        if (!editingRegister || editingRegister.length === 0) {
            if (datatableData.find(e => e.CODIGO === data.CODIGO)) {
                msgErro('Esse registro já existe, impossível continuar.')
                return
            }

            const currentMaxOrder = datatableData.reduce((max, obj) => {
                return obj.ORDEM > max ? obj.ORDEM : max
            }, 0)

            data.ORDEM = currentMaxOrder + 1

            datatable.row.add(data).draw(false)
        } else {
            const [index] = selectedRow.indexes().toArray()
            const existingRegisterCount = datatableData.filter((e, i) => e.CODIGO === data.CODIGO && index !== i)

            if (existingRegisterCount && existingRegisterCount.length > 0) {
                msgErro('Esse registro já existe, impossível continuar.')
                return
            }

            if (editingRegister.length > 1) {
                throw new Error()
            }

            const [dataSelected] = editingRegister

            data.ORDEM = dataSelected.ORDEM

            datatable.row(index).data(data).draw(false)
        }
    } catch (e) {
        console.log(e)
        msgErro('Ocorreu um problema ao inserir/editar o registro, por favor tente novamente.')
    } finally {
        desabilitaEdicaoTecido()
    }
}