$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true,
      onNext: (Element) => {
        if ((Element.node.id == 'avancar1')) {
          $('#avancar1').trigger('click');
        };
      },
      onPrevious: (Element) => {
        if (Element.node.id == 'checkTour') {
          $('#voltar4').trigger('click');
        };
      }
    });
    driver.defineSteps([
      {
        element: "#formcard1",
        popover: {
          title: "Dados Gerais",
          description:
            "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtCodigo",
        popover: {
          title: "Código do Banco",
          description:
            "Adicionamos aqui o código do Município.",
          position: "top",
        },
      },
      {
        element: "#www",
        popover: {
          title: "Consulta IBGE",
          description:
            "Ao clicar, faz consulta pelo código do município e preenche o nome da cidade e a UF.",
          position: "top",
        },
      },
      {
        element: "#gravar",
        popover: {
          title: "Botão Gravar",
          description: "Clicamos aqui para gravar o registro.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $('#txtUF').autocompleta(1, `JSON={ "tabela": "TABUF", "camposSelect":[ "CODIGO chave", "DESCRICAO descricao"], "where": null}`);
  $("#btnUF").pesquisa_serverside(["#txtUF"], ["CODIGO"], ["DESCRICAO"], '{"tabela":"TABUF", "camposSelect":[ "CODIGO", "DESCRICAO", "PAIS", "CODUF" ], "where": null}', "Pesquisa UF", 'uf');
  $("#btnLimpaUF").on("click", function () {
    $("#txtUF").val("");
  });

  $('#txtRegiao').autocompleta(1, `JSON={ "tabela": "REG_ESTADO", "camposSelect":[ "COTA chave", "DESCRICAO descricao"], "where": null}`);
  $("#btnRegiao").pesquisa_serverside(["#txtRegiao"], ["CODIGO"], ["DESCRICAO"], '{"tabela":"REG_ESTADO", "camposSelect":[ "CODIGO", "DESCRICAO", "OBS"], "where": null}', "Pesquisa UF");
  $("#btnLimpaRegiao").on("click", function () {
    $("#txtRegiao").val("");
  });

  $('#txtPais').autocompleta(1, `JSON={ "tabela": "CADPAIS", "camposSelect":[ "CODIGO chave", "NOME descricao"], "where": null}`);
  $("#btnPais").pesquisa_serverside(["#txtPais"], ["CODIGO"], ["NOME"], '{"tabela":"CADPAIS", "camposSelect":[ "CODIGO", "NOME"], "where": null}', "Pesquisa de Pais");
  $("#btnLimpaPais").on("click", function () {
    $("#txtPais").val("");
  });

  $("#btnVoltar").on("click", async function () {
    await deletaRegistro("CADCIDADE", getCookie("usuario"), cidade);
    window.location.href = `${BASE_URI}/cadcidade`;
  });

  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let cidade = parametros[parametros.length - 1];


  $('#txtCodigo').on('blur', async function () {
    if (cidade === 'create') {
      const cidade = $('#txtCodigo').val();
      let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
        `JSON={ "tabela":"CIDADE",
                "camposSelect":["CODIGO"], 
                "where": ["CODIGO = '${cidade}'"]}`, null);

      let json = await response.json();
      if (json.RESULT[0].length > 0) {
        toastr
          .warning(
            `Cidade já cadastrada`,
            "Alerta",
            {
              toastClass: "alert",
              iconClasses: {
                error: "alert-error",
                info: "alert-info",
                success: "alert-success",
                warning: "alert-warning",
              },
              positionClass: "toast-top-center",
              progressBar: true,
              timeOut: 3000,
              fadeOut: 1000,
              onHidden() {
                window.location.href = `${BASE_URI}/cadcidade/${cidade}`;
              },
            }
          )
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });

        // window.location.href = `${BASE_URI}/cadcidade/${cidade}`;
        // return;
      }
    }
  });

  if (cidade != "" && cidade != "create") {
    $('#txtCodigo, #www').prop('disabled', true)
    try {
      $.LoadingOverlay("show");
      try {
        let response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ 
              "tabela":"CIDADE", 
              "camposSelect":["CIDADE.CODIGO", "CIDADE.IDH", "CIDADE.NOME", "CIDADE.COD_UF", "TABUF.DESCRICAO", "CIDADE.CODIGOTOM", "CIDADE.CODIGOESTADUAL", "CIDADE.ISSQN", "CIDADE.PCV",
              "CIDADE.IPC", "CIDADE.DDD", "CIDADE.POPULACAO", "CIDADE.POPULACAO_F", "CIDADE.POPULACAO_M", "CIDADE.PERC_MARKUP", "CIDADE.REG_ESTADO", "REG_ESTADO.DESCRICAO DESCREGIAO", 
              "CIDADE.COD_PAIS", "CADPAIS.NOME NOMEPAIS", "CIDADE.OBS", "CIDADE.REGIAO", "CIDADE.SUFRAMA_CONF"],
              "leftJoin": [{
                "tabela": "REG_ESTADO", "condicao": "CIDADE.REG_ESTADO = REG_ESTADO.CODIGO"},{
                "tabela": "TABUF", "condicao": "CIDADE.COD_UF = TABUF.CODIGO"},{
                "tabela": "CADPAIS", "condicao": "CIDADE.COD_PAIS = CADPAIS.CODIGO"}], 
              "where": ["CIDADE.CODIGO =  '${cidade}'"]}`, null
        );

        if (!response) {
          return;
        }
        let jsonStr = await response.json();
        if (response.status != 200) {
          msgAlerta(jsonStr.RESULT[0].mensagem);
          return;
        }

        $("#txtCodigo").val(jsonStr.RESULT[0][0].CODIGO);
        $("#txtIDH").val(jsonStr.RESULT[0][0].IDH);
        $("#txtMunicipio").val(jsonStr.RESULT[0][0].NOME);
        insereValor('#txtUF', jsonStr.RESULT[0][0].COD_UF, jsonStr.RESULT[0][0].DESCRICAO)
        $("#txtTOM").val(jsonStr.RESULT[0][0].CODIGOTOM);
        $("#txtEstadual").val(jsonStr.RESULT[0][0].CODIGOESTADUAL);
        $("#txtISSQN").val(jsonStr.RESULT[0][0].ISSQN);
        $("#txtIPC").val(jsonStr.RESULT[0][0].PCV);
        $("#txtPCV").val(jsonStr.RESULT[0][0].IPC);
        $("#txtPopulacao").val(jsonStr.RESULT[0][0].POPULACAO);
        $("#txtPopulacaoF").val(jsonStr.RESULT[0][0].POPULACAO_F);
        $("#txtPopulacaoM").val(jsonStr.RESULT[0][0].POPULACAO_M);
        $("#txtDDD").val(jsonStr.RESULT[0][0].DDD);
        $("#txtFrete").val(jsonStr.RESULT[0][0].PERC_MARKUP);
        insereValor('#txtRegiao', jsonStr.RESULT[0][0].REG_ESTADO, jsonStr.RESULT[0][0].DESCREGIAO)
        insereValor('#txtPais', jsonStr.RESULT[0][0].COD_PAIS, jsonStr.RESULT[0][0].NOMEPAIS)
        $("#txtObservacao").val(jsonStr.RESULT[0][0].OBS);


        if (jsonStr.RESULT[0][0].REGIAO === "CA") {
          $('#rdCapital').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].REGIAO === "GC") {
          $('#rdGradeCapital').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].REGIAO === "IN") {
          $('#rdInterior').prop('checked', true);
        }

        let suframaConf = jsonStr.RESULT[0][0].SUFRAMA_CONF;

        let mapa = {
          'I': 'cbICMS',
          'P': 'cbPis',
          'C': 'cbCofins'
        };

        for (let i = 0; i < suframaConf.length; i++) {
          let char = suframaConf.charAt(i);
          if (mapa[char]) {
            $('#' + mapa[char]).prop('checked', true);
          }
        }

      } catch (error) {
        console.error(error);
        msgAlerta(`Não foi possível buscar os dados:`);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }



  $("#gravar").click(async function () {
    if ($('#txtCodigo').val() == '') {
      msgAlerta('Preencha o campo Cód. Município/IBGE');
      return;
    } else if ($('#txtMunicipio').val() == '') {
      msgAlerta('Preencha o Nome do Município.');
      return;
    } else if ($('#txtUF').val() == '') {
      msgAlerta('Preencha a UF do Município.');
      return
    }

    try {
      $.LoadingOverlay("show");
      let objCidade = {};

      let checkboxSel = "";
      let mapping = {
        'cbICMS': 'I',
        'cbPis': 'P',
        'cbCofins': 'C'
      };

      Object.keys(mapping).forEach(function (id) {
        if ($('#' + id).prop('checked')) {
          checkboxSel += mapping[id];
        }
      });

      objCidade.REGIAO = $('input[name="rdRegiao"]:checked').val();
      objCidade.SUFRAMA_CONF = checkboxSel;
      objCidade.CODIGO = $("#txtCodigo").val();
      objCidade.IDH = $("#txtIDH").val();
      objCidade.NOME = $("#txtMunicipio").val().toUpperCase();
      objCidade.COD_UF = pegaChave("#txtUF");

      objCidade.CODIGOTOM = $("#txtTOM").val();
      objCidade.CODIGOESTADUAL = $("#txtEstadual").val();
      objCidade.ISSQN = $("#txtISSQN").val();
      objCidade.IPC = $("#txtIPC").val();
      objCidade.PCV = $("#txtPCV").val();
      objCidade.POPULACAO = $("#txtPopulacao").val();
      objCidade.POPULACAO_F = $("#txtPopulacaoF").val();
      objCidade.POPULACAO_M = $("#txtPopulacaoM").val();
      objCidade.DDD = $("#txtDDD").val();
      objCidade.PERC_MARKUP = $("#txtFrete").val();

      objCidade.REG_ESTADO = pegaChave("#txtRegiao");
      objCidade.COD_PAIS = pegaChave("#txtPais");
      objCidade.OBS = $("#txtObservacao").val();

      let response = await requisicao(
        'POST', '/sisplan/cadastros/v1/cadcidade?', '', JSON.stringify(objCidade), 15500
      );

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      if (response.status != 200) {
        let jsonStr = await response.json();
        $.LoadingOverlay("hide");
        msgAlerta(jsonStr.mensagem);
        return;
      }
      $.LoadingOverlay("hide");
      toastr
        .success(
          `Cadastro efetuado com sucesso!
           Cidade: ${objCidade.CODIGO}`,
          "Confirmação",
          {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              window.location.href = `${BASE_URI}/cadcidade`;
            },
          }
        )
        .css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
      msgAlerta(`Não foi possível gravar os dados:`);
    }
  });

  // Funções

  $("#www").on("click", () => {
    if ($('#txtCodigo').val() == '') {
      msgAlerta('Preencha o código do município');
      $('#txtCodigo').focus();
    }

    let url = 'https://servicodados.ibge.gov.br/api/v1/localidades/municipios/' + $('#txtCodigo').val();

    $.ajax({
      url: url,
      type: 'GET',
      dataType: 'json',
      success: function (data) {
        if (data.length !== 0) {
          insereValor('#txtUF', data.microrregiao.mesorregiao.UF.sigla, data.microrregiao.mesorregiao.UF.nome)
          $('#txtMunicipio').val(data.nome);
        } else {
          $('#txtUF, #txtMunicipio').val('')
          msgAlerta('Código não encontrado na base de dados do IBGE.')
        }
      },
      error: function () {
        msgAlerta('Erro na requisição');
      }
    });
  });

  function limitarDigitos(elemento, maxDigitos) {
    $(elemento).on('input', function () {
      let valor = $(this).val();
      if (valor.length > maxDigitos) {
        $(this).val(valor.slice(0, maxDigitos));
      }
    });
  }

  limitarDigitos('#txtIDH', 12)
  limitarDigitos('#txtMunicipio', 30)
  limitarDigitos('#txtUF', 2)
  limitarDigitos('#txtISSQN', 9)
  limitarDigitos('#txtIPC', 27)
  limitarDigitos('#txtPCV', 22)
  limitarDigitos('#txtDDD', 3)
  limitarDigitos('#txtFrete', 9)
  limitarDigitos('#txtRegiao', 4)
  limitarDigitos('#txtPais', 5)
  limitarDigitos('#txtObservacao', 1024)
});