/* eslint-disable prefer-destructuring */
$('#tutorial').on('click', function () {
    // $('#geral-tab').trigger('click');
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            onHighlightStarted: (Element) => {
                if (Element.node.id == 'geral') {
                    if (!$('#multiCollapseExample1').hasClass('show')) {
                        $('#multiCollapseExample1').collapse('show');
                    }
                } else if (Element.node.id == 'itens') {
                    if (!$('#multiCollapseExample2').hasClass('show')) {
                        $('#multiCollapseExample2').collapse('show');
                    }
                } else if (Element.node.id == 'aviamentos') {
                    if (!$('#multiCollapseExample3').hasClass('show')) {
                        $('#multiCollapseExample3').collapse('show');
                    }
                } else if (Element.node.id == 'compras') {
                    if (!$('#multiCollapseExample4').hasClass('show')) {
                        $('#multiCollapseExample4').collapse('show');
                    }
                }
            },
            onPrevious: (Element) => {
                if (
                    Element.node.id == "geral"
                ) {
                    if ($("#geral>a").hasClass("collapsed")) {
                        $("#multiCollapseExample1").collapse("show");
                    }
                } else if (Element.node.id == "dados-contratuais") {
                    if ($("#itens>a").hasClass("collapsed")) {
                        $("#multiCollapseExample2").collapse("show");
                    }
                } else if (Element.node.id == "dados-pagamento") {
                    if ($("#aviamentos>a").hasClass("collapsed")) {
                        $("#multiCollapseExample3").collapse("show");
                    }
                } else if (Element.node.id == "outros") {
                    if ($("#compras>a").hasClass("collapsed")) {
                        $("#multiCollapseExample4").collapse("show");
                    }
                }
            }
        });

        driver.defineSteps([{
            element: '#geral',
            popover: {
                title: 'Aba Geral',
                description: 'Clique aqui para abrir a aba geral.',
                position: 'top'
            }
        },
        {
            element: '#multiCollapseExample1',
            popover: {
                title: 'Dados Gerais',
                description: 'Esses são os campos que você preencherá com os dados gerais de cadastro.',
                position: 'top'
            }
        },
        {
            element: '#itens',
            popover: {
                title: 'Aba Cores',
                description: 'Clique aqui para abrir a aba cores/itens.',
                position: 'top'
            }
        },
        {
            element: '#multiCollapseExample2',
            popover: {
                title: 'Dados de Cores',
                description: 'Aqui ficam as cores e preços das cores do material.',
                position: 'top'
            }
        },
        {
            element: '#btnControleItens',
            popover: {
                title: 'Modal Controle de Itens',
                description: 'Clicando neste botão abrirá um modal para fazer a manutenção das cores do material.',
                position: 'top'
            }
        },
        {
            element: '#btnQuebras',
            popover: {
                title: 'Modal Quebras',
                description: 'Clicando neste botão abrirá um modal para fazer a manutenção das quebras do material.',
                position: 'top'
            }
        },
        {
            element: '#btnPrecoTinturaria',
            popover: {
                title: 'Modal Preço Tinturaria',
                description: 'Clicando neste botão abrirá um modal para buscar o preço da tinturaria das cores do material.',
                position: 'top'
            }
        },
        {
            element: '#btnCustoMalhas',
            popover: {
                title: 'Modal Custo Malha',
                description: 'Clicando neste botão abrirá um modal para buscar o custo das malhas do material.',
                position: 'top'
            }
        },
        {
            element: '#aviamentos',
            popover: {
                title: 'Aba Aviamentos',
                description: 'Clique aqui para abrir a aba aviamentos.',
                position: 'top'
            }
        },
        {
            element: '#multiCollapseExample3',
            popover: {
                title: 'Dados de Aviamentos',
                description: 'Aqui ficam os aviamentos e preços dos aviamentos do material.',
                position: 'top'
            }
        },
        {
            element: '#btnAviamentos',
            popover: {
                title: 'Modal Aviamentos',
                description: 'Clicando neste botão abrirá um modal para fazer a manutenção dos aviamentos do material.',
                position: 'top'
            }
        },
        {
            element: '#compras',
            popover: {
                title: 'Aba Últimas Compras',
                description: 'Clique aqui para abrir a aba últimas compras.',
                position: 'top'
            }
        },
        {
            element: '#multiCollapseExample4',
            popover: {
                title: 'Últimas Compras',
                description: 'Aqui ficam as últimas compras do material.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: 'Botão Voltar',
                description: 'Ao clicar nesse botão você retorna para a tela de consulta.',
                position: "left",
            },
        },
        {
            element: '#btnGravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Ao clicar nesse botão você grava os dados inseridos.',
                position: 'left'
            }
        }
        ]);

        driver.start();
    });
});

function retornaOpcoes(sChave, tabela) {

    let retorno = '<div> ' +
        '    <button class="btn btn-info btn-sm dropdown-toggle btnOpcoesOrdem" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">' + sChave +
        '    </button> ' +
        '    <div class="dropdown-menu"> '
    if (tabela == 'tabelaControleItens') {
        retorno += '    <button class="dropdown-item" id="btn-alterar-ci">Alterar</button>' +
            '    <button class="dropdown-item" id="btn-excluir-ci">Excluir</button>'
    } else if (tabela == 'tabelaPrecoTin') {
        retorno += '    <button class="dropdown-item" id="btn-alterar-precotin">Alterar</button>'
    } else if (tabela == 'tabelaQuebras') {
        retorno += '    <button class="dropdown-item" id="btn-alterar-quebras">Alterar</button>' +
            '    <button class="dropdown-item" id="btn-excluir-quebras">Excluir</button>'
    } else if (tabela == 'tabelaModalAviamentos') {
        retorno += '    <button class="dropdown-item" id="btn-alterar-avi">Alterar</button>' +
            '    <button class="dropdown-item" id="btn-excluir-avi">Excluir</button>'
    }

    retorno += '    </div>';

    return retorno;
};

function retornaFloat(valor) {
    if (valor == '') {
        valor = 0;
    };

    if (typeof valor == 'string') {
        valor = valor.replace(',', '.');
    };

    valor = parseFloat(valor);

    return valor;
}

$(document).ready(async function () {

    const queryString = window.location.href;
    const parametros = queryString.split('/');
    let codMat = parametros[parametros.length - 1];

    let inclusaoCI = false;
    let inclusaoQuebras = false;

    const {
        cus210_7,
        cus210_8,
        cus280_10,
        cus280_18,
        cus280_19,
        cus280_32,
    } = await retornarParametrosErp()

    async function retornarParametrosErp() {
        try {
            const response = await requisicao("GET", `/sisplan/cadmatpreco/v1/parametroserp?`, '', '', 3600000)

            const json = await response.json()

            const { resultado, mensagem } = json
            if (mensagem?.codigo !== 200) {
                throw mensagem?.mensagem
            }

            const cus210_7 = resultado?.cus210_7 ?? ""
            const cus210_8 = resultado?.cus210_8 ?? ""
            const cus280_10 = resultado?.cus280_10 ?? ""
            const cus280_18 = resultado?.cus280_19 ?? ""
            const cus280_19 = resultado?.cus280_19 ?? ""
            const cus280_32 = resultado?.cus280_32 ?? ""

            return {
                cus210_7,
                cus210_8,
                cus280_10,
                cus280_18,
                cus280_19,
                cus280_32,
            }
        } catch (error) {
            console.error(error)
            msgErro(error)
            return {
                cus210_7: "",
                cus210_8: "",
                cus280_10: "",
                cus280_18: "",
                cus280_19: "",
                cus280_32: "",
            }
        }
    }

    if (codMat !== 'create') {
        $('#txtCodigo').prop('disabled', true);
        $('#txtCodigo').prop('readonly', true);
        $('#btnCodigo').prop('disabled', true);
        $('#btnCodigo').prop('readonly', true);
        carregarCadastro(codMat)
    } else {
        $('.create').prop('disabled', false);
    }

    $('#txtCodigo').on('input', function () {
        buscarDadosCodigoInformado(
            $(this).val()
        ).then(({ DESCRICAO: descricao, UNIDADE: unidade, DIVISOR: divisor }) => {
            $('#txtDescricao').val(descricao)
            $('#txtUnidade').val(unidade)
            $('#txtFatorConversao').val(retornarFloatFormatadoEmMonetario({ valor: divisor, quantidadeCasasDecimais: 5 }))
        }).catch((error) => {
            msgErro('Ocorreu um erro ao buscar os dados.')
            console.error(error)
        })
    })

    async function buscarDadosCodigoInformado(produto) {
        const pesquisa = {
            camposSelect: ['DESCRICAO', 'UNIDADE', 'DIVISOR'],
            tabela: 'MATERIAL',
            where: [`CODIGO = '${produto}'`],
        }
        const result = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa))
        return result[0] || {
            DESCRICAO: '',
            UNIDADE: '',
            DIVISOR: 0,
        }
    }

    $('#btnCodigo').pesquisa_serverside(
        ['#txtCodigo', '#txtDescricao', '#txtUnidade', '#txtFatorConversao'],
        ['CODIGO', 'DESCRICAO', 'UNIDADE', 'DIVISOR'],
        ['CODIGO', 'DESCRICAO', 'UNIDADE', 'DIVISOR'],
        '{"tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO", "UNIDADE", "DIVISOR" ], "where": null}',
        'Pesquisa Material',
        undefined,
        [true, true, true],
    );

    componenteFiltro('grupoPreco', false, false, 'Grupo')
    componenteFiltro('setor', false, false)
    componenteFiltro('parte', false, false)

    function carregarCadastro(codigo) {
        $.LoadingOverlay('show')
        buscarDadosCadastro(codigo).then((dados) => {
            if (!dados) {
                return
            }
            if (dados.capa) {
                alimentarDadosCapa(dados.capa)
            }
            criarTabelaCores(dados.cores)
            criarTabelaAviamentos(dados.aviamentos)
            alimentarUltimasCompras(dados.ultimasCompras)
            criarTabelaQuebraSalvar(dados.quebras)
            carregarFoto(codigo)
            $('#tituloModalAviamentos').html(`[${dados.capa?.codigo} - ${dados.capa?.descricao}] - Aviamentos`)
        }).catch((error) => {
            console.error(error)
            msgErro('Ocorreu um erro ao carregar os dados.')
        }).finally(() => {
            $.LoadingOverlay('hide')
        })
    }

    async function buscarDadosCadastro(codigo) {
        const response = await requisicao("GET", `/sisplan/cadmatpreco/v1/dadoscadastro?`, `CODIGO=${encodeURIComponent(codigo)}`, '', 3600000)

        const json = await response.json()

        if (json) {
            const { resultado, mensagem } = json
            if (mensagem?.codigo !== 200) {
                throw mensagem?.mensagem
            }

            return resultado
        }
    }

    function alimentarDadosCapa(dados) {
        $('#cbProduzido').prop('checked', dados.produzido)
        $('#txtCodigo').val(dados.codigo)
        $('#txtDescricao').val(dados.descricao)
        $('#txtUnidade').val(dados.unidade)
        $('#txtData').val(retornarDataISOEmYMD({ dataISO: dados.data, separadorData: '-', usarUTC: true }))
        $('#txtDataUltimaAtualizacao').val(retornarDataISOEmYMD({ dataISO: dados.ultimaAtualizacao, separadorData: '-', usarUTC: true }))
        insereValor('#txtGrupo', dados.grupo, dados.descricaoGrupo)
        insereValor('#txtSetor', dados.setor, dados.descricaoSetor)
        insereValor('#txtParte', dados.parte, dados.descricaoParte)
        $('#txtPrecoCompra').val(retornarFloatFormatadoEmMonetario({ valor: dados.precoCompra, quantidadeCasasDecimais: 6 }))
        $('#txtCreditoIPI').val(retornarFloatFormatadoEmMonetario({ valor: dados.percentualIpi }))
        $('#cbCreditoIPI').prop('checked', dados.creditaIpi)
        $('#txtCreditoICMS').val(retornarFloatFormatadoEmMonetario({ valor: dados.percentualIcms }))
        $('#cbCreditoICMS').prop('checked', dados.creditaIcms)
        $('#txtCreditoPIS').val(retornarFloatFormatadoEmMonetario({ valor: dados.percentualPis }))
        $('#cbCreditoPIS').prop('checked', dados.creditaPis)
        $('#txtCreditoCOFINS').val(retornarFloatFormatadoEmMonetario({ valor: dados.percentualCofins }))
        $('#cbCreditoCOFINS').prop('checked', dados.creditaCofins)
        $('#txtDespesasIPI').val(retornarFloatFormatadoEmMonetario({ valor: dados.despesasIpi }))
        $('#txtFrete').val(retornarFloatFormatadoEmMonetario({ valor: dados.percentualFrete }))
        $('#txtValorFrete').val(retornarFloatFormatadoEmMonetario({ valor: dados.valorFrete }))
        $('#txtFatorConversao').val(retornarFloatFormatadoEmMonetario({ valor: dados.fatorConversao, quantidadeCasasDecimais: 5 }))
        $('#txtAproveitamento').val(retornarFloatFormatadoEmMonetario({ valor: dados.aproveitamento }))
        $('#txtPrecoAnterior').val(retornarFloatFormatadoEmMonetario({ valor: dados.preco4 }))
        $('#txtMVA').val(retornarFloatFormatadoEmMonetario({ valor: dados.mva }))
        $('#txtPreco1').val(retornarFloatFormatadoEmMonetario({ valor: dados.preco1, quantidadeCasasDecimais: 6 }))
        $('#txtPreco2').val(retornarFloatFormatadoEmMonetario({ valor: dados.preco2, quantidadeCasasDecimais: 6 }))
        $('#txtPreco3').val(retornarFloatFormatadoEmMonetario({ valor: dados.preco3, quantidadeCasasDecimais: 6 }))
        $('#txtLarguraMalha').val(retornarFloatFormatadoEmMonetario({ valor: dados.largura }))
        $('#txtGramatura').val(retornarFloatFormatadoEmMonetario({ valor: dados.gramatura }))
        $('#txtIndicePeso').val(retornarFloatFormatadoEmMonetario({ valor: dados.indicePeso }))
        $('#txtInformacoesComplementares').val(dados.informacoesComplementares)
        $('#txtObs').val(dados.observacao)
    }

    function criarTabelaCores(data = []) {
        if ($.fn.DataTable.isDataTable('#tabelaCores')) {
            $('#tabelaCores').DataTable().destroy()
            $('#tabelaCores').empty()
        }

        const columns = [
            {
                data: 'id',
                title: 'Id',
            },
            {
                data: 'ativo',
                title: 'Ativo',
                render: function (data) {
                    return data ? 'S' : 'N'
                }
            },
            {
                data: 'codigo',
                title: 'Código',
            },
            {
                data: 'descricao',
                title: 'Descrição',
            },
            {
                data: 'precoTingimento',
                title: 'Preço Tingimento',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'precoCompra',
                title: 'Preço Compra',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'percentualDesperdicio',
                title: '% Desperdício',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'preco',
                title: 'Preço',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'pantone',
                title: 'Pantone',
            },
            {
                data: 'tinturaria',
                title: 'Tinturaria',
            },
            {
                data: 'nome',
                title: 'Nome',
            },
            {
                data: 'codigo2',
                title: 'Código 2',
            },
            {
                data: 'grupo',
                title: 'Grupo',
            },
            {
                data: 'descricaoGrupo',
                title: 'Descrição Grupo',
            },
            {
                data: 'fatorConversao',
                title: 'Fator Conversão',
                visible: false,
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario()
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 5 })
                },
            },
        ]

        $("#tabelaCores").DataTable({
            info: false,
            order: false,
            sort: false,
            paging: true,
            destroy: true,
            lengthChange: false,
            filter: false,
            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '315px',
        }).draw(false)
    }

    function criarTabelaControleItens(data = []) {
        if ($.fn.DataTable.isDataTable('#tabelaControleItens')) {
            $('#tabelaControleItens').DataTable().destroy()
            $('#tabelaControleItens').empty()
        }

        const columns = [
            {
                data: 'id',
                title: 'Id',
            },
            {
                data: 'ativo',
                title: 'Ativo',
                render: function (data) {
                    return data ? 'S' : 'N'
                }
            },
            {
                data: 'codigo',
                title: 'Código',
                render: function (data) {
                    return retornaOpcoes(data, 'tabelaControleItens');
                }
            },
            {
                data: 'descricao',
                title: 'Descrição',
            },
            {
                data: 'precoTingimento',
                title: 'Preço Tingimento',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'precoCompra',
                title: 'Preço Compra',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'percentualDesperdicio',
                title: '% Desperdício',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'preco',
                title: 'Preço',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'pantone',
                title: 'Pantone',
            },
            {
                data: 'tinturaria',
                title: 'Tinturaria',
                visible: false,
            },
            {
                data: 'nome',
                title: 'Nome',
                visible: false,
            },
            {
                data: 'codigo2',
                title: 'Código 2',
                visible: false,
            },
            {
                data: 'grupo',
                title: 'Grupo',
            },
            {
                data: 'descricaoGrupo',
                title: 'Descrição Grupo',
            },
            {
                data: 'fatorConversao',
                title: 'Fator Conversão',
                visible: false,
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario()
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 5 })
                },
            },
        ]

        $("#tabelaControleItens").DataTable({
            info: false,
            order: false,
            sort: false,
            paging: true,
            destroy: true,
            lengthChange: false,
            filter: false,
            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '300px',
        }).draw(false)
    }

    function criarTabelaAviamentos(data = []) {
        if ($.fn.DataTable.isDataTable('#tabelaAviamentos')) {
            $('#tabelaAviamentos').DataTable().destroy()
            $('#tabelaAviamentos').empty()
        }

        const columns = [
            {
                data: 'ordem',
                title: 'Ordem',
            },
            {
                data: 'codigo',
                title: 'Código',
            },
            {
                data: 'descricao',
                title: 'Descrição',
            },
            {
                data: 'unidade',
                title: 'Unidade',
            },
            {
                data: 'quantidade',
                title: 'Quantidade',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'custo',
                title: 'Custo',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'quebra',
                title: 'Quebra',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'valor',
                title: 'Valor',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'acumulado',
                title: 'Acumulado',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'ultimaAtualizacao',
                title: 'Atualizado Em',
                render: function (data) {
                    return retornarDataISOEmYMD({ dataISO: data, reverso: true, usarUTC: true })
                }
            },
        ]

        $("#tabelaAviamentos").DataTable({
            info: false,
            order: false,
            sort: false,
            paging: true,
            destroy: true,
            lengthChange: false,
            filter: false,
            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '315px',
        }).draw(false)
    }

    function criarTabelaQuebraSalvar(data = []) {
        if ($.fn.DataTable.isDataTable('#tabelaQuebrasGravar')) {
            $('#tabelaQuebrasGravar').DataTable().destroy()
            $('#tabelaQuebrasGravar').empty()
        }

        const columns = [
            {
                data: 'ordem',
                title: 'Ordem',
            },
            {
                data: 'codigo',
                title: 'Código',
            },
            {
                data: 'descricao',
                title: 'Descrição',
            },
            {
                data: 'unidade',
                title: 'Unidade',
            },
            {
                data: 'quebra',
                title: 'Quebra',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
        ]

        $("#tabelaQuebrasGravar").DataTable({
            info: false,
            order: false,
            sort: false,
            paging: true,
            destroy: true,
            lengthChange: false,
            filter: false,
            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '315px',
        }).draw(false)
    }

    function criarTabelaQuebra(data = []) {
        if ($.fn.DataTable.isDataTable('#tabelaQuebras')) {
            $('#tabelaQuebras').DataTable().destroy()
            $('#tabelaQuebras').empty()
        }

        const columns = [
            {
                data: 'ordem',
                title: 'Ordem',
            },
            {
                data: 'codigo',
                title: 'Código',
                render: function (data) {
                    return retornaOpcoes(data, 'tabelaQuebras');
                }
            },
            {
                data: 'descricao',
                title: 'Descrição',
            },
            {
                data: 'unidade',
                title: 'Unidade',
            },
            {
                data: 'quebra',
                title: 'Quebra',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
        ]

        $("#tabelaQuebras").DataTable({
            info: false,
            order: false,
            sort: false,
            paging: true,
            destroy: true,
            lengthChange: false,
            filter: false,
            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '315px',
        }).draw(false)
    }

    function criarTabelaPrecoTin(data = []) {
        if ($.fn.DataTable.isDataTable('#tabelaPrecoTin')) {
            $('#tabelaPrecoTin').DataTable().destroy()
            $('#tabelaPrecoTin').empty()
        }

        const columns = [
            {
                data: 'codigo',
                title: 'Código',
                render: function (data) {
                    return retornaOpcoes(data, 'tabelaPrecoTin');
                }
            },
            {
                data: 'descricao',
                title: 'Descrição',
            },
            {
                data: 'precoAtual',
                title: 'Preço Atual',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'precoTintur',
                title: 'Preço Tintur',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'precoNovo',
                title: 'Preço Novo',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'pantone',
                title: 'Pantone',
                visible: false
            },
            {
                data: 'tinturaria',
                title: 'Tinturaria',
                visible: false
            },
            {
                data: 'nome',
                title: 'Nome',
                visible: false
            },
            {
                data: 'codigo2',
                title: 'Codigo2',
                visible: false
            },
            {
                data: 'grupo',
                title: 'Grupo',
                visible: false
            },
            {
                data: 'descGrupo',
                title: 'Desc Grupo',
                visible: false
            },
        ]

        $("#tabelaPrecoTin").DataTable({
            info: false,
            order: false,
            sort: false,
            paging: true,
            destroy: true,
            lengthChange: false,
            filter: false,
            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '315px',
        }).draw(false)
    }

    function criarTabelaCustoMalhaBase(data = []) {
        if ($.fn.DataTable.isDataTable('#tabelaCustoMalhaBase')) {
            $('#tabelaCustoMalhaBase').DataTable().destroy()
            $('#tabelaCustoMalhaBase').empty()
        }

        const columns = [
            {
                data: 'cor',
                title: 'Cor',
            },
            {
                data: 'descricao',
                title: 'Descrição',
            },
            {
                data: 'custoCrua',
                title: 'Custo Crua',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'custoTin',
                title: 'Custo Tint',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'percentualDesperdicio',
                title: '% Desperdício',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'custoTotal',
                title: 'Custo Total',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
        ]

        $("#tabelaCustoMalhaBase").DataTable({
            info: false,
            order: false,
            sort: false,
            paging: true,
            destroy: true,
            lengthChange: false,
            filter: false,
            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '315px',
        }).draw(false)
    }

    function criarTabelaCustoMalhaCrua(data = []) {
        if ($.fn.DataTable.isDataTable('#tabelaCustoMalhaCrua')) {
            $('#tabelaCustoMalhaCrua').DataTable().destroy()
            $('#tabelaCustoMalhaCrua').empty()
        }

        const columns = [
            {
                data: 'codigo',
                title: 'Código',
            },
            {
                data: 'descricao',
                title: 'Descrição',
            },
            {
                data: 'cor',
                title: 'Cor',
            },
            {
                data: 'descCor',
                title: 'Desc. Cor',
            },
            {
                data: 'custoFio',
                title: 'Custo Fio',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'desperdicio',
                title: 'Desperdício',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'custoQuebra',
                title: 'Custo Quebra',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'custoTotal',
                title: 'Custo Total',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
        ]

        $("#tabelaCustoMalhaCrua").DataTable({
            info: false,
            order: false,
            sort: false,
            paging: true,
            destroy: true,
            lengthChange: false,
            filter: false,
            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '315px',
        }).draw(false)
    }

    function criarTabelaCustoMalhaRotativa(data = []) {
        if ($.fn.DataTable.isDataTable('#tabelaCustoMalhaRotativa')) {
            $('#tabelaCustoMalhaRotativa').DataTable().destroy()
            $('#tabelaCustoMalhaRotativa').empty()
        }

        const columns = [
            {
                data: 'corRotativa',
                title: 'Cor Rotativa',
            },
            {
                data: 'descCor',
                title: 'Desc_cor',
            },
            {
                data: 'corFundo',
                title: 'Cor Fundo',
            },
            {
                data: 'descCorFundo',
                title: 'Desc_cor_fundo',
            },
            {
                data: 'preco',
                title: 'Preço',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'custoMalha',
                title: 'Custo Malha',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'desperdicio',
                title: 'Desperdício',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'custoTotal',
                title: 'Custo Total',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
        ]

        $("#tabelaCustoMalhaRotativa").DataTable({
            info: false,
            order: false,
            sort: false,
            paging: true,
            destroy: true,
            lengthChange: false,
            filter: false,
            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '315px',
        }).draw(false)
    }

    async function prepararDadosPrecoTin(dados = []) {
        let pis = 0;
        let cofins = 0;

        let consulta = await buscaValor('EMPRESA', 'EMP_PIS', 'EMP_PAT', getCookie('empresa'));
        if (consulta) pis = retornaFloat(consulta.EMP_PIS);

        consulta = await buscaValor('EMPRESA', 'EMP_COFINS', 'EMP_PAT', getCookie('empresa'));
        if (consulta) cofins = retornaFloat(consulta.EMP_COFINS);

        return dados.map(item => {
            let precoAtual = item.PRECO_ATUAL ? retornaFloat(item.PRECO_ATUAL) : 0;
            let precoTintur = item.PRECO ? retornaFloat(item.PRECO) : 0;

            let precoNovo = precoTintur;
            if (cus210_7 === 'S') {
                precoNovo -= (precoTintur * (pis / 100));
            }
            if (cus210_8 === 'S') {
                precoNovo -= (precoTintur * (cofins / 100));
            }

            return {
                codigo: item.codigo,
                descricao: item.descricao,
                precoAtual,
                precoTintur,
                precoNovo,
                pantone: item.pantone,
                tinturaria: item.tinturaria,
                nome: item.nome,
                codigo2: item.codigo2,
                grupo: item.grupo,
                descGrupo: item.descGrupo
            }
        })
    }

    function prepararDadosMalhaCrua(dados = []) {
        if (dados) {
            return dados.map((e) => {
                let aprov = retornaFloat(e.aproveitamento)
                let qtde = retornaFloat(e.perc) / 100
                let precoCompra = retornaFloat(e.precoCompra)
                let desperdicio = retornaFloat(e.desperdicio)
                let valor = 0

                let custoQuebra = 0
                let custoTotal = 0

                if (e.unidade === 'HO' || e.unidade === 'HR') {
                    valor = (precoCompra * (qtde / 60)) / (aprov / 100)

                    if (desperdicio > 0) {
                        valor = valor / ((100 - desperdicio) / 100)
                    }
                    custoQuebra = valor
                } else {
                    if (aprov < 10) {
                        aprov = 100
                    }
                    valor = (precoCompra * qtde) / (aprov / 100)
                    if (desperdicio > 0 && desperdicio < 100) {
                        valor = valor / ((100 - desperdicio) / 100)
                    }
                    custoQuebra = valor
                }

                custoTotal = custoQuebra

                return {
                    codigo: e.codigo,
                    descricao: e.descricao,
                    cor: e.cor,
                    descCor: e.descCor,
                    custoFio: precoCompra,
                    desperdicio: desperdicio,
                    custoQuebra: custoQuebra,
                    custoTotal: custoTotal,
                }
            })
        } else {
            return []
        }
    }

    function carregarFoto(codigo) {
        buscarFoto(codigo).then((fotoBase64) => {
            $("#imagemMat").attr('src', fotoBase64)
        })
    }

    async function buscarFoto(codigo) {
        try {
            const response = await requisicao('GET', '/sisplan/Funcoes/v1/FotoItem?', `codigo=${codigo}`, null)

            if (!response) {
                return;
            }

            const jsonStr = await response.json()
            if (response.status != 200) {
                throw jsonStr.mensagem
            }

            return `data:image/png;base64,${jsonStr.mensagem}`
        } catch (error) {
            console.error(error)
            return `${BASE_URI}/dist/img/prod-1.png`
        }
    }

    $('#txtCodigo').on('blur', async function () {
        validarSeCodigoInformadoJaExiste(this.value)
    });

    async function validarSeCodigoInformadoJaExiste(codigo) {
        try {
            $.LoadingOverlay('show')
            const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"MAT_PRECO",
                "camposSelect":["CODIGO, TIPO"],
                "where": ["MAT_PRECO.CODIGO = '${codigo}'", "MAT_PRECO.EMP_ID = '${getCookie('emp_id')}'"]}`, null);

            if (!response) {
                return;
            }

            const jsonStr = await response.json()
            const [dadosItemJaCadastrado] = jsonStr?.RESULT[0];

            if (!dadosItemJaCadastrado) {
                $('.create').prop('disabled', false);
                return
            }

            msgAlerta(
                'Item já cadastrado, deseja alterar os dados?',
                () => {
                    if (dadosItemJaCadastrado.TIPO == 'M' || !dadosItemJaCadastrado.TIPO) {
                        carregarCadastro(codigo)
                        $('.create').prop('disabled', false)
                        $('#txtCodigo').prop('disabled', true)
                    } else {
                        window.location.href = `${BASE_URI}/cadprodpreco/${codigo}`;
                    }
                },
                () => {
                    $('.create').prop('disabled', true);
                    $('#txtCodigo').val('');
                    $('#txtDescricao').val('');
                    $('#txtUnidade').val('');
                    codMat = codigo
                })
        } catch (error) {
            console.error(error)
            msgErro('Ocorreu um erro ao validar os dados.')
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    function alimentarUltimasCompras(dados) {
        const conteudoUltimasCompras = retornarConteudoUltimasCompras(dados)
        $('#cardbody-compras').append(conteudoUltimasCompras)
    }

    function retornarConteudoUltimasCompras(dados) {

        $('#cardbody-compras').empty();

        let card = '';

        if (dados?.length > 0) {

            card = '<div class="scroll" style="max-height: 500px; overflow-y: scroll">' +
                '<div style="background-color: white; height: 1px;">' +
                '</div>';


            dados.forEach((compra) => {

                card += '<div class="card col-12">' +
                    '<div style="background-color: var(--font-color); height: 1px;">' +
                    '</div>' +
                    '<div class="form-row pl-1 pt-2 col-12">' +
                    '<h6 class="col-9"><b>Fornecedor:</b> [' +
                    compra.codigoFornecedor + '] - ' + compra.nomeFornecedor +
                    '</h6>' +
                    '<h6 class="col-3"><b>Nota:</b> ' +
                    compra.notaFiscal +
                    '</h6>' +
                    '</div>' +
                    '<div class="form-row pl-1 col-12">' +
                    '<h6 class="col-2"><b>Data:</b> ' +
                    retornarDataISOEmYMD({ dataISO: compra.dataEntrada, reverso: true, usarUTC: true }) +
                    '</h6>' +
                    '<h6 class="col-3"><b>Unidade de Compra:</b> ' +
                    compra.unidadeCompra +
                    '</h6>' +
                    '<h6 class="col-2"><b>Redução ICMS:</b> ' +
                    retornarFloatFormatadoEmMonetario({ valor: compra.percentualIcmsReduzido }) +
                    '</h6>' +
                    '<h6 class="col-2"><b>Quantidade:</b> ' +
                    retornarFloatFormatadoEmMonetario({ valor: compra.quantidade }) +
                    '</h6>' +
                    '<h6 class="col-3"><b>Preço:</b> ' +
                    retornarFloatFormatadoEmMonetario({ valor: compra.valor }) +
                    '</h6>' +
                    '</div' +
                    '<div class="form-row pl-1 pt-1 col-12">' +
                    '<h6 class="col-2"><b>Fator Conversão:</b> ' +
                    retornarFloatFormatadoEmMonetario({ valor: compra.fatorConversao }) +
                    '</h6>' +
                    '<h6 class="col-3"><b>Preço Convertido:</b> ' +
                    retornarFloatFormatadoEmMonetario({ valor: compra.precoConvertido }) +
                    '</h6>' +
                    '<h6 class="col-2"><b>Val Uni ICMS:</b> ' +
                    retornarFloatFormatadoEmMonetario({ valor: compra.valorUnitarioIcms }) +
                    '</h6>' +
                    '<h6 class="col-2"><b>Val Uni IPI:</b> ' +
                    retornarFloatFormatadoEmMonetario({ valor: compra.valorUnitarioIpi }) +
                    '</h6>' +
                    '<h6 class="col-3"><b>Custo Mat_Mov:</b> ' +
                    retornarFloatFormatadoEmMonetario({ valor: compra.custo }) +
                    '</h6>' +
                    '</div> ' +
                    '<div style="background-color: var(--font-color); height: 1px;">' +
                    '</div>' +
                    '</div>';
            })
        } else {
            card = '<div class="scroll flex" style="max-height: 500px">' +
                '<div style="background-color: var(--font-color); height: 1px;">' +
                '</div>';

            card += '<div class="d-flex justify-content-center">' +
                '<h6 class="my-3"><b>Nenhum registro encontrato</b>' +
                '</h6>' +
                '</div>'
        }

        card += '<div style="background-color: var(--font-color); height: 1px;">' +
            '</div>' +
            '</div>';

        return card
    }

    $('#multiCollapseExample2').on('shown.bs.collapse', function () {
        $('#tabelaCores').DataTable().columns.adjust().draw(false)
    });

    $('#multiCollapseExample3').on('shown.bs.collapse', function () {
        $('#tabelaAviamentos').DataTable().columns.adjust().draw(false)
    });

    $('.campoRecalcularCusto').on('blur', function () {
        const valoresCalcularCusto = retornarValoresCalcularCusto()
        const custo = retornarCustoCalculado(valoresCalcularCusto)
        $('#txtPreco1').val(retornarFloatFormatadoEmMonetario({ valor: custo, quantidadeCasasDecimais: 6 }))
    })

    $('.cbRecalcularCusto').on('change', function () {
        const valoresCalcularCusto = retornarValoresCalcularCusto()
        const custo = retornarCustoCalculado(valoresCalcularCusto)
        $('#txtPreco1').val(retornarFloatFormatadoEmMonetario({ valor: custo, quantidadeCasasDecimais: 6 }))
    })

    function retornarValoresCalcularCusto() {
        const precoCompra = retornarValorMonetarioEmFloat($('#txtPrecoCompra').val())
        const descontarIpi = $('#cbCreditoIPI').prop('checked')
        const percentualIpi = retornarValorMonetarioEmFloat($('#txtCreditoIPI').val())
        const descontarIcms = $('#cbCreditoICMS').prop('checked')
        const percentualIcms = retornarValorMonetarioEmFloat($('#txtCreditoICMS').val())
        const descontarPis = $('#cbCreditoPIS').prop('checked')
        const percentualPis = retornarValorMonetarioEmFloat($('#txtCreditoPIS').val())
        const descontarCofins = $('#cbCreditoCOFINS').prop('checked')
        const percentualCofins = retornarValorMonetarioEmFloat($('#txtCreditoCOFINS').val())
        const percentualFrete = retornarValorMonetarioEmFloat($('#txtFrete').val())
        const valorFrete = retornarValorMonetarioEmFloat($('#txtValorFrete').val())
        const despesasIpi = retornarValorMonetarioEmFloat($('#txtDespesasIPI').val())
        const mva = retornarValorMonetarioEmFloat($('#txtMVA').val())

        return {
            precoCompra,
            descontarIpi,
            percentualIpi,
            descontarIcms,
            percentualIcms,
            descontarPis,
            percentualPis,
            descontarCofins,
            percentualCofins,
            percentualFrete,
            valorFrete,
            despesasIpi,
            mva,
        }
    }

    function retornarCustoCalculado({
        precoCompra,
        descontarIpi,
        percentualIpi,
        descontarIcms,
        percentualIcms,
        descontarPis,
        percentualPis,
        descontarCofins,
        percentualCofins,
        percentualFrete,
        valorFrete,
        despesasIpi,
        mva,
    }) {
        try {
            if (precoCompra > 0) {
                let preco = precoCompra;

                if (descontarIpi) {
                    preco -= precoCompra * (percentualIpi / 100);
                };

                if (descontarIcms) {
                    preco -= precoCompra * (percentualIcms / 100);
                };

                if (descontarPis) {
                    preco -= precoCompra * (percentualPis / 100);
                };

                if (descontarCofins) {
                    preco -= precoCompra * (percentualCofins / 100);
                };

                preco += (precoCompra * (percentualFrete / 100)) + valorFrete;

                preco += precoCompra * (despesasIpi / 100);

                preco += precoCompra * (mva / 100);

                impostos = preco / precoCompra;

                if (precoCompra == 1000) {
                    precoCompra = 0;
                    preco = 0;
                };

                return preco
            }
        } catch (error) {
            console.error(error);
            msgErro(`Ocorreu um erro ao buscar os dados.`);
        }
    };

    $('#btnGravar').on('click', async function () {
        const dadosGravar = retornarDadosGravar()
        if (!validarDadosGravar(dadosGravar)) {
            return
        }

        msgAlerta('Deseja gravar os dados?', async () => {
            gravar(dadosGravar)
        });
    });

    function retornarDadosGravar() {
        const capa = retornarCapaGravar();
        const cores = retornarCoresGravar();
        const aviamentos = retornarAviamentosGravar();
        const quebras = retornarQuebrasGravar();

        return {
            capa,
            cores,
            aviamentos,
            quebras,
        }
    }

    function retornarCapaGravar() {
        const produzido = $('#cbProduzido').prop('checked')
        const codigo = $('#txtCodigo').val()
        const descricao = $('#txtDescricao').val()
        const unidade = $('#txtUnidade').val()
        const grupo = pegaChave('#txtGrupo')
        const setor = pegaChave('#txtSetor')
        const parte = pegaChave('#txtParte')
        const precoCompra = retornarValorMonetarioEmFloat($('#txtPrecoCompra').val())
        const preco1 = retornarValorMonetarioEmFloat($('#txtPreco1').val())
        const preco2 = retornarValorMonetarioEmFloat($('#txtPreco2').val())
        const preco3 = retornarValorMonetarioEmFloat($('#txtPreco3').val())
        const preco4 = retornarValorMonetarioEmFloat($('#txtPreco4').val())
        const percentualIpi = retornarValorMonetarioEmFloat($('#txtCreditoIPI').val())
        const creditaIpi = $('#txtCreditoIPI').prop('checked')
        const percentualIcms = retornarValorMonetarioEmFloat($('#txtCreditoICMS').val())
        const creditaIcms = $('#txtCreditoICMS').prop('checked')
        const percentualPis = retornarValorMonetarioEmFloat($('#txtCreditoPIS').val())
        const creditaPis = $('#cbCreditoPIS').prop('checked')
        const percentualCofins = retornarValorMonetarioEmFloat($('#txtCreditoCOFINS').val())
        const creditaCofins = $('#txtCreditoCOFINS').prop('checked')
        const despesasIpi = retornarValorMonetarioEmFloat($('#txtDespesasIPI').val())
        const percentualFrete = retornarValorMonetarioEmFloat($('#txtFrete').val())
        const valorFrete = retornarValorMonetarioEmFloat($('#txtValorFrete').val())
        const fatorConversao = retornarValorMonetarioEmFloat($('#txtFatorConversao').val())
        const aproveitamento = retornarValorMonetarioEmFloat($('#txtAproveitamento').val())
        const data = $('#txtData').val()
        const ultimaAtualizacao = $('#txtDataUltimaAtualizacao').val()
        const largura = retornarValorMonetarioEmFloat($('#txtLarguraMalha').val())
        const gramatura = retornarValorMonetarioEmFloat($('#txtGramatura').val())
        const indicePeso = retornarValorMonetarioEmFloat($('#txtIndicePeso').val())
        const mva = retornarValorMonetarioEmFloat($('#txtMVA').val())
        const informacoesComplementares = $('#txtInfoCompl').val()
        const observacao = $('#txtObs').val()

        return {
            produzido,
            codigo,
            descricao,
            unidade,
            grupo,
            setor,
            parte,
            precoCompra,
            preco1,
            preco2,
            preco3,
            preco4,
            percentualIpi,
            creditaIpi,
            percentualIcms,
            creditaIcms,
            percentualPis,
            creditaPis,
            percentualCofins,
            creditaCofins,
            despesasIpi,
            percentualFrete,
            valorFrete,
            fatorConversao,
            aproveitamento,
            data,
            ultimaAtualizacao,
            largura,
            gramatura,
            indicePeso,
            mva,
            informacoesComplementares,
            observacao,
        }
    }

    function retornarCoresGravar() {
        const tabela = $('#tabelaCores');
        if ($.fn.DataTable.isDataTable(tabela)) {
            return tabela.DataTable().data().toArray();
        }
        return [];
    }

    function retornarAviamentosGravar() {
        const tabela = $('#tabelaAviamentos');
        if ($.fn.DataTable.isDataTable(tabela)) {
            return tabela.DataTable().data().toArray();
        }
        return [];
    }

    function retornarQuebrasGravar() {
        const tabela = $('#tabelaQuebrasGravar');
        if ($.fn.DataTable.isDataTable(tabela)) {
            return tabela.DataTable().data().toArray();
        }
        return [];
    }

    function validarDadosGravar(dados) {
        if (!dados) {
            msgErro('Dados inválidos, impossível continuar..')
            return false
        }

        if (!dados.capa?.codigo) {
            msgErro('Código não informado, impossível continuar.')
            return false
        }

        if (!dados.capa?.descricao) {
            msgErro('Descrição não informada, impossível continuar.')
            return false
        }

        if (!dados.capa?.grupo) {
            msgErro('Grupo não informado, impossível continuar.')
            return false
        }

        return true
    }

    async function gravar(dados) {
        try {
            $.LoadingOverlay('show')
            const response = await requisicao('POST', `/sisplan/cadmatpreco/v1/dadoscadastro?`, '', JSON.stringify(dados), 3600000)

            const json = await response.json()

            if (json) {
                const { mensagem } = json
                if (mensagem?.codigo !== 200) {
                    throw mensagem?.mensagem
                }
            }

            toastr.success("Dados gravados com sucesso!", "Confirmação", {
                toastClass: "alert",
                iconClasses: {
                    error: "alert-error",
                    info: "alert-info",
                    success: "alert-success",
                    warning: "alert-warning",
                },
                onHidden() {
                    window.location.href = `${BASE_URI}/cadmatpreco`
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 1000,
                fadeOut: 1000,
            }).css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            })
        } catch (error) {
            console.error(error)
            msgErro('Ocorreu um erro ao gravar os dados.')
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    $('#btnAviamentos').on('click', async function () {
        carregarModalAviamentos()
    });

    function carregarModalAviamentos() {
        try {
            const dados = $('#tabelaAviamentos').DataTable().data().toArray()
            criarTabelaModalAviamentos(dados)

            $('#modalAviamentos').modal('show');
        } catch (error) {
            console.error(error)
            msgErro('Ocorreu um erro ao carregar os dados.')
        }
    }

    let indiceLinhaSelecionadaTabelaModalAviamentos = 0

    function criarTabelaModalAviamentos(data = []) {
        if ($.fn.DataTable.isDataTable('#tabelaModalAviamentos')) {
            $('#tabelaModalAviamentos').DataTable().destroy()
            $('#tabelaModalAviamentos').empty()
        }

        const columns = [
            {
                data: 'ordem',
                title: 'Ordem',
            },
            {
                data: 'codigo',
                title: 'Código',
                render: function (value, _1, _2, { row }) {
                    return `<div>
                    <div class="input-group flex-nowrap">
                      <input type="text" class="input-default focus form-control stepControlModalAviamentos${row}" id="txtCodigoModalAviamentos${row}" value="${value}" name="txtCodigoModalAviamentos${row}" placeholder="Código" style="min-width: 20ch">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnCodigoModalAviamentos${row}" name="btnCodigoModalAviamentos${row}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      </div>
                    </div>
                  </div>`
                }
            },
            {
                data: 'descricao',
                title: 'Descrição',
            },
            {
                data: 'unidade',
                title: 'Unidade',
            },
            {
                data: 'quantidade',
                title: 'Quantidade',
                className: 'text-right',
                render: function (value, _1, _2, { row }) {
                    const formattedValue = parseFloat(value).toLocaleString("pt-br", {
                        maximumFractionDigits: 4,
                        minimumFractionDigits: 4,
                    })
                    return `<div class="input-group-append justify-content-end">
                      <input type="text" value="${formattedValue}" style="min-width: 15ch; max-width: 20ch" class="input-default focus form-control validate text-right seisCasasDecimaisQuantityFormat stepControlModalAviamentos${row}" id="txtQuantidadeModalAviamentos${row}" name="txtQuantidadeModalAviamentos${row}" placeholder="0,0000">
                  </div>`
                },
            },
            {
                data: 'custo',
                title: 'Custo',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'quebra',
                title: 'Quebra',
                className: 'text-right',
                render: function (value, _1, _2, { row }) {
                    const formattedValue = parseFloat(value).toLocaleString("pt-br", {
                        maximumFractionDigits: 4,
                        minimumFractionDigits: 4,
                    })
                    return `<div class="input-group-append justify-content-end">
                      <input type="text" value="${formattedValue}" style="min-width: 15ch; max-width: 20ch" class="input-default focus form-control validate text-right seisCasasDecimaisQuantityFormat stepControlModalAviamentos${row}" id="txtQuebraModalAviamentos${row}" name="txtQuebraModalAviamentos${row}" placeholder="0,0000">
                  </div>`
                },
            },
            {
                data: 'valor',
                title: 'Valor',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'acumulado',
                title: 'Acumulado',
                className: 'text-right',
                render: function (data) {
                    if (!data) {
                        return retornarFloatFormatadoEmMonetario({ quantidadeCasasDecimais: 6 })
                    }
                    return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 6 })
                },
            },
            {
                data: 'ultimaAtualizacao',
                title: 'Atualizado Em',
                render: function (data) {
                    return retornarDataISOEmYMD({ dataISO: data, reverso: true, usarUTC: true })
                }
            },
        ]

        const table = $("#tabelaModalAviamentos").DataTable({
            info: false,
            order: false,
            sort: false,
            paging: false,
            destroy: true,
            lengthChange: false,
            filter: false,
            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '275px',
            select: {
                style: 'single',
                toggleable: false,
            },
        }).draw(false)

        function selectRow(index) {
            const row = table.row(index)
            if (row.node()) {
                table.rows().deselect()
                row.select()
            }
        }

        $('#tabelaModalAviamentos_wrapper .dataTables_scrollBody').off('wheel')
        $('#tabelaModalAviamentos_wrapper .dataTables_scrollBody').on('wheel', function (event) {
            event.preventDefault()

            const direction = event.originalEvent.deltaY > 0 ? 1 : -1
            const newIndex = indiceLinhaSelecionadaTabelaModalAviamentos + direction

            if (newIndex >= 0 && newIndex < table.rows().count()) {
                selectRow(newIndex)

                const rowNode = table.row(newIndex).node()
                $(rowNode).get(0).scrollIntoView({ behavior: 'smooth', block: 'center' })
            }
        })

        table.off('select')
        table.on('select', function (_e, _dt, type, indexes) {
            if (type === 'row') {
                indiceLinhaSelecionadaTabelaModalAviamentos = indexes[0]
            }
        })

        $(document).off('keydown')
        $(document).on('keydown', function (event) {
            if ((event.key === 'ArrowDown' || event.key === 'ArrowUp')) {
                event.preventDefault()

                const direction = event.key === 'ArrowDown' ? 1 : -1
                const newIndex = indiceLinhaSelecionadaTabelaModalAviamentos + direction

                if (newIndex >= 0 && newIndex < table.rows().count()) {
                    selectRow(newIndex)
                    const rowNode = table.row(newIndex).node()
                    $(rowNode).get(0).scrollIntoView({ behavior: 'smooth', block: 'center' })
                }
            }
        })

        selectRow(indiceLinhaSelecionadaTabelaModalAviamentos)
        adicionarEventosAviamentos(table)
    }

    $('#modalAviamentos').on('shown.bs.modal', function () {
        $('#tabelaModalAviamentos').DataTable().columns.adjust().draw(false)
    })

    $('#btnExcluirModalAviamentos').on('click', function () {
        excluirAviamento()
    })

    function excluirAviamento() {
        let datatable = $('#tabelaModalAviamentos').DataTable()
        const indicesSelecionados = datatable.rows({ selected: true }).indexes().toArray()
        if (!indicesSelecionados || indicesSelecionados.length === 0) {
            msgErro('Nenhum registro selecionado, impossível continuar.')
            return
        }
        if (indicesSelecionados.length > 1) {
            msgErro('Ocorreu um erro ao excluir, por favor tente novamente.')
            data.row(0).select()
            return
        }
        const [indiceSelecionado] = indicesSelecionados
        datatable.row(indiceSelecionado).remove()
        recalcularDadosTabelaModalAviamentos()
        datatable = $('#tabelaItensAlteracao').DataTable()
        const ultimoIndiceDisponivel = datatable.rows().count() - 1
        const proximoIndiceASerSelecionado = indiceSelecionado > ultimoIndiceDisponivel ? ultimoIndiceDisponivel : indiceSelecionado
        if (proximoIndiceASerSelecionado >= 0) {
            const row = datatable.row(proximoIndiceASerSelecionado)
            row.select()
            setTimeout(() => {
                $(row.node()).get(0).scrollIntoView({ behavior: 'smooth', block: 'center' })
            }, 150)
        }
    }

    $('#tabelaModalAviamentos').on('draw.dt', function () {
        aplicarEstilosCamposDecimais()
    })

    function retornarPesquisaAviamentos(codigo) {
        const pesquisa = {
            camposSelect: [
                'CODIGO',
                'DESCRICAO',
                'UNIDADE',
                'PRECO_1 CUSTO',
                'DT_ULT_ATUALIZACAO ATUALIZADO_EM',
            ],
            tabela: 'MAT_PRECO',
            groupBy: [
                'CODIGO',
                'DESCRICAO',
                'UNIDADE',
                'PRECO_1',
                'DT_ULT_ATUALIZACAO',
            ],
            camposSelectSubSelect: [
                'CODIGO',
                'DESCRICAO',
                'UNIDADE',
                'CUSTO',
                'ATUALIZADO_EM',
            ],
            groupBySubSelect: [
                'CODIGO',
                'DESCRICAO',
                'UNIDADE',
                'CUSTO',
                'ATUALIZADO_EM',
            ],
            camposWhereServerSide: [
                'CODIGO',
                'DESCRICAO',
            ]
        }

        if (codigo) {
            pesquisa.where = [`MAT_PRECO.CODIGO = '${codigo}'`]
        }

        return pesquisa
    }

    function adicionarEventosBotoesAviamentos(index, row) {
        $(`#btnCodigoModalAviamentos${index}`).pesquisa_serverside(
            [`#txtCodigoModalAviamentos${index}`],
            ['CODIGO', 'DESCRICAO'],
            ['DESCRICAO', 'DESCRICAO'],
            JSON.stringify(retornarPesquisaAviamentos()),
            'Pesquisa Item',
            () => {
                setTimeout(() => {
                    const valorSelecionado = $(`#txtCodigoModalAviamentos${index}`).val()
                    atualizarAviamentoComDadosDoCodigoInformado(valorSelecionado, index, row)
                }, 0)
            },
            [true],
        )
    }

    let debounceTimer;

    function adicionarEventosInputsAviamentos(index, row) {

        $(`#txtCodigoModalAviamentos${index}`).on('focus', function () {
            const input = this
            input.selectionStart = input.selectionEnd = input.value.length
        })

        let enterCampoCodigoFoiPressionado = false
        $(`#txtCodigoModalAviamentos${index}`)
            .on('keydown', function (e) {
                if (e.key === 'Enter') {
                    e.preventDefault()
                    enterCampoCodigoFoiPressionado = true
                    $(`#txtQuantidadeModalAviamentos${index}`).focus()
                    return
                }
            })
            .on('input', function () {
                if (debounceTimer) {
                    clearTimeout(debounceTimer);
                }

                if (enterCampoCodigoFoiPressionado) {
                    enterCampoCodigoFoiPressionado = false
                    return
                }

                debounceTimer = setTimeout(async () => {
                    try {
                        const valorDigitado = this.value
                        if (!valorDigitado) {
                            return
                        }
                        $(this).prop('disabled', true)
                        await atualizarAviamentoComDadosDoCodigoInformado(valorDigitado, index, row)
                        $(`#txtCodigoModalAviamentos${index}`).focus()
                    } finally {
                        $(this).prop('disabled', false)
                    }
                }, 300);
            })

        let enterCampoQuantidadeFoiPressionado = false
        $(`#txtQuantidadeModalAviamentos${index}`)
            .on('keydown', function (e) {
                enterCampoQuantidadeFoiPressionado = (e.key === 'Enter')
                if (enterCampoQuantidadeFoiPressionado) {
                    e.preventDefault()
                    $(this).blur()
                }
            })
            .on('blur', function () {
                try {
                    const quantidade = retornarValorMonetarioEmFloat(this.value)
                    const quebra = retornarValorMonetarioEmFloat($(`#txtQuebraModalAviamentos${index}`).val())
                    const data = row.data()
                    const custo = retornarValorMonetarioEmFloat(data.custo)
                    const valor = retornarValorAviamento({ custo, quantidade, quebra })

                    if (!valor || isNaN(valor)) {
                        row.data({ ...data, quantidade: 0, quebra: 0, valor: 0 })
                    } else {
                        row.data({ ...data, quantidade, quebra, valor })
                    }
                    recalcularDadosTabelaModalAviamentos()

                    if (enterCampoQuantidadeFoiPressionado) {
                        $(`#txtQuebraModalAviamentos${index}`).focus()
                    }
                } catch { }
                finally {
                    enterCampoQuantidadeFoiPressionado = false
                }
            })

        let enterCampoQuebraFoiPressionado = false
        $(`#txtQuebraModalAviamentos${index}`)
            .on('keydown', function (e) {
                enterCampoQuebraFoiPressionado = (e.key === 'Enter')
                if (enterCampoQuebraFoiPressionado) {
                    e.preventDefault()
                    $(this).blur()
                }
            }).on('blur', function () {
                try {
                    const quebra = retornarValorMonetarioEmFloat(this.value)
                    const quantidade = retornarValorMonetarioEmFloat($(`#txtQuantidadeModalAviamentos${index}`).val())
                    const data = row.data()
                    const custo = retornarValorMonetarioEmFloat(data.custo)
                    const valor = retornarValorAviamento({ quebra, quantidade, custo })

                    if (!valor || isNaN(valor)) {
                        row.data({ ...data, quantidade: 0, quebra: 0, valor: 0 })
                    } else {
                        row.data({ ...data, quantidade, quebra, valor })
                    }
                    recalcularDadosTabelaModalAviamentos()

                    if (enterCampoQuebraFoiPressionado) {
                        $(`#txtCodigoModalAviamentos${index + 1}`)?.focus()
                    }
                } catch { }
                finally {
                    enterCampoQuebraFoiPressionado = false
                }
            })
    }

    async function atualizarAviamentoComDadosDoCodigoInformado(codigo, index, row) {
        try {
            const {
                descricao,
                unidade,
                custo: custoBruto,
                atualizadoEm,
            } = await buscarDadosAviamentoInformado(codigo)

            const rowData = row.data()
            const quebra = retornarValorMonetarioEmFloat($(`#txtQuebraModalAviamentos${index}`).val())
            const quantidade = retornarValorMonetarioEmFloat(rowData.quantidade)
            const custo = retornarValorMonetarioEmFloat(custoBruto)
            const valor = retornarValorAviamento({ custo, quebra, quantidade })
            const newData = {
                ...rowData,
                codigo,
                descricao,
                unidade,
                custo: retornarFloatFormatadoEmMonetario({ valor: custo, quantidadeCasasDecimais: 6 }),
                valor: retornarFloatFormatadoEmMonetario({ valor, quantidadeCasasDecimais: 6 }),
                atualizadoEm,
            }
            row.data(newData)
            recalcularDadosTabelaModalAviamentos()
        } catch (error) {
            msgErro('Ocorreu um erro ao buscar os dados.')
            console.error(error)
        }
    }

    function retornarValorAviamento({ quantidade, custo, quebra }) {
        if (quebra >= 100) {
            quebra = 99.999999
        }
        return (quantidade * custo) / ((100 - quebra) / 100)
    }

    function adicionarEventosAviamentos(table) {
        table.rows().every((index) => {
            const row = table.row(index)
            adicionarEventosBotoesAviamentos(index, row)
            adicionarEventosInputsAviamentos(index, row)
        })
    }

    async function buscarDadosAviamentoInformado(codigo) {
        const pesquisa = retornarPesquisaAviamentos(codigo)
        const result = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa))
        return {
            descricao: result[0]?.DESCRICAO ?? '',
            unidade: result[0]?.UNIDADE ?? '',
            custo: result[0]?.CUSTO ?? 0,
            atualizadoEm: result[0]?.DT_ULT_ATUALIZACAO ?? '',
        }
    }

    $('#btnIncluirModalAviamentos').on('click', function () {
        adicionarAviamento()
    })

    function adicionarAviamento(data) {
        let table = $('#tabelaModalAviamentos').DataTable()
        if (!data) {
            const ordem = table.data().toArray().reduce((acc, item) => acc < item.ordem ? item.ordem : acc, 0) + 1
            const acumulado = table.data().toArray().reduce((acc, item) => acc += retornarValorMonetarioEmFloat(item.valor), 0)
            data = {
                ordem,
                codigo: '',
                descricao: '',
                unidade: '',
                quantidade: 0,
                custo: 0,
                quebra: 0,
                valor: 0,
                acumulado,
                atualizadoEm: '',
            }
        }
        table.row.add(data)
        const index = table.rows().count() - 1
        recalcularDadosTabelaModalAviamentos()
        table = $('#tabelaModalAviamentos').DataTable()
        const row = table.row(index)
        if (row.node()) {
            table.rows().deselect()
            row.select()
            setTimeout(() => {
                $(row.node()).get(0).scrollIntoView({ behavior: 'smooth', block: 'center' })
            }, 150)
        }
    }

    function recalcularDadosTabelaModalAviamentos() {
        const table = $('#tabelaModalAviamentos').DataTable()
        const data = table.data().toArray()
        let acumulado = 0

        const novosDados = data.map((item, idx) => {
            const valor = retornarValorMonetarioEmFloat(item?.valor)
            acumulado += valor
            return {
                ...item,
                acumulado,
                ordem: idx + 1,
            }
        })

        criarTabelaModalAviamentos(novosDados)
    }

    $('#btnComposicaoModalAviamentos').on('click', async function () {
        const codigo = $('#txtCodigo').val()
        if ($('#tabelaModalAviamentos').DataTable().data().length > 0) {
            msgAlerta('Já existem registros para esse cadastro, deseja refazer?', () => {
                carregarComposicaoMaterial(codigo)
            })
            return
        }
        carregarComposicaoMaterial(codigo)
    });

    async function carregarComposicaoMaterial(codigo) {
        $.LoadingOverlay('show')
        buscarComposicaoMaterial(codigo)
            .then(({ aviamentos }) => {
                criarTabelaModalAviamentos(aviamentos)
            })
            .catch((error) => {
                console.error(error)
                msgErro('Ocorreu um erro ao carregar os dados.')
            })
            .finally(() => $.LoadingOverlay('hide'))
    }

    async function buscarComposicaoMaterial(codigo) {
        const response = await requisicao("GET", `/sisplan/cadmatpreco/v1/composicao?`, `CODIGO=${encodeURIComponent(codigo)}`, '', 3600000)

        const json = await response.json()

        if (json) {
            const { resultado, mensagem } = json
            if (mensagem?.codigo !== 200) {
                throw mensagem?.mensagem
            }

            return resultado
        }
    }

    $('#btnConfirmarModalAviamentos').on('click', function () {
        try {
            const aviamentos = $('#tabelaModalAviamentos').DataTable().data().toArray().filter(item => item.valor && item.valor > 0)
            const totalCustoAviamentos = aviamentos?.reduce((acc, aviamento) => acc + aviamento.valor, 0) ?? 0
            const valoresCalcularCusto = retornarValoresCalcularCusto()
            const custoCalculado = retornarCustoCalculado({ ...valoresCalcularCusto, precoCompra: totalCustoAviamentos })
            $('#txtPreco1').val(retornarFloatFormatadoEmMonetario({ valor: custoCalculado, quantidadeCasasDecimais: 6 }))
            $('#txtPrecoCompra').val(retornarFloatFormatadoEmMonetario({ valor: totalCustoAviamentos, quantidadeCasasDecimais: 6 }))
            criarTabelaAviamentos(aviamentos)
            $('#modalAviamentos').modal('hide')
        } catch (error) {
            console.error(error)
            msgErro('Ocorreu um erro ao confirmar os dados.')
        }
    });

    $('#btnControleItens').on('click', function () {
        const dados = $('#tabelaCores').DataTable().data();
        criarTabelaControleItens(dados)

        $('#tituloControleItens').html(`[${codMat}] - ${$('#txtDescricao').val()}`);

        $('#txtUtilizaFatConv').val($('#txtFatorConversao').val());

        $('#modalControleItens').modal('show');
    });

    $('#modalControleItens').on('shown.bs.modal', function () {
        $('#tabelaControleItens').DataTable().columns.adjust().draw(false)

        $('#txtGrupoCI').autocompleta(1, `JSON={ "tabela":"GRUPO_COR", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`, null, null, null);
        $('#btnGrupoCI').pesquisa_serverside(['#txtGrupoCI'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"GRUPO_COR", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Grupo');

        $('#txtCorCI').off('autocompleta');
        $('#txtCorCI').autocompleta(1, `JSON={ "tabela":"MAT_ITEN", "camposSelect":["MAT_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${codMat}' AND MAT_ITEN.ATIVO = 'S' AND CADCOR.INATIVO = 'N'"] }`, undefined, undefined, undefined);
        $('#btnCorCI').off();
        $('#btnCorCI').pesquisa_array(['#txtCorCI'], ['COR'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "MAT_ITEN.COR", "CADCOR.DESCRICAO" ],"leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${codMat}' AND MAT_ITEN.ATIVO = 'S' AND CADCOR.INATIVO = 'N'"]}`, 'Pesquisa Cor', 'CADCOR');

        $('#txtCorCI').on('blur', async function () {
            if (inclusaoCI) {
                const dadosSelect = {
                    tabela: `MAT_ITEN`,
                    camposSelect: [`MAX(MAT_ITEN.PRECO_MED) PRECO_MED, CADCOR.PANTONE`],
                    leftjoin: [{ tabela: 'CADCOR', condicao: 'CADCOR.COR = MAT_ITEN.COR' }],
                    where: [`MAT_ITEN.CODIGO = '${codMat}'`, `MAT_ITEN.COR = '${pegaChave('#txtCorCI')}'`],
                    groupBy: ['CADCOR.PANTONE']
                };
                const retornoSelect = await retornaJsonPesquisaPadrao(
                    JSON.stringify(dadosSelect)
                );

                $('#txtPrecoCI').val(retornoSelect[0].PRECO_MED);
                $('#txtPantoneCI').val(retornoSelect[0].PANTONE);
            }
        });
    })

    $('#btnConsultarCI').on('click', async function () {
        filtraItensPorGrupo();
    });

    $('#tabelaControleItens').on('click', '#btn-alterar-ci', async function () {
        if ($('#tabelaControleItens').DataTable().data().length > 0) {
            habAlteracaoControleItens($("#tabelaControleItens").DataTable().row($(this).parents('tr')).data());
            $('#tabelaControleItens').DataTable().$('tr.selected').removeClass('selected');
            $(this).parents('tr').addClass('selected');
        }
    });

    $('#tabelaControleItens').on('click', '#btn-excluir-ci', async function () {
        const linha = $('#tabelaControleItens').DataTable().$($(this).parents('tr'))[0]._DT_RowIndex;
        const data = $('#tabelaControleItens').DataTable().data().toArray();
        excluiLinhaControleItens(linha, data);
    });

    $('#btnDesistirCI').on('click', function () {
        desabAlteracaoControleItens();
    });

    $('#cbUtilizaFatConv').on('change', function () {
        const preco = calculaPrecoControleItens(
            $('#txtPrecoTingimentoCI').val(),
            $('#txtPrecoCompraCI').val(),
            $('#txtPercDespCI').val(),
            $('#txtUtilizaFatConv').val(),
            $('#cbUtilizaFatConv').prop('checked')
        )

        $('#txtPrecoCI').val(preco);
    });

    $('#cbUtilizaFatConv').on('change', function () {
        const preco = calculaPrecoControleItens(
            $('#txtPrecoTingimentoCI').val(),
            $('#txtPrecoCompraCI').val(),
            $('#txtPercDespCI').val(),
            $('#txtUtilizaFatConv').val(),
            $('#cbUtilizaFatConv').prop('checked')
        )

        $('#txtPrecoCI').val(preco);
    });

    function habAlteracaoControleItens(linha) {
        if (inclusaoCI) {
            $('#cbAtivoCI').prop('checked', true);
            $('#precosTodosCI').addClass('d-none');
            $('#precosCI').removeClass('d-none');
            $('#btnIncluirCI').addClass('d-none');
            $('#btnExcluirCI').prop('disabled', false);
            $('#btnDesistirCI').removeClass('d-none');
            $('#btnConsultarCI').addClass('d-none');
            $('#btnAtualizarCoresCI').addClass('d-none');
            $('#grupoCI').addClass('d-none');
            $('#btnExcluirCI').addClass('d-none');
            $('#btnConfirmarCI').removeClass('d-none');
            $('#tabelaControleItens').prop('disabled', true);
            $('#txtCorCI').prop('disabled', false);
            $('#btnCorCI').prop('disabled', false);
        } else {
            $('#cbAtivoCI').prop('checked', linha.ativo == 'S' ? true : false);
            $('#txtIdCI').val(linha.id);
            insereValor('#txtCorCI', linha.codigo, linha.descricao);
            $('#txtPantoneCI').val(linha.pantone);
            $('#precosTodosCI').addClass('d-none');
            $('#precosCI').removeClass('d-none');
            $('#txtPrecoTingimentoCI').val(linha.precoTingimento);
            $('#txtPrecoCompraCI').val(linha.precoCompra);
            $('#txtPrecoCI').val(linha.preco);
            $('#txtPercDespCI').val(linha.percentualDesperdicio);
            $('#btnIncluirCI').addClass('d-none');
            $('#btnExcluirCI').prop('disabled', false);
            $('#btnDesistirCI').removeClass('d-none');
            $('#btnConsultarCI').addClass('d-none');
            $('#btnAtualizarCoresCI').addClass('d-none');
            $('#grupoCI').addClass('d-none');
            $('#btnConfirmarCI').removeClass('d-none');
        }
        $('#cbUtilizaFatConv').prop('disabled', false);
        $('#btnGravarControleItens').addClass('d-none');
    };

    function desabAlteracaoControleItens() {
        $('#tabelaControleItens').DataTable().$('tr.selected').removeClass('selected');
        $('#cbAtivoCI').prop('checked', false);
        $('#txtIdCI').val('');
        $('#txtCorCI').val('');
        $('#txtPrecoTingimentoCI').val('');
        $('#txtPrecoCompraCI').val('');
        $('#txtPercDespCI').val('');
        $('#txtPrecoCI').val('');
        $('#txtPantoneCI').val('');
        $('#precosTodosCI').removeClass('d-none');
        $('#precosCI').addClass('d-none');
        $('#btnIncluirCI').removeClass('d-none');
        $('#btnExcluirCI').prop('disabled', true);
        $('#btnDesistirCI').addClass('d-none');
        $('#btnConsultarCI').removeClass('d-none');
        $('#btnAtualizarCoresCI').removeClass('d-none');
        $('#grupoCI').removeClass('d-none');
        $('#txtPrecoTingimentoTodosCI').val('');
        $('#txtPrecoCompraTodosCI').val('');
        $('#txtPrecoTodosCI').val('');
        $('#txtPercDesperdicioTodosCI').val('');
        if (inclusaoCI) {
            $('#tabelaControleItens').prop('disabled', false)
            $('#btnExcluirCI').removeClass('d-none');
            $('#txtCorCI').prop('disabled', true);
            $('#btnCorCI').prop('disabled', true);
            $('#txtIdCI').prop('placeholder', 'ID');
            inclusaoCI = false;
        }
        $('#btnConfirmarCI').addClass('d-none');
        $('#cbUtilizaFatConv').prop('disabled', true);
        $('#btnGravarControleItens').removeClass('d-none');
    };

    $('#btnIncluirCI').on('click', function () {
        inclusaoCI = true;
        habAlteracaoControleItens(null);
    });

    $('#btnPrecoTingimentoTodosCI').on('click', function () {
        atualizaPrecoTodosCI('precoTingimento');
    });

    $('#btnPrecoCompraTodosCI').on('click', function () {
        atualizaPrecoTodosCI('precoCompra');
    });

    $('#btnPrecoTodosCI').on('click', function () {
        atualizaPrecoTodosCI('preco');
    });

    $('#btnPercDesperdicioTodosCI').on('click', function () {
        atualizaPrecoTodosCI('percentualDesperdicio');
    });

    function atualizaPrecoTodosCI(coluna) {
        $.LoadingOverlay('show');
        try {
            if (coluna == undefined) {
                return;
            }
            let valorCampo = '';
            let preco = 0;
            const grupo = pegaChave('#txtGrupoCI');

            switch (coluna) {
                case 'precoTingimento':
                    valorCampo = $('#txtPrecoTingimentoTodosCI').val()
                    break;
                case 'precoCompra':
                    valorCampo = $('#txtPrecoCompraTodosCI').val()
                    break;
                case 'preco':
                    valorCampo = $('#txtPrecoTodosCI').val()
                    break;
                case 'percentualDesperdicio':
                    valorCampo = $('#txtPercDesperdicioTodosCI').val()
                    break;
                default:
                    break;
            }

            if (valorCampo == '') {
                valorCampo = '0';
            }

            valorCampo = valorCampo.replace(',', '.');

            const data = $('#tabelaControleItens').DataTable().data();
            data.rows().remove();

            if (grupo != '' && grupo != undefined && grupo != null) {
                for (let i = 0; i < data.length; i++) {

                    data[i][coluna] = parseFloat(valorCampo);

                    if (data[i].grupo == grupo) {
                        if (coluna != 'preco') {
                            preco = calculaPrecoControleItens(
                                data[i].precoTingimento,
                                data[i].precoCompra,
                                data[i].percentualDesperdicio,
                                0,
                                'N');
                        } else {
                            preco = parseFloat(valorCampo).toFixed(6) == 'NaN' ? 0 : parseFloat(valorCampo).toFixed(6);
                        }

                    }

                    const objRow = {
                        id: data[i].id,
                        ativo: data[i].ativo,
                        codigo: data[i].codigo,
                        descricao: data[i].descricao,
                        precoTingimento: data[i].precoTingimento,
                        precoCompra: data[i].precoCompra,
                        percentualDesperdicio: data[i].percentualDesperdicio,
                        preco: preco,
                        pantone: data[i].pantone,
                        tinturaria: data[i].tinturaria,
                        nome: data[i].nome,
                        codigo2: data[i].codigo2,
                        grupo: data[i].grupo,
                        descricaoGrupo: data[i].descricaoGrupo,
                        fatorConversao: data[i].fatorConversao,
                    }

                    $('#tabelaControleItens').DataTable().row.add(objRow).draw(false);
                }
            } else {
                for (let i = 0; i < data.length; i++) {

                    data[i][coluna] = parseFloat(valorCampo);

                    if (coluna != 'preco') {
                        preco = calculaPrecoControleItens(
                            data[i].precoTingimento,
                            data[i].precoCompra,
                            data[i].percentualDesperdicio,
                            0,
                            'N');
                    } else {
                        preco = parseFloat(valorCampo).toFixed(6) == 'NaN' ? 0 : parseFloat(valorCampo).toFixed(6);
                    }

                    const objRow = {
                        id: data[i].id,
                        ativo: data[i].ativo,
                        codigo: data[i].codigo,
                        descricao: data[i].descricao,
                        precoTingimento: data[i].precoTingimento,
                        precoCompra: data[i].precoCompra,
                        percentualDesperdicio: data[i].percentualDesperdicio,
                        preco: preco,
                        pantone: data[i].pantone,
                        tinturaria: data[i].tinturaria,
                        nome: data[i].nome,
                        codigo2: data[i].codigo2,
                        grupo: data[i].grupo,
                        descricaoGrupo: data[i].descricaoGrupo,
                        fatorConversao: data[i].fatorConversao,
                    }

                    $('#tabelaControleItens').DataTable().row.add(objRow).draw(false);
                }
            }
        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados: ${error}`);

        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $('#btnConfirmarCI').on('click', async function () {
        let linha = null;

        if (!inclusaoCI) {
            linha = $('#tabelaControleItens').DataTable().$('tr.selected')[0]._DT_RowIndex;
        }
        const data = $('#tabelaControleItens').DataTable().data().toArray();

        if ($('#txtCorCI').val() == '') {
            msgErro('É necessário informar uma cor, favor verificar.');
            return;
        }

        let corExistente = false;
        const corInclusa = pegaChave('#txtCorCI');

        if (data.length > 0) {
            for (let i = 0; i < data.length; i++) {
                if (data[i].codigo == corInclusa) {
                    corExistente = true;
                }
            }
        }

        if (corExistente && inclusaoCI) {
            msgErro('Cor já Informada para o material, favor verificar.');
            return;
        }

        await confirmaAltControleItens(data, linha)
        desabAlteracaoControleItens();
    });

    $('#txtPrecoTingimentoCI').on('blur', function () {
        const preco = calculaPrecoControleItens(
            $('#txtPrecoTingimentoCI').val(),
            $('#txtPrecoCompraCI').val(),
            $('#txtPercDespCI').val(),
            $('#txtUtilizaFatConv').val(),
            $('#cbUtilizaFatConv').prop('checked')
        );

        $('#txtPrecoCI').val(preco);
    });

    $('#txtPrecoCompraCI').on('blur', function () {
        const preco = calculaPrecoControleItens(
            $('#txtPrecoTingimentoCI').val(),
            $('#txtPrecoCompraCI').val(),
            $('#txtPercDespCI').val(),
            $('#txtUtilizaFatConv').val(),
            $('#cbUtilizaFatConv').prop('checked')
        );

        $('#txtPrecoCI').val(preco);
    });

    $('#txtPercDespCI').on('blur', function () {
        const preco = calculaPrecoControleItens(
            $('#txtPrecoTingimentoCI').val(),
            $('#txtPrecoCompraCI').val(),
            $('#txtPercDespCI').val(),
            $('#txtUtilizaFatConv').val(),
            $('#cbUtilizaFatConv').prop('checked')
        );

        $('#txtPrecoCI').val(preco);
    });

    function calculaPrecoControleItens(precoTin, precoCom, percDesp, divisor, calculaDivisor) {
        try {
            if (divisor < 0.000001) {
                divisor = 1;
            };

            if (precoTin == '') {
                precoTin = 0;
            }

            if (typeof precoTin == 'string') {
                precoTin = precoTin.replace(',', '.');
            }

            precoTin = parseFloat(precoTin);

            if (precoCom == '') {
                precoCom = 0;
            }

            if (typeof precoCom == 'string') {
                precoCom = precoCom.replace(',', '.');
            }

            precoCom = parseFloat(precoCom);

            if (percDesp == '') {
                percDesp = 0;
            }

            if (typeof percDesp == 'string') {
                percDesp = percDesp.replace(',', '.');
            }

            percDesp = parseFloat(percDesp);

            let preco = precoCom + precoTin;

            if (cus280_32 == 'S') {
                preco = precoCom + (precoTin * piscofins);
            }

            if (cus280_18 == 'S') {
                preco = preco * impostos;
            }

            if (preco > 0) {
                if (calculaDivisor) {
                    preco = preco / divisor;
                }

                if (cus280_10 == 'S') {
                    preco = preco / ((100 - percDesp) / 100);
                } else {
                    preco = preco + (preco * (percDesp / 100));
                }
            }

            return preco.toFixed(6);
        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados: ${error}`);
        }
    }

    async function confirmaAltControleItens(data, linha) {
        try {
            $.LoadingOverlay('show');
            if (!data) return;

            const info = await retornaDadosCor(pegaChave('#txtCorCI'));

            $('#tabelaControleItens').DataTable().clear();

            if (inclusaoCI) {
                const objRow = {
                    id: $('#txtIdCI').val(),
                    ativo: $('#cbAtivoCI').prop('checked') ? 'S' : 'N',
                    codigo: pegaChave('#txtCorCI'),
                    descricao: pegaDescricao('#txtCorCI'),
                    precoTingimento: parseFloat($('#txtPrecoTingimentoCI').val().replace(',', '.')) || 0.00,
                    precoCompra: parseFloat($('#txtPrecoCompraCI').val().replace(',', '.')) || 0.00,
                    percentualDesperdicio: parseFloat($('#txtPercDespCI').val().replace(',', '.')) || 0.00,
                    preco: parseFloat($('#txtPrecoCI').val().replace(',', '.')) || 0.00,
                    pantone: $('#txtPantoneCI').val(),
                    tinturaria: info?.TINTURARIA ?? '',
                    nome: info?.NOME ?? '',
                    codigo2: info?.CODIGO2 ?? '',
                    grupo: info?.GRUPO ?? '',
                    descricaoGrupo: info?.DESCRICAO ?? '',
                    fatorConversao: info?.FATOR_CONVERSAO ?? 1
                };
                data.unshift(objRow);
            } else {
                data[linha] = {
                    ...data[linha],
                    ativo: $('#cbAtivoCI').prop('checked') ? 'S' : 'N',
                    precoTingimento: parseFloat($('#txtPrecoTingimentoCI').val().replace(',', '.')) || 0.00,
                    precoCompra: parseFloat($('#txtPrecoCompraCI').val().replace(',', '.')) || 0.00,
                    percentualDesperdicio: parseFloat($('#txtPercDespCI').val().replace(',', '.')) || 0.00,
                    preco: parseFloat($('#txtPrecoCI').val().replace(',', '.')) || 0.00,
                };
            }

            data.forEach(item => {
                $('#tabelaControleItens').DataTable().row.add({
                    ...item,
                    precoTingimento: (parseFloat(item.precoTingimento) || 0).toFixed(6),
                    precoCompra: (parseFloat(item.precoCompra) || 0).toFixed(6),
                    percentualDesperdicio: (parseFloat(item.percentualDesperdicio) || 0).toFixed(6),
                    preco: (parseFloat(item.preco) || 0).toFixed(6)
                }).draw(false);
            });
        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível gravar os dados: ${error}`);
        } finally {
            $('#txtPrecoTingimentoCI').val('');
            $('#txtPrecoCompraCI').val('');
            $('#txtPercDespCI').val('');
            $.LoadingOverlay('hide');
        }
    }

    function excluiLinhaControleItens(linha, data) {
        $.LoadingOverlay('show');
        try {
            data.splice(linha, 1);

            $('#tabelaControleItens').DataTable().clear();

            data.forEach(item => {
                $('#tabelaControleItens').DataTable().row.add({
                    ...item,
                    precoTingimento: (parseFloat(item.precoTingimento) || 0).toFixed(6),
                    precoCompra: (parseFloat(item.precoCompra) || 0).toFixed(6),
                    percentualDesperdicio: (parseFloat(item.percentualDesperdicio) || 0).toFixed(6),
                    preco: (parseFloat(item.preco) || 0).toFixed(6)
                }).draw(false);
            });

            desabAlteracaoControleItens();
        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível excluir o registro: ${error}`);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function retornaDadosCor(cor) {
        const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"CADCOR",
                "camposSelect":["CADCOR.GRUPO, GRUPO_COR.DESCRICAO, CADCOR.TINTURARIA, ENTIDADE.NOME, CADCOR.CODIGO2"],
                "leftjoin": [
                    {"tabela": "GRUPO_COR", "condicao": "CADCOR.GRUPO = GRUPO_COR.CODIGO"},
                    {"tabela": "ENTIDADE", "condicao": "CADCOR.TINTURARIA = ENTIDADE.CODCLI"}
                ],
                "where": ["CADCOR.COR = '${cor}'"]}`, null);

        if (!response) {
            return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
        }

        if (jsonStr.RESULT[0].length == 0) {
            return;
        }

        return jsonStr.RESULT[0][0];
    };

    $('#btnAtualizarCoresCI').on('click', async function () {
        const cores = await buscaNovasCores(codMat);
        insereNovasCores(cores);
    });

    async function buscaNovasCores(codigo) {
        $.LoadingOverlay('show');
        try {
            const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"MAT_ITEN",
                            "camposSelect":["DISTINCT MAT_ITEN.ATIVO, MAT_ITEN.CODIGO, MATERIAL.DESCRICAO, MAT_ITEN.COR, CADCOR.DESCRICAO AS DESC_COR,
                                            MAT_ITEN.PRECO_MED AS PRECO, CADCOR.PANTONE, CADCOR.GRUPO, GRUPO_COR.DESCRICAO AS DESC_GRUPO, CADCOR.TINTURARIA, 
                                            ENTIDADE.NOME, CADCOR.CODIGO2"],
                            "innerjoin": [
                                {"tabela": "MATERIAL", "condicao": "MAT_ITEN.CODIGO = MATERIAL.CODIGO"},
                                {"tabela": "CADCOR", "condicao": "MAT_ITEN.COR = CADCOR.COR"},
                                {"tabela": "GRUPO_COR", "condicao": "CADCOR.GRUPO = GRUPO_COR.CODIGO"}],
                            "leftjoin": [
                                {"tabela": "ENTIDADE", "condicao": "CADCOR.TINTURARIA = ENTIDADE.CODCLI"}    
                            ],
                            "where": ["MAT_ITEN.CODIGO = '${codigo}'", "MAT_ITEN.ATIVO IS NOT NULL"]}`, null);

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            jsonStr = jsonStr.RESULT[0];

            jsonStr.map(element => {
                if (element.ATIVO == '') {
                    element.ATIVO = 'S';
                }

                if (cus280_19 == 'S') {
                    element.PRECO_COMPRA = element.PRECO
                } else {
                    element.PRECO_COMPRA = 0;
                }
            })

            return jsonStr;

        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados: ${error}`);
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    function insereNovasCores(cores) {
        if (!cores || cores.length === 0) return;

        listaCores = cores.map(element => ({
            id: '',
            ativo: element.ATIVO,
            codigo: element.COR,
            descricao: element.DESC_COR,
            precoTingimento: parseFloat(element.PRECO) || 0,
            precoCompra: parseFloat(element.PRECO_COMPRA) || 0,
            percentualDesperdicio: 0,
            preco: 0,
            pantone: element.PANTONE,
            tinturaria: element.TINTURARIA,
            nome: element.NOME,
            codigo2: element.CODIGO2,
            grupo: element.GRUPO,
            descricaoGrupo: element.DESC_GRUPO,
            fatorConversao: 1
        }));

        let arrayCores = [];
        let arrayIndices = [];

        for (let i = 0; i < listaCores.length; i++) {
            if (!arrayCores.includes(listaCores[i].codigo)) {
                arrayCores.push(listaCores[i].codigo);
                arrayIndices.push(i);
            }
        }

        const dataTable = $('#tabelaControleItens').DataTable();
        const data = dataTable.data().toArray();

        dataTable.clear();

        arrayCores = data.map(item => item.codigo);

        for (let idx of arrayIndices) {
            if (!arrayCores.includes(listaCores[idx].codigo)) {
                data.unshift(listaCores[idx]);
            }
        }

        data.forEach(item => {
            dataTable.row.add({
                ...item,
                precoTingimento: (parseFloat(item.precoTingimento) || 0).toFixed(6),
                precoCompra: (parseFloat(item.precoCompra) || 0).toFixed(6),
                percentualDesperdicio: (parseFloat(item.percentualDesperdicio) || 0).toFixed(6),
                preco: (parseFloat(item.preco) || 0).toFixed(6)
            }).draw(false);
        });
    }

    $('#btnGravarControleItens').on('click', function () {
        const data = $('#tabelaControleItens').DataTable().data().toArray();
        atualizaTabelaCores(data);
    });

    function atualizaTabelaCores(data) {
        $.LoadingOverlay('show');
        try {
            const dados = data.map(item => ({
                id: item.id,
                ativo: item.ativo,
                codigo: item.codigo,
                descricao: item.descricao,
                precoTingimento: item.precoTingimento,
                precoCompra: item.precoCompra,
                percentualDesperdicio: item.percentualDesperdicio,
                preco: item.preco,
                pantone: item.pantone,
                tinturaria: item.tinturaria,
                nome: item.nome,
                codigo2: item.codigo2,
                grupo: item.grupo,
                descricaoGrupo: item.descricaoGrupo,
                fatorConversa: item.fatorConversao
            }));

            $('#tabelaCores').DataTable().clear().draw(false);
            criarTabelaCores(dados);

        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados: ${error}`);
        } finally {
            $('#modalControleItens').modal('hide');
            $.LoadingOverlay('hide');
        }
    }

    $('#modalControleItens').on('hide.bs.modal', function () {
        $('#tabelaControleItens').DataTable().data().rows().remove();
        desabAlteracaoControleItens();
    });

    function filtraItensPorGrupo() {
        $.LoadingOverlay('show');
        try {
            const grupo = pegaChave('#txtGrupoCI');
            const tabela = $('#tabelaControleItens').DataTable();

            tabela
                .column('grupo:name')
                .search(grupo || '')
                .draw();

        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível filtrar os dados: ${error}`);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    $('#btnFecharControleItens').on('click', function () {
        if ($('#tabelaControleItens').DataTable().data().length != $('#tabelaCores').DataTable().data().length) {
            msgAlerta('Podem haver informações não gravadas, deseja continuar?', () => {
                $('#modalControleItens').modal('hide');
            });
        } else {
            $('#modalControleItens').modal('hide');
        }
    });

    $('#btnQuebras').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            $('#modalQuebras').modal('show');

            $('#tituloQuebras').html(`[${codMat}] - ${$('#txtDescricao').val()}`);

            const dados = $('#tabelaQuebrasGravar').DataTable().data();

            criarTabelaQuebra(dados)
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#modalQuebras').on('shown.bs.modal', function () {
        $('#tabelaQuebras').DataTable().columns.adjust().draw(false)

        $('#txtCodigoQuebras').autocompleta(1, `JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO CHAVE, DESCRICAO DESCRICAO, UNIDADE"], "where": [] }`, ['#txtUnidadeQuebras'], ['UNIDADE'], ['UNIDADE'], null, [true]);

        $('#btnCodigoQuebras').pesquisa_serverside(['#txtCodigoQuebras', '#txtUnidadeQuebras'], ['CODIGO', 'UNIDADE'], ['DESCRICAO', 'UNIDADE'], '{"tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO", "UNIDADE"], "where": null}', 'Pesquisa Material', null, [false, true]);

        $('#btnACodigoQuebras').on('click', async function () {
            $('#txtCodigoQuebras').val('');
        });
    })

    $('#btnDesistirQuebras').on('click', async function () {
        await desabAlteracaoQuebras();
    });

    async function habAlteracaoQuebras(linha) {
        const data = $('#tabelaQuebras').DataTable().data();
        let ordens = [];

        for (let i = 0; i < data.length; i++) {
            ordens.push(data[i].ordem);
        }

        let novaOrdem = null;

        if (ordens.length > 0) {
            novaOrdem = (Math.max(...ordens)) + 1;
        } else {
            novaOrdem = 1;
        }

        if (inclusaoQuebras) {
            $('#btnIncluirQuebras').addClass('d-none');
            $('#btnConfirmarQuebras').removeClass('d-none');
            $('#btnDesistirQuebras').removeClass('d-none');
            $('#btnExcluirQuebras').prop('disabled', false);
            $('#txtOrdemQuebras').val(novaOrdem);
            $('#txtCodigoQuebras').val('');
            $('#txtUnidadeQuebras').val('');
            $('#txtQuebraQuebras').val('');
            $('#txtOrdemQuebras').prop('disabled', false);
            $('#txtCodigoQuebras').prop('disabled', false);
            $('#btnCodigoQuebras').prop('disabled', false);
            $('#btnACodigoQuebras').prop('disabled', false);
            $('#txtQuebraQuebras').prop('disabled', false);
        } else {
            $('#btnIncluirQuebras').addClass('d-none');
            $('#btnConfirmarQuebras').removeClass('d-none');
            $('#btnDesistirQuebras').removeClass('d-none');
            $('#btnExcluirQuebras').prop('disabled', false);
            $('#txtOrdemQuebras').val(linha.ordem);
            insereValor('#txtCodigoQuebras', linha.codigo, linha.descricao);
            $('#txtUnidadeQuebras').val(linha.unidade);
            $('#txtQuebraQuebras').val(linha.quebra);
            $('#txtOrdemQuebras').prop('disabled', false);
            $('#txtCodigoQuebras').prop('disabled', false);
            $('#btnCodigoQuebras').prop('disabled', false);
            $('#btnACodigoQuebras').prop('disabled', false);
            $('#txtQuebraQuebras').prop('disabled', false);
        }

        $('#btnGravarQuebras').addClass('d-none');
    }

    async function desabAlteracaoQuebras() {
        if (inclusaoQuebras) {
            inclusaoQuebras = false;
        }
        $('#tabelaQuebras').DataTable().$('tr.selected').removeClass('selected');
        $('#btnIncluirQuebras').removeClass('d-none');
        $('#btnConfirmarQuebras').addClass('d-none');
        $('#btnDesistirQuebras').addClass('d-none');
        $('#btnExcluirQuebras').prop('disabled', true);
        $('#txtOrdemQuebras').val('');
        $('#txtCodigoQuebras').val('');
        $('#txtUnidadeQuebras').val('');
        $('#txtQuebraQuebras').val('');
        $('#txtOrdemQuebras').prop('disabled', true);
        $('#txtCodigoQuebras').prop('disabled', true);
        $('#btnCodigoQuebras').prop('disabled', true);
        $('#btnACodigoQuebras').prop('disabled', true);
        $('#txtUnidadeQuebras').prop('disabled', true);
        $('#txtQuebraQuebras').prop('disabled', true);
        $('#btnGravarQuebras').removeClass('d-none');
    }

    $('#btnIncluirQuebras').on('click', async function () {
        inclusaoQuebras = true;
        await habAlteracaoQuebras();
    })

    $('#tabelaQuebras').on('click', '#btn-excluir-quebras', async function () {
        const linha = $('#tabelaQuebras').DataTable().$($(this).parents('tr'))[0]._DT_RowIndex;
        const data = $('#tabelaQuebras').DataTable().data().toArray();
        await excluiLinhaQuebras(linha, data);
    });

    $('#tabelaQuebras').on('click', '#btn-alterar-quebras', async function () {
        if ($('#tabelaQuebras').DataTable().data().length > 0) {
            await habAlteracaoQuebras($("#tabelaQuebras").DataTable().row($(this).parents('tr')).data());
            $('#tabelaQuebras').DataTable().$('tr.selected').removeClass('selected');
            $(this).parents('tr').addClass('selected');
        }
    });

    async function excluiLinhaQuebras(linha, data) {
        $.LoadingOverlay('show');
        try {
            data.rows().remove();
            data.splice(linha, 1);

            if (data.length > 0) {
                for (let i = 0; i < data.length; i++) {
                    const objRow = {
                        ordem: data[i].ordem,
                        codigo: data[i].codigo,
                        descricao: data[i].descricao,
                        unidade: data[i].unidade,
                        quebra: data[i].quebra
                    }

                    $('#tabelaQuebras').DataTable().row.add(objRow).draw(false);
                }
            } else {
                $('#tabelaQuebras').DataTable().draw(false);
            }

            await desabAlteracaoQuebras();
        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível excluir o registro: ${error}`);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    $('#btnConfirmarQuebras').on('click', async function () {
        let linha = null;

        if (!inclusaoQuebras) {
            linha = $('#tabelaQuebras').DataTable().$('tr.selected')[0]._DT_RowIndex
        }
        const data = $('#tabelaQuebras').DataTable().data();

        if ($('#txtCodigoQuebras').val() == '') {
            msgErro('É necessário informar um material, favor verificar.');
            return;
        }

        await confirmaAltQuebras(data, linha);
        await desabAlteracaoQuebras();
    });

    async function confirmaAltQuebras(data, linha) {
        $.LoadingOverlay('show');
        try {
            if (!data) {
                return;
            }

            data.rows().remove();
            if (inclusaoQuebras) {
                const objRow = {
                    ordem: $('#txtOrdemQuebras').val(),
                    codigo: pegaChave('#txtCodigoQuebras'),
                    descricao: pegaDescricao('#txtCodigoQuebras'),
                    unidade: $('#txtUnidadeQuebras').val(),
                    quebra: $('#txtQuebraQuebras').val() == '' ? 0.00 : parseFloat($('#txtQuebraQuebras').val())
                }
                data.push(objRow);
            } else {
                data[linha].ordem = $('#txtOrdemQuebras').val();
                data[linha].codigo = pegaChave('#txtCodigoQuebras');
                data[linha].descricao = pegaDescricao('#txtCodigoQuebras');
                data[linha].unidade = $('#txtUnidadeQuebras').val();
                data[linha].quebra = $('#txtQuebraQuebras').val() == '' ? 0.00 : parseFloat($('#txtQuebraQuebras').val());
            }

            for (let i = 0; i < data.length; i++) {
                const objRow = {
                    ordem: data[i].ordem,
                    codigo: data[i].codigo,
                    descricao: data[i].descricao,
                    unidade: data[i].unidade,
                    quebra: data[i].quebra
                }
                $('#tabelaQuebras').DataTable().row.add(objRow).draw(false);
            }
        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $('#btnGravarQuebras').on('click', async function () {
        const data = $('#tabelaQuebras').DataTable().data().toArray();

        let json = [];

        data.map(element => {
            json.push({
                ordem: element.ordem,
                codigo: element.codigo,
                descricao: element.descricao,
                unidade: element.unidade,
                quebra: element.quebra
            })
        })

        criarTabelaQuebraSalvar(json);
        $('#modalQuebras').modal('hide');
    });

    $('#modalQuebras').on('hide.bs.modal', async function () {
        $('#tabelaQuebras').DataTable().data().rows().remove();
        await desabAlteracaoQuebras();
    });

    $('#btnFecharQuebras').on('click', async function () {
        if ($('#tabelaQuebras').DataTable().data().length != $('#tabelaQuebrasGravar').DataTable().data().length) {
            msgAlerta('Podem haver informações não gravadas, deseja continuar?', async () => {
                $('#tabelaQuebras').DataTable().data().rows().remove();
                $('#modalQuebras').modal('hide');
            });
        } else {
            $('#modalQuebras').modal('hide');
        }
    });

    function carregaDadosTin(codigo, codcli) {
        $.LoadingOverlay('show')
        buscaPrecoTin(codigo, codcli).then((dados) => {
            if (!dados) {
                return
            }
            return prepararDadosPrecoTin(dados.precos)
        }).then((data) => {
            if (!data) {
                return
            }
            criarTabelaPrecoTin(data)
        }).catch((error) => {
            console.error(error)
            msgErro('Ocorreu um erro ao carregar os dados.')
        }).finally(() => {
            $.LoadingOverlay('hide')
        })
    }

    async function buscaPrecoTin(codigo, codcli) {
        const response = await requisicao("GET", `/sisplan/cadmatpreco/v1/buscaprecotin?`, `CODIGO=${encodeURIComponent(codigo)}&CODCLI=${encodeURIComponent(codcli)}`, '', 3600000)

        const json = await response.json()

        if (json) {
            const { resultado, mensagem } = json
            if (mensagem?.codigo !== 200) {
                throw mensagem?.mensagem
            }

            return resultado
        }
    }

    $('#btnPrecoTinturaria').on('click', async function () {
        $('#modalPrecoTin').modal('show');

        $('#tituloPrecoTin').html(`[${codMat}] - ${$('#txtDescricao').val()}`);

        const cliente = pegaChave('#txtTinturariaPrecoTin') != '' ? pegaChave('#txtTinturariaPrecoTin') : '00000'

        carregaDadosTin(codMat, cliente)
    });

    $('#modalPrecoTin').on('shown.bs.modal', function () {
        $('#tabelaPrecoTin').DataTable().columns.adjust().draw(false)

        $('#txtTinturariaPrecoTin').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);

        $('#btnTinturariaPrecoTin').pesquisa_serverside(['#txtTinturariaPrecoTin'], ['CODCLI'], ['NOME'], '{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'Pesquisa Entidade');

        $('#btnATinturariaPrecoTin').on('click', function () {
            $('#txtTinturariaPrecoTin').val('');
        });
    })

    $('#tabelaPrecoTin').on('click', '#btn-alterar-precotin', async function () {
        if ($('#tabelaPrecoTin').DataTable().data().length > 0) {
            $('#tabelaPrecoTin').DataTable().$('tr.selected').removeClass('selected');
            $(this).parents('tr').addClass('selected');
            await habAlteracaoPrecoTin($("#tabelaPrecoTin").DataTable().row($(this).parents('tr')).data());
        }
    });

    $('#btnDesistirPrecoTin').on('click', async function () {
        await desabAlteracaoPrecoTin();
    });

    async function habAlteracaoPrecoTin(linha) {
        $('#txtPrecoNovoPrecoTin').prop('disabled', false);
        $('#txtPrecoNovoPrecoTin').val(linha.precoNovo);
        $('#btnConfirmarPrecoTin').removeClass('d-none');
        $('#btnDesistirPrecoTin').removeClass('d-none');
        $('#btnGravarPrecoTin').addClass('d-none');
    };

    async function desabAlteracaoPrecoTin() {
        $('#tabelaPrecoTin').DataTable().$('tr.selected').removeClass('selected');
        $('#txtPrecoNovoPrecoTin').prop('disabled', true);
        $('#txtPrecoNovoPrecoTin').val('');
        $('#btnConfirmarPrecoTin').addClass('d-none');
        $('#btnDesistirPrecoTin').addClass('d-none');
        $('#btnGravarPrecoTin').removeClass('d-none');
    };

    $('#btnConfirmarPrecoTin').on('click', async function () {
        const linha = $('#tabelaPrecoTin').DataTable().$('tr.selected')[0]._DT_RowIndex;
        const data = $('#tabelaPrecoTin').DataTable().data();

        await confirmaAltPrecoTin(data, linha)
        await desabAlteracaoPrecoTin();
    });

    async function confirmaAltPrecoTin(data, linha) {
        $.LoadingOverlay('show');
        try {
            if (!data) {
                return;
            }

            data.rows().remove();
            data[linha].codigo = data[linha].codigo;
            data[linha].descricao = data[linha].descricao;
            data[linha].precoAtual = data[linha].precoAtual;
            data[linha].precoTintur = data[linha].precoTintur;
            data[linha].precoNovo = $('#txtPrecoNovoPrecoTin').val() == '' ? 0.00 : parseFloat(($('#txtPrecoNovoPrecoTin').val()).replace(',', '.'));

            for (let i = 0; i < data.length; i++) {
                const objRow = {
                    codigo: data[i].codigo,
                    descricao: data[i].descricao,
                    precoAtual: parseFloat(data[i].precoAtual).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i].precoAtual).toFixed(6),
                    precoTintur: parseFloat(data[i].precoTintur).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i].precoTintur).toFixed(6),
                    precoNovo: parseFloat(data[i].precoNovo).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i].precoNovo).toFixed(6),
                    pantone: data[linha].pantone,
                    tinturaria: data[linha].tinturaria,
                    nome: data[linha].nome,
                    codigo2: data[linha].codigo2,
                    grupo: data[linha].grupo,
                    descGrupo: data[linha].descGrupo
                }

                $('#tabelaPrecoTin').DataTable().row.add(objRow).draw(false);
            };
        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $('#btnConsultarPrecoTin').on('click', async function () {
        const cliente = pegaChave('#txtTinturariaPrecoTin') != '' ? pegaChave('#txtTinturariaPrecoTin') : '00000'

        carregaDadosTin(codMat, cliente)
    });

    $('#btnGravarPrecoTin').on('click', async function () {
        if ($('#tabelaPrecoTin').DataTable().data().length == 0) {
            msgErro('Não há nenhum dado a ser gravado, favor verificar.');
            return;
        }

        msgAlerta('Deseja atualizar o preço conforme a tinturaria?', async () => {
            await gravaDadosPrecoTin();
        });
    });

    async function gravaDadosPrecoTin() {
        $.LoadingOverlay('show');
        try {
            const dataCores = $('#tabelaCores').DataTable().data().toArray();
            const dataPrecoTin = $('#tabelaPrecoTin').DataTable().data().toArray();

            dataPrecoTin.forEach(tin => {
                const match = dataCores.find(cor => cor.codigo === tin.codigo);
                if (match) {
                    match.precoTingimento = parseFloat(tin.precoTintur || 0).toFixed(6);
                    match.preco = parseFloat(tin.precoNovo || 0).toFixed(6);
                } else {
                    dataCores.push({
                        id: '',
                        ativo: 'S',
                        codigo: tin.codigo,
                        descricao: tin.descricao,
                        precoTingimento: parseFloat(tin.precoTintur || 0).toFixed(6),
                        precoCompra: 0,
                        percentualDesperdicio: 0,
                        preco: parseFloat(tin.precoNovo || 0).toFixed(6),
                        pantone: tin.pantone || '',
                        tinturaria: tin.tinturaria || '',
                        nome: tin.nome || '',
                        codigo2: tin.codigo2 || '',
                        grupo: tin.grupo || '',
                        descricaoGrupo: tin.descGrupo || '',
                        fatorConversao: 0
                    });
                }
            });

            criarTabelaCores(dataCores);
        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível gravar os dados: ${error}`);
        } finally {
            $('#modalPrecoTin').modal('hide');
            $.LoadingOverlay('hide');
        }
    }

    $('#modalPrecoTin').on('hide.bs.modal', async function () {
        $('#tabelaPrecoTin').DataTable().data().rows().remove();
        $('#txtTinturariaPrecoTin').val('');
        await desabAlteracaoPrecoTin();
    });

    $('#btnFecharPrecoTin').on('click', async function () {
        msgAlerta('Podem haver informações não gravadas, deseja continuar?', async () => {
            $('#modalPrecoTin').modal('hide');
        });
    });

    async function carregaDadosCustoMalhas(codMat) {
        $.LoadingOverlay('show');
        try {
            const malhaCrua = await buscaValor('CADMATTI', 'CODIGO', 'CODIGO2', $('#txtMalhaBase').val());

            if (malhaCrua != '') {
                $('#txtMalhaCrua').val(malhaCrua);

                carregaMalhaCrua(malhaCrua)
            } else {
                carregaMalhaCrua()
            }

            const malhaRotativa = await buscaMalhasRotativas(codMat, '');
            if (malhaRotativa?.malha?.length > 0) {
                await calculaMalhaRotativa(codMat, malhaRotativa.malha);
            } else {
                await carregaMalhaBaseSemRotativa(codMat);
                $('#divMalhasRotativas').addClass('d-none');
            }

            const codSaida = $('#txtMalhaBase').val();
            const corFundo = $('#tabelaCustoMalhaRotativa').DataTable().data().toArray().map(e => `'${e.corFundo}'`).join(', ');
            const malhaBase = await buscaMalhasBase(codMat, corFundo, codSaida);
            if (malhaBase?.malha?.length > 0) {
                await calculaMalhaBase(malhaBase.malha);
            }
        } catch (error) {
            console.error(error);
            msgErro('Ocorreu um erro ao carregar os dados.');
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function calculaMalhaBase(data) {
        const dataCrua = $('#tabelaCustoMalhaCrua').DataTable().data().toArray()

        let custoMalhaCrua = dataCrua.reduce((acc, e) => acc + retornaFloat(e.custoTotal), 0);
        custoMalhaCrua += retornaFloat($('#txtCustoTec').val());
        custoMalhaCrua = retornaFloat(custoMalhaCrua).toFixed(2);

        const json = data.map(e => {
            let custoTotal = retornaFloat(custoMalhaCrua) + retornaFloat(e.custoTin);
            const desp = retornaFloat(e.percentualDesperdicio);
            if (desp > 0) {
                custoTotal += (desp / 100) * custoTotal;
            }
            return {
                cor: e.cor,
                descricao: e.descricao,
                custoCrua: custoMalhaCrua,
                custoTin: e.custoTin,
                percentualDesperdicio: desp,
                custoTotal: custoTotal.toFixed(2)
            };
        });

        criarTabelaCustoMalhaBase(json);
        criarTabelaCustoMalhaRotativa()
    }

    async function calculaMalhaRotativa(codigo, malhaRotativa) {
        const dataBase = $('#tabelaCustoMalhaBase').DataTable().data().toArray();

        const json = malhaRotativa.map(e => {
            const base = dataBase.find(b => b.cor === e.corFundo);
            const precoMalha = base ? retornaFloat(base.custoTotal) : retornaFloat(e.custoMalha);

            let custoTotal = retornaFloat(e.preco) + precoMalha;
            const desp = retornaFloat(e.desperdicio);
            if (desp > 0) {
                custoTotal += (desp / 100) * custoTotal;
            }

            return {
                corRotativa: e.cor,
                descCor: e.descCor,
                corFundo: e.corFundo,
                descCorFundo: e.descCorFundo,
                preco: e.preco,
                custoMalha: precoMalha.toFixed(2),
                desperdicio: desp,
                custoTotal: custoTotal.toFixed(2)
            };
        });

        criarTabelaCustoMalhaRotativa(json);
        criarTabelaCustoMalhaBase()
    }

    async function carregaMalhaBaseSemRotativa(codigo) {
        const c = await buscaValor('CADMATTI', 'CODIGO', 'CODIGO2', codigo);
        const malhaCrua = c?.CODIGO || '';
        const corFundo = '';

        const malhaBase = await buscaMalhasBase(codigo, corFundo, malhaCrua);
        if (malhaBase?.malha?.length > 0) {
            await calculaMalhaBase(malhaBase.malha);
        }
    }

    function carregaMalhaCrua(codigo) {
        $.LoadingOverlay('show')
        buscaMalhaCura(codigo).then((dados) => {
            if (!dados) {
                return
            }
            return prepararDadosMalhaCrua(dados.malha)
        }).then((data) => {
            if (!data) {
                return
            }
            criarTabelaCustoMalhaCrua(data)
        }).catch((error) => {
            console.error(error)
            msgErro('Ocorreu um erro ao carregar os dados.')
        }).finally(() => {
            $.LoadingOverlay('hide')
        })
    }

    async function buscaMalhaCura(codigo) {
        const response = await requisicao("GET", `/sisplan/cadmatpreco/v1/buscamalhacrua?`, `CODIGO=${encodeURIComponent(codigo)}`, '', 3600000)

        const json = await response.json()

        if (json) {
            const { resultado, mensagem } = json
            if (mensagem?.codigo !== 200) {
                throw mensagem?.mensagem
            }

            return resultado
        }
    }

    async function buscaMalhasRotativas(codigo) {
        const response = await requisicao(
            "GET",
            `/sisplan/cadmatpreco/v1/buscamalharotativa?`,
            `CODIGO=${encodeURIComponent(codigo)}&CODSAIDA=${encodeURIComponent('')}`,
            '',
            3600000
        )

        const json = await response.json()
        if (json?.mensagem?.codigo !== 200) {
            throw json.mensagem?.mensagem
        }

        return json.resultado || null
    }

    async function buscaMalhasBase(codigo, corFundo = '', malhaCrua = '') {
        const response = await requisicao(
            "GET",
            `/sisplan/cadmatpreco/v1/buscamalhabase?`,
            `CODIGO=${encodeURIComponent(codigo)}&COR_FUNDO=${encodeURIComponent(corFundo)}&CODSAIDA=${encodeURIComponent(malhaCrua)}`,
            '',
            3600000
        )

        const json = await response.json()
        if (json?.mensagem?.codigo !== 200) {
            throw json.mensagem?.mensagem
        }

        return json.resultado || null
    }

    $('#btnCustoMalhas').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            $('#tituloCustoMalhas').html(`[${codMat}] - ${$('#txtDescricao').val()}`);

            await carregaDadosCustoMalhas(codMat);

            $('#modalCustoMalhas').modal('show');
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#modalCustoMalhas').on('shown.bs.modal', function () {
        $('#tabelaCustoMalhaBase').DataTable().columns.adjust().draw(false)
        $('#tabelaCustoMalhaRotativa').DataTable().columns.adjust().draw(false)
        $('#tabelaCustoMalhaCrua').DataTable().columns.adjust().draw(false)
    })

    $('#btnConsultarCustoMalhas').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            const malha = $('#txtMalhaBase').val();
            let malhaCrua = (await buscaValor('CADMATTI', 'CODIGO', 'CODIGO2', malha))?.CODIGO || '';
            let custo = (await buscaValor('MAT_PRECO', 'PRECO_1', 'CODIGO', malhaCrua))?.PRECO_1 ?? 0;
            await calculaMalhaBase([{ ...$('#tabelaCustoMalhaBase').DataTable().data()[0], custoTin: custo }]);
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#btnGravarModalCusto').on('click', async function () {
        const hasData = $('#tabelaCustoMalhaRotativa').DataTable().data().length > 0 ||
            $('#tabelaCustoMalhaBase').DataTable().data().length > 0 ||
            $('#tabelaCustoMalhaCrua').DataTable().data().length > 0;

        if (!hasData) return msgErro('Não há nenhum dado a ser gravado, favor verificar.');

        await msgAlerta('Deseja atualizar o preço dos itens?', async () => {
            gravaDadosCusto();
        });
    });

    function gravaDadosCusto() {
        $.LoadingOverlay('show');
        try {
            if ($('#tabelaCustoMalhaRotativa').DataTable().data().length > 0) {
                gravaDadosMalhaRotativa();
            } else {
                gravaDadosMalhaBase();
            }
        } finally {
            $('#modalCustoMalhas').modal('hide');
            $.LoadingOverlay('hide');
        }
    }

    async function gravaDadosMalhaRotativa() {
        try {
            const tabelaCores = $('#tabelaCores').DataTable().data().toArray();
            const tabelaRotativa = $('#tabelaCustoMalhaRotativa').DataTable().data().toArray();

            const listaCores = tabelaRotativa.map(e => e.corFundo);
            const listaPrecos = tabelaRotativa.map(e => retornaFloat(e.custoTotal));

            const json = tabelaCores.map(e => {
                const index = listaCores.indexOf(e.codigo);
                if (index !== -1) {
                    e.preco = listaPrecos[index];
                }

                return {
                    id: e.id,
                    ativo: e.ativo,
                    codigo: e.codigo,
                    descricao: e.descricao,
                    precoTingimento: e.precoTingimento,
                    precoCompra: e.precoCompra,
                    percentualDesperdicio: e.percentualDesperdicio,
                    preco: e.preco,
                    pantone: e.pantone,
                    tinturaria: e.tinturaria,
                    nome: e.nome,
                    codigo2: e.codigo2,
                    grupo: e.grupo,
                    descricaoGrupo: e.descricaoGrupo,
                    fatorConversao: e.fatorConversao
                };
            });

            $('#tabelaCores').DataTable().clear().draw();
            criarTabelaCores(json);

        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível atualizar os dados da malha rotativa: ${error}`);
        }
    }

    async function gravaDadosMalhaBase() {
        try {
            const tabelaCores = $('#tabelaCores').DataTable().data().toArray();
            const tabelaBase = $('#tabelaCustoMalhaBase').DataTable().data().toArray();

            const listaCores = tabelaBase.map(e => e.cor);
            const listaPrecos = tabelaBase.map(e => retornaFloat(e.custoTotal));
            const listaPrecosTint = tabelaBase.map(e => retornaFloat(e.custoTin));
            const listaPrecosCompra = tabelaBase.map(e => retornaFloat(e.custoCrua));

            const json = tabelaCores.map(e => {
                const index = listaCores.indexOf(e.codigo);
                if (index !== -1) {
                    e.preco = listaPrecos[index];
                    e.precoTingimento = listaPrecosTint[index];
                    e.precoCompra = listaPrecosCompra[index];
                }

                return {
                    id: e.id,
                    ativo: e.ativo,
                    codigo: e.codigo,
                    descricao: e.descricao,
                    precoTingimento: e.precoTingimento,
                    precoCompra: e.precoCompra,
                    percentualDesperdicio: e.percentualDesperdicio,
                    preco: e.preco,
                    pantone: e.pantone,
                    tinturaria: e.tinturaria,
                    nome: e.nome,
                    codigo2: e.codigo2,
                    grupo: e.grupo,
                    descricaoGrupo: e.descricaoGrupo,
                    fatorConversao: e.fatorConversao
                };
            });

            $('#tabelaCores').DataTable().clear().draw();
            criarTabelaCores(json);

        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível atualizar os dados da malha base: ${error}`);
        }
    }

    $('#btnFecharModalCusto').on('click', function () {
        $('#modalCustoMalhas').modal('hide');
    });

    $('#modalCustoMalhas').on('hide.bs.modal', function () {
        $('#tabelaCustoMalhaRotativa').DataTable().data().rows().remove();
        $('#tabelaCustoMalhaBase').DataTable().data().rows().remove();
        $('#tabelaCustoMalhaCrua').DataTable().data().rows().remove();
        $('#divMalhaRotativa').removeClass('d-none');
    });

    $('#btnVoltar').on('click', function () {
        window.location.href = `${BASE_URI}/cadmatpreco`
    })

    function aplicarEstilosCamposDecimais() {
        $('.seisCasasDecimaisQuantityFormat').off('focus input focusout')
        $('.seisCasasDecimaisQuantityFormat').on('focus', function () {
            $(this).select()
        });

        $('.seisCasasDecimaisQuantityFormat').on('input', function () {
            let val = $(this).val();

            val = val.replace(/\./g, ',');

            val = val.replace(/[^0-9,]/g, '');

            let partes = val.split(',');
            if (partes.length > 1) {
                val = partes[0] + ',' + partes[1].substring(0, 6);
            }

            $(this).val(val);
        });

        $('.seisCasasDecimaisQuantityFormat').on('focusout', function () {
            let val = $(this).val();

            if (val) {
                if (val.startsWith(',')) {
                    val = '0' + val;
                }
                let partes = val.split(',');
                let inteiro = partes[0];
                inteiro = safeParseInt(inteiro)
                if (!inteiro) {
                    inteiro = '0'
                }
                let decimais = partes[1] || '';
                decimais = decimais.padEnd(6, '0');
                $(this).val(String(inteiro) + ',' + decimais);
            }
        });

        $('.quatroCasasDecimaisQuantityFormat').off('input')
        $('.quatroCasasDecimaisQuantityFormat').on('input', function () {
            let val = $(this).val()
            val = val.replace('.', ',')
            val = val.replace(/[^0-9,]/g, '')
            const parts = val.split(',')
            if (parts.length > 2) {
                val = parts[0] + ',' + parts.slice(1).join('')
            }
            if (parts[1]?.length > 4) {
                parts[1] = parts[1].slice(0, 4)
                val = parts.join(',')
            }

            $(this).val(val)
        })
    }

    aplicarEstilosCamposDecimais()
});