<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Cadastro de Veículos</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2511.11.1">
    <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.2511.11.1">
    <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" href="dist/css/custom.css?versao=3.2511.11.1">
    <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.2511.11.1">
    <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.2511.11.1" />
    <link rel="shortcut icon" href="favicon.ico">
    <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.2511.11.1">
    <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.2511.11.1" />
    <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.2511.11.1">
    <link rel="stylesheet" href="dist/css/sisplan.newColorsButtons.css?versao=3.2511.11.1" type="text/css" />
    <link rel="stylesheet" href="dist/css/sisplan.adjustDataTableButtons.css?versao=3.2511.11.1" type="text/css" />
    <style>
        #tabelaVeiculos td div button {
            padding: .0rem .5rem;
            margin: .0rem;
        }

        #tabelaVeiculos td {
            padding: 5px 8px !important;
        }

        .table.dataTable tbody td,
        th {
            white-space: nowrap;
            text-overflow: ellipsis;
            overflow: hidden;
        }

        #tabelaVeiculos_length {
            margin-top: 15px;
        }

        .dataTables_scroll {
            margin-top: -5px !important;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">
        <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6 flex">
                            <h1 class="m-0 text-dark">Cadastro de Veículos</h1>
                            <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                                <i class="fas fa-question-circle"></i></button>
                        </div>
                    </div>
                </div>
                <div class="container-fluid" id="tabelaMoedaForne">
                    <div class="row card">
                        <div class="col-sm-12 d-flex justify-content-between" style="margin-top: 8px; padding-left: 20px; padding-right: 20px; z-index: 9999;">
                            <div class="d-flex align-items-center mt-2">
                                <button class="btn btnFiltros btn-sisp" id="btnFiltros"><span class="fas fa-filter"></span> Filtros</button>
                                <button class="btn btn-danger btn-sisp marginBtnH" id="btnNovoVeiculo"><span class="fas fa-plus"></span> Incluir</button>
                            </div>
                        </div>
                        <div class="col-sm-12 table-responsive card-body" style="margin-top: -15px; height: 80vh">
                            <table id="tabelaVeiculos" class="table table-sm table-sm-sisp table-select table-hover" width="100%">
                                <thead>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
                <div class="modal-dialog modal-xl" role="document">
                    <div class="modal-content" id="modalBody">
                        <div class="modal-header">
                            <h4 class="modal-title">Filtros</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="form-group col-md-6 col-12">
                                    <label data-error="wrong" data-success="right">Vencimento de/até: </label>
                                    <div class="relative">
                                        <div class="input-group">
                                            <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtVencimentoDe" value="1200-01-01" name="dtVencimentoDe" class="form-control">
                                            <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtVencimentoAte" value="2500-12-31" name="dtVencimentoAte" class="form-control">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group col-md-6 col-12">
                                    <label data-error="wrong" data-success="right">Vencimento IPVA de/até: </label>
                                    <div class="relative">
                                        <div class="input-group">
                                            <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtVencimentoIPVADe" value="1200-01-01" name="dtVencimentoIPVADe" class="form-control">
                                            <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtVencimentoIPVAAte" value="2500-12-31" name="dtVencimentoIPVAAte" class="form-control">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-md-4 col-12">
                                    <label data-error="wrong" data-success="right" for="txtProprietario">Proprietário: </label>
                                    <div class="input-group">
                                        <input type="text" autocomplete="off" class="input-default focus form-control" id="txtProprietario" name="txtProprietario" class="form-control" placeholder="Proprietário">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnProprietario" name="btnProprietario" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btnLimpaProprietario" name="btnLimpaProprietario" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group col-md-4 col-12" id="inputPlaca">
                                    <label data-error="wrong" data-success="right" for="txtPlaca">Placa: </label>
                                    <div class="input-group">
                                        <input type="text" autocomplete="off" class="input-default focus form-control" id="txtPlaca" name="txtPlaca" class="form-control" placeholder="Placa">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnPlaca" name="btnPlaca" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btnLimpaPlaca" name="btnLimpaPlaca" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group col-md-4 col-12">
                                    <label data-error="wrong" data-success="right" for="txtModelo">Modelo: </label>
                                    <div class="input-group">
                                        <input type="text" autocomplete="off" class="input-default focus form-control" id="txtModelo" name="txtModelo" class="form-control" placeholder="Modelo">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnModelo" name="btnModelo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btnLimpaModelo" name="btnLimpaModelo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group col-md-6 col-12" id="inputCidade">
                                    <label data-error="wrong" data-success="right" for="txtCidade">Cidade: </label>
                                    <div class="input-group">
                                        <input type="text" autocomplete="off" class="input-default focus form-control" id="txtCidade" name="txtCidade" class="form-control" placeholder="Cidade">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnCidade" name="btnCidade" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btnLimpaCidade" name="btnLimpaCidade" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group col-md-6 col-12" id="inputSeguradora">
                                    <label data-error="wrong" data-success="right" for="txtSeguradora">Seguradora: </label>
                                    <div class="input-group">
                                        <input type="text" autocomplete="off" class="input-default focus form-control" id="txtSeguradora" name="txtSeguradora" class="form-control" placeholder="Seguradora">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnSeguradora" name="btnSeguradora" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btnLimpaSeguradora" name="btnLimpaSeguradora" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <div class="row">
                                <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
                                <button class="btn btn-danger btn-sisp marginBtnH" id="btnLimparFiltros"><span class="fas fa-trash"></span> Limpar Filtros</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
    include_once('../../../modais.php');
    ?>
    <aside class="control-sidebar control-sidebar-dark">
    </aside>
    </div>
    <script src="plugins/jquery/jquery.min.js?versao=3.2511.11.1"></script>
    <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.2511.11.1"></script>
    <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.2511.11.1"></script>
    <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.2511.11.1"></script>
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2511.11.1"></script>
    <script src="dist/js/adminlte.min.js?versao=3.2511.11.1"></script>
    <script src="dist/js/sisplan.js?versao=3.2511.11.1"></script>
    <script src="utils/funcoes.js?versao=3.2511.11.1"></script>
    <script src="utils/cookies.js?versao=3.2511.11.1"></script>
    <script src="dist/js/requisicoes.js?versao=3.2511.11.1"></script>
    <script src="dist/js/loadingoverlay.min.js?versao=3.2511.11.1"></script>
    <script src="dist/js/driver.min.js?versao=3.2511.11.1"></script>
    <script src="plugins/toastr/toastr.min.js?versao=3.2511.11.1"></script>

    <script type="text/javascript" src="dist/js/sum().js?versao=3.2511.11.1"></script>
    <script type="text/javascript" src="config.js?versao=3.2511.11.1"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            ipInterno = IP_INTERNO;
            ipExterno = IP_EXTERNO;
            basicAuth = BASIC_AUTH;

            const temAcesso = await temAcessoTela('CADVEICULO');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            sArquivo = `${BASE_URI}/pages/cadveiculo/acesso_cadveiculo/acesso_cadveiculo.js?versao=3.2511.11.1`;
            insereJavaScriptPagina(sArquivo);

        });
    </script>
</body>

</html>