$('#tutorial').on('click', function () {
  $('#geral-tab').trigger('click');
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      onHighlightStarted: (Element) => {
        if (Element.node.id == 'geral') {
          if (!$('#DadosGerais').hasClass('show'));
          $('#DadosGerais').collapse('show');
        }
      },
    });

    driver.defineSteps([{
      element: '#btnFiltros',
      popover: {
        title: 'Filtros',
        description: 'Aqui você pode inserir filtros para fazer a consulta do cancelamento.',
        position: 'bottom'
      }
    },
    {
      element: '#btnNovoCancelamento',
      popover: {
        title: 'Incluir Cancelamento',
        description: 'Ao selecionar esse botão, você será direcionado para a tela de cancelamento de pedido.',
        position: 'bottom'
      }
    },
    {
      element: '#btnImprimir',
      popover: {
        title: 'Botão Imprimir',
        description: 'Clique aqui para imprimir os pedidos filtrados.',
        position: 'right'
      }
    },
    {
      element: '#tutTabelaPedido',
      popover: {
        title: 'Tabela de Pedidos',
        description: 'Aqui estão pedidos, é possivel identificar as quantidades canceladas e/ou faturadas.',
        position: 'bottom'
      }
    }
    ]);

    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("CANCELAMENTO_PEDIDO");
  let consultando = true
  const itensCancelar = []

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.acessoCancelamento == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, acessoCancelamento: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  $('#btnConfirmarColunas').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, acessoCancelamento: novasColunas }))

      $('#tabelaPedido').DataTable().columns().visible(true);

      $('#tabelaPedido').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaPedido').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.acessoCancelamento ?? [], ['NUMERO'])
  })

  buscaDataAtual();

  async function buscaDataAtual() {
    const date = new Date();
    const firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
    $('#dtCancalamentoDe').val(formataData(firstDay));
  }

  $('#txtCliente').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":["CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtRepresentante').autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtMotivo').autocompleta(1, `JSON={ "tabela":"MENSAGEM", "camposSelect":["CODMEN CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtReserva').autocompleta(1, `JSON={ "tabela":"PED_RESERVA", "camposSelect":["NUMERO CHAVE", "CODIGO DESCRICAO"], "where": null}`);
  $('#txtColecao').autocompleta(1, `JSON={ "tabela":"COLECAO", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtEtiqueta').autocompleta(1, `JSON={ "tabela":"ETQ_PROD", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtCor').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtTamanho').autocompleta(1, `JSON={ "tabela":"TABTAM", "camposSelect":["TAM CODIGO", "FAIXA DESCRICAO"], "where": null}`);
  $('#txtMotivoGrava').autocompleta(1, `JSON={ "tabela":"CODMEN", "camposSelect":["CODMEN CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtProduto').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtGrupoProduto').autocompleta(1, `JSON={ "tabela":"GRUPO_PA", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtProgramacao').autocompleta(1, `JSON={ "tabela":"OF1", "camposSelect":["NUMERO CHAVE", "PROGRAMACAO DESCRICAO"], "where": null}`);
  $('#txtPedido').autocompleta(1, `JSON={ "tabela":"PEDIDO", "camposSelect":[ "PEDIDO.NUMERO CHAVE", "ENTIDADE.NOME DESCRICAO" ], "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = PEDIDO.CODCLI"}], "where": null}`);

  $('#btnPedido').pesquisa('#txtPedido', 'NUMERO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"PEDIDO", "camposSelect":[ "PEDIDO.NUMERO", "ENTIDADE.NOME" ], "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = PEDIDO.CODCLI"}]}`, 'Pesquisa Pedido', 'PEDIDO');
  $('#btnCliente').pesquisa('#txtCliente', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"]}`, 'Pesquisa Cliente', 'ENTIDADE');
  $('#btnRepresentante').pesquisa('#txtRepresentante', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME"]}`, 'Pesquisa Representante', 'REPRESEN');
  $('#btnMotivo').pesquisa('#txtMotivo', 'CODMEN', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MENSAGEM", "camposSelect":[ "CODMEN", "DESCRICAO"]}`, 'Pesquisa Motivo', 'MENSAGEM');
  $('#btnReserva').pesquisa('#txtReserva', 'NUMERO', 'CODIGO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"PED_RESERVA", "camposSelect":[ "NUMERO", "CODIGO"]}`, 'Pesquisa Reserva', 'PED_RESERVA');
  $('#btnColecao').pesquisa('#txtColecao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Colecao', 'COLECAO');
  $('#btnEtiqueta').pesquisa('#txtEtiqueta', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"ETQ_PROD", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Etiqueta', 'ETQ_PROD');
  $('#btnCor').pesquisa('#txtCor', 'COR', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO"]}`, 'Pesquisa Cor', 'CADCOR');
  $('#btnTamanho').pesquisa('#txtTamanho', 'TAM', 'FAIXA', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TABTAM", "camposSelect":[ "TAM", "FAIXA"]}`, 'Pesquisa Tamanho', 'TABTAM');
  $('#btnMotivoGrava').pesquisa('#txtMotivoGrava', 'CODMEN', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MENSAGEM", "camposSelect":[ "CODMEN", "DESCRICAO"]}`, 'Pesquisa Motivo Grava', 'MENSAGEM');
  $('#btnProduto').pesquisa('#txtProduto', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Produto', 'PRODUTO');
  $('#btnGrupoProduto').pesquisa('#txtGrupoProduto', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Grupo Produto', 'GRUPO_PA');
  $('#btnProgramacao').pesquisa('#txtProgramacao', 'NUMERO', 'PROGRAMACAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"OF1", "camposSelect":[ "NUMERO", "PROGRAMACAO"]}`, 'Pesquisa Programacao', 'OF1');

  $('#btnLimpaPedido').on('click', function () {
    $('#txtPedido').val('');
  });

  $('#btnLimpaCliente').on('click', function () {
    $('#txtCliente').val('');
  });

  $('#btnLimpaRepresentante').on('click', function () {
    $('#txtRepresentante').val('');
  });

  $('#btnLimpaMotivo').on('click', function () {
    $('#txtMotivo').val('');
  });

  $('#btnLimpaReserva').on('click', function () {
    $('#txtReserva').val('');
  });

  $('#btnLimpaColecao').on('click', function () {
    $('#txtColecao').val('');
  });

  $('#btnLimpaEtiqueta').on('click', function () {
    $('#xtEtiqueta').val('');
  });

  $('#btnLimpaCor').on('click', function () {
    $('#txtCor').val('');
  });

  $('#btnLimpaTamanho').on('click', function () {
    $('#txtTamanho').val('');
  });

  $('#btnMotivoGrava').on('click', function () {
    $('#txtMotivoGrava').val('');
  });

  $('#btnLimpaProgramacao').on('click', function () {
    $('#txtProgramacao').val('');
  });

  $('#btnLimpaGrupoProduto').on('click', function () {
    $('#txtGrupoProduto').val('');
  });

  $('#btnLimpaProduto').on('click', function () {
    $('#txtProduto').val('');
  });

  $('#btnLimpaFiltros').on('click', function () {
    buscaDataAtual();
    $('#cbMotivoCancelamento').prop('checked', false);
    $('#cbFaturamentoParcial').prop('checked', false);
    $('#cbSomenteQtdePendente').prop('checked', false);
    $('#dtCancelamentoAte').val('2500-12-31');
    $('#txtPedido').val('');
    $('#txtCliente').val('');
    $('#txtRepresentante').val('');
    $('#txtMotivo').val('');
    $('#txtReserva').val('');
    $('#txtColecao').val('');
    $('#xtEtiqueta').val('');
    $('#txtCor').val('');
    $('#txtTamanho').val('');
    $('#txtMotivoGrava').val('');
    $('#txtProgramacao').val('');
    $('#txtGrupoProduto').val('');
    $('#txtProduto').val('');
  })

  function retornaBotaoOpcoes(pedido) {
    var retorno = '<div style="text-align:start;"> ' +
      '   <div class="dropdown" style="position: initial"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + pedido + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button id="btn-editar" type="button" class="dropdown-item">Alterar</button>' +
      `    <button id="btn-imprimirIndividual" type="button" ${getCookie('cod_usuario') == '0000' ? 'title="Este botão chama o Layout RelCancelamentoPedidoIndividual.FR3"' : ''} class="dropdown-item">Imprimir</button>`;
    retorno += '</div>' +
      '  </div>' +
      '</div>';
    return retorno;
  }

  function buscaParametros() {
    //CHECKBOX
    let sMotivoCancelamento = $('#cbMotivoCancelamento').is(':checked') ? 'S' : 'N';
    let sFaturadoParcialmente = $('#cbFaturamentoParcial').is(':checked') ? 'S' : 'N';
    let sComQtdePendente = $('#cbSomenteQtdePendente').is(':checked') ? 'S' : 'N';
    //CAMPOS    
    let sDtCancelamentoDe = formataDataBonita($('#dtCancalamentoDe').val());
    let sDtCancelamentoAte = formataDataBonita($('#dtCancelamentoAte').val());
    let sPedido = pegaChave('#txtPedido');
    let sCliente = pegaChave('#txtCliente');
    let sRepresentante = pegaChave('#txtRepresentante');
    let sReserva = pegaChave('#txtReserva');
    let sMotivo = pegaChave('#txtMotivo');
    let sColecao = pegaChave('#txtColecao');
    let sEtiqueta = pegaChave('#txtEtiqueta');
    let sCor = pegaChave('#txtCor');
    let sTamanho = pegaChave('#txtTamanho');
    let sProduto = pegaChave('#txtProduto');
    let sGrupoProduto = pegaChave('#txtGrupoProduto');
    let sProgramacao = pegaChave('#txtProgramacao');

    let retorno =
      //CHECKBOX
      `MOTIVO_CANCELAMENTO=${sMotivoCancelamento}` +
      `&FATURADO_PARCIALMENTE=${sFaturadoParcialmente}` +
      `&COM_QTDE_PENDENTE=${sComQtdePendente}` +
      //CAMPOS
      `&DT_CANCEL_INICIO=${sDtCancelamentoDe}` +
      `&DT_CANCEL_FIM=${sDtCancelamentoAte}` +
      `&NUMERO=${sPedido}` +
      `&CLIENTE=${sCliente}` +
      `&CODREP=${sRepresentante}` +
      `&RESERVA=${sReserva}` +
      `&MOTIVO=${sMotivo}` +
      `&COLECAO=${sColecao}` +
      `&ETIQUETA=${sEtiqueta}` +
      `&COR=${sCor}` +
      `&TAMANHO=${sTamanho}` +
      `&PRODUTO=${sProduto}` +
      `&GRUPO_PRODUTO=${sGrupoProduto}` +
      `&PROGRAMACAO=${sProgramacao}`;

    return retorno;
  };

  $('#btnConsultar').on('click', async function () {
    consultando = true
    if ($.fn.DataTable.isDataTable('#tabelaPedido')) {
      $('#tabelaPedido').DataTable().destroy();
      $('#tabelaPedido').empty();
    }
    try {
      const trazerItens = $('#cbTrazerItens').is(':checked')

      const titulosColunas = {
        NUMERO: 'Número',
        CODCLI: 'Código Cliente',
        NOME_CLIENTE: 'Nome Cliente',
        CODREP: 'Código Representante',
        NOME_REPRESEN: 'Nome Representante',
        QTDE: 'Quantidade',
        QTDE_CANC: 'Quantidade Cancelada',
        VALOR_CANC: 'Valor Cancelado',
        QTDE_FAT: 'Quantidade Faturada',
        VALOR_FAT: 'Valor Faturado',
      }

      const chavesColunas = ['NUMERO', 'CODCLI', 'NOME_CLIENTE', 'CODREP', 'NOME_REPRESEN', 'QTDE', 'QTDE_CANC', 'VALOR_CANC', 'QTDE_FAT', 'VALOR_FAT']

      let ordemColunasRelatorio = localStorage.getItem('ordemColunasDataTable')
      ordemColunasRelatorio = JSON.parse(ordemColunasRelatorio)

      let keys
      if (ordemColunasRelatorio != null && ordemColunasRelatorio.cancelamentoAcesso != undefined) {
        const ordenacao = 'GERAL'
        const colunas = ordemColunasRelatorio.cancelamentoAcesso.filter(f => f.ordenacao == ordenacao)
        keys = colunas.length > 0 ? colunas[0].colunas : chavesColunas;
      } else {
        keys = chavesColunas;
      }

      const colunasOriginais = chavesColunas

      const columns = keys.map((key) => ({
        data: key,
        title: titulosColunas[key],
      }))

      const filtros = buscaParametros()

      const response = await requisicao("GET", `/sisplan/cancelamentopedido/v1/buscarcancelamento?`, filtros, '', 3600000)

      const jsonStr = await response.json()

      $('#tabelaPedido').DataTable({
        paging: true,
        lengthChange: true,
        filter: false,
        info: true,
        order: false,
        destroy: true,
        order: [],
        colReorder: true,
        scrollY: "300px",
        scrollX: true,
        data: jsonStr,
        columns,
        columnDefs: [
          {
            render(row) {
              return retornaBotaoOpcoes(row);
            },
            targets: [keys.indexOf(colunasOriginais[0])],
          },
          {
            targets: [keys.indexOf(colunasOriginais[7]), keys.indexOf(colunasOriginais[9])],
            render(data) {
              return parseFloat(data).toFixed(2).replace('.', ',')
            }
          }]
      });

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#tabelaPedido_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaPedido_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis').prop('title', 'Configurar colunas visíveis');
      $('#buttonExcel').prop('title', 'Exportar');

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        await exportaCSV('', '', true, null, 'Relatório dos Itens do Pedido', undefined, '', 999, false, false, jsonStr);
      })

      $('#tabelaPedido').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.acessoCancelamento).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

      $('#tabelaPedido').on('column-reorder.dt', function (e, settings, details) {
        if (consultando) {
          return
        }
        const newColumnOrder = []

        for (let i = 0; i < settings.aoColumns.length; i++) {
          const column = settings.aoColumns[i].mData

          newColumnOrder.push(column)
        }

        let ordemColunas = localStorage.getItem('ordemColunasDataTable')
        ordemColunas = JSON.parse(ordemColunas)
        const ordenacao = 'GERAL'

        if (ordemColunas == null || ordemColunas.cancelamentoAcesso == undefined) {
          localStorage.setItem('ordemColunasDataTable', JSON.stringify({ ...ordemColunas, cancelamentoAcesso: [{ ordenacao: ordenacao, colunas: newColumnOrder }] }));

        } else if (!ordemColunas.cancelamentoAcesso.some(s => s.ordenacao == ordenacao)) {

          const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
          const newObj = { ordenacao: ordenacao, colunas: newColumnOrder }
          ordensSalvas.cancelamentoAcesso.push(newObj)
          localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));

        } else if (ordemColunas.cancelamentoAcesso.some(s => s.ordenacao == ordenacao)) {

          const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
          ordensSalvas.cancelamentoAcesso.filter(f => f.ordenacao == ordenacao)[0].colunas = newColumnOrder
          localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));
        }
      });

      if (trazerItens) {
        $('#divTabelaItens').removeClass('d-none')
      } else {
        $('#divTabelaItens').addClass('d-none')
      }

      consultando = false
    } catch (err) {
      console.log(err)
    } finally {
      $('#modal-filtros').modal('hide');
    }
  });

  $('#tabelaPedido').on('click', '#btn-editar', async function () {
    try {
      if (permissaoUsuarioLogado.ALTERA == 'S') {
        let data = $('#tabelaPedido').DataTable().row($(this).parents('tr')).data();
        window.location.href = `cancelamento_pedido/${data.NUMERO}`;
      } else {
        msgAlertaSemConfirmacao("Sem permissão para alterar!");
      }
    } catch (error) {
      console.error();
    }
  })

  $('#tabelaPedido').on('dblclick', 'tr', async function () {
    try {
      if (permissaoUsuarioLogado.ALTERA == 'S') {
        let data = $('#tabelaPedido').DataTable().row($(this)).data();
        window.location.href = `cancelamento_pedido/${data.NUMERO}`;
      } else {
        msgAlertaSemConfirmacao("Sem permissão para alterar!");
      }
    } catch (error) {
      console.error();
    }
  });

  $('#tabelaPedido').on('click', '#btn-imprimirIndividual', async function () {
    $.LoadingOverlay('show');
    try {
      const data = $('#tabelaPedido').DataTable().row($(this).parents('tr')).data();
      const url = `/sisplan/cancelamentopedido/v1/imprimirindividual?`;

      const filtros = `EMPRESA=${getCookie('empresa')}&USUARIO=${getCookie('usuario')}&NUMERO=${data.NUMERO}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelCancelamentoPedidoIndividual');
      let arquivo = await GeraRelatorio(`${url}${filtros}`, 'GET', 150000, false, 'RelCancelamentoPedidoIndividual');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#tabelaPedido').on('click', 'tr', async function (e) {
    const colunaIndex = $(e.target).closest("td").index();

    if (colunaIndex == 0) return;

    const trazerItens = $('#cbTrazerItens').is(':checked');
    if (!trazerItens) return;

    const tabela = $('#tabelaPedido').DataTable();
    const data = tabela.row($(this)).data();

    if ($(this).hasClass('selected')) {
      $(this).removeClass('selected');
    } else {
      tabela.$('tr.selected').removeClass('selected');
      $(this).addClass('selected');
    }

    await retornaItensPedido(data.NUMERO);

    ajustaSelectedTabelaPedido();
  });


  $('#btnNovoCancelamento').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "cancelamento_pedido/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  retornaHintRelatorio('btnImprimir', 'RelCancelamentoPedido')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let url = `/sisplan/cancelamentopedido/v1/imprimir?`;

        const filtros = buscaParametros();
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelCancelamentoPedido');
        let arquivo = await GeraRelatorio(`${url}&EMPRESA=${getCookie('empresa')}&USUARIO=${getCookie('usuario')}&${filtros}`, 'GET', 150000, false, 'RelCancelamentoPedido');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  async function retornaItensPedido(pedido) {
    $.LoadingOverlay('show')
    try {
      let data = await buscaDadosPedidos(pedido);

      criaTabelaItens(data.itens)
    } catch (error) {
      console.error(error)
      msgAlerta(error)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  async function buscaDadosPedidos(pedido) {
    const response = await requisicao("GET", `/sisplan/cancelamentopedido/v1/buscadadositens?`, `&NUMERO=${pedido}`, '', 3600000)

    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado
    }
  };

  function criaTabelaItens(data) {
    if ($.fn.DataTable.isDataTable('#tabelaItens')) {
      $('#tabelaItens').DataTable().destroy();
      $('#tabelaItens').empty();
    }

    $('.txtCancelar').val(0)

    const dataSetCols = [
      { data: 'pedido', title: 'Pedido' },
      { data: 'codigo', title: 'Código' },
      { data: 'descProduto', title: 'Descrição' },
      { data: 'cor', title: 'Cor' },
      { data: 'descCor', title: 'Desc. Cor' },
      { data: 'tam', title: 'Tam' },
      { data: 'precoLiq', title: 'Preço Liq.', className: 'pr-4 text-right' },
      { data: 'qtdeOrig', title: 'Qtde Orig.', className: 'pr-4 text-right' },
      { data: 'qtde', title: 'Qtde', className: 'pr-4 text-right' },
      {
        data: 'cancelada',
        title: `Cancelada
              <i class="fas fa-check ml-1 mt-1" id="cbCancelarTotal" title="Cancelar Total" style="color: #32CD32; font-size: 1.0em; cursor: pointer;"></i>
              <i class="fas fa-times ml-1 mt-1 d-none" id="cbLimparCancelar" title="Limpar Quantidades a Cancelar" style="color: #be0000; font-size: 1.0em; cursor: pointer;"></i>`,
        render: function (_, __, ___, meta) {
          const index = meta.row;
          return `
          <div class="input-group flex-nowrap">
            <input type="text" 
                   class="input-default focus form-control stepControlPedido${index} txtCancelar" 
                   id="txtCancelar_${index}" 
                   name="txtCancelar_${index}" 
                   placeholder="0" 
                   style="max-width: 71px; max-height: 30px;">
          </div>`;
        }
      },
      { data: 'faturada', title: 'Faturada', visible: false },
      { data: 'qtdeCanc', title: 'Qtde Canc.', className: 'pr-4 text-right' },
      { data: 'qtdeFat', title: 'Qtde Fat.', className: 'pr-4 text-right' },
      { data: 'idItemPed', title: 'Id Item Ped', visible: false },
      { data: 'ordem', title: 'Ordem', visible: false },
      { data: 'reservada', title: 'Reservada', visible: false },
      { data: 'qtdeResB', title: 'Qtde Res. B.', visible: false },
      { data: 'qualidade', title: 'Qualidade', visible: false },
      { data: 'tipo', title: 'Tipo', visible: false },
      { data: 'expedicao', title: 'Expedicao', visible: false },
    ];

    const tabela = $('#tabelaItens').DataTable({
      paging: false,
      filter: false,
      info: false,
      order: [],
      colReorder: false,
      destroy: true,
      scrollY: '350px',
      columns: dataSetCols,
      data,
      createdRow: function (row) {
        $('td', row).eq(8).css({ color: 'green', fontWeight: 'bold' });
        $('td', row).eq(10).css({ color: 'red', fontWeight: 'bold' });
        $('td', row).eq(7).css('font-weight', 'bold');
      }
    });

    tabela.on('draw', function () {
      for (let i = 0; i < $('#tabelaItens').DataTable().data().toArray().length; i++) {
        const item = $('#tabelaItens').DataTable().data().toArray()[i];

        const itemExistente = itensCancelar.find(x => x.ID_ITEM_PED == item.idItemPed && x.NUMERO == item.pedido)

        if (itemExistente && itemExistente.CANCELADA > 0) {
          $(`#txtCancelar_${i}`).val(itemExistente.CANCELADA).trigger('blur');
        } else {
          $(`#txtCancelar_${i}`).val(0).trigger('blur');
        }
      }
    });

    $('#cbCancelarTotal').on('click', function () {
      msgAguardaConfirmacao('Deseja cancelar a qtde total de todos os itens?', () => {
        tabela.rows().every(function (index) {
          const qtde = this.data().qtde;
          const input = $(`#txtCancelar_${index}`);
          input.val(qtde).trigger('blur');
        });
        $('#cbCancelarTotal').addClass('d-none');
        $('#cbLimparCancelar').removeClass('d-none');
      });
    });

    $('#cbLimparCancelar').on('click', function () {
      msgAguardaConfirmacao('Deseja limpar a qtde a cancelar de todos os itens?', () => {
        tabela.rows().every(function (index) {
          const input = $(`#txtCancelar_${index}`);
          input.val(0).trigger('blur');
        });
        $('#cbCancelarTotal').removeClass('d-none');
        $('#cbLimparCancelar').addClass('d-none');
      });
    });

    aplicaMascara()
  }

  $('#tabelaItens').on('blur', '.txtCancelar', function () {
    const linha = $(this).closest('tr');
    const data = $('#tabelaItens').DataTable().row(linha).data()
    const qtdeMax = parseInt(data?.qtde ?? 0);
    const qtdeVal = parseInt($(this).val() || 0);

    if (qtdeVal > qtdeMax) {
      $(this).val(0);
      linha.removeClass('selected');
      throw msgAlerta(`Quantidade a cancelar: ${qtdeVal}, maior que o saldo do item do pedido: ${qtdeMax}, impossível continuar.`);
    }

    if (qtdeVal > 0) {
      linha.addClass('selected');
      addItemCancelar(data, qtdeVal)
    } else {
      linha.removeClass('selected');
      addItemCancelar(data, qtdeVal, false)
    }
  });

  function addItemCancelar(data, qtdeCanc, adiciona = true) {
    const indexExistente = itensCancelar.findIndex(
      x => x.ID_ITEM_PED === data.idItemPed && x.NUMERO === data.pedido
    );

    if (!adiciona) {
      if (indexExistente != -1) {
        itensCancelar.splice(indexExistente, 1);
      }
      return;
    }

    if (indexExistente != -1) {
      itensCancelar[indexExistente].CANCELADA = qtdeCanc;
      return;
    }

    const obj = {
      NUMERO: data.pedido,
      CODIGO: data.codigo,
      DESCRICAO: data.descProduto,
      COR: data.cor,
      DESCCOR: data.descCor,
      TAM: data.tam,
      PRECOLIQ: data.precoLiq,
      QTDE_ORIG: data.qtdeOrig,
      QTDE: data.qtde,
      CANCELADA: qtdeCanc,
      QTDE_CANC: data.qtdeCanc,
      QTDE_F: data.qtdeFat,
      ID_ITEM_PED: data.idItemPed,
      ORDEM: data.ordem,
      RESERVADO: data.reservada,
      QTDE_RES_B: data.qtdeResB,
      QUALIDADE: data.qualidade,
      TIPO: data.tipo,
      EXPEDICAO: data.expedicao,
    };

    itensCancelar.push(obj)
  }

  function ajustaSelectedTabelaPedido() {
    const tabela = $('#tabelaPedido').DataTable();
    if (!tabela) return;

    tabela.rows().every(function () {
      const data = this.data();
      const $linha = $(this.node());

      const pedidoExistente = itensCancelar.some(x => x.NUMERO == data.NUMERO);

      const isCurrentlySelected = $linha.hasClass('selected')

      if (pedidoExistente || isCurrentlySelected) {
        $linha.addClass('selected');
      } else {
        $linha.removeClass('selected');
      }
    });
  }

  function buscaDadosTabelaGravar() {
    const itensFiltrados = itensCancelar.filter(item => item.CANCELADA > 0);

    const pedidosMap = {};

    itensFiltrados.forEach(item => {
      if (!pedidosMap[item.NUMERO]) {
        pedidosMap[item.NUMERO] = {
          PEDIDO: item.NUMERO,
          ITENS: [],
          QTDE: 0,
          QTDECANC: 0
        };
      }

      pedidosMap[item.NUMERO].ITENS.push({
        CODIGO: item.CODIGO,
        DESCRICAO: item.DESCRICAO,
        COR: item.COR,
        DESCCOR: item.DESCCOR,
        TAM: item.TAM,
        PRECOLIQ: item.PRECOLIQ,
        QTDE_ORIG: item.QTDE_ORIG,
        QTDE: item.QTDE,
        CANCELADA: item.CANCELADA,
        QTDE_CANC: item.QTDE_CANC,
        QTDE_F: item.QTDE_F,
        ID_ITEM_PED: item.ID_ITEM_PED,
        ORDEM: item.ORDEM,
        RESERVADO: item.RESERVADO,
        QTDE_RES_B: item.QTDE_RES_B,
        QUALIDADE: item.QUALIDADE,
        TIPO: item.TIPO,
        EXPEDICAO: item.EXPEDICAO
      });

      pedidosMap[item.NUMERO].QTDE += Number(item.QTDE) || 0;
      pedidosMap[item.NUMERO].QTDE_CANC += Number(item.CANCELADA) || 0;
    });

    const listaPedidos = Object.values(pedidosMap);

    return listaPedidos;
  }

  function validacoesGravar() {
    if (!$('#txtDeposito').val() && $('#cbBaixarEstoque').is(':checked')) {
      throw new Error('O depósito deve ser informado, verifique!');
    };

    if (!$('#txtMotivo').val()) {
      throw new Error('O motivo deve ser informado, verifique!');
    };

    let qtde = 0;
    itensCancelar.forEach((item, index) => {
      qtde += item.CANCELADA;
      if (parseInt(item.CANCELADA) > parseInt(item.QTDE)) {
        throw new Error('Quantidade a cancelar maior que o saldo do pedido, impossível continuar.');
      }
    })

    if (qtde == 0) {
      throw new Error('Nenhuma quantidade informada, impossível continuar.');
    }
  };


  async function gravaCancelamento() {
    try {
      $.LoadingOverlay('show');
      const Pedidos = buscaDadosTabelaGravar();

      let objeto = { Pedidos };
      let response = await requisicao('POST', `/sisplan/cancelamentopedido/v1/gravarvarios?`, '', JSON.stringify(objeto), 60000);

      if (!response) {
        return;
      };

      if (response.status != 200) {
        let jsonStr = await response.json();
        msgErro(jsonStr.mensagem);
        return;
      }

      toastr.success(
        `Dados gravados com sucesso!`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/cancelamento_pedido`;
        }
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#btnGravar').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      validacoesGravar();
      await gravaCancelamento();
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  function aplicaMascara() {
    $('.txtCancelar').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });
  }

  $('#btnConsultar').trigger('click');
});