$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
      animate: true,
      onNext: (Element) => {
        if (Element.node.id == "gravar") {
          $(".driver-next-btn").on("click", location.reload());
        }
      },
      onPrevious: (Element) => {
        if (Element.node.id == "formcard1") {
          $(".driver-close-btn").on("click", location.reload());
        }
      },
    });

    driver.defineSteps([
      {
        element: "#campostuto",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#tutorialCodigo",
        popover: {
          title: "Código",
          description:
            "Aqui adicionamos o código para a Classificação Tributária.",
          position: "top",
        },
      },
      {
        element: "#tutorialDescricao",
        popover: {
          title: "Descrição",
          description:
            "Neste campo adicionamos a descrição da Classificação Tributária.",
          position: "top",
        },
      },
      {
        element: "#tutorialPadrao",
        popover: {
          title: "Padrão",
          description:
            "Aqui selecionamos se será a Classificação Padrão, poderá ter apenas uma classificação como padrão.",
          position: "top",
        },
      },
      {
        element: "#tutorialTributacao",
        popover: {
          title: "Tributação ICMS",
          description:
            "Aqui selecionamos qual o tipo de Tributação ICMS da classificação.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#gravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar a o cadastro.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let clatrib = parametros[parametros.length - 1];

  $("#btnVoltar").on("click", async function () {
    await deletaRegistro("CLATRIB", getCookie("usuario"), clatrib);
    window.location.href = `${BASE_URI}/clatrib`;
  });

  $(document).ready(function () {
    let currentFs;
    let nextFs; // fieldsets
    let opacity;

    $(".next").click(function () {
      currentFs = $(this).parent();
      nextFs = $(this).parent().next();

      $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

      nextFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;

            currentFs.css({
              display: "none",
              position: "relative",
            });
            nextFs.css({
              opacity,
            });
          },
          duration: 600,
        }
      );
    });

    $("#checkPadrao").on("click", async function () {
      if ($("#checkPadrao").prop("checked")) {
        try {
          let response = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={ "tabela":"tabtri", "camposSelect":["codigo", "padrao"], "where":[" PADRAO = 'S' AND CODIGO != '${$("#txtCodigo").val()}'"]}`,
            null
          );

          if (!response) {
            return;
          }
          let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }
          if (jsonStr.RESULT[0].length != 0) {
            $("#checkPadrao").prop("checked", false);
            msgAlerta(
              `O CST ICMS ${jsonStr.RESULT[0][0].CODIGO} já está como padrão`
            );
          }
        } catch (error) {
          console.error(error);
        }
      }
    });

    $("#msform").validate({
      debug: false,
      ignore: "",
      rules: {
        txtCodigo: {
          required: true,
        },
        txtDescricao: {
          required: true,
        },
      },
      messages: {
        txtCodigo: {
          required: "Informe um código válido.",
        },
        txtDescricao: {
          required: "Informe uma descrição válida.",
        },
      },
      errorElement: "span",
      errorPlacement(error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight(element) {
        $(element).addClass("is-invalid");
      },
      unhighlight(element) {
        $(element).removeClass("is-invalid");
      },
    });

    $(".radio-group .radio").click(function () {
      $(this).parent().find(".radio").removeClass("selected");
      $(this).addClass("selected");
    });

    $(".submit").click(function () {
      return false;
    });
  });

  if (clatrib != "" && clatrib != "create") {
    // if (await liberarRegistro('CLATRIB', clatrib) == false) {
    //     window.location.href = '../clatrib';
    // } else {

    try {
      $.LoadingOverlay("show");
      try {
        let response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela":"tabtri", 
                    "camposSelect":["codigo", "descricao", "padrao", "icms"], 
                    "where": ["codigo = '${clatrib}'"]}`,
          null
        );

        if (!response) {
          return;
        }
        let jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }

        $("#txtCodigo").val(jsonStr.RESULT[0][0].CODIGO);
        $("#txtDescricao").val(jsonStr.RESULT[0][0].DESCRICAO);

        if (jsonStr.RESULT[0][0].PADRAO == "S") {
          $("#checkPadrao").prop("checked", true);
        }

        if (jsonStr.RESULT[0][0].ICMS == 1) {
          $('#radioBaseIcms').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].ICMS == 2) {
          $('#radioIsentaIcms').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].ICMS == 3) {
          $('#radioOutraIcms').prop('checked', true);
        }
      } catch (error) {
        console.error(error);
        msgErro(`Não foi possível buscar os dados do tamanho: ${error}`);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
    // }
  }

  $("#txtCodigo").change(async function () {
    try {
      $.LoadingOverlay("show");

      try {
        let response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela":"tabtri", 
                "camposSelect":["codigo"], 
                "where": ["codigo = '${$("#txtCodigo").val()}'"]}`,
          null
        );

        if (!response) {
          return;
        }
        let jsonStr = await response.json();
        if (jsonStr.RESULT[0].length > 0) {
          msgAlerta("Classificação tributária já cadastrada.");
          $("#txtCodigo").val("");
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $("#gravar").click(async function () {
    let validator = $("#msform").validate();
    validator.form();
    let erros = 0;
    erros = validator.numberOfInvalids();

    if (erros == 0) {
      try {
        $.LoadingOverlay("show");

        let clatribClasse = {};

        clatribClasse.CODIGO = $("#txtCodigo").val();
        clatribClasse.DESCRICAO = $("#txtDescricao").val().toUpperCase();

        if ($("#checkPadrao").prop("checked")) {
          clatribClasse.PADRAO = "S";
        } else {
          clatribClasse.PADRAO = "N";
        }

        if ($('#radioBaseIcms').prop('checked')) {
          clatribClasse.ICMS = '1';
        }
        if ($('#radioIsentaIcms').prop('checked')) {
          clatribClasse.ICMS = '2';
        }
        if ($('#radioOutraIcms').prop('checked')) {
          clatribClasse.ICMS = '3';
        }

        let response = await requisicao(
          "POST",
          "/Sisplan/Cadastros/v1/clatrib?",
          `JSON=${encodeURIComponent(JSON.stringify(clatribClasse))}`,
          null
        );

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgErro(jsonStr.mensagem);
          return;
        }
        $.LoadingOverlay("hide");
        toastr
          .success("Cadastro efetuado com sucesso!", "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              window.location.href = `${BASE_URI}/clatrib`;
            },
          })
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      } catch (error) {
        console.error(error);
        $.LoadingOverlay("hide");
        msgErro(`Não foi possível gravar os dados do tamanho: ${error}`);
      }
    }
  });
});
