$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([{
            element: '#campostour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigo',
            popover: {
                title: 'Código',
                description: 'Aqui, adicionamos o código da composição.',
                position: 'top'
            }
        },
        {
            element: '#txtDescricao',
            popover: {
                title: 'Descrição',
                description: 'Aqui, adicionamos a descrição da composição.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar a composição.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let composicao = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('COMPOSICAOPRODUTO', getCookie('usuario'), composicao);
        window.location.href = `${BASE_URI}/composicaoproduto`;
    });

    $('#txtCodigo').on('blur', async function () {
        if ($(this).val() != ''){
            return
        }
        $.LoadingOverlay('show')
        try {
            const newCodigo = await RetornaProximo('CODIGO', 'CADCOMPOSI', 'CODIGO', 3)

            $(this).val(newCodigo)
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $(document).ready(function () {

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtDescricao: {
                    required: true,
                },
            },
            messages: {
                txtDescricao: {
                    required: "Informe uma descrição válida."
                },
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    if (composicao != '' && composicao != 'create') {

        if (await liberarRegistro('COMPOSICAOPRODUTO', composicao) == false) {
            window.location.href = '../composicaoproduto';
        } else {

            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"CADCOMPOSI", 
                    "camposSelect":["CODIGO", "DESCRICAO"], 
                    "where": ["CODIGO = '${composicao}'"]}`, null);

                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
                    $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados da composição: ${error}`);
                }
            } finally {
                $('#txtCodigo').attr('readonly', true);
                $.LoadingOverlay('hide');
            }
        }
    }

    $("#gravar").click(

        async function () {
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                try {
                    $.LoadingOverlay("show");

                    composicaoClasse = {};
                    
                    composicaoClasse.CODIGO = $('#txtCodigo').val()
                    composicaoClasse.DESCRICAO = $('#txtDescricao').val().toUpperCase();

                    let response = await requisicao('POST', '/Sisplan/Cadastros/v1/composicaoproduto?', `JSON=${encodeURIComponent(JSON.stringify(composicaoClasse))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro efetuado com sucesso!`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/composicaoproduto`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });

                } catch (error) {
                    console.error(error);
                    $.LoadingOverlay("hide");
                }
            }
        });
});