<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Consultar Log</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2511.11.1">
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.2511.11.1">
  <link rel="stylesheet" href="plugins/overlayScrollbars/css/OverlayScrollbars.min.css?versao=3.2511.11.1">
  <link rel="stylesheet" href="plugins/daterangepicker/daterangepicker.css?versao=3.2511.11.1">
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="stylesheet" href="dist/css/animate.min.css?versao=3.2511.11.1">
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.2511.11.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.2511.11.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.2511.11.1" />
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.2511.11.1" />
  <link rel="shortcut icon" href="favicon.ico">
  <link href="dist/css/jquery.gridly.css?versao=3.2511.11.1" rel="stylesheet" type="text/css" />
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.2511.11.1">

  <style>
    textarea:focus {
      border-color: #c2121a !important;
    }

    textarea {
      resize: none;
      font-size: 13.5px !important;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Consulta de Logs</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-6">
            </div>
            <div class="container-fluid" id="tabelalogs">
              <div class="col-sm-12 my-3">
                <button class="btn btn-success btn-sisp" id="btnFiltros"><span class="fas fa-search"></span> Filtros</button>
                <button id="btnImprimir" class="btn-sisp btn btn-danger"><i class="fas fa-print"></i> Imprimir</button>
              </div>

              <nav class="col-lg-12">
                <div class="nav nav-tabs d-flex flex-nowrap" id="nav-tab" role="tablist" style="text-decoration: none; max-width: none!important; white-space: nowrap!important; overflow-x: auto!important; overflow-y: hidden">
                  <a class="nav-link abaLink active" id="tabLogs" data-toggle="tab" href="#divLogs" role="tab" aria-controls="divLogs" aria-selected="true">Logs</a>
                  <a class="nav-link abaLink" id="tabLogAlteracao" data-toggle="tab" href="#divLogAlteracao" role="tab" aria-controls="divLogAlteracao" aria-selected="false">Log Alteração</a>
                </div>
              </nav>

              <div class="tab-content col-lg-12 row ml-0" style="min-height: 505px;" id="nav-tabContent">

                <div class="tab-pane fade show active col-lg-12" id="divLogs" role="tabpanel" aria-labelledby="tabLogs">

                  <div class="row card">
                    <div class="col-sm-12 table-responsive p-3">
                      <table id="tabelaLogs" class="table table-sm table-select table-hover" width="100%"></table>
                      <thead>
                        <tr></tr>
                      </thead>
                      <tbody>
                        <tr></tr>
                      </tbody>
                    </div>
                  </div>

                </div>

                <div class="tab-pane fade col-lg-12 px-0" id="divLogAlteracao" role="tabpanel" aria-labelledby="tabLogAlteracao">

                  <div class="card">
                    <div class="row">

                      <div class="col-9 table-responsive p-3">
                        <table id="tabelaLogAlteracao" class="table table-sm-sisp table-select table-hover" width="100%" style="white-space: nowrap;"></table>
                      </div>

                      <div class="col-3 py-3 pl-0">
                        <div class="p-2" style="max-height: 500px; overflow-y: auto;">
                          <h6>Detalhes do Log</h6>
                          <table id="tabelaDetalhesLog" class="table table-sm-sisp table-select table-hover" width="100%" style="white-space: nowrap;"></table>
                        </div>
                      </div>

                    </div>
                  </div>

                </div>

              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content" id="modalBody">
          <div class="modal-header">
            <h4 class="modal-title">Filtros</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-lg-3 col-sm-12 col-12">
                <div class="group-default form-group">
                  <label for="txtDataIni">Data Emissão:</label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataIni" name="DataDe">
                  </div>
                </div>
              </div>
              <div class="col-lg-3 col-sm-12 col-12">
                <div class="group-default form-group">
                  <label for="txtDataFim">Até:</label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="2500-12-01" class="input-default focus form-control validate" id="txtDataFim" name="DataAte">
                  </div>
                </div>
              </div>
              <div class="col-lg-6 col-sm-12 col-12" id="LogInfoTour">
                <label data-error="wrong" data-success="right" for="txtUsuario">Usuario: </label>
                <div class="input-group">
                  <input type="text" autocomplete="off" class="input-default focus form-control" id="txtUsuario" name="txtUsuario" class="form-control" placeholder="Usuario">
                </div>
              </div>
              <div class="col-12 form-group" id="EmpresaTuto">
                <label data-error="wrong" class="labelGeral" data-success="right" for="txtEmpresa">Empresa: </label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" required aria-describedby="empresaError" id="txtEmpresa" name="txtEmpresa" placeholder="Empresa" />
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btn-empresa" name="btn-empresa" data-button="absolute" type="button">
                      <i class="m-0 p-0 fas fa-search"></i>
                    </button>
                    <button class="btn bg-danger" id="btn-limpa-empresa" type="button">
                      <i class="m-0 p-0 fas fa-trash"></i>
                    </button>
                  </div>
                </div>
              </div>
              <div class="col-6 form-group" id="LogInfoTour">
                <label id="lblAcao" for="txtAcao">Ação:
                  <span id="btnInfoAcao" type="button" class="btn btn-info ml-2" style="color: white; padding: 0rem .50rem; font-size: 12px;"
                    title="Este campo faz a busca da coluna Descrição na tabela de Log">
                    <i class="fas fa-question-circle"></i>
                  </span>
                </label>

                <div class="input-group">
                  <input type="text" autocomplete="off" class="input-default focus form-control" id="txtAcao" name="txtAcao" placeholder="Ação">
                </div>
              </div>

              <div class="col-6 form-group" id="LogInfoTour">
                <label data-error="wrong" data-success="right" for="txtChave">Chave: </label>
                <div class="input-group">
                  <input type="text" autocomplete="off" class="input-default focus form-control" id="txtChave" name="txtChave" class="form-control" placeholder="Chave">
                </div>
              </div>
              <div class="col-6" id="LogInfoTour">
                <label data-error="wrong" data-success="right" for="txtTela">Tela: </label>
                <div class="input-group">
                  <input type="text" autocomplete="off" class="input-default focus form-control" id="txtTela" name="txtTela" class="form-control" placeholder="Tela">
                </div>
              </div>
              <div class="col-6" id="divForm">
                <label data-error="wrong" data-success="right" for="txtForm">Form: </label>
                <div class="input-group">
                  <input type="text" autocomplete="off" class="input-default focus form-control" id="txtForm" name="txtForm" class="form-control" placeholder="Form">
                </div>
              </div>
              <div class="col-6 d-none" id="divTabela">
                <label data-error="wrong" data-success="right" for="txtTabela">Tabela: </label>
                <div class="input-group">
                  <input type="text" autocomplete="off" class="input-default focus form-control" id="txtTabela" name="txtTabela" class="form-control" placeholder="Tabela">
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer border-top d-flex justify-content-between align-items-end">
            <div class="mx-auto mx-md-0">
              <label for="txtOrdem">Opção de Relatório:</label>
              <div class="relative d-flex align-items-center">
                <select id="txtOrdem" class="input-default focus custom-select">
                </select>
                <button class="btn btn-sm btn-success ml-2 btnEdicaoRelatorio" title="Edição de ordenações">
                  <i class="fas fa-check"></i>
                </button>
              </div>
            </div>
            <div class="mx-auto mx-md-0">
              <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>     
              <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
            </div>
          </div>
        </div>
      </div>
    </div>
    <?php
    include_once('../../modais.php');
    ?>
    <aside class="control-sidebar control-sidebar-dark">
    </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.2511.11.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.2511.11.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button)
  </script>
  <script type="text/javascript" src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2511.11.1"></script>
  <script type="text/javascript" src="plugins/chart.js/Chart.min.js?versao=3.2511.11.1"></script>
  <script type="text/javascript" src="plugins/sparklines/sparkline.js?versao=3.2511.11.1"></script>
  <script type="text/javascript" src="dist/js/sisplan.js?versao=3.2511.11.1"></script>
  <script type="text/javascript" src="utils/funcoes.js?versao=3.2511.11.1"></script>
  <script type="text/javascript" src="dist/js/adminlte.min.js?versao=3.2511.11.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.min.js?versao=3.2511.11.1"></script>
  <script type="text/javascript" src="dist/js/loadingoverlay.min.js?versao=3.2511.11.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.2511.11.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.2511.11.1"></script>
  <script type="text/javascript" src="dist/js/jquery.maskMoney.min.js?versao=3.2511.11.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.keyTable.js?versao=3.2511.11.1"></script>
  <script type="text/javascript" src="utils/cookies.js?versao=3.2511.11.1"></script>
  <script type="text/javascript" src="dist/js/requisicoes.js?versao=3.2511.11.1"></script>
  <script src="dist/js/driver.min.js?versao=3.2511.11.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.2511.11.1"></script>
  <script type="text/javascript" src="config.js?versao=3.2511.11.1"></script>
  <script src="dist/js/sql-formatter.min.js?versao=3.2511.11.1"></script>
  <script src="plugins/jquery-validation/jquery.validate.min.js?versao=3.2511.11.1"></script>
  <script src="plugins/jquery-validation/additional-methods.min.js?versao=3.2511.11.1"></script>
  <script src="dist/js/datetime.js?versao=3.2511.11.1"></script>
  <script src="plugins/moment/moment.min.js?versao=3.2511.11.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }
      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('CONSULTALOG');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/consultalog/consultalog.js?versao=3.2511.11.1`;
      insereJavaScriptPagina(sArquivo);

      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
      habilitaCamposObrigatoriosTela(nomeTela);

      $(function() {
        $('[data-toggle="tooltip"]').tooltip()
      })

    });
  </script>
</body>

</html>