$('#tutorial').on('click', () => {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnNovoTemplate',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de uma nova Cotação de Moeda.',
          position: 'right'
        }
      },
      {
        element: '#tabelaCotacoes',
        popover: {
          title: 'Tabela de Cotações de Moeda',
          description: 'Aqui estão os dados das Cotações de Moedas cadastradas.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});
$(document).ready(async function () {
  $('#btnFiltros').on('click', () => { $('#modal-filtros').modal('show') });
  $('#btnLimparFiltros').on('click', () => {
    $('#txtMoeda').val('');
    $('#txtDataIni').val('');
    $('#txtDataFim').val('');
  });

  $('#txtConsultaMoeda').autocompleta(1, `JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE chave", "DESCRICAO descricao"], "where": null}`);
  $('#btnConsultaMoeda').pesquisa('#txtConsultaMoeda', 'CODMOE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MOEDA", "camposSelect":["CODMOE", "DESCRICAO"]}`, 'Consulta Tipo Fiscal', 'MOEDA');
  $('#btnLimpaMoeda').on('click', () => { $('#txtConsultaMoeda').val('') });

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await fazConsulta();
  });

  $('#btnConsultar').trigger('click');

  function formataDataAoContrario(date, anoCompleto = true) {
    if (date == '') {
      return '';
    }

    const dateParts = date.split("-");
    const dia = dateParts[2].padStart(2, '0');
    const mes = dateParts[1].padStart(2, '0');
    const ano = anoCompleto ? dateParts[0] : dateParts[0].substring(2);

    return ano + "/" + mes + "/" + dia;
  }

  async function buscaParametros() {
    let pDtConsultaIni = formataDataAoContrario($('#txtDataIni').val(), true);
    let pDtConsultaFim = formataDataAoContrario($('#txtDataFim').val(), true);
    let pMoeda = pegaChave("#txtConsultaMoeda");


    let retorno =
      `DTCONSULTAINI=${pDtConsultaIni}` +
      `&DTCONSULTAFIM=${pDtConsultaFim}` +
      `&MOEDA=${pMoeda}`;
    return retorno;
  };

  async function fazConsulta() {
    try {
      $.LoadingOverlay("show");
      let params = await buscaParametros();
      let response = await requisicao('GET', '/sisplan/cadastros/v1/cotacaomoeda?', params, '', 15000);

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgAlerta(jsonStr.RESULT[0].mensagem);
        return;
      }

      let dataSetCols = []

      dataSetCols.push(
        {
          'title': 'Moeda',
          'data': 'MOEDA'
        },
        {
          'title': 'Desc. Moeda',
          'data': 'DESCRICAO'
        },
        {
          'title': `Valor Compra
          <span type="button" class="btn btn-info ml-2 infoValor" style="color: white;" class="infoValor" title="Para garantir a exatidão necessária em transações financeiras, os campos de valores apresentam quatro dígitos decimais após o ponto.">
            <i class="fas fa-question-circle"></i>
          </span>
          `,
          'data': 'VALOR_COMPRA'
        },
        {
          'title': `Valor Venda
          <span type="button" class="btn btn-info ml-2 infoValor" style="color: white;" class="infoValor" title="Para garantir a exatidão necessária em transações financeiras, os campos de valores apresentam quatro dígitos decimais após o ponto.">
            <i class="fas fa-question-circle"></i>
          </span>`,
          'data': 'VALOR'
        },
        {
          'title': 'Data',
          'data': 'DATA'
        },
        {
          'title': 'Data Ini.',
          'data': 'DATAINI'
        },
        {
          'title': 'Data Fin.',
          'data': 'DATAFIM'
        },
        {
          'title': 'Cotação Oficial',
          'data': 'COTACAO_OFICIAL'
        },
        {
          'title': 'Dia',
          'data': 'DIA'
        },
        {
          'title': 'Mês',
          'data': 'MES'
        },
        {
          'title': 'Ano',
          'data': 'ANO'
        }
      );

      $("#tabelaCotacoes").DataTable({
        destroy: true,
        paging: true,
        filter: true,
        info: false,
        autowidth: true,
        data: jsonStr,
        columns: dataSetCols,
        columnDefs: [
          {
            targets: [5, 6, 8, 9, 10],
            visible: false
          },
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
          {
            render(data) {
              return parseFloat(data).toLocaleString("pt-BR", {
                maximumFractionDigits: 4,
                minimumFractionDigits: 4
              });
            },
            targets: [2, 3],
          },
        ],
      });
      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }




  function retornaBotaoOpcoes(data) {
    let retorno = ''
    retorno = '<div style="text-align:start;"> ' +
      '    <button id="editaOpcoes" class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu" > ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  $('#tabelaCotacoes').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const row = $(this).closest('tr');
      const data = $('#tabelaCotacoes').DataTable().row(row).data();

      let dataOriginal = data.DATA;
      let dataFormatada = dataOriginal.split('/').join('-');

      let registroLiberado = await verificarRegistro('COTACAO_MOEDA', data.MOEDA);
      if (registroLiberado) {
        window.location.href = `cotacao_moeda/${data.MOEDA}&${dataFormatada}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaCotacoes').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const row = $(this).closest('tr');
      const data = $('#tabelaCotacoes').DataTable().row(row).data();

      let dataOriginal = data.DATA;
      let dataFormatada = dataOriginal.split('/').join('-');

      let registroLiberado = await verificarRegistro('COTACAO_MOEDA', data.MOEDA);
      if (registroLiberado) {
        window.location.href = `cotacao_moeda/${data.MOEDA}&${dataFormatada}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaCotacoes').on('click', '#btn-excluir', function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      const row = $(this).closest('tr');
      const data = $('#tabelaCotacoes').DataTable().row(row).data();

      msgAlerta(`Você realmente deseja excluir o registro?`, async function () {
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  $("#btnNovoTemplate").on("click", async function () {
    if (permissaoUsuarioLogado.INCLUI == "S") {
      window.location.href = "cotacao_moeda/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });


  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let response = await requisicao("DELETE", '/Sisplan/cadastros/V1/cotacaomoeda?', `MOEDA=${(data.MOEDA)}&DATA=${(data.DATA)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/cotacao_moeda`;
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function permissaoAcessos(tela) {
    try {
      $.LoadingOverlay("show");

      let object = new Object();
      object.resultado = true;
      object.mensagem = "";

      if (getCookie("cod_usuario") == "0000") {
        object.ALTERA = "S";
        object.CONSULTA = 'S';
        object.EXCLUI = 'S';
        object.INCLUI = 'S';
        return object;
      }

      try {
        const codusuario = `'${getCookie("cod_usuario")}'`;
        const response = await requisicao(
          "GET",
          `/Sisplan/AcessoMenu/v1/Acesso?`,
          `codusuarios=${codusuario}&telas='${tela}'`,
          null,
          60000
        );

        if (!response) {
          msgErro("Erro ao buscar permissões da tela.");
          return;
        }

        let valida = await response.json();
        if (response.status != 200) {
          console.error(valida.RESULT[0].mensagem);
          msgErro("Erro ao buscar permissões da tela.");
          return;
        }

        if (valida.length <= 0) {
          object.ALTERA = "N";
          object.CONSULTA = 'N';
          object.EXCLUI = 'N';
          object.INCLUI = 'N';
          return object;
        }

        return valida[0];
      } catch (error) {
        console.error(error);
        msgErro("Erro ao buscar permissões da tela.");
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  const permissaoUsuarioLogado = await permissaoAcessos("COTACAO_MOEDA");

});
