function validarCaracteres(value) {
    const result = value.match(/[&\/\\#,+()$~%.'":*?<>{}´`]/g);
    return result?.length ?? 0;
}

$(document).ready(async function () {
    let contaFs = 1;

    $(".next").click(function () {
        contaFs += 1;

        let validator = $("#msform").validate();
        validator.form();
        let erros = 0;
        erros = validator.numberOfInvalids();

        if (erros == 0) {
            currentFs = $(this).parent();
            nextFs = $(this).parent().next();

            $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

            nextFs.show();
            currentFs.animate(
                {
                    opacity: 0,
                },
                {
                    step(now) {
                        opacity = 1 - now;

                        currentFs.css({
                            display: "none",
                            position: "relative",
                        });
                        nextFs.css({
                            opacity,
                        });
                    },
                    duration: 600,
                }
            );
        }
    });

    $(".previous").click(function () {
        contaFs -= 1;

        currentFs = $(this).parent();
        previousFs = $(this).parent().prev();
        $("#progressbar li")
            .eq($("fieldset").index(currentFs))
            .removeClass("active");
        previousFs.show();
        currentFs.animate(
            {
                opacity: 0,
            },
            {
                step(now) {
                    opacity = 1 - now;
                    currentFs.css({
                        display: "none",
                        position: "relative",
                    });
                    previousFs.css({
                        opacity,
                    });
                },
                duration: 600,
            }
        );
    });

    if (getCookie("usuario") == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
    }

    let queryString = window.location.href;
    let parametros = queryString.split("/");
    let d = parametros[parametros.length - 1];
    let gBanco;
    let gCodigo;
    let gCarteira;
    let gId;

    if (d != 'create') {
        gBanco = d.split('-')[0];
        gCodigo = d.split('-')[1];
        gCarteira = d.split('-')[2];
        gId = d.split('-')[3];
        $('#txtCodigo').prop('disabled', true);
        $('#txtBanco').prop('disabled', true);
        $('#btnBanco').prop('disabled', true);
        $('#btnLimpaBanco').prop('disabled', true);
    }

    $('#account').on('click', function () {
        if (contaFs == 2) {
            $('#voltar2').trigger('click');
        }
    });

    $('#payment').on('click', function () {
        if (contaFs == 1) {
            $('#avancar1').trigger('click');
        }
    });

    componenteFiltro('banco', false, false);
    componenteFiltro('situacao', false, false);
    // componenteFiltro('carteira');
    $('#btnCarteira').pesquisa_serverside([`#txtCarteira`], ['CARTEIRA'], ['DESCRICAO'], '{"tabela":"CARTEIRA", "camposSelect":[ "CARTEIRA", "DESCRICAO"], "where": null}', 'Pesquisa de Carteira');
    $('#btnLimpaCarteira').on('click', () => {
        $('#txtCarteira').val('');
    });
    componenteFiltro('historico', false, false);
    componenteFiltro('classe', false, false);
    componenteFiltro('conta');
    componenteFiltro('alterarBanco', false, false);

    $('#cbAlterarBanco').on('change', function () {
        if ($('#cbAlterarBanco').prop('checked') == true) {
            $('#divAlterarBanco').removeClass('d-none');
        } else {
            $('#divAlterarBanco').addClass('d-none');
        }
    })

    await preencheDados();

    async function preencheDados() {

        try {
            $.LoadingOverlay('show');

            try {

                if (parseInt(gId) > 0) {
                    where = `["OCORRENCIA.ID = ${gId}"]`;
                } else {

                    where = `["OCORRENCIA.BANCO = '${gBanco}'", "OCORRENCIA.CODIGO = '${gCodigo}'"`;

                    if (gCarteira != '') {
                        where += `, "OCORRENCIA.CARTEIRA = '${gCarteira}'"`;
                    }
                    where += ']';
                }


                const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"OCORRENCIA",
                "camposSelect":["OCORRENCIA.ID","OCORRENCIA.SOLIC_ESTORNO", "OCORRENCIA.CODIGO", "OCORRENCIA.DESCRICAO", "OCORRENCIA.BANCO", "CADBAN.NOME_BANCO DESC_BANCO", "OCORRENCIA.INSTRUCAO",
                                "OCORRENCIA.SITUACAO", "TABSIT.DESCRICAO DESC_SITUACAO", "OCORRENCIA.CARTEIRA", "CARTEIRA.DESCRICAO DESC_CARTEIRA", "OCORRENCIA.HISTORICO",
                                "HISTCP.DESCRICAO DESC_HISTORICO", "OCORRENCIA.CLASSE", "CLASSE_GER.DESCRICAO DESC_CLASSE", "OCORRENCIA.CONTA", "CADCONTA.DESCRICAO DESC_CONTA",
                                "OCORRENCIA.TIPO", "OCORRENCIA.OPERACAO", "OCORRENCIA.BAIXA", "OCORRENCIA.LANCA", "OCORRENCIA.CAPTACAO", "OCORRENCIA.DESPESA", "OCORRENCIA.REJEITA",
                                "OCORRENCIA.MANTER_NRBANCO", "OCORRENCIA.DESPESA_COB", "OCORRENCIA.MANUT", "OCORRENCIA.ALT_VENCTO", "OCORRENCIA.GRAVA_HIST", "OCORRENCIA.OCULTA_OCORRENCIA",
                                "OCORRENCIA.VALOR_EXCEDIDO", "OCORRENCIA.VAL_EXCEDIDO_SALDO", "OCORRENCIA.LIMPA_CC", "OCORRENCIA.ALTERAR_BANCO", "OCORRENCIA.BANCO_ALT", "CADBAN2.NOME_BANCO DESC_BANCO_ALT"
                            ],
                "leftjoin": [
                            {"tabela": "CADBAN", "condicao": "OCORRENCIA.BANCO = CADBAN.BANCO"},
                            {"tabela": "TABSIT", "condicao": "OCORRENCIA.SITUACAO = TABSIT.CODIGO"},
                            {"tabela": "CARTEIRA", "condicao": "OCORRENCIA.CARTEIRA = CARTEIRA.CARTEIRA"},
                            {"tabela": "HISTCP", "condicao": "OCORRENCIA.HISTORICO = HISTCP.HISTORICO"},
                            {"tabela": "CLASSE_GER", "condicao": "OCORRENCIA.CLASSE = CLASSE_GER.CODIGO"},
                            {"tabela": "CADCONTA", "condicao": "OCORRENCIA.CONTA = CADCONTA.CONTA"},
                            {"tabela": "CADBAN", "alias": "CADBAN2", "condicao": "OCORRENCIA.BANCO_ALT = CADBAN2.BANCO"}
                ],
                "where": ${where}}`,
                )

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                const data = jsonStr.RESULT[0];

                $('#txtId').val(data[0].ID);
                $('#txtCodigo').val(data[0].CODIGO);
                $('#txtDescricao').val(data[0].DESCRICAO);
                insereValor('#txtBanco', data[0].BANCO, data[0].DESC_BANCO);
                insereValor('#txtSituacao', data[0].SITUACAO, data[0].DESC_SITUACAO);
                insereValor('#txtCarteira', data[0].CARTEIRA, data[0].DESC_CARTEIRA);
                insereValor('#txtHistorico', data[0].HISTORICO, data[0].DESC_HISTORICO);
                insereValor('#txtClasse', data[0].CLASSE, data[0].DESC_CLASSE);
                // insereValor('#txtConta', data[0].CONTA, data[0].DESC_CONTA);
                $('#txtInstrucao').val(data[0].INSTRUCAO);
                $(`input[name="radioTipo"][value="${data[0].TIPO}"]`).prop("checked", true);
                $(`input[name="radioOperacao"][value="${data[0].OPERACAO}"]`).prop("checked", true);
                $('#cbBaixaDuplicata').prop('checked', data[0].BAIXA == 'S');
                $('#cbLancaFluxoCaixa').prop('checked', data[0].LANCA == 'S');
                $('#cbCaptacaoFundos').prop('checked', data[0].CAPTACAO == 'S');
                $('#cbDespesasCartorio').prop('checked', data[0].DESPESA == 'S');
                $('#cbTituloRejeitado').prop('checked', data[0].REJEITA == 'S');
                $('#cbManterNrBanco').prop('checked', data[0].MANTER_NRBANCO == 'S');
                $('#cbDespesasCobranca').prop('checked', data[0].DESPESA_COB == 'S');
                $('#cbManutencaoTitulo').prop('checked', data[0].MANUT == 'S');
                $('#cbAlteracaoVencimento').prop('checked', data[0].ALT_VENCTO == 'S');
                $('#cbGravarHistorico').prop('checked', data[0].GRAVA_HIST == 'S');
                $('#cbOcultarOcorrencia').prop('checked', data[0].OCULTA_OCORRENCIA == 'S');
                $('#cbEstornoBanco').prop('checked', data[0].SOLIC_ESTORNO == 'S');
                $('#cbJogarJuros').prop('checked', data[0].VALOR_EXCEDIDO == 'S');
                $('#cbSaldoRestante').prop('checked', data[0].VAL_EXCEDIDO_SALDO == 'S');
                $('#cbLimpaContaCorrente').prop('checked', data[0].LIMPA_CC == 'S');
                $('#cbAlterarBanco').prop('checked', data[0].ALTERAR_BANCO == 'S');
                if (data[0].ALTERAR_BANCO == 'S') {
                    $('#cbAlterarBanco').trigger('change');
                }
                insereValor('#txtAlterarBanco', data[0].BANCO_ALT, data[0].DESC_BANCO_ALT)
            } catch (e) {
                console.log(e);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    $('#btnGravar').on('click', async function () {
        if ($('#txtBanco').val() == '') {
            msgErro('Campo banco é obrigatório, impossível continuar.');
            if (contaFs == 2) {
                $('#voltar2').trigger('click');
            }
            $('#txtBanco').focus();
            return;
        }

        if ($('#txtCodigo').val() == '') {
            msgErro('Campo código é obrigatório, impossível continuar.');
            if (contaFs == 2) {
                $('#voltar2').trigger('click');
            }
            $('#txtCodigo').focus();
            return;
        }

        await gravaDados();
    })

    async function gravaDados() {
        try {
            $.LoadingOverlay('show');
            try {
                ocorrencia = {};

                let sCarteira = d == 'create' ? pegaChave('#txtCarteira') : gCarteira;
                const carteira = (($('#txtCarteira').val() != '') && ($('#txtCarteira').val().includes('['))) ? pegaChave('#txtCarteira') : pegaValor('#txtCarteira');

                ocorrencia.ID = $('#txtId').val();
                ocorrencia.BANCO = pegaChave('#txtBanco');
                ocorrencia.CODIGO = $('#txtCodigo').val();
                ocorrencia.DESCRICAO = $('#txtDescricao').val();
                ocorrencia.SITUACAO = pegaChave('#txtSituacao');
                ocorrencia.CARTEIRA = carteira;
                ocorrencia.HISTORICO = pegaChave('#txtHistorico');
                ocorrencia.CLASSE = pegaChave('#txtClasse');
                ocorrencia.INSTRUCAO = $('#txtInstrucao').val();
                ocorrencia.BAIXA = $('#cbBaixaDuplicata').prop('checked') ? 'S' : 'N';
                ocorrencia.LANCA = $('#cbLancaFluxoCaixa').prop('checked') ? 'S' : 'N';
                ocorrencia.CAPTACAO = $('#cbCaptacaoFundos').prop('checked') ? 'S' : 'N';
                ocorrencia.DESPESA = $('#cbDespesasCartorio').prop('checked') ? 'S' : 'N';
                ocorrencia.REJEITA = $('#cbTituloRejeitado').prop('checked') ? 'S' : 'N';
                ocorrencia.MANTER_NRBANCO = $('#cbManterNrBanco').prop('checked') ? 'S' : 'N';
                ocorrencia.DESPESA_COB = $('#cbDespesasCobranca').prop('checked') ? 'S' : 'N';
                ocorrencia.MANUT = $('#cbManutencaoTitulo').prop('checked') ? 'S' : 'N';
                ocorrencia.ALT_VENCTO = $('#cbAlteracaoVencimento').prop('checked') ? 'S' : 'N';
                ocorrencia.GRAVA_HIST = $('#cbGravarHistorico').prop('checked') ? 'S' : 'N';
                ocorrencia.OCULTA_OCORRENCIA = $('#cbOcultarOcorrencia').prop('checked') ? 'S' : 'N';
                ocorrencia.VALOR_EXCEDIDO = $('#cbJogarJuros').prop('checked') ? 'S' : 'N';
                ocorrencia.TIPO = $('input[name="radioTipo"]:checked').val();
                ocorrencia.OPERACAO = $('input[name="radioOperacao"]:checked').val();
                // ocorrencia.CONTA = pegaChave('#txtConta');
                ocorrencia.ALTERAR_BANCO = $('#cbAlterarBanco').prop('checked') ? 'S' : 'N';
                ocorrencia.SOLIC_ESTORNO = $('#cbEstornoBanco').prop('checked') ? 'S' : 'N';
                ocorrencia.BANCO_ALT = $('#cbAlterarBanco').prop('checked') ? pegaChave('#txtAlterarBanco') : '';
                ocorrencia.VAL_EXCEDIDO_SALDO = $('#cbSaldoRestante').prop('checked') ? 'S' : 'N';
                ocorrencia.LIMPA_CC = $('#cbLimpaContaCorrente').prop('checked') ? 'S' : 'N';
                ocorrencia.CATEIRA_ORIG = sCarteira;
                ocorrencia.INCLUSAO = d == 'create' ? 'S' : 'N';

                let response = await requisicao("POST", `/Sisplan/Cadastros/V1/escocorrencia?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`, `JSON=${encodeURIComponent(JSON.stringify(ocorrencia))}`);

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgAlerta(jsonStr.mensagem);
                    return;
                }

                toastr.success("Dados gravados com sucesso!", "Confirmação", {
                    toastClass: "alert",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.href = `${BASE_URI}/escocorrencia`;
                    },
                })
                    .css({
                        "margin-top": "20%",
                        width: "500px",
                        "max-width": "500px",
                    });

            } catch (e) {
                console.log(e);
            }
        } finally {
            $.LoadingOverlay('hide');
        }

    }

    $('#voltar1').on('click', function () {
        msgAlerta('Tem certeza que deseja cancelar as alterações?', () => {
            window.location.href = `${BASE_URI}/escocorrencia`
        })
    })

    $("#tutorial").on("click", function () {
        $(document).ready(async function () {
            const driver = new Driver({
                doneBtnText: "Sair",
                closeBtnText: "Fechar",
                nextBtnText: "Próximo",
                prevBtnText: "Anterior",
                allowClose: false,
                animate: true,
                onNext: (Element) => {
                    if ((Element.node.id == 'avancar1')) {
                        $('#avancar1').trigger('click');
                    };
                },
                onPrevious: (Element) => {
                    if (Element.node.id == 'fieldset2') {
                        $('#voltar2').trigger('click');
                    }
                }
            });

            driver.defineSteps([
                {
                    element: "#fieldset1",
                    popover: {
                        title: "Dados",
                        description:
                            "Aqui você informa os dados da ocorrência.",
                        position: "right",
                    },
                },
                {
                    element: "#voltar1",
                    popover: {
                        title: "Botão Voltar",
                        description:
                            "Clique neste botão para voltar para a tela de acesso.",
                        position: "right",
                    },
                },
                {
                    element: "#avancar1",
                    popover: {
                        title: "Botão Gravar",
                        description: "Clique neste botão para avançar para a aba Configuração.",
                        position: "top",
                    },
                },
                {
                    element: "#fieldset2",
                    popover: {
                        title: "Configuração",
                        description: "Aqui você realiza a configuração da ocorrência.",
                        position: "top",
                    },
                },
                {
                    element: "#voltar2",
                    popover: {
                        title: "Configuração",
                        description: "Clique neste botão para voltar para a aba Geral.",
                        position: "top",
                    },
                },
                {
                    element: "#btnGravar",
                    popover: {
                        title: "Configuração",
                        description: "Clique neste botão para gravar os dados.",
                        position: "top",
                    },
                },
            ]);
            driver.start();
        });
    });

});