$(document).ready(async function () {

    const produtoCodigo = await retornaCodigoProdutoUrl();
    const produtoDescricao = await retornaDescricaoProduto();
    let ultimaRowFocus = -1;

    $('#titleProduto').html(`Produto [${produtoCodigo}] - ${produtoDescricao}`);

    $('#btnConsultar').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            $('#tabelaItensProd').DataTable().clear().draw(false);

            const url = '/sisplan/proditensest/v1/consultaitensestprod?';
            const filtros = await retornaFiltros();
            const response = await requisicao('GET', url, filtros, '', 360000);

            const jsonStr = await response.json();

            if (jsonStr.length <= 0) {
                msgAlerta('Nenhum registro encontrado.');
                return
            }

            let antigoValor = '';

            for (const rowKey in jsonStr) {
                const newRow = $('#tabelaItensProd').DataTable().row.add(jsonStr[rowKey]).draw(false);

                const celulasEditaveis = [6, 7];

                celulasEditaveis.forEach((index) => {
                    const td = $($(newRow.node()).children()[index])[0];

                    const originalText = (td.textContent || '').trim();
                    td.textContent = '';

                    const divEdit = document.createElement('div');
                    divEdit.contentEditable = true;
                    divEdit.className = 'editableDiv';
                    divEdit.textContent = originalText;

                    td.appendChild(divEdit);

                    aplicaEvento(divEdit, 'focus', (event) => {
                        antigoValor = event.target.textContent;
                        event.target.textContent = '';
                    });

                    aplicaEvento(divEdit, 'blur', (event) => {
                        if (event.target.textContent === '' && antigoValor !== '') {
                            event.target.textContent = antigoValor;
                            antigoValor = '';
                            return;
                        }
                    });

                    aplicaEvento(divEdit, 'input', (event) => {
                        let input = event.target.textContent || '';
                        input = input.replace(/[^0-9]/g, '').replace(/^0+/, '');

                        if (input.length > 2) {
                            let integerPart = input.slice(0, -2);
                            let decimalPart = input.slice(-2);
                            event.target.textContent = (integerPart || '0') + '.' + decimalPart;
                        } else if (input.length > 0) {
                            event.target.textContent = '0.' + input.padStart(2, '0');
                        } else {
                            event.target.textContent = '';
                        }

                        const range = document.createRange();
                        const sel = window.getSelection();
                        range.selectNodeContents(event.target);
                        range.collapse(false);
                        sel.removeAllRanges();
                        sel.addRange(range);
                    });
                });
            }

            $('.editableDiv').addClass('input-default btn-sisp');

            setTimeout(() => { $('#tabelaItensProd').DataTable().columns.adjust().draw(false); }, 200)
        } catch (error) {
            console.error(error);
            msgErro('Ocorreu um erro ao consultar! Erro: ' + error.message);
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#btnGravar').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            const arrayRegs = [];
            const tb = $('#tabelaItensProd').DataTable();
            const rows = $('#tabelaItensProd tbody tr');

            for (let i = 0; i < rows.length; i++) {
                const row = $(rows[i]);
                const data = tb.row(i).data();

                const qtdMin = row.find('td').eq(6).find('.editableDiv').text().trim();
                const qtdMax = row.find('td').eq(7).find('.editableDiv').text().trim();

                const obj = {
                    CODIGO: produtoCodigo,
                    COR: data.COR,
                    TAM: data.TAM,
                    DEPOSITO: data.DEPOSITO,
                    EST_MIN: qtdMin,
                    EST_MAX: qtdMax
                };

                arrayRegs.push(obj);
            }

            const url = '/sisplan/proditensest/v1/atualizaitensestprod?';
            const response = await requisicao(
                'PUT',
                url,
                '',
                `LISTAITENSPROD=${encodeURIComponent(JSON.stringify({ LISTAITENSPRODEST: arrayRegs }))}`,
                360000
            );

            if (response.status == 200) {
                criaMensagemSucesso(
                    `Dados do produto [${produtoCodigo}] - ${produtoDescricao} atualizados com sucesso!`,
                    () => { window.location.reload(true) }
                );
                return;
            }

            if (response.status != 200) {
                const jsonStr = await response.json();
                msgErro('Não foi possível atualizar os dados desse produto! Verifique. Erro: ' + jsonStr.mensagem);
                return;
            }
        } catch (error) {
            console.error(error);
            msgErro('Ocorreu um erro ao gravar! Erro: ' + error.message);
        } finally {
            $.LoadingOverlay('hide');
        }
    });


    document.addEventListener('keydown', (event) => {
        if (event.key === 'Enter') {
            event.preventDefault();
        };
    });

    async function retornaCodigoProdutoUrl() {
        const queryString = window.location.href;
        const parametros = queryString.split('/');
        const produtoUrl = atob(parametros[parametros.length - 1]);

        return produtoUrl;
    };

    async function retornaDescricaoProduto() {
        const pesquisaDescricaoProduto = {
            tabela: 'PRODUTO',
            camposSelect: ['DESCRICAO'],
            where: [`CODIGO = '${produtoCodigo}'`]
        }

        const jsonDescricaoProduto = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaDescricaoProduto));

        if (jsonDescricaoProduto.length == 0) {
            return;
        };

        return jsonDescricaoProduto[0].DESCRICAO;
    };

    function aplicaEvento(element, evento, callback) {
        element.addEventListener(evento, callback);
    };

    async function retornaFiltros() {
        const somenteComEstoque = $('#checkSomenteCEstoque').is(':checked') ? 'S' : 'N';
        const depositos = await formataListas($('#txtDeposito').val().toString());
        const cores = await formataListas($('#txtCor').val().toString());
        const tamanhos = await formataListas($('#txtTamanho').val().toString());

        return `SOMENTE_COM_ESTOQUE=${somenteComEstoque}&DEPOSITOS=${depositos}&CORES=${cores}&TAMANHO=${tamanhos}&CODIGO=${produtoCodigo}`;
    }

    function criaDataTableAoAbrirATela() {
        $('#tabelaItensProd').DataTable({
            destroy: true,
            ordering: false,
            pageLength: 10,
            lengthChange: false,
            serverside: false,
            searching: false,
            paging: false,
            scrollY: '400px',
            scrollX: true,
            scrollCollapse: true,
            autoWidth: false,
            columns: [
                {
                    "data": "COR",
                    "title": "Cor",
                },
                {
                    "data": "DESC_COR",
                    "title": "Desc. Cor",
                },
                {
                    "data": "TAM",
                    "title": "Tamanho",
                },
                {
                    "data": "DEPOSITO",
                    "title": "Depósito",
                },
                {
                    "data": "DESC_DEPOSITO",
                    "title": "Desc. Depósito",
                },
                {
                    "data": "QUANTIDADE",
                    "title": "Quantidade",
                },
                {
                    "data": "QTDE_EST_MIN",
                    "title": `Est. Mín.<i class="fas fa-check ml-1 mt-1" id="checkAtualizaQtdeMin" title="Aplicar valor para todos(somente o primeiro valor para os demais)" style="color: #32CD32; font-size: 1.0em"/>`,
                },
                {
                    "data": "QTDE_EST_MAX",
                    "title": `Est. Máx.<i class="fas fa-check ml-1 mt-1" id="checkAtualizaQtdeMax" title="Aplicar valor para todos(somente o primeiro valor para os demais)" style="color: #32CD32; font-size: 1.0em"/>`,
                },
            ],
            columnDefs: [
                {
                    targets: [5, 6, 7],
                    className: 'text-right',
                    width: '100px'
                }
            ],
        });

        $('#checkAtualizaQtdeMin').on('click', async function () {
            await atualizaTodosRegistros(6);
        });

        $('#checkAtualizaQtdeMax').on('click', async function () {
            await atualizaTodosRegistros(7);
        });

        $('#tabelaItensProd').on('focus', 'td', function () {
            const row = $(this).closest('tr');
            ultimaRowFocus = row.index();
        });
    };

    function criaPesquisas() {
        
        componenteFiltro('depositoUsuario', true, true, 'Deposito', );
        componenteFiltro('cor', true, true, 'Cor', [`COR IN (SELECT DISTINCT COR FROM [PA_ITEN] WHERE CODIGO = '${produtoCodigo}')`]);
        componenteFiltro('tamanho', true, true, 'Tamanho', [`TAM IN (SELECT DISTINCT TAM FROM [PA_ITEN] WHERE CODIGO = '${produtoCodigo}')`]);
    };

    async function atualizaTodosRegistros(indice) {
        if (ultimaRowFocus === 0) {
            msgAguardaConfirmacao('Deseja inserir esse valor para todos os registros?', () => {
                const tb = $('#tabelaItensProd').DataTable();
                const tbRecordCount = tb.data().toArray().length;
                const primeiroTd = $($('#tabelaItensProd tbody tr')[0]).children()[indice];
                const valorPrimeiroTd = $(primeiroTd).find('.editableDiv').text();

                for (let i = 0; i < tbRecordCount; i++) {
                    const td = $($('#tabelaItensProd tbody tr')[i]).children()[indice];
                    const editable = $(td).find('.editableDiv');

                    if (editable.length > 0) {
                        editable.text(valorPrimeiroTd);
                    } else {
                        $(td).text(valorPrimeiroTd);
                    }
                }
            }, () => { });
        }
    }


    criaDataTableAoAbrirATela();
    criaPesquisas();
});