async function avancarPag() {

	$("#txtDescricao").val(' ');
	$("#txtPrioridade").val(0);
	$("#txtOperacaoFiscal").val(' ');

	currentFs = $(this).parent();
	nextFs = $(this).parent().next();

	$("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

	nextFs.show();
	currentFs.animate({
		opacity: 0
	}, {
		step(now) {
			opacity = 1 - now;

			currentFs.css({
				'display': 'none',
				'position': 'relative'
			});
			nextFs.css({
				'opacity': opacity
			});
		},
		duration: 600
	});
}

$('#tutorial').on('click', function () {
	$(document).ready(async function () {
		const driver = new Driver({
			doneBtnText: 'Sair',
			closeBtnText: 'Fechar',
			nextBtnText: 'Próximo',
			prevBtnText: 'Anterior',
			allowClose: false,
			animate: true,
			onNext: (Element) => {
				if ((Element.node.id == 'avancar1')) {
					avancarPag();
					$('#avancar1').trigger('click');
				};
				if ((Element.node.id == 'avancar2')) {
					$('#avancar2').trigger('click');
				}
			},
			onPrevious: (Element) => {
				if (Element.node.id == 'tourcamposcomparacao') {
					$('#voltar').trigger('click');
				};
				if (Element.node.id == 'campostouralteracao') {
					$('#voltar2').trigger('click');
				}
			}
		});

		driver.defineSteps([{
			element: '#formcard1',
			popover: {
				title: 'Dados Gerais',
				description: 'Aqui estão os campos disponíveis para o cadastro.',
				position: 'top'
			}
		},
		{
			element: '#txtCodigo',
			popover: {
				title: 'Campos Obrigatórios',
				description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
				position: 'top'
			}
		},
		{
			element: '#txtDescricao',
			popover: {
				title: 'Campos Obrigatórios',
				description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
				position: 'top'
			}
		},
		{
			element: '#txtPrioridade',
			popover: {
				title: 'Campos Obrigatórios',
				description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
				position: 'top'
			}
		},
		{
			element: '#txtOperacaoFiscal',
			popover: {
				title: 'Campos Obrigatórios',
				description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
				position: 'top'
			}
		},
		{
			element: '#btnVoltar',
			popover: {
				title: 'Botão Voltar',
				description: 'Clique aqui para voltar para a tela de consulta.',
				position: 'left'
			}
		},
		{
			element: '#avancar1',
			popover: {
				title: 'Botão Avançar',
				description: 'Clique aqui para ir para a próxima aba.',
				position: 'left'
			}
		},
		{
			element: '#tourcamposcomparacao',
			popover: {
				title: 'Campos de comparação',
				description: 'Aqui estão os campos de comparação da redução.',
				position: 'top'
			}
		},
		{
			element: '#avancar2',
			popover: {
				title: 'Botão Avançar',
				description: 'Clique aqui para ir para a próxima aba.',
				position: 'left'
			}
		},
		{
			element: '#campostouralteracao',
			popover: {
				title: 'Dados de Alteração',
				description: 'Aqui estão os dados que serão alterados na redução.',
				position: 'top'
			}
		},
		{
			element: '#btnGravar',
			popover: {
				title: 'Botão Gravar',
				description: 'Clique aqui para gravar a redução.',
				position: 'left'
			}
		}
		]);
		driver.start();
	});
});

$(document).ready(async function () {

	let contaFs = 1;

	$(document).ready(function () {

		$('#txtReducaoMVA').maskMoney({
			decimal: '.',
			thousands: '',
			precision: 4
		});
		$('#txtAliqInternaUF').maskMoney({
			decimal: '.',
			thousands: '',
			precision: 2
		});
		$('#txtAliquotaICMS').maskMoney({
			decimal: '.',
			thousands: '',
			precision: 2
		});
		$('#txtPercFCP').maskMoney({
			decimal: '.',
			thousands: '',
			precision: 2
		});
		$('#txtCredPresumido').maskMoney({
			decimal: '.',
			thousands: '',
			precision: 2
		});
		$('#txtPercEfetivo').maskMoney({
			decimal: '.',
			thousands: '',
			precision: 2
		});
		$('#txtPercRedBase').maskMoney({
			decimal: '.',
			thousands: '',
			precision: 2
		});
		$('#txtAliquotaIPI').maskMoney({
			decimal: '.',
			thousands: '',
			precision: 2
		});
		$('#txtAliquotaPIS').maskMoney({
			decimal: '.',
			thousands: '',
			precision: 2
		});
		$('#txtAliquotaCOFINS').maskMoney({
			decimal: '.',
			thousands: '',
			precision: 2
		});
		$('#txtAliquotaIVA').maskMoney({
			decimal: '.',
			thousands: '',
			precision: 2
		});
		$('#txtPercIsentoIva').maskMoney({
			decimal: '.',
			thousands: '',
			precision: 2
		});
		$('.maskDescimais').maskMoney({
			decimal: '.',
			thousands: '',
			precision: 2
		});

		let currentFs; let nextFs; let previousFs; // fieldsets
		let opacity;

		$(".next").click(function () {

			contaFs += 1;

			let validator = $("#msform").validate();
			validator.form();
			let erros = 0;
			erros = validator.numberOfInvalids();

			if (erros == 0) {

				currentFs = $(this).parent();
				nextFs = $(this).parent().next();

				$("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

				nextFs.show();
				currentFs.animate({
					opacity: 0
				}, {
					step(now) {
						opacity = 1 - now;

						currentFs.css({
							'display': 'none',
							'position': 'relative'
						});
						nextFs.css({
							'opacity': opacity
						});
					},
					duration: 600
				});
			}
		});

		$('#msform').validate({
			debug: false,
			ignore: "",
			rules: {

				txtDescricao: {
					required: true,
				},
				txtPrioridade: {
					required: true,
				},
				txtOperacaoFiscal: {
					required: true,
				}
			},
			messages: {

				txtDescricao: {
					required: "Informe uma descrição válida."
				},
				txtPrioridade: {
					required: "Informe uma prioridade válida."
				},
				txtOperacaoFiscal: {
					required: "Informe uma operação válida."
				}

			},
			errorElement: 'span',
			errorPlacement(error, element) {
				error.addClass('invalid-feedback');
				element.closest('.form-group').append(error);
			},
			highlight(element) {
				$(element).addClass('is-invalid');
			},
			unhighlight(element) {
				$(element).removeClass('is-invalid');
			}
		});


		$(".previous").click(function () {

			contaFs -= 1;

			currentFs = $(this).parent();
			previousFs = $(this).parent().prev();
			$("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");
			previousFs.show();
			currentFs.animate({
				opacity: 0
			}, {
				step(now) {
					opacity = 1 - now;
					currentFs.css({
						'display': 'none',
						'position': 'relative'
					});
					previousFs.css({
						'opacity': opacity
					});
				},
				duration: 600
			});
		});

		$('.radio-group .radio').click(function () {
			$(this).parent().find('.radio').removeClass('selected');
			$(this).addClass('selected');
		});

		$(".submit").click(function () {
			return false;
		});
	});

	$("#txtPercReducaoCST").maskMoney({
		decimal: ".",
		thousands: "",
		precision: 4,
	});

	$("#txtPercIcmsDif").maskMoney({
		decimal: ".",
		thousands: "",
		precision: 2,
	});

	$("#txtPercCredPres").maskMoney({
		decimal: ".",
		thousands: "",
		precision: 2,
	});

	$('#tabelaEmpresa').DataTable({
		paging: false,
		filter: false,
		info: false,
		order: true,
		destroy: true,
		scrollX: true,
		scrollY: '200px',
	});

	await preencheEmpresas();

	$('#txtCodigo').prop('disabled', true);

	const sWhereOperFiscal = await retornaWhereOperFiscalUsuario(getCookie('cod_usuario'));
	$('#txtOperacaoFiscal').autocompleta(1, `JSON={ "tabela":"OPER_FISCAL", "camposSelect":[ "codigo chave", "descricao descricao"], "where": ${sWhereOperFiscal}}`);
	$('#btnOperacaoFiscal').pesquisa('#txtOperacaoFiscal', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ 
            "tabela":"OPER_FISCAL", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ${sWhereOperFiscal}}`, 'Pesquisa Operação Fiscal', 'OPER_FISCAL');
	$('#btnAOperacaoFiscal').on('click', function () {
		$('#txtOperacaoFiscal').val('');
	});

	$('#txtNaturezaICMS').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":[ "natureza chave", "descricao descricao"], "where": null}`);
	$('#btnNaturezaICMS').pesquisa('#txtNaturezaICMS', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ 
            "tabela":"natureza", "camposSelect":[ "NATUREZA", "DESCRICAO"]}`, 'Pesquisa Natureza', 'natureza');
	$('#btnANaturezaICMS').on('click', function () {
		$('#txtNaturezaICMS').val('');
	});

	$('#txtContabilizacao').autocompleta(1, `JSON={ "tabela":"NAT_CONTA", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null, "groupBy": ["CODIGO", "DESCRICAO"]}`);
	$('#btnContabilizacao').pesquisa('#txtContabilizacao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ 
            "tabela":"NAT_CONTA", "camposSelect":[ "CODIGO", "DESCRICAO"], "groupBy": ["CODIGO", "DESCRICAO"]}`, 'Pesquisa Contabilização', 'NAT_CONTA');
	$('#btnAContabilizacao').on('click', function () {
		$('#txtContabilizacao').val('');
	});

	$('#txtClatribICMS').autocompleta(1, `JSON={ "tabela":"tabtri", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
	$('#btnClatribICMS').pesquisa('#txtClatribICMS', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ 
            "tabela":"tabtri", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classificação Tributária', 'tabtri');
	$('#btnAClatribICMS').on('click', function () {
		$('#txtClatribICMS').val('');
	});

	$('#txtCsosnICMS').autocompleta(1, `JSON={ "tabela":"tabcsosn", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
	$('#btnCsosnICMS').pesquisa('#txtCsosnICMS', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ 
            "tabela":"tabcsosn", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa CSOSN', 'tabcsosn');
	$('#btnACsosnICMS').on('click', function () {
		$('#txtCsosnICMS').val('');
	});

	$('#txtCstIpi').autocompleta(1, `JSON={ "tabela":"tabipi", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
	$('#btnCstIpi').pesquisa('#txtCstIpi', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ 
            "tabela":"tabipi", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa CST IPI', 'tabipi');
	$('#btnACstIpi').on('click', function () {
		$('#txtCstIpi').val('');
	});

	$('#txtEnquadraIPI').autocompleta(1, `JSON={ "tabela":"enquadra", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
	$('#btnEnquadraIPI').pesquisa('#txtEnquadraIPI', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ 
            "tabela":"enquadra", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Enquadramento IPI', 'enquadra');
	$('#btnAEnquadraIPI').on('click', function () {
		$('#txtEnquadraIPI').val('');
	});

	$('#txtCstPIS').autocompleta(1, `JSON={ "tabela":"tabpis", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
	$('#btnCstPIS').pesquisa('#txtCstPIS', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ 
            "tabela":"tabpis", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa CST PIS', 'tabpis');
	$('#btnACstPIS').on('click', function () {
		$('#txtCstPIS').val('');
	});

	$('#txtCstCOFINS').autocompleta(1, `JSON={ "tabela":"tabcofins", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
	$('#btnCstCOFINS').pesquisa('#txtCstCOFINS', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ 
            "tabela":"tabcofins", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa CST COFINS', 'tabcofins');
	$('#btnACstCOFINS').on('click', function () {
		$('#txtCstCOFINS').val('');
	});

	$('#txtIdIbsCbs').autocompleta(1, `JSON={ "tabela":"tributacao", "camposSelect":[ "ID chave", "DESC_IBSCBS descricao"], "where": null}`);
	$('#btnIdIbsCbs').pesquisa('#txtIdIbsCbs', 'ID', 'DESC_IBSCBS', `/sisplan/funcoes/v1/pesquisa?JSON={ 
            "tabela":"tributacao", "camposSelect":[ "ID", "DESC_IBSCBS"]}`, 'Pesquisa Tributação', 'tributacao');
	$('#btnAIdIbsCbs').on('click', function () {
		$('#txtIdIbsCbs').val('');
	});

	$('#tabelaEmpresa').on('click', 'td', function () {
		selecionarLinhaTabela('#tabelaEmpresa', 'checkEmpresa', this);
	});

	$('#txtIdIbsCbs').on('blur', async function () {
		const id = pegaChave('#txtIdIbsCbs');

		if (id == '') {
			return;
		}

		await buscaDadosTrib(id);
	});

	async function buscaDadosTrib(id) {
		const objPesquisa = {
			tabela: "tributacao",
			camposSelect: [
				"cst_ibscbs", "desc_ibscbs", "classtrib", "desc_classtrib", "perc_red_ibs", "perc_red_cbs"
			],
			where: [`id = ${id}`],
		};

		const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(objPesquisa));

		if (jsonStr.length == 0) {
			return;
		}

		insereValor('#txtCSTIBSCBS', jsonStr[0].CST_IBSCBS);
		insereValor('#txtDESCCSTIBSCBS', jsonStr[0].DESC_IBSCBS);
		insereValor('#txtACSTCLASSTRIB', jsonStr[0].CLASSTRIB);
		insereValor('#txtADESCCLASSTRIB', jsonStr[0].DESC_CLASSTRIB);
		insereValor('#txtRedAliqIbs', jsonStr[0].PERC_RED_IBS);
		insereValor('#txtRedAliqCbs', jsonStr[0].PERC_RED_CBS);
	};

	async function preencheEmpresas() {
		const dataSet = await RetornaEmpresas();
		for (let i = 0; i < dataSet.length; i++) {
			const empresa = dataSet[i];
			$('#tabelaEmpresa').DataTable().row.add([botaoSelecionarGrid(), `${empresa.EMP_ID} - ${empresa.EMP_NOME}`, empresa.EMP_FANTASIA]).draw(false);
		}

		$('#tabelaEmpresa').DataTable().columns.adjust().draw(false)
	};

	function botaoSelecionarGrid() {
		return '<div class="form-check">' +
			'<input type="checkbox" class="align-self-center checkEmpresa" value"">' +
			'</div>';
	};

	async function RetornaEmpresas() {
		const _url = `/sisplan/funcoes/v1/pesquisa?`;
		const _params = `JSON={"tabela":"empresa", "camposSelect":[ "emp_id", "emp_nome", "emp_fantasia"], "where": null}`;

		try {
			const response = await requisicao('GET', _url, _params, null);

			if (!response) {
				return '';
			}

			const jsonStr = await response.json();
			if (response.status != 200) {
				msgErro(jsonStr.RESULT[0].mensagem);
				return '';
			}

			return jsonStr.RESULT[0];

		} catch (error) {
			console.error(error);
		}
	};

	async function BuscaTipoOperacao() {
		let codigo = pegaChave('#txtOperacaoFiscal');
		let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
			`JSON={ "tabela":"oper_fiscal", 
        "camposSelect":["TIPO"], 
        "where": ["CODIGO = '${codigo}'"]}`, null);
		if (!response) {
			return;
		}

		let jsonStr = await response.json();
		if (response.status != 200) {
			msgErro(jsonStr.RESULT[0].mensagem);
			return;
		}

		if (jsonStr.RESULT[0][0].TIPO == 'E') {
			$("#btnCFOP").show();
		}
		else {
			$("#btnCFOP").hide();
		}
	};

	$('#txtOperacaoFiscal').blur(async function () {
		if ($('#txtOperacaoFiscal').val() != '') {
			await BuscaTipoOperacao();
		}
	});

	$('#btnEstados').on('click', function () {
		$('#modalEstados').modal('show');
	});
	$('#btnConfirmarEstados').on('click', function () {
		$('#modalEstados').modal('hide');
	});

	$('#btnEntidade').on('click', function () {
		$('#modalEntidade').modal('show');
	});
	$('#btnConfirmarEntidade').on('click', function () {
		$('#modalEntidade').modal('hide');
	});

	$('#btnOrigem').on('click', function () {
		$('#modalOrigem').modal('show');
	});
	$('#btnConfirmarOrigem').on('click', function () {
		$('#modalOrigem').modal('hide');
	});

	$('#btnPresenca').on('click', function () {
		$('#modalPresenca').modal('show');
	});
	$('#btnConfirmarPresenca').on('click', function () {
		$('#modalPresenca').modal('hide');
	});

	$('#btnIndIE').on('click', function () {
		$('#modalIndIE').modal('show');
	});
	$('#btnConfirmarIndIE').on('click', function () {
		$('#modalIndIE').modal('hide');
	});

	$('#btnCFOP').on('click', function () {
		$('#modalCFOP').modal('show');
	});
	$('#btnConfirmarCFOP').on('click', function () {
		$('#modalCFOP').modal('hide');
	});

	$('#btnModelo').on('click', function () {
		$('#modalModelo').modal('show');
	});
	$('#btnConfirmarModelo').on('click', function () {
		$('#modalModelo').modal('hide');
	});

	$('#btnCodSPED').on('click', function () {
		$('#modalCodSPED').modal('show');
	});
	$('#btnConfirmarCodSPED').on('click', function () {
		$('#modalCodSPED').modal('hide');
	});
	$('#modalCodSPED').on('shown.bs.modal', function () {
		$('#tabelaCodSPED').DataTable().columns.adjust().draw(false);
	});

	$('#btnEntidAux').on('click', function () {
		$('#modalEntidAux').modal('show');
	});
	$('#btnConfirmarEntidAux').on('click', function () {
		$('#modalEntidAux').modal('hide');
	});
	$('#modalEntidAux').on('shown.bs.modal', function () {
		$('#tabelaEntidAux').DataTable().columns.adjust().draw(false);
	});

	$('#modalCFOP').on('shown.bs.modal', function () {
		$('#tabelaCFOP').DataTable().columns.adjust().draw(false);
	});

	$('#modalModelo').on('shown.bs.modal', function () {
		$('#tabelaModelo').DataTable().columns.adjust().draw(false);
	});

	$('#btnNCM').on('click', function () {
		$('#modalNCM').modal('show');
	});
	$('#btnConfirmarNCM').on('click', function () {
		$('#modalNCM').modal('hide');
	});

	$('#modalNCM').on('shown.bs.modal', function () {
		$('#tabelaNCM').DataTable().columns.adjust().draw(false);
	});

	$('#txtCFOP').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":[ "natureza chave", "descricao descricao"], "where": null}`);
	$('#btnbuscaCFOP').pesquisa('#txtCFOP', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ 
            "tabela":"natureza", "camposSelect":[ "NATUREZA", "DESCRICAO"]}`, 'Pesquisa Natureza', 'natureza');
	$('#btnACFOP').on('click', function () {
		$('#txtCFOP').val('');
	});

	$('#txtModelo').autocompleta(1, `JSON={ "tabela":"MODELO", "camposSelect":[ "CODIGO chave", "DESCRICAO descricao"], "where": null}`);
	$('#btnbuscaModelo').pesquisa('#txtModelo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ 
            "tabela":"MODELO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Modelo', 'MODELO');
	$('#btnAModelo').on('click', function () {
		$('#txtModelo').val('');
	});

	$('#txtCodSPED').autocompleta(1, `JSON={ "tabela":"TABSPED", "camposSelect":[ "CODIGO chave", "DESCRICAO descricao"], "where": null}`);
	$('#btnbuscaCodSPED').pesquisa('#txtCodSPED', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ 
            "tabela":"TABSPED", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa TABSPED', 'TABSPED');
	$('#btnACodSPED').on('click', function () {
		$('#txtCodSPED').val('');
	});

	$('#txtEntidAux').autocompleta(1, `JSON={ "tabela":"ENTID_AUX", "camposSelect":[ "CODIGO chave", "DESCRICAO descricao"], "where": null}`);
	$('#btnbuscaEntidAux').pesquisa('#txtEntidAux', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ 
            "tabela":"ENTID_AUX", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa ENTID_AUX', 'ENTID_AUX');
	$('#btnAEntidAux').on('click', function () {
		$('#txtEntidAux').val('');
	});

	$('#tabelaCFOP').DataTable({
		paging: false,
		filter: false,
		info: false,
		ordering: true,
		destroy: true,
		scrollY: "215px",
		autowidth: false,
	});

	$('#btnAdicionarCFOP').click(async function () {
		addCFOP();
	});

	async function addCFOP() {
		if ($('#txtCFOP').val() == '') {
			msgAlerta('Preencha o campo para adicionar uma CFOP.');

		} else {
			let cfopCodigo = pegaChave('#txtCFOP');
			let cfopDesc = pegaDescricao('#txtCFOP');
			$('#tabelaCFOP').DataTable().row.add([cfopCodigo, cfopDesc,
				'<div style="text-align:center;"> ' +
				'   <button class="btn btn-info btn-sm" id="btnExluirCFOP" type="button"> ' +
				'      Excluir' +
				'   </button> ' +
				'</div>'
			]).draw(false);
			$('#txtCFOP').val('');
		}
	};

	$('#tabelaCFOP').on('click', '#btnExluirCFOP', async function () {
		let table = $('#tabelaCFOP').DataTable();
		table
			.row($(this).parents('tr'))
			.remove()
			.draw(false);
	});

	$('#tabelaModelo').DataTable({
		paging: false,
		filter: false,
		info: false,
		ordering: true,
		destroy: true,
		scrollY: "215px",
		autowidth: false,
	});

	$('#btnAdicionarModelo').click(async function () {
		addModelo();
	});

	async function addModelo() {
		if ($('#txtModelo').val() == '') {
			msgAlerta('Preencha o campo para adicionar uma Modelo.');

		} else {
			let codModelo = pegaChave('#txtModelo');
			let descModelo = pegaDescricao('#txtModelo');
			$('#tabelaModelo').DataTable().row.add([codModelo, descModelo,
				'<div style="text-align:center;"> ' +
				'   <button class="btn btn-info btn-sm" id="btnExluirModelo" type="button"> ' +
				'      Excluir' +
				'   </button> ' +
				'</div>'
			]).draw(false);
			$('#txtModelo').val('');
		}
	};

	$('#tabelaModelo').on('click', '#btnExluirModelo', async function () {
		let table = $('#tabelaModelo').DataTable();
		table
			.row($(this).parents('tr'))
			.remove()
			.draw(false);
	});

	$('#tabelaCodSPED').DataTable({
		paging: false,
		filter: false,
		info: false,
		ordering: true,
		destroy: true,
		scrollY: "215px",
		autowidth: false,
	});

	$('#btnAdicionarCodSPED').click(async function () {
		addCodSPED();
	});

	async function addCodSPED() {
		if ($('#txtCodSPED').val() == '') {
			msgAlerta('Preencha o campo para adicionar uma CodSPED.');

		} else {
			let CodSPEDCodigo = pegaChave('#txtCodSPED');
			let CodSPEDDesc = pegaDescricao('#txtCodSPED');
			$('#tabelaCodSPED').DataTable().row.add([CodSPEDCodigo, CodSPEDDesc,
				'<div style="text-align:center;"> ' +
				'   <button class="btn btn-info btn-sm" id="btnExluirCodSPED" type="button"> ' +
				'      Excluir' +
				'   </button> ' +
				'</div>'
			]).draw(false);
			$('#txtCodSPED').val('');
		}
	};

	$('#tabelaCodSPED').on('click', '#btnExluirCodSPED', async function () {
		let table = $('#tabelaCodSPED').DataTable();
		table
			.row($(this).parents('tr'))
			.remove()
			.draw(false);
	});

	$('#tabelaEntidAux').DataTable({
		paging: false,
		filter: false,
		info: false,
		ordering: true,
		destroy: true,
		scrollY: "215px",
		autowidth: false,
	});

	$('#btnAdicionarEntidAux').click(async function () {
		addEntidAux();
	});

	async function addEntidAux() {
		if ($('#txtEntidAux').val() == '') {
			msgAlerta('Preencha o campo para adicionar uma Entid. Aux.');

		} else {
			let EntidAuxCodigo = pegaChave('#txtEntidAux');
			let EntidAuxDesc = pegaDescricao('#txtEntidAux');
			$('#tabelaEntidAux').DataTable().row.add([EntidAuxCodigo, EntidAuxDesc,
				'<div style="text-align:center;"> ' +
				'   <button class="btn btn-info btn-sm" id="btnExluirEntidAux" type="button"> ' +
				'      Excluir' +
				'   </button> ' +
				'</div>'
			]).draw(false);
			$('#txtEntidAux').val('');
		}
	};

	$('#tabelaEntidAux').on('click', '#btnExluirEntidAux', async function () {
		let table = $('#tabelaEntidAux').DataTable();
		table
			.row($(this).parents('tr'))
			.remove()
			.draw(false);
	});

	$('#txtNCM').autocompleta(1, `JSON={ "tabela":"tabfis", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
	$('#btnbuscaNCM').pesquisa('#txtNCM', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ 
            "tabela":"tabfis", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa NCM', 'tabfis');
	$('#btnANCM').on('click', function () {
		$('#txtNCM').val('');
	});

	$('#tabelaNCM').DataTable({
		paging: false,
		filter: false,
		info: false,
		ordering: true,
		destroy: true,
		scrollY: "215px",
		autowidth: false,
	});

	$('#btnAdicionarNCM').click(async function () {
		addNCM();
	});

	async function addNCM() {
		if ($('#txtNCM').val() == '') {
			msgAlerta('Preencha o campo para adicionar um NCM.');
		} else {
			let ncmCodigo = pegaChave('#txtNCM');
			let ncmDesc = pegaDescricao('#txtNCM');
			$('#tabelaNCM').DataTable().row.add([ncmCodigo, ncmDesc,
				'<div style="text-align:center;"> ' +
				'   <button class="btn btn-info btn-sm" id="btnExluirNCM" type="button"> ' +
				'      Excluir' +
				'   </button> ' +
				'</div>'
			]).draw(false);
			$('#txtNCM').val('');
		}
	};

	$('#tabelaNCM').on('click', '#btnExluirNCM', async function () {
		let table = $('#tabelaNCM').DataTable();
		table
			.row($(this).parents('tr'))
			.remove()
			.draw(false);
	});

	$('#btnICMS').on('click', function () {
		$('#modalICMS').modal('show');
	});
	$('#btnConfirmarICMS').on('click', function () {
		$('#modalICMS').modal('hide');
	});

	$('#btnIPI').on('click', function () {
		$('#modalIPI').modal('show');
	});
	$('#btnConfirmarIPI').on('click', function () {
		$('#modalIPI').modal('hide');
	});

	$('#btnPISCOFINS').on('click', function () {
		$('#modalPISCOFINS').modal('show');
	});
	$('#btnConfirmarPISCOFINS').on('click', function () {
		$('#modalPISCOFINS').modal('hide');
	});

	$('#btnIVA').on('click', function () {
		$('#modalIVA').modal('show');
	});
	$('#btnConfirmarIVA').on('click', function () {
		$('#modalIVA').modal('hide');
	});

	$('#btnRefTrib').on('click', function () {
		$('#modalRefTrib').modal('show');
	});
	$('#btnConfirmarRefTrib').on('click', function () {
		$('#modalRefTrib').modal('hide');
	});

	let queryString = window.location.href;
	let parametros = queryString.split('/');
	let reducao = parametros[parametros.length - 1];

	$('#btnVoltar').on('click', async function () {
		await deletaRegistro('REDUCAO', getCookie('usuario'), reducao);
		window.location.href = `${BASE_URI}/regrafiscal`;
	});

	if (reducao != '' && reducao != 'create') {

		$('#account').css('cursor', 'pointer');
		$('#payment').css('cursor', 'pointer');
		$('#personal').css('cursor', 'pointer');

		try {
			$.LoadingOverlay("show");
			try {
				let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
					`JSON={ "tabela":"regra_fiscal", 
                    "camposSelect":["NUM_CONTROLE", "descricao", "ativo", "prioridade", "cod_oper", "tp_pessoa", "cons_final", "tipo_venda", "porte_entid",
                                    "orig_item", "trib_entid", "estados", "cfop", "ncm", "aplica_desc", "dupli", "conf_base_icms", "csosn", "cst_icms",
                                    "natureza", "perc_icms", "usa_aliq_uf", "conf_base_ipi", "enquadra", "cst_ipi", "aliq_ipi", "conf_base_pis_cofins",
                                    "cst_cofins", "aliq_cofins", "cst_pis", "aliq_pis", "aliq_interna", "cred_presumido", "mva_zerada", "perc_efetivo",
                                    "perc_fcp", "perc_red_base", "reducao", "cod_sped", "entid_aux", "presenca", "usa_cst_icms_item", "desc_aliq_emp", "ind_ie",
																	  "COD_BENEF", "COD_BENEF1", "COD_BENEF2", "NAT_CONT", "MODELO", "PERC_REDUZ", "MENSAGEM", "PERC_ICMS_DIF", "usa_ipi_ncm",
																		"PERC_CRED_PRES", "COD_BENEF_CRED", "perc_iva", "PERC_ISENTO_IVA", "MOTDESICMS", "ID_TRIBUTACAO", "PERC_IBSUF", 
																		"PERC_RED_IBS", "PERC_IBSMUN", "PERC_CBS", "PERC_RED_CBS"], 
                    "where": ["NUM_CONTROLE = '${reducao}'"]}`, null);
				if (!response) {
					return;
				}
				let jsonStr = await response.json();
				if (response.status != 200) {
					msgErro(jsonStr.RESULT[0].mensagem);
					return;
				}

				if (!!jsonStr.RESULT[0][0].ID_TRIBUTACAO && jsonStr.RESULT[0][0].ID_TRIBUTACAO != '') {
					insereValor('#txtIdIbsCbs', jsonStr.RESULT[0][0].ID_TRIBUTACAO, 'REFORMA TRIBUTÁRIA');
					$('#txtIdIbsCbs').trigger('blur');
				}
				$('#txtAliqIbsUF').val(jsonStr.RESULT[0][0].PERC_IBSUF || 0);
				$('#txtAliqIbsMun').val(jsonStr.RESULT[0][0].PERC_IBSMUN || 0);
				$('#txtAliqCbs').val(jsonStr.RESULT[0][0].PERC_CBS || 0);
				$('#txtRedAliqCbs').val(jsonStr.RESULT[0][0].PERC_RED_CBS || 0);
				$('#txtRedAliqIbs').val(jsonStr.RESULT[0][0].PERC_RED_IBS || 0);

				if (jsonStr.RESULT[0][0].ATIVO == "S") {
					$('#checkAtivo').prop('checked', true);
				} else {
					$('#checkAtivo').prop('checked', false);
				}

				if (jsonStr.RESULT[0][0].MVA_ZERADA == "S") {
					$('#checkMVAZerada').prop('checked', true);
				} else {
					$('#checkMVAZerada').prop('checked', false);
				}

				$('#txtAliqInternaUF').val(jsonStr.RESULT[0][0].ALIQ_INTERNA);
				$('#txtCredPresumido').val(jsonStr.RESULT[0][0].CRED_PRESUMIDO);
				$('#txtPercEfetivo').val(jsonStr.RESULT[0][0].PERC_EFETIVO);
				$('#txtPercFCP').val(jsonStr.RESULT[0][0].PERC_FCP);
				$('#txtPercRedBase').val(jsonStr.RESULT[0][0].PERC_RED_BASE);
				$('#txtReducaoMVA').val(jsonStr.RESULT[0][0].REDUCAO);

				$('#txtCodigo').val(jsonStr.RESULT[0][0].NUM_CONTROLE);
				$('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
				$('#txtPrioridade').val(jsonStr.RESULT[0][0].PRIORIDADE);

				$('#txtCodBenef').val(jsonStr.RESULT[0][0].COD_BENEF);
				$('#txtCodBenef1').val(jsonStr.RESULT[0][0].COD_BENEF1);
				$('#txtCodBenef2').val(jsonStr.RESULT[0][0].COD_BENEF2);
				$('#txtMensagem').val(jsonStr.RESULT[0][0].MENSAGEM);

				$('#txtPercReducaoCST').val(jsonStr.RESULT[0][0].PERC_REDUZ);
				$('#txtPercIcmsDif').val(jsonStr.RESULT[0][0].PERC_ICMS_DIF);

				$('#txtPercCredPres').val(jsonStr.RESULT[0][0].PERC_CRED_PRES);
				$('#txtCodBenefCred').val(jsonStr.RESULT[0][0].COD_BENEF_CRED);
				$('#selectMotDeson').val(jsonStr.RESULT[0][0].MOTDESICMS ? jsonStr.RESULT[0][0].MOTDESICMS : '0').change();

				try {
					let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
						`JSON={ "tabela":"oper_fiscal", 
                        "camposSelect":["descricao"], 
                        "where": ["codigo = '${jsonStr.RESULT[0][0].COD_OPER}'"]}`, null);

					let jsonStrOperadora = await responseOperadora.json();

					insereValor('#txtOperacaoFiscal', jsonStr.RESULT[0][0].COD_OPER, jsonStrOperadora.RESULT[0][0].DESCRICAO);

				} catch (error) {
					console.error(error);
				}

				$('#txtAliquotaPIS').val(jsonStr.RESULT[0][0].ALIQ_PIS);

				try {
					let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
						`JSON={ "tabela":"tabpis", 
                        "camposSelect":["descricao"], 
                        "where": ["codigo = '${jsonStr.RESULT[0][0].CST_PIS}'"]}`, null);

					let jsonStrOperadora = await responseOperadora.json();

					insereValor('#txtCstPIS', jsonStr.RESULT[0][0].CST_PIS, jsonStrOperadora.RESULT[0][0].DESCRICAO);

				} catch (error) {
					console.error(error);
				}

				$('#txtAliquotaIVA').val(jsonStr.RESULT[0][0].PERC_IVA);
				$('#txtPercIsentoIva').val(jsonStr.RESULT[0][0].PERC_ISENTO_IVA);

				$('#txtAliquotaCOFINS').val(jsonStr.RESULT[0][0].ALIQ_COFINS);

				try {
					let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
						`JSON={ "tabela":"tabcofins", 
                        "camposSelect":["descricao"], 
                        "where": ["codigo = '${jsonStr.RESULT[0][0].CST_COFINS}'"]}`, null);

					let jsonStrOperadora = await responseOperadora.json();

					insereValor('#txtCstCOFINS', jsonStr.RESULT[0][0].CST_COFINS, jsonStrOperadora.RESULT[0][0].DESCRICAO);

				} catch (error) {
					console.error(error);
				}

				if (jsonStr.RESULT[0][0].CONF_BASE_PIS_COFINS != '') {
					let arrayConfBasePisCofins = jsonStr.RESULT[0][0].CONF_BASE_PIS_COFINS.split('');
					arrayConfBasePisCofins.forEach(element => {
						if (element == 'F') {
							$('#checkFretePISCOFINS').prop('checked', true);
						};
						if (element == 'D') {
							$('#checkDespesaPISCOFINS').prop('checked', true);
						}
					});
				};

				$('#txtAliquotaIPI').val(jsonStr.RESULT[0][0].ALIQ_IPI);

				try {
					let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
						`JSON={ "tabela":"tabipi", 
                        "camposSelect":["descricao"], 
                        "where": ["codigo = '${jsonStr.RESULT[0][0].CST_IPI}'"]}`, null);

					let jsonStrOperadora = await responseOperadora.json();

					insereValor('#txtCstIpi', jsonStr.RESULT[0][0].CST_IPI, jsonStrOperadora.RESULT[0][0].DESCRICAO);

				} catch (error) {
					console.error(error);
				}

				try {
					let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
						`JSON={ "tabela":"enquadra", 
                        "camposSelect":["descricao"], 
                        "where": ["codigo = '${jsonStr.RESULT[0][0].ENQUADRA}'"]}`, null);

					let jsonStrOperadora = await responseOperadora.json();

					insereValor('#txtEnquadraIPI', jsonStr.RESULT[0][0].ENQUADRA, jsonStrOperadora.RESULT[0][0].DESCRICAO);

				} catch (error) {
					console.error(error);
				}

				if (jsonStr.RESULT[0][0].CONF_BASE_IPI != '') {
					let arrayConfBaseIpi = jsonStr.RESULT[0][0].CONF_BASE_IPI.split('');
					arrayConfBaseIpi.forEach(element => {
						if (element == 'F') {
							$('#checkFreteIPI').prop('checked', true);
						};
						if (element == 'S') {
							$('#checkSeguroIPI').prop('checked', true);
						};
						if (element == 'D') {
							$('#checkDespesaIPI').prop('checked', true);
						}
					});
				};

				try {
					let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
						`JSON={ "tabela":"natureza", 
                        "camposSelect":["descricao"], 
                        "where": ["natureza = '${jsonStr.RESULT[0][0].NATUREZA}'"]}`, null);

					let jsonStrOperadora = await responseOperadora.json();

					insereValor('#txtNaturezaICMS', jsonStr.RESULT[0][0].NATUREZA, jsonStrOperadora.RESULT[0][0].DESCRICAO);

				} catch (error) {
					console.error(error);
				}

				try {
					const responseContabilizacao = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
						`JSON={ "tabela":"NAT_CONTA", 
                        "camposSelect":["descricao"], 
                        "where": ["codigo = '${jsonStr.RESULT[0][0].NAT_CONT}'"]}`, null);

					const jsonStrContabilizacao = await responseContabilizacao.json();

					insereValor('#txtContabilizacao', jsonStr.RESULT[0][0].NAT_CONT, jsonStrContabilizacao.RESULT[0][0].DESCRICAO);
				} catch (error) {
					console.error(error);
				}

				$('#txtAliquotaICMS').val(jsonStr.RESULT[0][0].PERC_ICMS);

				if (jsonStr.RESULT[0][0].USA_ALIQ_UF == "S") {
					$('#checkUsarAliquotaUF').prop('checked', true);
				}

				if (jsonStr.RESULT[0][0].USA_IPI_NCM == "S") {
					$('#checkUsarAliquotaNCM').prop('checked', true);
				}

				$('#checkUsarCstItem').prop('checked', (jsonStr.RESULT[0][0].USA_CST_ICMS_ITEM == "S"));
				$('#descAliqEmp').prop('checked', (jsonStr.RESULT[0][0].DESC_ALIQ_EMP == "S"));

				try {
					let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
						`JSON={ "tabela":"tabtri", 
                        "camposSelect":["descricao"], 
                        "where": ["codigo = '${jsonStr.RESULT[0][0].CST_ICMS}'"]}`, null);

					let jsonStrOperadora = await responseOperadora.json();

					insereValor('#txtClatribICMS', jsonStr.RESULT[0][0].CST_ICMS, jsonStrOperadora.RESULT[0][0].DESCRICAO);

				} catch (error) {
					console.error(error);
				}

				try {
					let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
						`JSON={ "tabela":"tabcsosn", 
                        "camposSelect":["descricao"], 
                        "where": ["codigo = '${jsonStr.RESULT[0][0].CSOSN}'"]}`, null);

					let jsonStrOperadora = await responseOperadora.json();

					insereValor('#txtCsosnICMS', jsonStr.RESULT[0][0].CSOSN, jsonStrOperadora.RESULT[0][0].DESCRICAO);

				} catch (error) {
					console.error(error);
				}

				if (jsonStr.RESULT[0][0].CONF_BASE_ICMS != '') {
					let arrayConfBaseIcms = jsonStr.RESULT[0][0].CONF_BASE_ICMS.split('');
					arrayConfBaseIcms.forEach(element => {
						if (element == 'I') {
							$('#checkIpiIcms').prop('checked', true);
						};
						if (element == 'S') {
							$('#checkSeguroICMS').prop('checked', true);
						};
						if (element == 'D') {
							$('#checkDespesaICMS').prop('checked', true);
						};
						if (element == 'F') {
							$('#checkFreteICMS').prop('checked', true);
						}
					});
				};

				if (jsonStr.RESULT[0][0].NCM != '') {
					let arrayNCM = jsonStr.RESULT[0][0].NCM.replace(/'/g, '').split(',');
					arrayNCM.forEach(element => {
						addValor();
						async function addValor() {
							let codigo = element;
							try {
								let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
									`JSON={ "tabela":"tabfis", 
                                        "camposSelect":["descricao"], 
                                        "where": ["codigo = '${codigo}'"]}`, null);
								let jsonStrOperadora = await responseOperadora.json();
								let descricao = jsonStrOperadora.RESULT[0][0].DESCRICAO;

								$('#tabelaNCM').DataTable().row.add([codigo, descricao,
									'<div style="text-align:center;"> ' +
									'   <button class="btn btn-info btn-sm" id="btnExluirNCM" type="button"> ' +
									'      Excluir' +
									'   </button> ' +
									'</div>'
								]).draw(false);
							} catch (error) {
								console.error(error);
							}
						}
					});
				};

				if (jsonStr.RESULT[0][0].CFOP != '') {
					let arrayCFOP = jsonStr.RESULT[0][0].CFOP.replace(/'/g, '').split(',');
					arrayCFOP.forEach(element => {
						addValor();
						async function addValor() {
							let codigo = element;
							try {
								let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
									`JSON={ "tabela":"natureza", 
                                        "camposSelect":["descricao"], 
                                        "where": ["natureza = '${codigo}'"]}`, null);
								let jsonStrOperadora = await responseOperadora.json();
								let descricao = jsonStrOperadora.RESULT[0][0].DESCRICAO;

								$('#tabelaCFOP').DataTable().row.add([codigo, descricao,
									'<div style="text-align:center;"> ' +
									'   <button class="btn btn-info btn-sm" id="btnExluirCFOP" type="button"> ' +
									'      Excluir' +
									'   </button> ' +
									'</div>'
								]).draw(false);
							} catch (error) {
								console.error(error);
							}
						}
					});
				};

				if (jsonStr.RESULT[0][0].MODELO != '') {
					let arrayModelo = jsonStr.RESULT[0][0].MODELO.replace(/'/g, '').split(',');
					arrayModelo.forEach(element => {
						addValor();
						async function addValor() {
							let codigo = element;
							try {
								let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
									`JSON={ "tabela":"MODELO", 
                                        "camposSelect":["descricao"], 
                                        "where": ["CODIGO = '${codigo}'"]}`, null);
								let jsonStrOperadora = await responseOperadora.json();
								let descricao = jsonStrOperadora.RESULT[0][0].DESCRICAO;

								$('#tabelaModelo').DataTable().row.add([codigo, descricao,
									'<div style="text-align:center;"> ' +
									'   <button class="btn btn-info btn-sm" id="btnExluirModelo" type="button"> ' +
									'      Excluir' +
									'   </button> ' +
									'</div>'
								]).draw(false);
							} catch (error) {
								console.error(error);
							}
						}
					});
				};

				if (jsonStr.RESULT[0][0].COD_SPED != '') {
					let arrayCOD_SPED = jsonStr.RESULT[0][0].COD_SPED.replace(/'/g, '').split(',');
					arrayCOD_SPED.forEach(element => {
						addValor();
						async function addValor() {
							let codigo = element;
							try {
								let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
									`JSON={ "tabela":"TABSPED", 
                                        "camposSelect":["DESCRICAO"], 
                                        "where": ["CODIGO = '${codigo}'"]}`, null);
								let jsonStrOperadora = await responseOperadora.json();
								let descricao = jsonStrOperadora.RESULT[0][0].DESCRICAO;

								$('#tabelaCodSPED').DataTable().row.add([codigo, descricao,
									'<div style="text-align:center;"> ' +
									'   <button class="btn btn-info btn-sm" id="btnExluirCodSPED" type="button"> ' +
									'      Excluir' +
									'   </button> ' +
									'</div>'
								]).draw(false);
							} catch (error) {
								console.error(error);
							}
						}
					});
				};

				if (jsonStr.RESULT[0][0].ENTID_AUX != '') {
					let arrayENTID_AUX = jsonStr.RESULT[0][0].ENTID_AUX.replace(/'/g, '').split(',');
					arrayENTID_AUX.forEach(element => {
						addValor();
						async function addValor() {
							let codigo = element;
							try {
								let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
									`JSON={ "tabela":"ENTID_AUX", 
                                        "camposSelect":["DESCRICAO"], 
                                        "where": ["CODIGO = '${codigo}'"]}`, null);
								let jsonStrOperadora = await responseOperadora.json();
								let descricao = jsonStrOperadora.RESULT[0][0].DESCRICAO;

								$('#tabelaEntidAux').DataTable().row.add([codigo, descricao,
									'<div style="text-align:center;"> ' +
									'   <button class="btn btn-info btn-sm" id="btnExluirEntidAux" type="button"> ' +
									'      Excluir' +
									'   </button> ' +
									'</div>'
								]).draw(false);
							} catch (error) {
								console.error(error);
							}
						}
					});
				};

				if (jsonStr.RESULT[0][0].ESTADOS != '') {
					let arrayEstados = jsonStr.RESULT[0][0].ESTADOS.replace(/'/g, '').split(',');
					arrayEstados.forEach(element => {
						if (element == 'AC') {
							$('#checkAC').prop('checked', true);
						};
						if (element == 'AL') {
							$('#checkAL').prop('checked', true);
						};
						if (element == 'AM') {
							$('#checkAM').prop('checked', true);
						};
						if (element == 'AP') {
							$('#checkAP').prop('checked', true);
						};
						if (element == 'BA') {
							$('#checkBA').prop('checked', true);
						};
						if (element == 'CE') {
							$('#checkCE').prop('checked', true);
						};
						if (element == 'DF') {
							$('#checkDF').prop('checked', true);
						};
						if (element == 'ES') {
							$('#checkES').prop('checked', true);
						};
						if (element == 'EX') {
							$('#checkEX').prop('checked', true);
						};
						if (element == 'GO') {
							$('#checkGO').prop('checked', true);
						};
						if (element == 'MA') {
							$('#checkMA').prop('checked', true);
						};
						if (element == 'MG') {
							$('#checkMG').prop('checked', true);
						};
						if (element == 'MS') {
							$('#checkMS').prop('checked', true);
						};
						if (element == 'MT') {
							$('#checkMT').prop('checked', true);
						};
						if (element == 'PA') {
							$('#checkPA').prop('checked', true);
						};
						if (element == 'PB') {
							$('#checkPB').prop('checked', true);
						};
						if (element == 'PE') {
							$('#checkPE').prop('checked', true);
						};
						if (element == 'PI') {
							$('#checkPI').prop('checked', true);
						};
						if (element == 'PR') {
							$('#checkPR').prop('checked', true);
						};
						if (element == 'RJ') {
							$('#checkRJ').prop('checked', true);
						};
						if (element == 'RN') {
							$('#checkRN').prop('checked', true);
						};
						if (element == 'RO') {
							$('#checkRO').prop('checked', true);
						};
						if (element == 'RR') {
							$('#checkRR').prop('checked', true);
						};
						if (element == 'RS') {
							$('#checkRS').prop('checked', true);
						};
						if (element == 'SC') {
							$('#checkSC').prop('checked', true);
						};
						if (element == 'SE') {
							$('#checkSE').prop('checked', true);
						};
						if (element == 'SP') {
							$('#checkSP').prop('checked', true);
						};
						if (element == 'TO') {
							$('#checkTO').prop('checked', true);
						};
					});
				};

				if (jsonStr.RESULT[0][0].TRIB_ENTID != '') {
					let arrayTribEntidade = jsonStr.RESULT[0][0].TRIB_ENTID.replace(/'/g, '').split(',');
					arrayTribEntidade.forEach(element => {
						if (element == 'A') {
							$('#checkA').prop('checked', true);
						};
						if (element == 'N') {
							$('#checkN').prop('checked', true);
						};
						if (element == 'L') {
							$('#checkL').prop('checked', true);
						};
						if (element == 'D') {
							$('#checkD').prop('checked', true);
						};
						if (element == 'S') {
							$('#checkS').prop('checked', true);
						};
						if (element == 'R') {
							$('#checkR').prop('checked', true);
						};
						if (element == 'C') {
							$('#checkC').prop('checked', true);
						};
						if (element == 'P') {
							$('#checkP').prop('checked', true);
						};
					});
				};

				if (jsonStr.RESULT[0][0].ORIG_ITEM != '') {
					let arrayOrigemItem = jsonStr.RESULT[0][0].ORIG_ITEM.replace(/'/g, '').split(',');
					arrayOrigemItem.forEach(element => {
						if (element == 'N') {
							$('#checkNormalOrig').prop('checked', true);
						};
						if (element == 'D') {
							$('#checkDiferenciada').prop('checked', true);
						};
						if (element == '1') {
							$('#check1').prop('checked', true);
						};
						if (element == '2') {
							$('#check2').prop('checked', true);
						};
						if (element == '3') {
							$('#check3').prop('checked', true);
						};
						if (element == '4') {
							$('#check4').prop('checked', true);
						};
						if (element == '5') {
							$('#check5').prop('checked', true);
						};
						if (element == '6') {
							$('#check6').prop('checked', true);
						};
						if (element == '7') {
							$('#check7').prop('checked', true);
						};
						if (element == '8') {
							$('#check8').prop('checked', true);
						};
					});
				};

				if (jsonStr.RESULT[0][0].PRESENCA != '') {
					let arrayPresencaItem = jsonStr.RESULT[0][0].PRESENCA.replace(/'/g, '').split(',');
					arrayPresencaItem.forEach(element => {
						if (element == '0') {
							$('#chkPresenca0').prop('checked', true);
						};
						if (element == '1') {
							$('#chkPresenca1').prop('checked', true);
						};
						if (element == '2') {
							$('#chkPresenca2').prop('checked', true);
						};
						if (element == '3') {
							$('#chkPresenca3').prop('checked', true);
						};
						if (element == '4') {
							$('#chkPresenca4').prop('checked', true);
						};
						if (element == '5') {
							$('#chkPresenca5').prop('checked', true);
						};
						if (element == '9') {
							$('#chkPresenca9').prop('checked', true);
						};
					});
				};

				if (jsonStr.RESULT[0][0].IND_IE != '') {
					let arrIndIeItem = jsonStr.RESULT[0][0].IND_IE.replace(/'/g, '').split(',');
					arrIndIeItem.forEach(element => {
						if (element == '1') {
							$('#chkIndIE1').prop('checked', true);
						};
						if (element == '2') {
							$('#chkIndIE2').prop('checked', true);
						};
						if (element == '9') {
							$('#chkIndIE9').prop('checked', true);
						};
					});
				};

				if (jsonStr.RESULT[0][0].PORTE_ENTID != '') {
					let arrayPorteEntidade = jsonStr.RESULT[0][0].PORTE_ENTID.replace(/'/g, '').split(',');
					arrayPorteEntidade.forEach(element => {
						if (element == 'SA') {
							$('#checkSA').prop('checked', true);
						};
						if (element == 'LTDA') {
							$('#checkLTDA').prop('checked', true);
						};
						if (element == 'SIMPLES') {
							$('#checkSimples').prop('checked', true);
						};
						if (element == 'ME') {
							$('#checkME').prop('checked', true);
						};
						if (element == 'EPP') {
							$('#checkEPP').prop('checked', true);
						};
						if (element == 'NORMAL') {
							$('#checkNormal').prop('checked', true);
						};
						if (element == 'MEI') {
							$('#checkMEI').prop('checked', true);
						};
						if (element == 'EIRELI') {
							$('#checkEireli').prop('checked', true);
						};
					});
				};

				if (jsonStr.RESULT[0][0].TIPO_VENDA != '') {
					let arrayTipoVenda = jsonStr.RESULT[0][0].TIPO_VENDA.replace(/'/g, '').split(',');
					arrayTipoVenda.forEach(element => {
						if (element == '0') {
							$('#checkProducao').prop('checked', true);
						}
						if (element == '1') {
							$('#checkRevenda').prop('checked', true);
						}
					});
				};

				if (jsonStr.RESULT[0][0].CONS_FINAL != '') {
					let arrayConsFinal = jsonStr.RESULT[0][0].CONS_FINAL.replace(/'/g, '').split(',');
					arrayConsFinal.forEach(element => {
						if (element == 'Sim') {
							$('#checkSim').prop('checked', true);
						}
						if (element == 'Nao') {
							$('#checkNao').prop('checked', true);
						}
					});
				};

				if (jsonStr.RESULT[0][0].TP_PESSOA != '') {
					let arrayTipoPessoa = jsonStr.RESULT[0][0].TP_PESSOA.replace(/'/g, '').split(',');
					arrayTipoPessoa.forEach(element => {
						if (element == '1') {
							$('#checkFisica').prop('checked', true);
						}
						if (element == '2') {
							$('#checkJuridica').prop('checked', true);
						}
					});
				};

				if (jsonStr.RESULT[0][0].APLICA_DESC == 'S') {
					$('#checkAplicaDesc').prop('checked', true);
				}

				if (jsonStr.RESULT[0][0].DUPLI == 'S') {
					$('#checkGeraDup').prop('checked', true);
				}

				const dadosEmpresa = await buscaEmpresas(reducao);

				if (dadosEmpresa != '') {
					for (let i = 0; i < dadosEmpresa.length; i++) {
						for (let x = 0; x < $('#tabelaEmpresa').DataTable().rows().data().length; x++) {
							let dados = $('#tabelaEmpresa').DataTable().rows().data()[x];
							let empresa = dados[1].split(' - ')[0];
							if (empresa == dadosEmpresa[i].EMP_ID) {
								$($('.checkEmpresa')[x]).prop('checked', true);
								$($("table#tabelaEmpresa tr")[x + 1]).addClass("selected");
							}
						}
					}
				}

			} catch (error) {
				console.error(error);
				msgErro(`Não foi possível buscar os dados da redução: ${error}`);
			}
		} finally {
			$.LoadingOverlay('hide');
		}
	};

	async function buscaEmpresas(codigo) {
		try {
			const url = '/Sisplan/Funcoes/v1/pesquisa?';
			const response = await requisicao('GET', url, `JSON={ "tabela":"EMP_VALOR", "camposSelect":["EMP_ID"], "where": ["TABELA = 'REGRA_FISCAL' AND VALOR = '${codigo}'"]}`);

			if (!response) {
				return;
			}

			let jsonStr = await response.json();
			if (response.status != 200) {
				msgErro(jsonStr.mensagem);
				return;
			}
			if (jsonStr.RESULT[0].length > 0) {
				return jsonStr.RESULT[0];
			}
			return '';


		} catch (error) {
			console.error(error);
			msgErro('Erro ao buscar dados da empresa do usuário');
		}
	}

	$('#account').on('click', function () {
		if (reducao != 'create') {
			if (contaFs == 2) {
				$('#voltar').trigger('click');
			}
			if (contaFs == 3) {
				$('#voltar2').trigger('click');
				$('#voltar').trigger('click');
			}
		}
	});

	$('#payment').on('click', function () {
		if (reducao != 'create') {
			if (contaFs == 1) {
				$('#avancar1').trigger('click');
			}
			if (contaFs == 3) {
				$('#voltar2').trigger('click');
			}
		}
	});

	$('#personal').on('click', function () {
		if (reducao != 'create') {
			if (contaFs == 1) {
				$('#avancar1').trigger('click');
				$('#avancar2').trigger('click');
			}
			if (contaFs == 2) {
				$('#avancar2').trigger('click');
			}
		}
	});


	$("#btnGravar").click(

		async function () {
			try {
				// $.LoadingOverlay("show");

				reducao = {};

				reducao.EMP_ID = 1;
				reducao.COD_OPER = pegaChave('#txtOperacaoFiscal', reducao.COD_OPER);
				reducao.NUM_CONTROLE = $('#txtCodigo').val() == '' ? await RetornaProximo('REGRA_FISCAL', 'REGRA_FISCAL', 'NUM_CONTROLE', 0) : $('#txtCodigo').val();
				reducao.DESCRICAO = $('#txtDescricao').val();
				reducao.PRIORIDADE = $('#txtPrioridade').val();

				reducao.ALIQ_INTERNA = $('#txtAliqInternaUF').val();
				reducao.CRED_PRESUMIDO = $('#txtCredPresumido').val();
				reducao.PERC_EFETIVO = $('#txtPercEfetivo').val();
				reducao.PERC_FCP = $('#txtPercFCP').val();
				reducao.PERC_RED_BASE = $('#txtPercRedBase').val();
				reducao.REDUCAO = $('#txtReducaoMVA').val();

				reducao.COD_BENEF = $('#txtCodBenef').val();
				reducao.COD_BENEF1 = $('#txtCodBenef1').val();
				reducao.COD_BENEF2 = $('#txtCodBenef2').val();
				reducao.PERC_REDUZ = $('#txtPercReducaoCST').val();
				reducao.PERC_ICMS_DIF = $('#txtPercIcmsDif').val();

				reducao.COD_BENEF_CRED = $('#txtCodBenefCred').val();
				reducao.PERC_CRED_PRES = $('#txtPercCredPres').val();

				reducao.MOTDESICMS = $('#selectMotDeson').val();

				if ($('#checkMVAZerada').prop('checked')) {
					reducao.MVA_ZERADA = 'S';
				} else {
					reducao.MVA_ZERADA = 'N';
				}

				if ($('#checkAtivo').prop('checked')) {
					reducao.ATIVO = 'S';
				} else {
					reducao.ATIVO = 'N';
				}

				reducao.TP_PESSOA = '';
				if ($('#checkFisica').prop('checked')) {
					reducao.TP_PESSOA += "'1'";
				}
				if ($('#checkJuridica').prop('checked')) {
					if (reducao.TP_PESSOA != '') {
						reducao.TP_PESSOA += ",";
					}
					reducao.TP_PESSOA += "'2'";
				}

				reducao.CONS_FINAL = '';
				if ($('#checkNao').prop('checked')) {
					reducao.CONS_FINAL += "'Nao'";
				}
				if ($('#checkSim').prop('checked')) {
					if (reducao.CONS_FINAL != '') {
						reducao.CONS_FINAL += ",";
					}
					reducao.CONS_FINAL += "'Sim'";
				}

				reducao.TIPO_VENDA = '';
				if ($('#checkProducao').prop('checked')) {
					reducao.TIPO_VENDA += "'0'";
				}
				if ($('#checkRevenda').prop('checked')) {
					if (reducao.TIPO_VENDA != '') {
						reducao.TIPO_VENDA += ",";
					}
					reducao.TIPO_VENDA += "'1'";
				}

				reducao.PORTE_ENTID = '';
				if ($('#checkSA').prop('checked')) {
					reducao.PORTE_ENTID += "'SA'";
				}
				if ($('#checkLTDA').prop('checked')) {
					if (reducao.PORTE_ENTID != '') {
						reducao.PORTE_ENTID += ",";
					}
					reducao.PORTE_ENTID += "'LTDA'";
				}
				if ($('#checkSimples').prop('checked')) {
					if (reducao.PORTE_ENTID != '') {
						reducao.PORTE_ENTID += ",";
					}
					reducao.PORTE_ENTID += "'SIMPLES'";
				}
				if ($('#checkME').prop('checked')) {
					if (reducao.PORTE_ENTID != '') {
						reducao.PORTE_ENTID += ",";
					}
					reducao.PORTE_ENTID += "'ME'";
				}
				if ($('#checkEPP').prop('checked')) {
					if (reducao.PORTE_ENTID != '') {
						reducao.PORTE_ENTID += ",";
					}
					reducao.PORTE_ENTID += "'EPP'";
				}
				if ($('#checkNormal').prop('checked')) {
					if (reducao.PORTE_ENTID != '') {
						reducao.PORTE_ENTID += ",";
					}
					reducao.PORTE_ENTID += "'NORMAL'";
				}
				if ($('#checkMEI').prop('checked')) {
					if (reducao.PORTE_ENTID != '') {
						reducao.PORTE_ENTID += ",";
					}
					reducao.PORTE_ENTID += "'MEI'";
				}
				if ($('#checkEireli').prop('checked')) {
					if (reducao.PORTE_ENTID != '') {
						reducao.PORTE_ENTID += ",";
					}
					reducao.PORTE_ENTID += "'EIRELI'";
				}

				reducao.ORIG_ITEM = '';
				if ($('#checkNormalOrig').prop('checked')) {
					reducao.ORIG_ITEM += "'N'";
				}
				if ($('#checkDiferenciada').prop('checked')) {
					if (reducao.ORIG_ITEM != '') {
						reducao.ORIG_ITEM += ",";
					}
					reducao.ORIG_ITEM += "'D'";
				}
				if ($('#check1').prop('checked')) {
					if (reducao.ORIG_ITEM != '') {
						reducao.ORIG_ITEM += ",";
					}
					reducao.ORIG_ITEM += "'1'";
				}
				if ($('#check2').prop('checked')) {
					if (reducao.ORIG_ITEM != '') {
						reducao.ORIG_ITEM += ",";
					}
					reducao.ORIG_ITEM += "'2'";
				}
				if ($('#check3').prop('checked')) {
					if (reducao.ORIG_ITEM != '') {
						reducao.ORIG_ITEM += ",";
					}
					reducao.ORIG_ITEM += "'3'";
				}
				if ($('#check4').prop('checked')) {
					if (reducao.ORIG_ITEM != '') {
						reducao.ORIG_ITEM += ",";
					}
					reducao.ORIG_ITEM += "'4'";
				}
				if ($('#check5').prop('checked')) {
					if (reducao.ORIG_ITEM != '') {
						reducao.ORIG_ITEM += ",";
					}
					reducao.ORIG_ITEM += "'5'";
				}
				if ($('#check6').prop('checked')) {
					if (reducao.ORIG_ITEM != '') {
						reducao.ORIG_ITEM += ",";
					}
					reducao.ORIG_ITEM += "'6'";
				}
				if ($('#check7').prop('checked')) {
					if (reducao.ORIG_ITEM != '') {
						reducao.ORIG_ITEM += ",";
					}
					reducao.ORIG_ITEM += "'7'";
				}
				if ($('#check8').prop('checked')) {
					if (reducao.ORIG_ITEM != '') {
						reducao.ORIG_ITEM += ",";
					}
					reducao.ORIG_ITEM += "'8'";
				}

				reducao.PRESENCA = '';
				if ($('#chkPresenca0').prop('checked')) {
					reducao.PRESENCA += "'0'";
				}
				if ($('#chkPresenca1').prop('checked')) {
					if (reducao.PRESENCA != '') {
						reducao.PRESENCA += ",";
					}
					reducao.PRESENCA += "'1'";
				}
				if ($('#chkPresenca2').prop('checked')) {
					if (reducao.PRESENCA != '') {
						reducao.PRESENCA += ",";
					}
					reducao.PRESENCA += "'2'";
				}
				if ($('#chkPresenca3').prop('checked')) {
					if (reducao.PRESENCA != '') {
						reducao.PRESENCA += ",";
					}
					reducao.PRESENCA += "'3'";
				}
				if ($('#chkPresenca4').prop('checked')) {
					if (reducao.PRESENCA != '') {
						reducao.PRESENCA += ",";
					}
					reducao.PRESENCA += "'4'";
				}
				if ($('#chkPresenca5').prop('checked')) {
					if (reducao.PRESENCA != '') {
						reducao.PRESENCA += ",";
					}
					reducao.PRESENCA += "'5'";
				}
				if ($('#chkPresenca9').prop('checked')) {
					if (reducao.PRESENCA != '') {
						reducao.PRESENCA += ",";
					}
					reducao.PRESENCA += "'9'";
				}


				reducao.IND_IE = '';
				if ($('#chkIndIE1').prop('checked')) {
					reducao.IND_IE += "'1'";
				}
				if ($('#chkIndIE2').prop('checked')) {
					if (reducao.IND_IE != '') {
						reducao.IND_IE += ",";
					}
					reducao.IND_IE += "'2'";
				}
				if ($('#chkIndIE9').prop('checked')) {
					if (reducao.IND_IE != '') {
						reducao.IND_IE += ",";
					}
					reducao.IND_IE += "'9'";
				}


				reducao.TRIB_ENTID = '';
				if ($('#checkA').prop('checked')) {
					reducao.TRIB_ENTID += "'A'";
				}
				if ($('#checkN').prop('checked')) {
					if (reducao.TRIB_ENTID != '') {
						reducao.TRIB_ENTID += ",";
					}
					reducao.TRIB_ENTID += "'N'";
				}
				if ($('#checkL').prop('checked')) {
					if (reducao.TRIB_ENTID != '') {
						reducao.TRIB_ENTID += ",";
					}
					reducao.TRIB_ENTID += "'L'";
				}
				if ($('#checkD').prop('checked')) {
					if (reducao.TRIB_ENTID != '') {
						reducao.TRIB_ENTID += ",";
					}
					reducao.TRIB_ENTID += "'D'";
				}
				if ($('#checkS').prop('checked')) {
					if (reducao.TRIB_ENTID != '') {
						reducao.TRIB_ENTID += ",";
					}
					reducao.TRIB_ENTID += "'S'";
				}
				if ($('#checkR').prop('checked')) {
					if (reducao.TRIB_ENTID != '') {
						reducao.TRIB_ENTID += ",";
					}
					reducao.TRIB_ENTID += "'R'";
				}
				if ($('#checkC').prop('checked')) {
					if (reducao.TRIB_ENTID != '') {
						reducao.TRIB_ENTID += ",";
					}
					reducao.TRIB_ENTID += "'C'";
				}
				if ($('#checkP').prop('checked')) {
					if (reducao.TRIB_ENTID != '') {
						reducao.TRIB_ENTID += ",";
					}
					reducao.TRIB_ENTID += "'P'";
				}

				reducao.ESTADOS = '';
				if ($('#checkAC').prop('checked')) {
					reducao.ESTADOS += "'AC'";
				}
				if ($('#checkAL').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'AL'";
				}
				if ($('#checkAM').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'AM'";
				}
				if ($('#checkAP').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'AP'";
				}
				if ($('#checkBA').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'BA'";
				}
				if ($('#checkCE').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'CE'";
				}
				if ($('#checkDF').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'DF'";
				}
				if ($('#checkES').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'ES'";
				}
				if ($('#checkEX').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'EX'";
				}
				if ($('#checkGO').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'GO'";
				}
				if ($('#checkMA').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'MA'";
				}
				if ($('#checkMG').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'MG'";
				}
				if ($('#checkMS').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'MS'";
				}
				if ($('#checkMT').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'MT'";
				}
				if ($('#checkPA').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'PA'";
				}
				if ($('#checkPB').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'PB'";
				}
				if ($('#checkPE').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'PE'";
				}
				if ($('#checkPI').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'PI'";
				}
				if ($('#checkPR').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'PR'";
				}
				if ($('#checkRJ').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'RJ'";
				}
				if ($('#checkRN').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'RN'";
				}
				if ($('#checkRO').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'RO'";
				}
				if ($('#checkRR').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'RR'";
				}
				if ($('#checkRS').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'RS'";
				}
				if ($('#checkSC').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'SC'";
				}
				if ($('#checkSE').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'SE'";
				}
				if ($('#checkSP').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'SP'";
				}
				if ($('#checkTO').prop('checked')) {
					if (reducao.ESTADOS != '') {
						reducao.ESTADOS += ",";
					}
					reducao.ESTADOS += "'TO'";
				}

				reducao.NCM = '';
				for (let index = 0; index < $('#tabelaNCM').DataTable().rows().count(); index++) {
					let data = $('#tabelaNCM').DataTable().row(index).data();
					if (reducao.NCM != '') {
						reducao.NCM += ",";
					}
					reducao.NCM += `'${data[0]}'`;
				}

				reducao.CFOP = '';
				for (let index = 0; index < $('#tabelaCFOP').DataTable().rows().count(); index++) {
					let data = $('#tabelaCFOP').DataTable().row(index).data();
					if (reducao.CFOP != '') {
						reducao.CFOP += ",";
					}
					reducao.CFOP += `'${data[0]}'`;
				}

				reducao.MODELO = '';
				for (let index = 0; index < $('#tabelaModelo').DataTable().rows().count(); index++) {
					let data = $('#tabelaModelo').DataTable().row(index).data();
					if (reducao.MODELO != '') {
						reducao.MODELO += ",";
					}
					reducao.MODELO += `'${data[0]}'`;
				}

				reducao.COD_SPED = '';
				for (let index = 0; index < $('#tabelaCodSPED').DataTable().rows().count(); index++) {
					let data = $('#tabelaCodSPED').DataTable().row(index).data();
					if (reducao.COD_SPED != '') {
						reducao.COD_SPED += ",";
					}
					reducao.COD_SPED += `'${data[0]}'`;
				}

				reducao.ENTID_AUX = '';
				for (let index = 0; index < $('#tabelaEntidAux').DataTable().rows().count(); index++) {
					let data = $('#tabelaEntidAux').DataTable().row(index).data();
					if (reducao.ENTID_AUX != '') {
						reducao.ENTID_AUX += ",";
					}
					reducao.ENTID_AUX += `'${data[0]}'`;
				}

				if ($('#checkAplicaDesc').prop('checked')) {
					reducao.APLICA_DESC = 'S';
				} else {
					reducao.APLICA_DESC = 'N';
				}
				if ($('#checkGeraDup').prop('checked')) {
					reducao.DUPLI = 'S';
				} else {
					reducao.DUPLI = 'N';
				}

				if ($('#checkUsarAliquotaUF').prop('checked')) {
					reducao.USA_ALIQ_UF = 'S';
				} else {
					reducao.USA_ALIQ_UF = 'N';
				}

				if ($('#checkUsarAliquotaNCM').prop('checked')) {
					reducao.USA_IPI_NCM = 'S';
				} else {
					reducao.USA_IPI_NCM = 'N';
				}

				reducao.USA_CST_ICMS_ITEM = ($('#checkUsarCstItem').prop('checked')) ? 'S' : 'N';
				reducao.DESC_ALIQ_EMP = ($('#descAliqEmp').prop('checked')) ? 'S' : 'N';
				reducao.NATUREZA = pegaChave('#txtNaturezaICMS', reducao.NATUREZA);
				reducao.NAT_CONT = pegaChave('#txtContabilizacao', reducao.NAT_CONT);
				reducao.PERC_ICMS = $('#txtAliquotaICMS').val();
				reducao.CST_ICMS = pegaChave('#txtClatribICMS', reducao.CST_ICMS);
				reducao.CSOSN = pegaChave('#txtCsosnICMS', reducao.CSOSN);

				reducao.CONF_BASE_ICMS = '';
				if ($('#checkIpiIcms').prop('checked')) {
					reducao.CONF_BASE_ICMS += 'I';
				}
				if ($('#checkSeguroICMS').prop('checked')) {
					reducao.CONF_BASE_ICMS += 'S';
				}
				if ($('#checkDespesaICMS').prop('checked')) {
					reducao.CONF_BASE_ICMS += 'D';
				}
				if ($('#checkFreteICMS').prop('checked')) {
					reducao.CONF_BASE_ICMS += 'F';
				}

				reducao.CST_IPI = pegaChave('#txtCstIpi', reducao.CST_IPI);
				reducao.ALIQ_IPI = $('#txtAliquotaIPI').val();
				reducao.ENQUADRA = pegaChave('#txtEnquadraIPI', reducao.ENQUADRA);

				reducao.CONF_BASE_IPI = '';
				if ($('#checkFreteIPI').prop('checked')) {
					reducao.CONF_BASE_IPI += 'F';
				}
				if ($('#checkSeguroIPI').prop('checked')) {
					reducao.CONF_BASE_IPI += 'S';
				}
				if ($('#checkDespesaIPI').prop('checked')) {
					reducao.CONF_BASE_IPI += 'D';
				}

				reducao.CST_PIS = pegaChave('#txtCstPIS', reducao.CST_IPI);
				reducao.ALIQ_PIS = $('#txtAliquotaPIS').val();

				reducao.CST_COFINS = pegaChave('#txtCstCOFINS', reducao.CST_IPI);
				reducao.ALIQ_COFINS = $('#txtAliquotaCOFINS').val();

				reducao.PERC_IVA = $('#txtAliquotaIVA').val();
				reducao.PERC_ISENTO_IVA = $('#txtPercIsentoIva').val();

				reducao.CONF_BASE_PIS_COFINS = '';
				if ($('#checkFretePISCOFINS').prop('checked')) {
					reducao.CONF_BASE_PIS_COFINS += 'F';
				}
				if ($('#checkDespesaPISCOFINS').prop('checked')) {
					reducao.CONF_BASE_PIS_COFINS += 'D';
				}

				reducao.MENSAGEM = $('#txtMensagem').val()

				reducao.ID_TRIBUTACAO = pegaChave('#txtIdIbsCbs');
				reducao.PERC_IBSUF = pegaValor('#txtAliqIbsUF');
				reducao.PERC_IBSMUN = pegaValor('#txtAliqIbsMun');
				reducao.PERC_CBS = pegaValor('#txtAliqCbs');
				reducao.PERC_RED_CBS = pegaValor('#txtRedAliqCbs');
				reducao.PERC_RED_IBS = pegaValor('#txtRedAliqIbs');

				let arrayEmpresas = [];
				for (let i = 0; i < $('#tabelaEmpresa').DataTable().rows('.selected').data().length; i++) {
					let empresa = {};
					let dados = $('#tabelaEmpresa').DataTable().rows('.selected').data()[i];
					empresa.EMP_ID = dados[1].split(' - ')[0];
					arrayEmpresas.push(empresa);
				}
				reducao.EMPRESAS = arrayEmpresas;

				let response = await requisicao('POST', '/Sisplan/Cadastros/v1/Reducao?', `JSON=${encodeURIComponent(JSON.stringify(reducao))}`, null);

				if (!response) {
					$.LoadingOverlay("hide");
					return;
				};

				let jsonStr = await response.json();
				if (response.status != 200) {
					$.LoadingOverlay("hide");
					msgErro(jsonStr.mensagem);
					return;
				}
				$.LoadingOverlay("hide");
				toastr.success(
					`Cadastro efetuado com sucesso!
                    Regra fiscal: ${reducao.NUM_CONTROLE}`,
					'Confirmação', {
					toastClass: 'alert',
					iconClasses: {
						error: 'alert-error',
						info: 'alert-info',
						success: 'alert-success',
						warning: 'alert-warning'
					},
					positionClass: "toast-top-center",
					progressBar: true,
					timeOut: 3000,
					fadeOut: 1000,
					onHidden() {
						window.location.href = `${BASE_URI}/regrafiscal`;
					}
				}
				).css({
					"margin-top": "20%",
					"width": "500px",
					"max-width": "500px"
				});

			} catch (error) {
				console.error(error);
				$.LoadingOverlay("hide");
				msgErro(`Não foi possível gravar os dados da regrafiscal: ${error}`);
			}
		});
});