$(document).ready(async function () {
  addPesquisaAutocompleta();
  criaDataTables();
  let tamProjetoFiltrado = -1;
  let codcliFiltrado = '';
  let listaResultadosGrafico = [];
  let listaResultadosGrafico1 = [];
  let listaResultadosGrafico2 = [];

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnLimparFiltros").on("click", function () {
    limpaFiltros();
  });

  function limpaFiltros() {
    $("#txtRepresentante").val("").trigger("change");
    $("#txtCliente").val("").trigger("change");
    $("#txtGestor").val("").trigger("change");
    $("#dtCadastroDe").val("1899-01-01");
    $("#dtCadastroAte").val("2500-12-31");
  };

  async function buscaNomeRepresentante(codrep) {
    try {
      const pesquisaNomeRepresen = {
        tabela: 'REPRESEN',
        camposSelect: ['NOME AS NOME_REP'],
        where: [`CODREP = '${codrep}'`]
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaNomeRepresen));

      if (jsonStr.length == 0) {
        return;
      };

      return jsonStr[0].NOME_REP;
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar o nome dos representantes filtrados, por favor, verifique!');
    };
  };

  async function buscaNomeGestor(gestor) {
    try {
      const pesquisaNomeGestor = {
        tabela: 'PESSOAL',
        camposSelect: ['NOME AS NOME_GESTOR'],
        where: [`CODIGO = '${gestor}'`]
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaNomeGestor));

      if (jsonStr.length == 0) {
        return;
      };

      return jsonStr[0].NOME_GESTOR;
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar o nome dos representantes filtrados, por favor, verifique!');
    };
  };

  async function retornaFiltros() {
    const cliente = await formataListas($("#txtCliente").val().toString());
    const representante = await formataListas($("#txtRepresentante").val().toString());
    const gestor = await formataListas($("#txtGestor").val().toString());
    const tecnico = await formataListas($("#txtTecnico").val().toString());
    const dtCadastroDe = $("#dtCadastroDe").val();
    const dtCadastroAte = $("#dtCadastroAte").val();
    const status = $("#selectStatus").val();
    const projeto = $("#selectProjeto").val();
    const consideraCliente = $('#cbConsideraCliente').is(':checked');

    $('#txtPeriodoFiltrado').text('');
    $('#txtGestorFiltrado').text('');
    $('#txtRepresFiltrado').text('');
    $('#txtProjetoFiltrado').text('');

    $('#txtPeriodoFiltrado').text(formataDataBonita(dtCadastroDe) + ' - ' + formataDataBonita(dtCadastroAte));

    const listaRepresentante = $('#txtRepresentante').val();

    for (let i = 0; i < listaRepresentante.length; i++) {
      const representanteSpan = $('#txtRepresFiltrado').text();

      if (listaRepresentante[i].trim() != '') {
        if (representanteSpan.trim() == '') {
          $('#txtRepresFiltrado').text(`${listaRepresentante[i]} - ${await buscaNomeRepresentante(listaRepresentante[i])}`);
        } else {
          $('#txtRepresFiltrado').text(`${representanteSpan}, ${listaRepresentante[i]} - ${await buscaNomeRepresentante(listaRepresentante[i])}`);
        };
      }
    };

    const listaGestor = $('#txtGestor').val();

    for (let x = 0; x < listaGestor.length; x++) {
      const gestorSpan = $('#txtGestorFiltrado').text();

      if (listaGestor[x].trim() != '') {
        if (gestorSpan.trim() == '') {
          $('#txtGestorFiltrado').text(`${listaGestor[x]} - ${await buscaNomeGestor(listaGestor[x])}`);
        } else {
          $('#txtGestorFiltrado').text(`${gestorSpan}, ${listaGestor[x]} - ${await buscaNomeGestor(listaGestor[x])}`);
        };
      };
    };

    if (projeto == 'T') {
      $('#txtProjetoFiltrado').text('Todos');
    } else if (projeto == 'S') {
      $('#txtProjetoFiltrado').text('Sim');
    } else if (projeto == 'N') {
      $('#txtProjetoFiltrado').text('Não');
    }

    return `CLIENTE=${cliente}&REPRESENTANTE=${representante}&GESTOR=${gestor}&DT_CADASTRO_DE=${dtCadastroDe}&DT_CADASTRO_ATE=${dtCadastroAte}&STATUS=${status}&PROJETO=${projeto}&CONSIDERA_CLIENTE=${consideraCliente}&TECNICO=${tecnico}`;
  };

  $("#btnConsultar").on("click", async function () {
    await fazConsulta();
  });

  async function fazConsulta(tamProjeto = -1, codcli = '', horas_implant = 0) {
    $.LoadingOverlay("show");

    if (codcli != codcliFiltrado) {
      const indexHorasProjeto = $("#tabelaHorasProjeto").DataTable().$("tr.selected").index();

      if (indexHorasProjeto != tamProjeto) {
        $("#tabelaHorasProjeto").DataTable().$("tr.selected").removeClass("selected");
      };
    }

    if (tamProjeto == -1 && codcli != '') {
      if (tamProjeto == -1) {
        const index = $("#tabelaHorasProjeto").DataTable().$("tr.selected").index();
        if (index != undefined && index != -1) {
          tamProjeto = index;
          tamProjetoFiltrado = index;
        };
      };

      if (horas_implant > 0 && horas_implant <= 100) {
        $("#tabelaHorasProjeto").DataTable().$("tr.selected").removeClass("selected");
        $($("#tabelaHorasProjeto").DataTable().row(0).node()).addClass("selected");
      } else if (horas_implant > 100 && horas_implant <= 200) {
        $("#tabelaHorasProjeto").DataTable().$("tr.selected").removeClass("selected");
        $($("#tabelaHorasProjeto").DataTable().row(1).node()).addClass("selected");
      } else if (horas_implant > 200 && horas_implant <= 300) {
        $("#tabelaHorasProjeto").DataTable().$("tr.selected").removeClass("selected");
        $($("#tabelaHorasProjeto").DataTable().row(2).node()).addClass("selected");
      } else if (horas_implant > 300 && horas_implant <= 400) {
        $("#tabelaHorasProjeto").DataTable().$("tr.selected").removeClass("selected");
        $($("#tabelaHorasProjeto").DataTable().row(3).node()).addClass("selected");
      } else if (horas_implant > 400 && horas_implant <= 500) {
        $("#tabelaHorasProjeto").DataTable().$("tr.selected").removeClass("selected");
        $($("#tabelaHorasProjeto").DataTable().row(4).node()).addClass("selected");
      } else if (horas_implant > 500 && horas_implant <= 1000) {
        $("#tabelaHorasProjeto").DataTable().$("tr.selected").removeClass("selected");
        $($("#tabelaHorasProjeto").DataTable().row(5).node()).addClass("selected");
      } else if (horas_implant > 1000 && horas_implant <= 2000) {
        $("#tabelaHorasProjeto").DataTable().$("tr.selected").removeClass("selected");
        $($("#tabelaHorasProjeto").DataTable().row(6).node()).addClass("selected");
      } else if (horas_implant > 2000) {
        $("#tabelaHorasProjeto").DataTable().$("tr.selected").removeClass("selected");
        $($("#tabelaHorasProjeto").DataTable().row(7).node()).addClass("selected");
      };
    };

    if (codcli == "") {
      if (tamProjeto != -1) {
        if (tamProjetoFiltrado != tamProjeto) {
          tamProjetoFiltrado = tamProjeto;
        } else {
          tamProjeto = -1;
          tamProjetoFiltrado = tamProjeto;
        };
      };
    };

    if (codcli != '') {
      if (codcliFiltrado != codcli) {
        codcliFiltrado = codcli;
      } else {
        codcli = '';
        codcliFiltrado = codcli;
      };
    };

    if (codcli == '') {
      $("#tabelaSolicitacoesCliente").DataTable().clear().draw();
    };

    if (tamProjeto == -1 && codcli == '') {
      $("#tabelaHorasProjeto").DataTable().clear().draw();
    };

    $("#tabelaSolicitacoesConsultor").DataTable().clear().draw();

    let qtdeSemAnalise = 0;
    let qtdeProgramacao = 0;
    let qtdeAprovado = 0;
    let qtdeAprovacao = 0;
    let qtdeTotal = 0;
    let qtdeConcluido = 0;
    let qtdeRejeitado = 0;
    let qtdeAnalisado = 0;

    try {
      const url = "/sisplan/impressao/v1/consultarelanalisesolicitacoes?TAM_PROJETO=" + tamProjeto + "&CODCLI=" + codcli + "&";

      const filtros = await retornaFiltros();

      const response = await requisicao("GET", url, filtros, '', 1300000);

      if (!response) {
        return;
      };

      const jsonStr = await response.json();

      if (response.status != 200) {
        console.error(jsonStr.mensagem);
        return;
      };

      if (jsonStr.length == 0) {
        limpaFiltros();
        return;
      };

      const listaResultadosSolicitacoes = [];
      const listaResultadosConsultorSolicitacoes = [];
      listaResultadosGrafico = [];
      listaResultadosGrafico1 = [];
      listaResultadosGrafico2 = [];
      listaHorasProjeto = [
        {
          TAM_PROJETO: 'De 1 a 100 horas',
          QTDE_SOLICITACOES: 0
        },
        {
          TAM_PROJETO: 'De 101 a 200 horas',
          QTDE_SOLICITACOES: 0
        },
        {
          TAM_PROJETO: 'De 201 a 300 horas',
          QTDE_SOLICITACOES: 0
        },
        {
          TAM_PROJETO: 'De 301 a 400 horas',
          QTDE_SOLICITACOES: 0
        },
        {
          TAM_PROJETO: 'De 401 a 500 horas',
          QTDE_SOLICITACOES: 0
        },
        {
          TAM_PROJETO: 'De 501 a 1000 horas',
          QTDE_SOLICITACOES: 0
        },
        {
          TAM_PROJETO: 'De 1001 a 2000 horas',
          QTDE_SOLICITACOES: 0
        },
        {
          TAM_PROJETO: 'Mais de 2000 horas',
          QTDE_SOLICITACOES: 0
        }
      ];

      for (let i = 0; i < jsonStr.length; i++) {
        const index = listaResultadosSolicitacoes.findIndex(item => item.NOME === jsonStr[i].NOME);
        if (index !== -1) {
          listaResultadosSolicitacoes[index].QTDE_SOLICITACOES += 1;
        } else {
          listaResultadosSolicitacoes.push({
            CODCLI: jsonStr[i].CODCLI,
            NOME: jsonStr[i].NOME,
            QTDE_SOLICITACOES: 1,
            HR_UTILIZADA: await buscaHorasUtilizadas(jsonStr[i].CODCLI),
            HORAS_IMPLANT: jsonStr[i].HORAS_IMPLANT,
          });
        };

        const indexConsultor = listaResultadosConsultorSolicitacoes.findIndex(item => item.DESC_TECNICO === jsonStr[i].DESC_TECNICO);

        if (indexConsultor !== -1) {
          listaResultadosConsultorSolicitacoes[indexConsultor].QTDE_SOLICITACOES += 1;
        } else {
          listaResultadosConsultorSolicitacoes.push({
            DESC_TECNICO: jsonStr[i].DESC_TECNICO,
            QTDE_SOLICITACOES: 1
          });
        };

        if (jsonStr[i].HORAS_IMPLANT > 0 && jsonStr[i].HORAS_IMPLANT <= 100) {
          listaHorasProjeto[0].QTDE_SOLICITACOES += 1;
        } else if (jsonStr[i].HORAS_IMPLANT > 100 && jsonStr[i].HORAS_IMPLANT <= 200) {
          listaHorasProjeto[1].QTDE_SOLICITACOES += 1;
        } else if (jsonStr[i].HORAS_IMPLANT > 200 && jsonStr[i].HORAS_IMPLANT <= 300) {
          listaHorasProjeto[2].QTDE_SOLICITACOES += 1;
        } else if (jsonStr[i].HORAS_IMPLANT > 300 && jsonStr[i].HORAS_IMPLANT <= 400) {
          listaHorasProjeto[3].QTDE_SOLICITACOES += 1;
        } else if (jsonStr[i].HORAS_IMPLANT > 400 && jsonStr[i].HORAS_IMPLANT <= 500) {
          listaHorasProjeto[4].QTDE_SOLICITACOES += 1;
        } else if (jsonStr[i].HORAS_IMPLANT > 500 && jsonStr[i].HORAS_IMPLANT <= 1000) {
          listaHorasProjeto[5].QTDE_SOLICITACOES += 1;
        } else if (jsonStr[i].HORAS_IMPLANT > 1000 && jsonStr[i].HORAS_IMPLANT <= 2000) {
          listaHorasProjeto[6].QTDE_SOLICITACOES += 1;
        } else if (jsonStr[i].HORAS_IMPLANT > 2000) {
          listaHorasProjeto[7].QTDE_SOLICITACOES += 1;
        };

        if (jsonStr[i].STATUS == 'S') {
          qtdeSemAnalise += 1;
        } else if (jsonStr[i].STATUS == 'P') {
          qtdeProgramacao += 1;
        } else if (jsonStr[i].STATUS == 'C') {
          qtdeConcluido += 1;
        } else if (jsonStr[i].STATUS == 'R') {
          qtdeRejeitado += 1;
        } else if (jsonStr[i].STATUS == 'A') {
          qtdeAnalisado += 1;
        } else if (jsonStr[i].STATUS == 'O') {
          qtdeAprovacao += 1;
        } else if (jsonStr[i].STATUS == 'V') {
          qtdeAprovado += 1;
        };

        qtdeTotal += 1;

        const indexGrafico = listaResultadosGrafico.findIndex(item => item.name == (jsonStr[i].IE_TIPO_PENDENCIA == '' ? 'Sem Tipo' : jsonStr[i].IE_TIPO_PENDENCIA));

        if (indexGrafico != -1) {
          listaResultadosGrafico[indexGrafico].y += 1;
        } else {
          let nameTipoPendencia = jsonStr[i].IE_TIPO_PENDENCIA;
          if (nameTipoPendencia == '') {
            nameTipoPendencia = 'Sem Tipo'
          };
          let obj = {
            name: nameTipoPendencia,
            y: 1
          };

          listaResultadosGrafico.push(obj);
        };

        const indexGrafico1 = listaResultadosGrafico1.findIndex(item => item.DESCRICAO_TIPO_PENDENCIA == jsonStr[i].DESC_TIPO);

        if (indexGrafico1 != -1) {
          listaResultadosGrafico1[indexGrafico1].QTDE_SOLICITACOES += 1;
        } else {
          let obj = {
            DESCRICAO_TIPO_PENDENCIA: jsonStr[i].DESC_TIPO,
            QTDE_SOLICITACOES: 1
          };
          listaResultadosGrafico1.push(obj);
        };

        const indexGrafico2 = listaResultadosGrafico2.findIndex(item => item.DESCRICAO_TIPO_OPERACAO == jsonStr[i].DESC_TIPO_OPER);

        if (indexGrafico2 != -1) {
          listaResultadosGrafico2[indexGrafico2].QTDE_SOLICITACOES += 1;
        } else {
          let obj = {
            DESCRICAO_TIPO_OPERACAO: jsonStr[i].DESC_TIPO_OPER,
            QTDE_SOLICITACOES: 1
          };
          listaResultadosGrafico2.push(obj);
        };
      };

      listaResultadosSolicitacoes.sort((a, b) => b.QTDE_SOLICITACOES - a.QTDE_SOLICITACOES);

      listaResultadosConsultorSolicitacoes.sort((a, b) => b.QTDE_SOLICITACOES - a.QTDE_SOLICITACOES);

      $('#txtQtdeTotalSemAnalise').text(qtdeSemAnalise);
      $('#txtQtdeTotalProgramacao').text(qtdeProgramacao);
      $('#txtQtdeTotalAprovado').text(qtdeAprovado);
      $('#txtQtdeTotalAprovacao').text(qtdeAprovacao);
      $('#txtQtdeTotalConcluido').text(qtdeConcluido);
      $('#txtQtdeTotalRejeitado').text(qtdeRejeitado);
      $('#txtQtdeTotalAnalisado').text(qtdeAnalisado);
      $('#txtQtdeTotalRealizado').text(qtdeProgramacao + qtdeConcluido);
      $('#txtQtdeTotalClientes').text(listaResultadosSolicitacoes.length);
      $('#txtQtdeTotal').text(qtdeTotal);

      if (tamProjeto == -1 && codcli == '') {
        $('#tabelaHorasProjeto').DataTable().rows.add(listaHorasProjeto).draw(false);
      };

      if (codcli == "") {
        $('#tabelaSolicitacoesCliente').DataTable().rows.add(listaResultadosSolicitacoes).draw(false);
      };

      $('#tabelaSolicitacoesConsultor').DataTable().rows.add(listaResultadosConsultorSolicitacoes).draw(false);

      Graficos.limpaGrafico(["graficoRelAnaliseSolicitacoes1"]);
      Graficos.limpaGrafico(["graficoRelAnaliseSolicitacoes2"]);

      GraficosAnaliseSolicitacoes.criarGraficoPizza({
        container: 'graficoAnaliseSolicitacoes',
        data: listaResultadosGrafico,
        grafico3d: true,
        title: 'Erro por qtde. de Solicitações'
      });

      Graficos.criarGrafico({
        container: "graficoRelAnaliseSolicitacoes1",
        tipo: 'bar',
        dados: listaResultadosGrafico1,
        colunasAgrupamento: ["DESCRICAO_TIPO_PENDENCIA"],
        colunasValor: ["QTDE_SOLICITACOES"],
        title: `Tipo de Solicitação em Qtde`,
        formatarValor: (value) => {
          return (
            parseInt(value)
          );
        },
        qtdeRegistros: 10,
      });

      Graficos.criarGrafico({
        container: "graficoRelAnaliseSolicitacoes2",
        tipo: 'bar',
        dados: listaResultadosGrafico2,
        colunasAgrupamento: ["DESCRICAO_TIPO_OPERACAO"],
        colunasValor: ["QTDE_SOLICITACOES"],
        title: `Operação em Qtde`,
        formatarValor: (value) => {
          return (
            parseInt(value)
          );
        },
        qtdeRegistros: 10,
      });

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
      $("#modal-filtros").modal("hide");
    };
  };

  $("#graficoColuna").on("click", async function () {
    if ($("#tabelaSolicitacoesConsultor").DataTable().data().toArray().length > 0) {
      await mudaOsGraficos('C');
    } else {
      msgErro('Necessário ter registros em tabela pra mudar o tipo do gráfico. Tente novamente.');
      return
    };
  });

  $("#graficoBarra").on("click", async function () {
    if ($("#tabelaSolicitacoesConsultor").DataTable().data().toArray().length > 0) {
      await mudaOsGraficos("B");
    } else {
      msgErro('Necessário ter registros em tabela pra mudar o tipo do gráfico. Tente novamente.');
      return
    };
  });

  $("#graficoPizza").on("click", async function () {
    if ($("#tabelaSolicitacoesConsultor").DataTable().data().toArray().length > 0) {
      await mudaOsGraficos("Z");
    } else {
      msgErro('Necessário ter registros em tabela pra mudar o tipo do gráfico. Tente novamente.');
      return
    };
  });

  $("#graficoLinha").on("click", async function () {
    if ($("#tabelaSolicitacoesConsultor").DataTable().data().toArray().length > 0) {
      await mudaOsGraficos("L");
    } else {
      msgErro('Necessário ter registros em tabela pra mudar o tipo do gráfico. Tente novamente.');
      return
    };
  });

  $("#graficoVazio").on("click", async function () {
    if ($("#tabelaSolicitacoesConsultor").DataTable().data().toArray().length > 0) {
      await mudaOsGraficos("T");
    } else {
      msgErro('Necessário ter registros em tabela pra mudar o tipo do gráfico. Tente novamente.');
      return
    };
  });

  $("#graficoPadrao").on("click", async function () {
    if ($("#tabelaSolicitacoesConsultor").DataTable().data().toArray().length > 0) {
      await mudaOsGraficos("P");
    } else {
      msgErro('Necessário ter registros em tabela pra mudar o tipo do gráfico. Tente novamente.');
      return
    };
  });

  $('#btnImprimir').on('click', async function () {
    window.print();
  });

  async function mudaOsGraficos(opcao = 'P') {
    if (opcao == 'P') {
      $('#divGraficoAnaliseSolicitacoes').removeClass('d-none');
      $('#graficoRelAnaliseSolicitacoes').addClass('d-none');

      Graficos.limpaGrafico(["graficoRelAnaliseSolicitacoes1"]);
      Graficos.limpaGrafico(["graficoRelAnaliseSolicitacoes2"]);

      GraficosAnaliseSolicitacoes.criarGraficoPizza({
        container: 'graficoAnaliseSolicitacoes',
        data: listaResultadosGrafico,
        grafico3d: true,
        title: 'Erro por qtde. de Solicitações'
      });

      Graficos.criarGrafico({
        container: "graficoRelAnaliseSolicitacoes1",
        tipo: 'bar',
        dados: listaResultadosGrafico1,
        colunasAgrupamento: ["DESCRICAO_TIPO_PENDENCIA"],
        colunasValor: ["QTDE_SOLICITACOES"],
        title: `Tipo de Solicitação em Qtde`,
        formatarValor: (value) => {
          return (
            parseInt(value)
          );
        },
        qtdeRegistros: 10,
      });

      Graficos.criarGrafico({
        container: "graficoRelAnaliseSolicitacoes2",
        tipo: 'bar',
        dados: listaResultadosGrafico2,
        colunasAgrupamento: ["DESCRICAO_TIPO_OPERACAO"],
        colunasValor: ["QTDE_SOLICITACOES"],
        title: `Operação em Qtde`,
        formatarValor: (value) => {
          return (
            parseInt(value)
          );
        },
        qtdeRegistros: 10,
      });
    } else if (opcao == 'L') {
      $('#divGraficoAnaliseSolicitacoes').addClass('d-none');
      $('#graficoRelAnaliseSolicitacoes').removeClass('d-none');

      Graficos.limpaGrafico(["graficoRelAnaliseSolicitacoes"]);
      Graficos.limpaGrafico(["graficoRelAnaliseSolicitacoes1"]);
      Graficos.limpaGrafico(["graficoRelAnaliseSolicitacoes2"]);

      Graficos.criarGrafico({
        container: "graficoRelAnaliseSolicitacoes",
        tipo: 'line',
        dados: listaResultadosGrafico,
        colunasAgrupamento: ["name"],
        colunasValor: ["y"],
        title: `Erro por qtde. de Solicitações`,
        formatarValor: (value) => {
          return (
            parseInt(value)
          );
        },
        qtdeRegistros: 10,
      });

      Graficos.criarGrafico({
        container: "graficoRelAnaliseSolicitacoes1",
        tipo: 'line',
        dados: listaResultadosGrafico1,
        colunasAgrupamento: ["DESCRICAO_TIPO_PENDENCIA"],
        colunasValor: ["QTDE_SOLICITACOES"],
        title: `Tipo de Solicitação em Qtde`,
        formatarValor: (value) => {
          return (
            parseInt(value)
          );
        },
        qtdeRegistros: 10,
      });

      Graficos.criarGrafico({
        container: "graficoRelAnaliseSolicitacoes2",
        tipo: 'line',
        dados: listaResultadosGrafico2,
        colunasAgrupamento: ["DESCRICAO_TIPO_OPERACAO"],
        colunasValor: ["QTDE_SOLICITACOES"],
        title: `Operação em Qtde`,
        formatarValor: (value) => {
          return (
            parseInt(value)
          );
        },
        qtdeRegistros: 10,
      });
    } else if (opcao == 'C') {
      $('#divGraficoAnaliseSolicitacoes').addClass('d-none');
      $('#graficoRelAnaliseSolicitacoes').removeClass('d-none');

      Graficos.limpaGrafico(["graficoRelAnaliseSolicitacoes"]);
      Graficos.limpaGrafico(["graficoRelAnaliseSolicitacoes1"]);
      Graficos.limpaGrafico(["graficoRelAnaliseSolicitacoes2"]);

      Graficos.criarGrafico({
        container: "graficoRelAnaliseSolicitacoes",
        tipo: 'column',
        dados: listaResultadosGrafico,
        colunasAgrupamento: ["name"],
        colunasValor: ["y"],
        title: `Erro por qtde. de Solicitações`,
        formatarValor: (value) => {
          return (
            parseInt(value)
          );
        },
        qtdeRegistros: 10,
      });

      Graficos.criarGrafico({
        container: "graficoRelAnaliseSolicitacoes1",
        tipo: 'column',
        dados: listaResultadosGrafico1,
        colunasAgrupamento: ["DESCRICAO_TIPO_PENDENCIA"],
        colunasValor: ["QTDE_SOLICITACOES"],
        title: `Tipo de Solicitação em Qtde`,
        formatarValor: (value) => {
          return (
            parseInt(value)
          );
        },
        qtdeRegistros: 10,
      });

      Graficos.criarGrafico({
        container: "graficoRelAnaliseSolicitacoes2",
        tipo: 'column',
        dados: listaResultadosGrafico2,
        colunasAgrupamento: ["DESCRICAO_TIPO_OPERACAO"],
        colunasValor: ["QTDE_SOLICITACOES"],
        title: `Operação em Qtde`,
        formatarValor: (value) => {
          return (
            parseInt(value)
          );
        },
        qtdeRegistros: 10,
      });
    } else if (opcao == 'Z') {
      $('#divGraficoAnaliseSolicitacoes').addClass('d-none');
      $('#graficoRelAnaliseSolicitacoes').removeClass('d-none');

      Graficos.limpaGrafico(["graficoRelAnaliseSolicitacoes"]);
      Graficos.limpaGrafico(["graficoRelAnaliseSolicitacoes1"]);
      Graficos.limpaGrafico(["graficoRelAnaliseSolicitacoes2"]);

      Graficos.criarGrafico({
        container: "graficoRelAnaliseSolicitacoes",
        tipo: 'pie',
        dados: listaResultadosGrafico,
        colunasAgrupamento: ["name"],
        colunasValor: ["y"],
        title: `Erro por qtde. de Solicitações`,
        formatarValor: (value) => {
          return (
            parseInt(value)
          );
        },
        qtdeRegistros: 10,
      });

      Graficos.criarGrafico({
        container: "graficoRelAnaliseSolicitacoes1",
        tipo: 'pie',
        dados: listaResultadosGrafico1,
        colunasAgrupamento: ["DESCRICAO_TIPO_PENDENCIA"],
        colunasValor: ["QTDE_SOLICITACOES"],
        title: `Tipo de Solicitação em Qtde`,
        formatarValor: (value) => {
          return (
            parseInt(value)
          );
        },
        qtdeRegistros: 10,
      });

      Graficos.criarGrafico({
        container: "graficoRelAnaliseSolicitacoes2",
        tipo: 'pie',
        dados: listaResultadosGrafico2,
        colunasAgrupamento: ["DESCRICAO_TIPO_OPERACAO"],
        colunasValor: ["QTDE_SOLICITACOES"],
        title: `Operação em Qtde`,
        formatarValor: (value) => {
          return (
            parseInt(value)
          );
        },
        qtdeRegistros: 10,
      });
    } else if (opcao == 'T') {
      $('#divGraficoAnaliseSolicitacoes').addClass('d-none');
      Graficos.limpaGrafico(["graficoRelAnaliseSolicitacoes"]);
      Graficos.limpaGrafico(["graficoRelAnaliseSolicitacoes1"]);
      Graficos.limpaGrafico(["graficoRelAnaliseSolicitacoes2"]);
    } else if (opcao == 'B') {
      $('#divGraficoAnaliseSolicitacoes').addClass('d-none');
      $('#graficoRelAnaliseSolicitacoes').removeClass('d-none');

      Graficos.limpaGrafico(["graficoRelAnaliseSolicitacoes"]);
      Graficos.limpaGrafico(["graficoRelAnaliseSolicitacoes1"]);
      Graficos.limpaGrafico(["graficoRelAnaliseSolicitacoes2"]);

      Graficos.criarGrafico({
        container: "graficoRelAnaliseSolicitacoes",
        tipo: 'bar',
        dados: listaResultadosGrafico,
        colunasAgrupamento: ["name"],
        colunasValor: ["y"],
        title: `Erro por qtde. de Solicitações`,
        formatarValor: (value) => {
          return (
            parseInt(value)
          );
        },
        qtdeRegistros: 10,
      });

      Graficos.criarGrafico({
        container: "graficoRelAnaliseSolicitacoes1",
        tipo: 'bar',
        dados: listaResultadosGrafico1,
        colunasAgrupamento: ["DESCRICAO_TIPO_PENDENCIA"],
        colunasValor: ["QTDE_SOLICITACOES"],
        title: `Tipo de Solicitação em Qtde`,
        formatarValor: (value) => {
          return (
            parseInt(value)
          );
        },
        qtdeRegistros: 10,
      });

      Graficos.criarGrafico({
        container: "graficoRelAnaliseSolicitacoes2",
        tipo: 'bar',
        dados: listaResultadosGrafico2,
        colunasAgrupamento: ["DESCRICAO_TIPO_OPERACAO"],
        colunasValor: ["QTDE_SOLICITACOES"],
        title: `Operação em Qtde`,
        formatarValor: (value) => {
          return (
            parseInt(value)
          );
        },
        qtdeRegistros: 10,
      });
    };
  };

  function criaDataTables() {
    $("#tabelaSolicitacoesCliente").DataTable({
      search: false,
      filter: false,
      sort: false,
      destroy: true,
      pageLength: 8,
      paging: true,
      autoWidth: false,
      scrollX: false,
      columnDefs: [
        {
          targets: [2, 3],
          render(data) {
            return parseInt(data);
          },
          className: "pr-4 text-right",
        },
        {
          targets: [0, 4],
          visible: false,
        },
      ],
      data: [],
      columns: [
        {
          "title": "Cod. Cliente",
          "data": "CODCLI",
        },
        {
          "title": "Cliente",
          "data": "NOME",
        },
        {
          "title": "Qtde. Solicitações",
          "data": "QTDE_SOLICITACOES",
        },
        {
          "title": "Hora Utilizada",
          "data": "HR_UTILIZADA",
        },
        {
          "title": "Horas Projeto",
          "data": "HORAS_IMPLANT",
        }
      ],
    });

    $('#tabelaSolicitacoesCliente_length').addClass('d-none');

    $("#tabelaHorasProjeto").DataTable({
      search: false,
      filter: false,
      sort: false,
      destroy: true,
      pageLength: 8,
      paging: false,
      autoWidth: true,
      columnDefs: [
        {
          targets: [1],
          render(data) {
            return parseInt(data);
          },
          className: "pr-4 text-right",
        },
      ],
      data: [],
      columns: [
        {
          "title": "Tam. Projeto",
          "data": "TAM_PROJETO",
        },
        {
          "title": "Qtde. Solicitações",
          "data": "QTDE_SOLICITACOES",
        },
      ],
    });

    $("#tabelaSolicitacoesConsultor").DataTable({
      search: false,
      filter: false,
      sort: false,
      destroy: true,
      pageLength: 8,
      paging: true,
      autoWidth: true,
      columnDefs: [
        {
          targets: [1],
          render(data) {
            return parseInt(data);
          },
          className: "pr-4 text-right",
        },
      ],
      data: [],
      columns: [
        {
          "title": "Consultor",
          "data": "DESC_TECNICO",
        },
        {
          "title": "Qtde. Solicitações",
          "data": "QTDE_SOLICITACOES",
        },
      ],
    });

    $('#tabelaSolicitacoesConsultor_length').addClass('d-none');

    $("#tabelaHorasProjeto tbody").on("click", "tr", async function () {
      $("#tabelaHorasProjeto").DataTable().$("tr.selected").removeClass("selected");
      $(this).addClass("selected");
      await fazConsulta($(this).index());
    });

    $("#tabelaSolicitacoesCliente tbody").on("click", "tr", async function () {
      $("#tabelaSolicitacoesCliente").DataTable().$("tr.selected").removeClass("selected");
      $(this).addClass("selected");
      const rowData = $("#tabelaSolicitacoesCliente").DataTable().row(this).data();
      const codcli = rowData.CODCLI;
      await fazConsulta(tamProjetoFiltrado, codcli, rowData.HORAS_IMPLANT);
    });
  };

  function addPesquisaAutocompleta() {
    componenteFiltro("vendedor", true, true, 'Representante', ["ATIVO = 'S'"]);
    componenteFiltro("clienteSolicitacoes", true, true, 'Cliente');
    componenteFiltro("gestor", true, true, 'Gestor', ["ATIVO = 'S'", "FUNCAO = '42'"]);
    componenteFiltro("tecnico", true, true, 'Tecnico', ["ATIVO = 'S'"]);
  };

  async function buscaHorasUtilizadas(codcli) {
    const url = "/sisplan/impressao/v1/consultahorasutilizadas?";

    const response = await requisicao("GET", url, `CODCLI=${codcli}`, '', 1300000);

    if (!response) {
      return;
    };

    const jsonStr = await response.json();

    if (response.status != 200) {
      console.error(jsonStr.mensagem);
      return;
    };

    if (jsonStr.length == 0) {
      limpaFiltros();
      return;
    };

    return jsonStr;
  }
});
