$(document).ready(async function () {
    await setarDataAtual('txtDataDe', true);
    await setarDataAtual('txtDataAte', false, 30);

    const dataSetColsDesistenciaItem = []
    const columnsDesistenciaItem = [{
        title: 'Item',
        data: 'CODIGO',
    },
    {
        title: 'Desistencia',
        data: 'CODMEN',
    },
    {
        title: 'Descrição',
        data: 'DESCRICAO',
    }]

    const dataSetColsItensMesa = []
    const columns = [{
        title: 'Situação',
        data: 'SITUACAO',
    },
    {
        title: 'Codigo',
        data: 'CODIGO',
    },
    {
        title: 'Descrição',
        data: 'DESCRICAO',
    },
    {
        title: 'Ações',
        data: 'ACOES',
    },
    {
        title: 'Preço',
        data: 'PRECO',
    },
    {
        title: 'Tipo',
        data: 'TIPO_ITEM',
    },
    {
        title: 'Data',
        data: 'DATA',
    },
    {
        title: 'Unidade',
        data: 'UNIDADE'
    },
    {
        title: 'Largura',
        data: 'LARGURA'
    },
    {
        title: 'Gramatura',
        data: 'GRAMATURA'
    },
    {
        title: 'Situação Codigo',
        data: 'SITUACAO_CODIGO',
    }]
    columns.forEach((column, i) => {
        dataSetColsItensMesa.push({
            'title': column.title,
            'data': column.data
        });
    });

    columnsDesistenciaItem.forEach((column, i) => {
        dataSetColsDesistenciaItem.push({
            'title': column.title,
            'data': column.data
        });
    });

    var tabelaDesistenciaItem = $(`#tabelaDesistenciaItem`).DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        destroy: true,
        "columns": dataSetColsDesistenciaItem
    });

    var tabelaCarrinho = $('#tabelaCarrinho').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        destroy: true,
        scrollX: '250px',
        scrollY: '200px',
        autoWidth: true,
        columns: dataSetColsCarrinho,
    });

    function formataEmDinheiro(valor) {
        return valor.toLocaleString('pt-BR', {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2
        });
    }

    function adicionaLinhaTabela(dados, tabela) {
        $(tabela).DataTable().row.add(dados).draw(false);
    }

    async function listaPedidosNaoSalvos() {
        try {
            const response = await fetch(`busca_arquivosPedido.php`, {
                method: 'GET',
                body: null,
            },);
            const listasArquivo = await response.json();
            return listasArquivo;
        } catch (error) {
            return;
        }
    }

    async function retornaPedidosNaoSalvos(arquivos) {
        let myHeaders = new Headers();
        myHeaders.append('pragma', 'no-cache');
        myHeaders.append('cache-control', 'no-cache');
        const pedidos = await Promise.all(arquivos.map(async (arquivo) => {
            const response = await fetch(arquivo, {
                headers: myHeaders,
                method: 'GET',
                body: null,
            })
            const json = await response.json()
            return json
        }))
        return pedidos
    }

    function retornaDiferencaDatasPendentes(datasPendentes) {
        function formatarData(data) {
            const partes = data.split('T');
            const dataPartes = partes[0].split('-');
            const horaPartes = partes[1].split(':');

            const ano = dataPartes[0];
            const mes = dataPartes[1];
            const dia = dataPartes[2];
            const hora = horaPartes[0].padStart(2, '0');
            const minuto = horaPartes[1].padStart(2, '0');
            const segundo = horaPartes[2];

            return `${ano}-${mes}-${dia}T${hora}:${minuto}:${segundo}`;
        }
        if (datasPendentes.length > 0) {
            const soma = datasPendentes.reduce((acumulador, data) => {
                const diferenca = Math.abs(new Date(formatarData(data.fim))) - Math.abs(new Date(formatarData(data.inicio)));
                return acumulador + diferenca;
            }, 0);

            return soma
        }

        return 0;

    }

    function mostraContador(dataInicioPedido, id, datasPendentes, statusPedido, tempo) {
        const dataAtual = new Date();
        const dataInicio = new Date(dataInicioPedido);
        const somaPendentes = retornaDiferencaDatasPendentes(datasPendentes);
        const diffEmMilissegundos = Math.abs(dataAtual - dataInicio) - somaPendentes;
        const diffEmSegundos = Math.floor(diffEmMilissegundos / 1000);
        if (statusPedido == 'A') {
            iniciarContador(diffEmSegundos, id);
        } else {
            $(`#txtContador-${id}`).val(tempo)
        }
    }

    function atualizarRelogio(tempoTotal, id) {
        let segundos = tempoTotal % 60;
        let minutos = Math.floor(tempoTotal / 60) % 60;
        let horas = Math.floor(tempoTotal / 3600);

        const segundosStr = segundos.toString().padStart(2, '0');
        const minutosStr = minutos.toString().padStart(2, '0');
        const horasStr = horas.toString().padStart(2, '0');
        $(`#txtContador-${id}`).val(`${horasStr}:${minutosStr}:${segundosStr}`)
    }

    function iniciarContador(tempoTotal, id) {
        const intervalo = setInterval(() => {
            tempoTotal++;
            atualizarRelogio(tempoTotal, id);
        }, 1000);
    }


    const pedidosNaoSalvos = await listaPedidosNaoSalvos();
    const objetosPedidos = await retornaPedidosNaoSalvos(pedidosNaoSalvos);
    criaCardMesas(objetosPedidos);

    $('.collapsePedidos').on('click', function () {
        if ($($(this).find('i')[0]).hasClass('fa-angle-down')) {
            $($(this).find('i')[0]).removeClass('fa-angle-down')
            $($(this).find('i')[0]).addClass('fa-angle-right')
        } else {
            $($(this).find('i')[0]).removeClass('fa-angle-right')
            $($(this).find('i')[0]).addClass('fa-angle-down')
        }
    })

    setInterval(async function () {

        async function atualizaValores() {
            const pedidosNaoSalvos = await listaPedidosNaoSalvos()
            const objetosPedidos = await retornaPedidosNaoSalvos(pedidosNaoSalvos);

            if ((($(`.mesasRetaguarda`).length == 0) && (objetosPedidos.length > 0)) || (objetosPedidos.length != $(`.mesasRetaguarda`).length)) {
                criaCardMesas(objetosPedidos, true);

                $('.collapsePedidos').on('click', function () {
                    if ($($(this).find('i')[0]).hasClass('fa-angle-down')) {
                        $($(this).find('i')[0]).removeClass('fa-angle-down')
                        $($(this).find('i')[0]).addClass('fa-angle-right')
                    } else {
                        $($(this).find('i')[0]).removeClass('fa-angle-right')
                        $($(this).find('i')[0]).addClass('fa-angle-down')
                    }
                })
            }

            $('.collapsePedidos').on('click', function () {
                if ($($(this).find('i')[0]).hasClass('fa-angle-down')) {
                    $($(this).find('i')[0]).removeClass('fa-angle-down')
                    $($(this).find('i')[0]).addClass('fa-angle-right')
                } else {
                    $($(this).find('i')[0]).removeClass('fa-angle-right')
                    $($(this).find('i')[0]).addClass('fa-angle-down')
                }
            })

            objetosPedidos.forEach((mesa, i) => {
                $(`#txtValorCarrinho-${mesa.numeroAtendimento}`).html()
                $(`#txtItensCarrinho-${mesa.numeroAtendimento}`).html(mesa.itens.filter(item => item.SITUACAO_CODIGO == 'F').length ?? 0)
                $(`#txtItensDesistencia-${mesa.numeroAtendimento}`).html(mesa.itens.filter(item => item.SITUACAO_CODIGO == 'D').length ?? 0)
                $(`#txtItensMesa-${mesa.numeroAtendimento}`).html(mesa.itens.length)
                $(`#txtCreditoAberto-${mesa.numeroAtendimento}`).html(mesa.cliente.limiteCreditoDisponivel - mesa.cliente.limiteCredito)
                $(`#txtCCDisponivel-${mesa.numeroAtendimento}`).html(mesa.cliente.creditoGrupoDisponivel)
                $(`#txtLimiteCreditoDisponivel-${mesa.numeroAtendimento}`).html(mesa.cliente.limiteCreditoDisponivel)
                $(`#txtClassificacao-${mesa.numeroAtendimento}`).html(mesa.cliente.classificacao == '' ? 'Não possui' : mesa.cliente.classificacao)
                $(`#txtNomeCliente-${mesa.numeroAtendimento}`).html(`${mesa.cliente.codCli} - ${mesa.cliente.nome_Consumidor}`)
                $(`#txtRepresentante-${mesa.numeroAtendimento}`).html(`${mesa.vendedor} - ${mesa.nome_Vendedor}`)
                $(`#txtResponsavel-${mesa.numeroAtendimento}`).html(`${mesa.responsavel} - ${mesa.nome_responsavel}`)

                const valorTotal = mesa.itens.map((item) => {
                    return item.CORES.map((cor) => cor.VALOR_TOTAL).reduce((total, valor) => total + valor, 0);
                }).reduce((total, valor) => total + valor, 0);
                const total_desc = mesa.itens.map((item) => {
                    return item.CORES.map((cor) => TruncaDecimaisNova(2, cor.VALOR_DESC)).reduce((total, valor) => total + valor, 0);
                }).reduce((total, valor) => total + valor, 0);

                $(`#txtValorTotalPedido-${mesa.numeroAtendimento}`).val(formataEmDinheiro(valorTotal))
                $(`#total_desc-${mesa.numeroAtendimento}`).html(formataEmDinheiro(total_desc));
                $(`#total_orig-${mesa.numeroAtendimento}`).html(formataEmDinheiro(valorTotal));
                $(`#credito_cliente_saldo-${mesa.numeroAtendimento}`).html(formataEmDinheiro(mesa.cliente.limiteCreditoDisponivel - (valorTotal - total_desc)));
                $(`#subtotal_Pedido-${mesa.numeroAtendimento}`).html(formataEmDinheiro((valorTotal - total_desc) - mesa.cliente.limiteCreditoDisponivel));
                $(`#saldo_geral-${mesa.numeroAtendimento}`).html(formataEmDinheiro((valorTotal - total_desc) - mesa.cliente.limiteCreditoDisponivel));
                $(`#total_itensQuantidades-${mesa.numeroAtendimento}`).html(mesa.itens.length ?? 0);
                $(`#total_itensCarrinhos-${mesa.numeroAtendimento}`).html(mesa.itens.filter(item => item.SITUACAO_CODIGO == 'F').length ?? 0);

                mostraContador(mesa.dataInicio, mesa.numeroAtendimento, mesa.datasPendentes, mesa.statusPedido, mesa.tempo);


                $(`#btnCarrinho-${mesa.numeroAtendimento}`).on('click', async function () {
                    try {
                        if ($.fn.DataTable.isDataTable('#tabelaCarrinho')) {
                            $('#tabelaCarrinho').DataTable().rows().remove().draw(false);
                        }
                        $.LoadingOverlay('show');
                        $('#tabelaCarrinho').DataTable()
                        $('#modal-carrinho').modal('show');
                        await montaCarrinho()

                        setTimeout(() => {
                            $('#tabelaCarrinho').DataTable().columns.adjust().draw(false);
                        }, 200);

                    } finally {
                        $.LoadingOverlay('hide');

                    }
                })

                $(`#btnItensMesa-${mesa.numeroAtendimento}`).on('click', async function () {
                    try {
                        function adicionaItensPedido(itens) {
                            $(`#tabelaItensMesa-${mesa.numeroAtendimento}`).DataTable().row.add(itens).draw(false);
                            let $scrollBody = $($(`#tabelaItensMesa-${mesa.numeroAtendimento}`).DataTable().table().node()).parent();
                            $scrollBody.scrollTop($scrollBody.get(0).scrollHeight);
                        }

                        if ($.fn.DataTable.isDataTable(`#tabelaItensMesa-${mesa.numeroAtendimento}`)) {
                            $(`#tabelaItensMesa-${mesa.numeroAtendimento}`).DataTable().rows().remove().draw(false);
                        }

                        $.LoadingOverlay('show');

                        $(`#modal-ItensMesa-${mesa.numeroAtendimento}`).modal('show');

                        mesa.itens.forEach((item) => {
                            adicionaItensPedido(item);
                        });

                        setTimeout(() => {
                            $(`#tabelaItensMesa-${mesa.numeroAtendimento}`).DataTable().columns.adjust().draw(false);
                        }, 200);

                    } finally {
                        $.LoadingOverlay('hide');

                    }
                })

                $(`#tabelaItensMesa-${mesa.numeroAtendimento} tbody`).on('dblclick', 'tr', function () {
                    event.preventDefault()
                    $('#tabelaDesistenciaItem').DataTable().rows().remove().draw(false);

                    $(`#modal-ItensMesa-${mesa.numeroAtendimento}`).modal('hide');
                    const data = $(`#tabelaItensMesa-${mesa.numeroAtendimento}`).DataTable().row($(this)).data();
                    if (data.SITUACAO_CODIGO != 'D') {
                        msgAlerta('Item sem Desistência!');
                        return;
                    }
                    const desistencia = mesa.desistencias.filter((desistencia) => desistencia.CODIGO == data.CODIGO);
                    desistencia.forEach((item) => {
                        adicionaLinhaTabela(item, '#tabelaDesistenciaItem');
                    })
                    $('#modalDesistencia').modal('show');
                })


            })
        }

        await atualizaValores()
    }, 5000);

    $('#cbAoVivo').on('change', async function () {
        const pedidosNaoSalvos = await listaPedidosNaoSalvos();
        const objetosPedidos = await retornaPedidosNaoSalvos(pedidosNaoSalvos);
        criaCardMesas(objetosPedidos, true)

        if (isChecked('#cbAoVivo')) {
            $('#tipoConsulta').html('Ao Vivo');

        } else {
            $('#tipoConsulta').html('Pendentes');
        }

        $('.collapsePedidos').on('click', function () {
            if ($($(this).find('i')[0]).hasClass('fa-angle-down')) {
                $($(this).find('i')[0]).removeClass('fa-angle-down')
                $($(this).find('i')[0]).addClass('fa-angle-right')
            } else {
                $($(this).find('i')[0]).removeClass('fa-angle-right')
                $($(this).find('i')[0]).addClass('fa-angle-down')
            }
        })
    })

    $('#btnVoltar').on('click', async function () {
        $('#divTabelaAtendimentos').addClass('d-none');
        $('#cardMesasRetaguarda').removeClass('d-none');
        $('#tipoConsulta').html('Ao Vivo');
        $('#cbAoVivo').prop('disabled', false);
        $('#cbAoVivo').prop('checked', true);
        $('#cbAoVivo').trigger('change');
        $('#divBtnVoltar').addClass('d-none');
    })

    $('#btnConsultar').on('click', async function () {
        let dataSetCols = [];
        $('#cardMesasRetaguarda').addClass('d-none');
        $('#divTabelaAtendimentos').removeClass('d-none');
        $('#tipoConsulta').html('Fechados');
        $('#cbAoVivo').prop('disabled', true);
        $('#divBtnVoltar').removeClass('d-none');

        let where;
        where = pegaChave('#txtUsuarioConsulta') != '' ? ` AND USUARIO = '${$('#txtUsuarioConsulta').val()}'` : '';
        if ($("#txtDataDe").val() != "01-01-1200" || $$("#txtDataAte").val() != "01-12-2500") {
            where += ` AND DT_INICIO >= '${$("#txtDataDe").val()}' AND DT_FIM <= '${$("#txtDataAte").val()}'`;
        }
        const pesquisaParam = {
            tabela: "ATENDIMENTOSB2B",
            camposSelect: [
                'NUMERO_ATEND',
                'USUARIO',
                'TEMPO',
                'DT_INICIO',
                'DT_FIM',
                'STATUS',
                'PEDIDO',
                'AVALIACAO_OBS',
                'AVALIACAO_NOTA',
            ],
            where: [`1=1 ${where} AND STATUS = 'F'`],
        };

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
        if (jsonStr.length == 0) {
            msgAlerta('Nenhum registro encontrado!')
            return;
        }
        const keys = Object.keys(jsonStr[0]);

        for (let k in keys) {
            dataSetCols.push({
                'title': keys[k],
                'data': keys[k]
            });
        }

        dataSetCols[3].render = function (data, type, row) {
            var isIE = function () {
                if (/MSIE/i['test'](navigator['userAgent']) == true || /Edge/i['test'](navigator[
                    'userAgent']) == true) {
                    return true;
                } else {
                    return false;
                }
            }
            if (isIE()) {
                x = data.slice(0, 10).split('-');
                return x[2] + "/" + x[1] + "/" + x[0] + row['DT_INICIO'].slice('10');
            } else {
                x = data.slice(0, 10).split('-');
                return x[2] + "/" + x[1] + "/" + x[0] + row['DT_INICIO'].slice('10');
                return $.datepicker.formatDate("dd/mm/Y", new Date(data)) + row['DT_INICIO'].slice('10');
            }
        }
        dataSetCols[4].render = function (data, type, row) {
            var isIE = function () {
                if (/MSIE/i['test'](navigator['userAgent']) == true || /Edge/i['test'](navigator[
                    'userAgent']) == true) {
                    return true;
                } else {
                    return false;
                }
            }
            if (isIE()) {
                x = data.slice(0, 10).split('-');
                return x[2] + "/" + x[1] + "/" + x[0] + row['DT_FIM'].slice('10');
            } else {
                x = data.slice(0, 10).split('-');
                return x[2] + "/" + x[1] + "/" + x[0] + row['DT_FIM'].slice('10');
                return $.datepicker.formatDate("dd/mm/Y", new Date(data)) + row['DT_FIM'].slice('10');
            }
        }


        dataSetCols[8].render = function (data, type, row) {
            if (data == 1) {
                return '<i nota="1" class="reacaoAtendimento fas fa-sad-cry"></i>'
            }
            if (data == 2) {
                return '<i nota="2" class="reacaoAtendimento fas fa-sad-tear"></i>'

            }
            if (data == 3) {
                return '<i nota="3" class="reacaoAtendimento fas fa-smile"></i>'

            }
            if (data == 4) {
                return '<i nota="4" class="reacaoAtendimento fas fa-smile-wink"></i>'

            }
            if (data == 5) {
                return '<i nota="5" class="reacaoAtendimento fas fa-smile-beam"></i>'
            }
        }


        $('#tabelaAtendimentos').DataTable({
            paging: false,
            filter: false,
            info: true,
            order: true,
            destroy: true,
            "data": jsonStr,
            "columns": dataSetCols,
            "columnDefs": [{
                "targets": [],
                "visible": false
            }]
        });


        $("#modal-filtros").modal("hide");
    })

    function criaCardMesas(mesas, criaDoZero = false) {
        mesas.forEach((mesa, i = 1) => {

            if (criaDoZero) {
                $(`#finalizarPedido-${mesa.numeroAtendimento}`).removeClass('d-none');
                $('.collapsePedidos').on('click', function () {
                    if ($($(this).find('i')[0]).hasClass('fa-angle-down')) {
                        $($(this).find('i')[0]).removeClass('fa-angle-down')
                        $($(this).find('i')[0]).addClass('fa-angle-right')
                    } else {
                        $($(this).find('i')[0]).removeClass('fa-angle-right')
                        $($(this).find('i')[0]).addClass('fa-angle-down')
                    }
                })
            }
            if (isChecked('#cbAoVivo')) {
                if (mesa.statusPedido == 'P') {
                    $(`#finalizarPedido-${mesa.numeroAtendimento}`).addClass('d-none');
                    return;
                }
            } else {
                if (mesa.statusPedido == 'A') {
                    $(`#finalizarPedido-${mesa.numeroAtendimento}`).addClass('d-none');
                    return;
                }
            }

            if ($(`#finalizarPedido-${mesa.numeroAtendimento}`).length > 0) {
                return;
            }

            function retornaLocalPedido() {
                if ((!mesa.latitude) && (!mesa.longitude)) {
                    return;
                }
                const url = "https://maps.googleapis.com/maps/api/geocode/json?latlng=" + mesa.latitude + "," + mesa.longitude + "&key=AIzaSyB8Qo1OXHlFZX2Ses4Bol4oLHbcy22vPp0";
                fetch(url)
                    .then(function (response) {
                        return response.json();
                    })
                    .then(function (data) {
                        const address = data.results[0].formatted_address;
                        $(`#txtEndereco-${mesa.numeroAtendimento}`).html(address);
                    });
            }

            async function montaCarrinho() {
                const url = '/sisplan/pedidob2b/v1/montacarrinho?';
                const itens = { Itens: [] }

                mesa.itens.forEach((item) => {
                    item.CORES.forEach((item) => {
                        itens.Itens.push({
                            Codigo: item.CODIGO_ITEM,
                            Cor: item.COR,
                            Estoque: item.ESTOQUE,
                            Ordem_Compra: item.ORDEM_COMPRA,
                            Preco: item.PRECO,
                            Quantidade: item.QTDE,
                            Total: item.VALOR_TOTAL,
                        })
                    }
                    )
                })

                const response = await requisicao('POST', url, '', JSON.stringify(itens));

                if (!response) {
                    msgErro('Erro ao abrir o carrinho!');
                    return;
                }

                if (response.status != 200) {
                    msgErro('Erro ao abrir o carrinho!');
                    return;
                }

                const json = await response.json();
                console.log(json)

                $('#tabelaCarrinho').DataTable().rows().remove().draw(false)
                json.itens.map((item) => {
                    const row = {
                        ...item,
                        ordem_Compra: item.ordem_Compra ? 'Sim' : 'Não',
                    };
                    adicionaLinhaTabela(row, '#tabelaCarrinho');
                });
            }

            mostraContador(mesa.dataInicio, mesa.numeroAtendimento, mesa.datasPendentes, mesa.statusPedido, mesa.tempo);
            retornaLocalPedido();

            const nome = mesa.usuario.toLowerCase().split(".")[0];
            const sobrenome = mesa.usuario.toLowerCase().split(".")[1];
            const nomeCompleto = nome[0].toUpperCase() + nome.substr(1) + ' ' + sobrenome[0].toUpperCase() + sobrenome.substr(1);
            const html = /*html*/`
                    <div id="finalizarPedido-${mesa.numeroAtendimento}" class="mesasRetaguarda">
                        <div class="card card-header collapseHeader mb-0" role="tab">
                            <a style="width:100%;" class="collapsePedidos" data-toggle="collapse" data-parent="#collapsePedido-${mesa.numeroAtendimento}" href="#collapsePedido-${mesa.numeroAtendimento}" aria-expanded="true" aria-controls="collapseOne1">
                                <div class="headerMesas">
                                    <div class="d-flex align-items-center">
                                        <div class="iconCollapse" style="max-width:20px;margin-top:auto; margin-bottom: auto">
                                            <i class="fas fa-angle-right"></i>
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <!-- ${mesa.numeroAtendimento} -->
                                            <h5 class="tempoValor ml-2">Atendimento: ${mesa.numeroAtendimento}</h5>
                                            <h5 class="tempoValor ml-2">Usuário: ${nomeCompleto}</h5>
                                            <!-- ${nomeCompleto} -->
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center justify-content-end tempoValor" style="grid-gap: 10px;">
                                        <h6 class="timerVendaPedido mt-1 d-flex align-items-center justify-content-center">
                                            <i class="far fa-clock"></i><input class="inputContador" style="max-width: 70px;" disabled="true" type="text" name="" value="00:00:00" id="txtContador-${mesa.numeroAtendimento}" />
                                        </h6>
                                        <h6 class="timerVendaPedido mt-1 d-flex align-items-center justify-content-center">
                                            <i class="fas fa-dollar-sign"></i><input class="inputInvisivel" disabled="true" type="text" name="" value="R$ 00.00" id="txtValorTotalPedido-${mesa.numeroAtendimento}" />
                                        </h6>
                                    </div>
                                </div>
                            </a>
                        </div>

                        <div class="collapse" id="collapsePedido-${mesa.numeroAtendimento}">
                            <div class="card-body">
                                <div class="mainMesas row">
                                    <div class="col-6">
                                        <div class="lineInfo" title="Cliente">
                                            <i class="fas fa-user" style="width: 20px;"></i>
                                            <div class="infos">
                                                <span class="title-info">
                                                    Cliente:
                                                </span>
                                                <span id="txtNomeCliente-${mesa.numeroAtendimento}">
                                                    ${mesa.cliente.codCli} - ${mesa.cliente.nome_Consumidor}
                                                </span>
                                            </div>
                                        </div>
                                        <div class="lineInfo" title="Classificação">
                                            <i class="fas fa-list" style="width: 20px;"></i>
                                            <div class="infos">
                                                <span class="title-info">
                                                    Classificação:
                                                </span>
                                                <span id="txtClassificacao-${mesa.numeroAtendimento}">
                                                    ${mesa.cliente.classificacao == '' ? 'Não possui' : mesa.cliente.classificacao}
                                                </span>
                                            </div>
                                        </div>
                                        <div class="lineInfo" title="Responsável">
                                            <i class="fas fa-user-check" style="width: 20px;"></i>
                                            <div class="infos">
                                                <span class="title-info">
                                                    Responsável:
                                                </span>
                                                <span id="txtResponsavel-${mesa.numeroAtendimento}">
                                                    ${mesa.responsavel} - ${mesa.nome_responsavel}
                                                </span>
                                            </div>
                                        </div>
                                        <div class="lineInfo" title="Vendedor">
                                            <i class="fas fa-business-time" style="width: 20px;"></i>
                                            <div class="infos">
                                                <span class="title-info">
                                                    Vendedor:
                                                </span>
                                                <span id="txtRepresentante-${mesa.numeroAtendimento}">
                                                    ${mesa.vendedor} - ${mesa.nome_Vendedor}
                                                </span>
                                            </div>
                                        </div>
                                        <div class="lineInfo" title="Coordenador">
                                            <i class="fas fa-user-tie" style="width: 20px;"></i>
                                            <div class="infos">
                                                <span class="title-info">
                                                    Coordenador:
                                                </span>
                                                <span id="txtCoordenador-${mesa.numeroAtendimento}">
                                                    ${mesa.coordenador} - ${mesa.nome_coordenador}
                                                </span>
                                            </div>
                                        </div>


                                        <div class="lineInfo" title="Endereço">
                                            <i class="fas fa-map-marker-alt" style="width: 20px;"></i>

                                            <div class="infos">
                                                <span class="title-info">
                                                    Endereço:
                                                </span>
                                                <span id="txtEndereco-${mesa.numeroAtendimento}">
                                                </span>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-6">
                                        <!-- <div id="map-${mesa.numeroAtendimento}" style="width: 100%; height: 300px;"></div> -->
                                    </div>
                                    <div class="p-0 mt-2 col-12" style="margin-left: -10px; margin-right: -10px; border:none;">
                                        <div class="info-box " style="background-color: transparent!important;justify-content: flex-end; box-shadow: none;">
                                            <div class="" style="width: 100%; display: flex; justify-content: space-between; align-items: center; grid-gap: 5px;flex-wrap: wrap;">
                                                <div class="d-flex pointer" id="btnCarrinho-${mesa.numeroAtendimento}">
                                                    <div class="flex">
                                                        <span class="info-box-icon" style="width: 20px;"><i class="fas fa-cart-plus " style="font-size: 13px;"></i></span>
                                                        <div class="info-box-content">
                                                            <span class="info-box-text" style="font-size:13px">Carrinho</span>
                                                            <span id="total_itensCarrinhos-${mesa.numeroAtendimento}" class="info-box-number " style="font-size:13px">
                                                                ${mesa.itens.filter(item => item.SITUACAO_CODIGO == 'F').length ?? 0}
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="">
                                                    <div class="d-flex pointer" id="btnItensMesa-${mesa.numeroAtendimento}">
                                                        <div class="flex">
                                                            <span class="info-box-icon" style="width: 20px;"><i class="fas fa-luggage-cart " style="font-size: 13px;"></i></span>
                                                            <div class="info-box-content">
                                                                <span class="info-box-text" style="font-size:13px">Itens Mesa</span>

                                                                <span id="total_itensQuantidades-${mesa.numeroAtendimento}" class="info-box-number " style="font-size:13px">
                                                                    ${mesa.itens.length ?? 0}
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="">
                                                    <div class="flex">
                                                        <span class="info-box-icon" style="width: 20px;"><i class="fas fa-dollar-sign text-green" style="font-size: 13px;"></i></span>
                                                        <div class="info-box-content">
                                                            <span class="info-box-text " style="font-size:13px">Valor no Carrinho</span>
                                                            <span id="total_orig-${mesa.numeroAtendimento}" class="info-box-number " style="font-size:13px">
                                                                ${mesa.valorCarrinho ?? 0}
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="">
                                                    <div class="flex">
                                                        <span class="info-box-icon" style="width: 20px;"><i class="fas fa-dollar-sign text-red" style="font-size: 13px;"></i></span>
                                                        <div class="info-box-content">
                                                            <span class="info-box-text " style="font-size:13px">Total Desconto</span>
                                                            <span id="total_desc-${mesa.numeroAtendimento}" class="info-box-number " style="font-size:13px">
                                                                ${mesa.valorDesconto ?? 0}
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="">
                                                    <div class="flex">
                                                        <span class="info-box-icon" style="width: 20px;"><i class="fas fa-shopping-cart " style="font-size: 13px;"></i></span>
                                                        <div class="info-box-content ">
                                                            <span class="info-box-text " style="font-size:13px">SubTotal</span>
                                                            <span id="subtotal_Pedido-${mesa.numeroAtendimento}" class="info-box-number " style="font-size:13px">R$&nbsp;0,00</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="">
                                                    <div class="flex">
                                                        <span class="info-box-icon credito_cliente" style="width: 20px;">
                                                            <i class="fas fa-hand-holding-usd " style="font-size: 13px;"></i>
                                                        </span>
                                                        <div class="info-box-content credito_cliente">
                                                            <span class="info-box-text " style="font-size:13px">Crédito</span>
                                                            <span id="credito_cliente-${mesa.numeroAtendimento}" class="info-box-number " style="font-size:13px">R$&nbsp;0,00</span>
                                                            <div class="d-flex">
                                                                <span class="info-box-number " style="font-size:13px">Saldo:&nbsp;</span>
                                                                <span id="credito_cliente_saldo-${mesa.numeroAtendimento}" class="info-box-number text-green" style="font-size:13px">R$&nbsp;0,00</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="">
                                                    <div class="flex">
                                                        <span class="info-box-icon" style="width: 20px;"><i class="fas fa-equals " style="font-size: 13px;"></i></span>
                                                        <div class="info-box-content">
                                                            <span class="info-box-text " style="font-size:13px">Saldo</span>
                                                            <span id="saldo_geral-${mesa.numeroAtendimento}" class="info-box-number " style="font-size:13px">R$&nbsp;0,00</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    `

            $(`#cardMesasRetaguarda`).append(html);
            // var map;
            // var ajaxRequest;
            // var plotlist;
            // var plotlayers = [];

            // // Init Open Street Maps
            // function initmap() {
            //     // set up the map
            //     map = new L.Map(`map-${mesa.numeroAtendimento}`);
            //     var osmUrl = 'https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png';
            //     var osmAttrib = 'Map data © <a href="https://openstreetmap.org">OpenStreetMap</a> contributors';
            //     var osm = new L.TileLayer(osmUrl, { minZoom: 2, maxZoom: 19, attribution: osmAttrib });
            //     map.setView(new L.LatLng(mesa.latitude, mesa.longitude), 15);
            //     map.addLayer(osm);

            //     L.marker([mesa.latitude, mesa.longitude]).addTo(map);
            // }

            // initmap();

            $(`body`).append(`
                <div class="modal fade" id="modal-ItensMesa-${mesa.numeroAtendimento}" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-xl">
                        <div class="modal-content">
                            <div class="modal-header" style="border:none">
                                <h4 id="modal-simular-titulo" class="modal-title">Itens Mesa de Atendimento</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-12 table-responsive ">
                                        <table id="tabelaItensMesa-${mesa.numeroAtendimento}" style="width:100%;" width="100%" class="table table-sm table-select">
                                            <thead></thead>
                                            <tbody></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            `);

            var tabelaItensMesa = $(`#tabelaItensMesa-${mesa.numeroAtendimento}`).DataTable({
                paging: false,
                filter: false,
                info: false,
                order: false,
                destroy: true,
                "columns": dataSetColsItensMesa,
                "columnDefs": [{
                    "targets": [3, 4, 5, 6, 7, 8, 9, 10],
                    "visible": false
                },
                {
                    "targets": [2],
                    "width": '250px'
                }]
            });

            $(`#btnCarrinho-${mesa.numeroAtendimento}`).on('click', async function () {
                try {
                    if ($.fn.DataTable.isDataTable('#tabelaCarrinho')) {
                        $('#tabelaCarrinho').DataTable().rows().remove().draw(false);
                    }
                    $.LoadingOverlay('show');
                    $('#tabelaCarrinho').DataTable()
                    $('#modal-carrinho').modal('show');
                    await montaCarrinho()

                    setTimeout(() => {
                        $('#tabelaCarrinho').DataTable().columns.adjust().draw(false);
                    }, 200);

                } finally {
                    $.LoadingOverlay('hide');

                }
            })

            $(`#btnItensMesa-${mesa.numeroAtendimento}`).on('click', async function () {
                try {
                    function adicionaItensPedido(itens) {
                        $(`#tabelaItensMesa-${mesa.numeroAtendimento}`).DataTable().row.add(itens).draw(false);
                        let $scrollBody = $($(`#tabelaItensMesa-${mesa.numeroAtendimento}`).DataTable().table().node()).parent();
                        $scrollBody.scrollTop($scrollBody.get(0).scrollHeight);
                    }

                    if ($.fn.DataTable.isDataTable(`#tabelaItensMesa-${mesa.numeroAtendimento}`)) {
                        $(`#tabelaItensMesa-${mesa.numeroAtendimento}`).DataTable().rows().remove().draw(false);
                    }

                    $.LoadingOverlay('show');

                    $(`#modal-ItensMesa-${mesa.numeroAtendimento}`).modal('show');

                    mesa.itens.forEach((item) => {
                        adicionaItensPedido(item);
                    });

                    setTimeout(() => {
                        $(`#tabelaItensMesa-${mesa.numeroAtendimento}`).DataTable().columns.adjust().draw(false);
                    }, 200);

                } finally {
                    $.LoadingOverlay('hide');
                }
            })

            $(`#tabelaItensMesa-${mesa.numeroAtendimento} tbody`).on('dblclick', 'tr', function () {
                event.preventDefault()
                $('#tabelaDesistenciaItem').DataTable().rows().remove().draw(false);

                $(`#modal-ItensMesa-${mesa.numeroAtendimento}`).modal('hide');
                const data = $(`#tabelaItensMesa-${mesa.numeroAtendimento}`).DataTable().row($(this)).data();
                if (data.SITUACAO_CODIGO != 'D') {
                    msgAlerta('Item sem Desistência!');
                    return;
                }
                const desistencia = mesa.desistencias.filter((desistencia) => desistencia.CODIGO == data.CODIGO);
                desistencia.forEach((item) => {
                    adicionaLinhaTabela(item, '#tabelaDesistenciaItem');
                });
                $('#modalDesistencia').modal('show');
            });

            const valorTotal = mesa.itens.map((item) => {
                return item.CORES.map((cor) => cor.VALOR_TOTAL).reduce((total, valor) => total + valor, 0);
            }).reduce((total, valor) => total + valor, 0);
            const total_desc = mesa.itens.map((item) => {
                return item.CORES.map((cor) => TruncaDecimaisNova(2, cor.VALOR_DESC)).reduce((total, valor) => total + valor, 0);
            }).reduce((total, valor) => total + valor, 0);

            $(`#txtValorTotalPedido-${mesa.numeroAtendimento}`).val(formataEmDinheiro(valorTotal))
            $(`#total_desc-${mesa.numeroAtendimento}`).html(formataEmDinheiro(total_desc));
            $(`#total_orig-${mesa.numeroAtendimento}`).html(formataEmDinheiro(valorTotal));
            $(`#credito_cliente_saldo-${mesa.numeroAtendimento}`).html(formataEmDinheiro(mesa.cliente.limiteCreditoDisponivel - (valorTotal - total_desc)));
            $(`#subtotal_Pedido-${mesa.numeroAtendimento}`).html(formataEmDinheiro((valorTotal - total_desc) - mesa.cliente.limiteCreditoDisponivel));
            $(`#saldo_geral-${mesa.numeroAtendimento}`).html(formataEmDinheiro((valorTotal - total_desc) - mesa.cliente.limiteCreditoDisponivel));
        });

        $('.informacoes').on('click', function () {
            if ($($(this).find('i')[0]).hasClass('fa-angle-down')) {
                $($(this).find('i')[0]).removeClass('fa-angle-down')
                $($(this).find('i')[0]).addClass('fa-angle-up')
            } else {
                $($(this).find('i')[0]).removeClass('fa-angle-up')
                $($(this).find('i')[0]).addClass('fa-angle-down')
            }
        })
    }

    $("#btnFiltros").on("click", async function () {
        $("#modal-filtros").modal("show");
    });

    $('#btnFecharDesistencia').on('click', function () {
        $('#modalDesistencia').modal('hide');
    })
});

