$('#tutorial').on('click', function () {
    if ($('.select2-selection__rendered').length > 0) {
        $('.select2-selection__rendered').css('z-index', '0')
    }
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([{
            element: '#campostour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para gerar o arquivo Sintegra.',
                position: 'top'
            }
        },
        {
            element: '#tutorialPeriodo',
            popover: {
                title: 'Período',
                description: 'Aqui informamos o período do arquivo.',
                position: 'top'
            }
        },
        {
            element: '#tutorialEstoque',
            popover: {
                title: 'Estoque',
                description: 'Aqui informamos o período do estoque do arquivo.',
                position: 'top'
            }
        },
        {
            element: '#tutorialModelo',
            popover: {
                title: 'Modelo',
                description: 'Aqui informamos o código modelo do documento fiscal.',
                position: 'top'
            }
        },
        {
            element: '#tutorialSetor',
            popover: {
                title: 'Setor',
                description: 'Aqui informamos os setores.',
                position: 'top'
            }
        },
        {
            element: '#tutorialFinalidade',
            popover: {
                title: 'Finalidade',
                description: 'Aqui informamos a Finalidade.',
                position: 'top'
            }
        },
        {
            element: '#tutorialOpcoes',
            popover: {
                title: 'Parâmetros Exportação',
                description: 'Aqui informamos os registros que serão gerados.',
                position: 'top'
            }
        },
        {
            element: '#gerar',
            popover: {
                title: 'Botão Gerar',
                description: 'Clique aqui para gerar o arquivo Sintegra.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    $('#txtSetor').pesquisa_variosServerside(1, '{ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
    $('#btnSetor').pesquisa_serversideSel('#txtSetor', `{ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Setor');

    $('#btnASetor').on('click', function () {
        $('#txtSetor').empty().trigger('change');
    });

    function ajustaDataAtualInputs() {
        let dataAtual = new Date()

        let primeiroDiaDoMes = new Date(dataAtual.getFullYear(), dataAtual.getMonth() - 1, 1);
        $('#txtPeriodoDe').val(primeiroDiaDoMes.toISOString().split('T')[0])
        $('#txtEstoqueDe').val(primeiroDiaDoMes.toISOString().split('T')[0])

        let ultimoDiaDoMes = new Date(dataAtual.getFullYear(), dataAtual.getMonth(), 0);
        $('#txtPeriodoAte').val(ultimoDiaDoMes.toISOString().split('T')[0]);
        $('#txtEstoqueAte').val(ultimoDiaDoMes.toISOString().split('T')[0]);
    }

    ajustaDataAtualInputs()

    async function buscaParamSIS670() {
        $.LoadingOverlay('show')
        try {
            let param670 = '';
            let response = await requisicao('GET',
                '/Sisplan/Funcoes/V1/pesquisa?',
                `JSON={ 
              "tabela":"EMP_PARAM", 
              "camposSelect":["EMP_PARAM.VALOR"], 
              "where": ["EMP_PARAM.EMPRESA = '${getCookie('empresa').substring(1)}' AND EMP_PARAM.TIPO = 'SIS' AND EMP_PARAM.CODIGO IN ('670')"]
            }`, null);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();
            if (response.status !== 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }
            if (jsonStr.RESULT[0].length > 0) {
                param670 = jsonStr.RESULT[0][0].VALOR;
            }

            return param670;
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    async function marcaRegistros() {
        let param670 = await buscaParamSIS670();
        // Inicio Primeira coluna
        $('#checkRegistro10').prop('checked', param670[0] == 'S')
        $('#checkRegistro10').prop('disabled', param670[0] != 'L')

        $('#checkRegistro11').prop('checked', param670[1] == 'S')
        $('#checkRegistro11').prop('disabled', param670[1] != 'L')

        $('#checkRegistro50').prop('checked', param670[2] == 'S')
        $('#checkRegistro50').prop('disabled', param670[2] != 'L')

        $('#checkRegistro51').prop('checked', param670[3] == 'S')
        $('#checkRegistro51').prop('disabled', param670[3] != 'L')

        $('#checkRegistro53').prop('checked', param670[4] == 'S')
        $('#checkRegistro53').prop('disabled', param670[4] != 'L')

        $('#checkRegistro54').prop('checked', param670[5] == 'S')
        $('#checkRegistro54').prop('disabled', param670[5] != 'L')

        $('#checkRegistro60M').prop('checked', param670[6] == 'S')
        $('#checkRegistro60M').prop('disabled', param670[6] != 'L')

        $('#checkRegistro60A').prop('checked', param670[7] == 'S')
        $('#checkRegistro60A').prop('disabled', param670[7] != 'L')

        $('#checkRegistro60D').prop('checked', param670[8] == 'S')
        $('#checkRegistro60D').prop('disabled', param670[8] != 'L')

        $('#checkRegistro60I').prop('checked', param670[9] == 'S')
        $('#checkRegistro60I').prop('disabled', param670[9] != 'L')
        // Fim primeira Coluna
        // Inicio Segunda coluna
        $('#checkRegistro60R').prop('checked', param670[10] == 'S')
        $('#checkRegistro60R').prop('disabled', param670[10] != 'L')

        $('#checkRegistro61').prop('checked', param670[11] == 'S')
        $('#checkRegistro61').prop('disabled', param670[11] != 'L')

        $('#checkRegistro61R').prop('checked', param670[12] == 'S')
        $('#checkRegistro61R').prop('disabled', param670[12] != 'L')

        $('#checkRegistro70').prop('checked', param670[13] == 'S')
        $('#checkRegistro70').prop('disabled', param670[13] != 'L')

        $('#checkRegistro74').prop('checked', param670[14] == 'S')
        $('#checkRegistro74').prop('disabled', param670[14] != 'L')

        $('#checkRegistro75').prop('checked', param670[15] == 'S')
        $('#checkRegistro75').prop('disabled', param670[15] != 'L')

        $('#checkRegistro85').prop('checked', param670[16] == 'S')
        $('#checkRegistro85').prop('disabled', param670[16] != 'L')

        $('#checkRegistro86').prop('checked', param670[17] == 'S')
        $('#checkRegistro86').prop('disabled', param670[17] != 'L')

        $('#checkRegistro88EAN').prop('checked', param670[18] == 'S')
        $('#checkRegistro88EAN').prop('disabled', param670[18] != 'L')

        $('#checkRegistro90').prop('checked', param670[19] == 'S')
        $('#checkRegistro90').prop('disabled', param670[19] != 'L')
        // Fim Segunda Coluna
    }

    await marcaRegistros();

    $("#gerar").click(async function () {
        $.LoadingOverlay("show");
        try {
            let sintegraClasse = {};

            sintegraClasse.PERIODOINICIAL = $('#txtPeriodoDe').val();
            sintegraClasse.PERIODOFINAL = $('#txtPeriodoAte').val();
            sintegraClasse.ESTOQUEINICIAL = $('#txtEstoqueDe').val();
            sintegraClasse.ESTOQUEFINAL = $('#txtEstoqueAte').val();
            sintegraClasse.SETOR = await formataListas($('#txtSetor').val().toString());

            if ($('#rd2B').prop('checked')) {
                sintegraClasse.CODIGOMODELO = '2B'
            } else if ($('#rd2C').prop('checked')) {
                sintegraClasse.CODIGOMODELO = '2C'
            } else if ($('#rd2D').prop('checked')) {
                sintegraClasse.CODIGOMODELO = '2D'
            }
            sintegraClasse.FINALIDADE = $('#rdNormal').prop('checked') ? '1' : '2'

            sintegraClasse.REGISTRO10 = $('#checkRegistro10').is(':checked')
            sintegraClasse.REGISTRO11 = $('#checkRegistro11').is(':checked')
            sintegraClasse.REGISTRO50 = $('#checkRegistro50').is(':checked')
            sintegraClasse.REGISTRO51 = $('#checkRegistro51').is(':checked')
            sintegraClasse.REGISTRO53 = $('#checkRegistro53').is(':checked')
            sintegraClasse.REGISTRO54 = $('#checkRegistro54').is(':checked')
            sintegraClasse.REGISTRO60M = $('#checkRegistro60M').is(':checked')
            sintegraClasse.REGISTRO60A = $('#checkRegistro60A').is(':checked')
            sintegraClasse.REGISTRO60D = $('#checkRegistro60D').is(':checked')
            sintegraClasse.REGISTRO60I = $('#checkRegistro60I').is(':checked')
            sintegraClasse.REGISTRO60R = $('#checkRegistro60R').is(':checked')
            sintegraClasse.REGISTRO61 = $('#checkRegistro61').is(':checked')
            sintegraClasse.REGISTRO61R = $('#checkRegistro61R').is(':checked')
            sintegraClasse.REGISTRO70 = $('#checkRegistro70').is(':checked')
            sintegraClasse.REGISTRO74 = $('#checkRegistro74').is(':checked')
            sintegraClasse.REGISTRO75 = $('#checkRegistro75').is(':checked')
            sintegraClasse.REGISTRO85 = $('#checkRegistro85').is(':checked')
            sintegraClasse.REGISTRO86 = $('#checkRegistro86').is(':checked')
            sintegraClasse.REGISTRO88EAN = $('#checkRegistro88EAN').is(':checked')
            sintegraClasse.REGISTRO90 = $('#checkRegistro90').is(':checked')

            let response = await requisicao(
                "POST",
                "/Sisplan/Cadastros/v1/sintegra?",
                `JSON=${encodeURIComponent(JSON.stringify(sintegraClasse))}`,
                null
            );
            
            if (!response) {
                return;
            }
            
            let jsonStr = await response.text();
            if (response.status != 200) {
                let jsonStr = await response.json();
                msgAlerta(jsonStr.mensagem);
            }
            
            if (response.status == 200) {
                toastr.success(
                    'Arquivo gerado com sucesso!',
                    'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            downloadArquivo(jsonStr)
                        },
                    }
                ).css({
                    "margin-top": "20%",
                    "width": "500px",
                    "max-width": "500px"
                });
            } else {
                return;
            }

        } catch (err) {
            console.error(err)
            msgAlerta('Não foi possivel gerar o arquivo, verifique!');
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    function downloadArquivo(pathRes) {
        const path = pathRes.replace(/\\/g, "/").split("/").pop();
        const name = path.split("/").pop();
        const url = `${BASE_URI}/SintegraArq/${name}`
        const a = document.createElement("a");
        a.href = url;
        a.download = name;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    }

});