$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta dos Usuários.",
          position: "right",
        },
      },
      {
        element: "#btnNovoUsuario",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para iniciar o cadastro de um Usuário",
          position: "right",
        },
      },
      {
        element: "#tabelaUsuarios",
        popover: {
          title: "Tabela Usuários",
          description: "Aqui estão todos os Usuários cadastrados.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("USUARIO");

  $('#txtUsuario').autocompleta(1, `JSON={ "tabela":"acesso_usuarios", "camposSelect":[ "codigo chave", "nome descricao"], "where": ["CODIGO <> '9999'"]}`);
  $('#btnUsuario').pesquisa('#txtUsuario', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"acesso_usuarios", "camposSelect":[ "CODIGO", "NOME"], "where": ["CODIGO <> '9999'"]}`, 'Pesquisa Usuários', 'acesso_usuarios');
  $('#btn-Limpa-usuario').on('click', function () {
    $('#txtUsuario').val('');
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item btn-editar" type="button" title="Editar">Editar</button>     ' +
      '    <button class="dropdown-item btn-excluir" type="button" title="Excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };


  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let url = '/sisplan/funcoes/v1/pesquisa?';
        let usuario = pegaChave('#txtUsuario') != '' ? `CODIGO = '${pegaChave('#txtUsuario')}'` : '';
        const ativo = $('#txtAtivo').val() != '' ? `ATIVO = '${$('#txtAtivo').val()}'` : '';
        let params = `JSON={ "tabela": "acesso_usuarios", "camposSelect": ["CODIGO", "NOME", "TIPO", "ATIVO"], "where": ["1=1", "CODIGO <> '9999'",  "${usuario}", "${ativo}"] }`;
        let dataSetCols = [];

        let response = await requisicao('GET', url, params);

        if (!response) {
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          console.log(jsonStr.RESULT[0].mensagem);
          return;
        }

        if (jsonStr.RESULT[0].length == '0') {
          $('#tabelaUsuarios').DataTable().clear().draw();
          return;
        }

        let keys = Object.keys(jsonStr.RESULT[0][0]);

        keys.forEach(k => {
          dataSetCols.push({
            'title': k,
            'data': k
          });
        });

        $('#tabelaUsuarios').DataTable({
          paging: false,
          filter: false,
          info: true,
          order: true,
          destroy: true,
          "data": jsonStr.RESULT[0],
          "columns": dataSetCols,
          "columnDefs": [
            {
              targets: [0], render: function (data, type, row) {
                return retornaBotaoOpcoes(data);
              }
            },
          ],
        });

        $('.btn-editar').on('click', async function () {
          try {
            if (permissaoUsuarioLogado.ALTERA == 'S') {
              let data = $('#tabelaUsuarios').DataTable().row($(this).parents('tr')).data();
              let usuarioLiberado = await liberarRegistro('ACESSO_USUARIOS', data.CODIGO);
              if (usuarioLiberado) {
                let codUsuario = btoa(data.CODIGO);
                window.location.href = `usuario/${codUsuario}`;
              }
            } else {
              msgAlertaSemConfirmacao("Sem permissão para alterar!");
            }
          } catch (error) {
            console.error();
          }
        });

        $('#tabelaUsuarios').on('dblclick', 'tr', async function () {
          try {
            if (permissaoUsuarioLogado.ALTERA == 'S') {
              let data = $('#tabelaUsuarios').DataTable().row($(this)).data();
              let usuarioLiberado = await liberarRegistro('ACESSO_USUARIOS', data.CODIGO);
              if (usuarioLiberado) {
                let codUsuario = btoa(data.CODIGO);
                window.location.href = `usuario/${codUsuario}`;
              }
            } else {
              msgAlertaSemConfirmacao("Sem permissão para alterar!");
            }
          } catch (error) {
            console.error();
          }
        });

        $('.btn-excluir').on('click', async function () {
          if (permissaoUsuarioLogado.EXCLUI == 'S') {
            let data = $('#tabelaUsuarios').DataTable().row($(this).parents('tr')).data();
            codigo = data.CODIGO;
            msgAlerta('Deseja realmente excluir esse usuário?', deletaUsuario);
          } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
          }
          
          async function deletaUsuario() {
            try {
              $.LoadingOverlay('show');
              try {
                url = '/sisplan/usuario/v1/usuario?';
                params = `CODIGO=${codigo}`;

                response = await requisicao('DELETE', url, params);

                if (!response) {
                  return;
                }

                if (response.status === 200) {

                  toastr.success(
                    'Usuário excluído com sucesso!',
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                      error: 'alert-error',
                      info: 'alert-info',
                      success: 'alert-success',
                      warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                      window.location.href = `${BASE_URI}/usuario`;
                    }
                  }
                  ).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px"
                  });
                } else {
                  jsonStr = await response.json();
                  msgErro(jsonStr.mensagem);
                }

              } catch (error) {
                console.error(error);
              }
            } finally {
              $.LoadingOverlay('hide');
            }
          }

        });

      } catch (error) {
        console.error(error);
      }

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
      atualizaTotais();
    }
  });

  function atualizaTotais() {
    let totalAtivos = 0;
    let totalBloqueados = 0;
    let valorTotal = $("#tabelaUsuarios").DataTable().rows().count();

    let array = $("#tabelaUsuarios").DataTable().rows().data();
    array.map(function (element) {
      if (element.ATIVO == "S") {
        totalAtivos++;
      }
      if (element.BLOQUEIO == "S") {
        totalBloqueados++;
      }
      return 0;
    });
    $("#txt_val_total").html(valorTotal);
    $("#txt_val_ativos").html(totalAtivos);
    $("#txt_val_bloqueados").html(totalBloqueados);
  }

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnConsultar').trigger('click');

  $('#btnNovoUsuario').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "usuario/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });



});