$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnNovoTipoVenda",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para iniciar o cadastro de um tipo de venda.",
          position: "right",
        },
      },
      {
        element: "#tabelaTipo",
        popover: {
          title: "Tabela Tipos de Venda",
          description: "Aqui estão os dados dos tipos de venda cadastrados.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});
$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("TIPOVENDA");

  $('#txtTipoVenda').autocompleta(1, `JSON={ "tabela":"VENDA_TIPO", "camposSelect":[ "ID CHAVE", "DESCRICAO"], "where": null}`);
  $('#btnTipoVenda').pesquisa('#txtTipoVenda', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"VENDA_TIPO", "camposSelect":[ "ID CODIGO", "DESCRICAO"]}`, "Pesquisa Tipo de Venda", 'VENDA_TIPO');
  $('#btnATipoVenda').on('click', function () { $('#txtTipoVenda').val(''); });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnLimparFiltros').on('click', async function () {
    $('#txtTipoVenda').val('');
  });

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await consultarTipo();
  });

  $('#btnNovoTipoVenda').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "tipovenda/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#tabelaTipo').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaTipo').DataTable().row($(this).parents('tr')).data();
      window.location.href = `tipovenda/${data.CODIGO}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaTipo').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaTipo').DataTable().row($(this)).data();
      window.location.href = `tipovenda/${data.CODIGO}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaTipo').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaTipo").DataTable().row($(this).parents("tr")).data().CODIGO;
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  await consultarTipo();

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  async function consultarTipo() {
    $.LoadingOverlay("show");
    try {

      let sWhere = ' 1 = 1 ';
      sWhere += pegaChave('#txtTipoVenda') != '' ? `AND ID = ${pegaChave('#txtTipoVenda')}` : '';

      const pesquisaParam = {
        tabela: 'VENDA_TIPO',
        camposSelect: ['ID CODIGO', 'DESCRICAO'],
        where: [sWhere]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      let dataSetCols = [
        { data: "CODIGO", title: "Código" },
        { data: "DESCRICAO", title: "Descrição" }
      ];

      let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      if (colunasInvisiveis == null || colunasInvisiveis.acessoCadTipoVenda == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadTipoVenda: ['EMPRESA'] }));
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      }

      $('#tabelaTipo').DataTable({
        destroy: true,
        lengthChange: true,
        paging: true,
        searching: true,
        scrollX: true,
        scrollY: '350px',
        "autoWidth": true,
        "data": jsonStr,
        "columns": dataSetCols,
        "columnDefs": [{
          targets: [0], render: function (data, type, row) {
            return retornaBotaoOpcoes(data);
          }
        }]
      });

      $('#tabelaTipo_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaTipo_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel').prop('title', 'Exportar')

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const dados = $("#tabelaTipo").DataTable().data().toArray();
        await exportaCSV("", "", undefined, null, 'Relatório da aba de acesso cadastro de Tipo de Venda', '', '', 999, false, false, dados);
      });

      $('#tabelaTipo').DataTable().columns().every(function () {
        if ((colunasInvisiveis.acessoCadTipoVenda).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaTipo').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      });
    });

    adicionaColunas(cols, colunasInvisiveis.acessoCadTipoVenda ?? ['EMPRESA']);
  });

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      removeColunasFixas(novasColunas, ["CODIGO"]);
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadTipoVenda: novasColunas }));

      $('#tabelaTipo').DataTable().columns().visible(true);

      $('#tabelaTipo').DataTable().columns().every(function () {
        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  });

  async function excluiRegistro(sCodigo) {
    $.LoadingOverlay('show');
    try {

      let response = await requisicao('DELETE', '/sisplan/cadastros/v1/vendatipo?', `ID=${encodeURIComponent(sCodigo)}`, null);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        $.LoadingOverlay('hide');
        let jsonStr = await response.json();
        msgErro(jsonStr.mensagem);
        return;
      }

      $.LoadingOverlay('hide');
      criaMensagemSucesso('Exclusão efetuada com sucesso!', () => { window.location.reload(); });

    } catch (error) {
      $.LoadingOverlay('hide');
      console.error(error);
    };
  }

});
