$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#campostuto",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtCodigo",
        popover: {
          title: "Código",
          description:
            "O campo de código é preenchido automaticamente após gravar o registro.",
          position: "top",
        },
      },
      {
        element: "#txtDescricao",
        popover: {
          title: "Descrição",
          description:
            "Neste campo adicionamos a descrição para o tipo de venda.",
          position: "top",
        },
      },
      {
        element: "#tabelaDataset",
        popover: {
          title: "Tabela DataSet",
          description:
            "Caso inclua algum dataSet, será listado na tabela abaixo.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#btnGravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar o preço.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $('#msform').validate({
    debug: false,
    ignore: '',
    rules: {
      txtDescricao: {
        required: true,
      },
      txtTipoVenda: {
        required: true,
      },
    },
    messages: {
      txtDescricao: {
        required: 'Informe uma descrição válida.',
      },
      txtTipoVenda: {
        required: 'Informe um tipo de venda válido.',
      },
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback');
      element.closest('.form-group').append(error);
    },
    highlight(element) {
      $(element).addClass('is-invalid');
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid');
    },
  });

  $('#btnTabelaPreco').pesquisa_serverside(['#txtTabelaPreco'], ["REGIAO"], ["DESCRICAO"], `{"tabela":"REGIAO", "camposSelect":["REGIAO", "DESCRICAO"], "where": ["LIBERADO = 'S'"]}`, 'Pesquisa de Tabela de Preço');
  $('#txtTabelaPreco').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":["REGIAO CHAVE, DESCRICAO DESCRICAO"], "where": ["LIBERADO = 'S'"]}`);
  $('#btnLimpaTabelaPreco').on('click', function () {
    $('#txtTabelaPreco').val('');
  });

  $('#txtMoeda').pesquisa_variosServerside(1, '{ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO" ], "where": null}', 'CODMOE', 'DESCRICAO');
  $('#btnMoeda').pesquisa_serversideSel('#txtMoeda', `{ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO"], "where": null}`, 'Pesquisa Moeda');
  $('#btnLimpaMoeda').on('click', function () {
    $('#txtMoeda').empty().trigger('change');
  });

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/tipovenda`;
  });

  $('#btnIncluir').on('click', function () {
    $('#txtCodDataset').val($('#tabelaDataset').DataTable().rows().data().length + 1);
    $('#modalDataset').modal('show');
  });

  $('#btnIdentar').on('click', function () {
    $(`#txtSelect`).val(window.sqlFormatter.format($(`#txtSelect`).val()));
  });

  $('#modalDataset').on('hidden.bs.modal', function (_) {
    limpaCampos();
  });

  $('#btnConfirmar').on('click', function () {
    const codigo = $('#txtCodDataset').val();
    const descricao = $('#txtDescDataset').val();
    const tpmsg = $('#rgTpMensagem').val();
    const msg = $('#txtMensagem').val();
    const sql = $('#txtSelect').val();
    if ([codigo, descricao, msg, sql].includes('')) {
      msgAlerta('Necessário preencher todos os campos para confirmar.');
      return;
    }
    addDataset(codigo, descricao, tpmsg, msg, sql);
  });

  $('#tabelaDataset').on('click', '#btnExcluir', function () {
    msgAlerta('Deseja mesmo excluir esse DataSet?', () => { excluiDataset($(this)); });
  });

  $('#tabelaDataset').on('click', '#btnEditar', function () {
    const dados = $('#tabelaDataset').DataTable().row($(this).parents('tr')).data();
    editaDataset(dados.ID_DATASET, dados.DESCRICAO, dados.TIPO_MSG, dados.MENSAGEM, dados.SQL);
  });

  $('#btnGravar').click(async function () {
    const validator = $('#msform').validate();
    validator.form();
    const erros = validator.numberOfInvalids();
    if (erros > 0) {
      return;
    }
    await gravaRegraVenda();
  });

  const regraVenda = $(window.location.href.split('/')).get(-1);

  criaTabelaDataSet();

  await carregaDados(regraVenda);

  function editaDataset(sCodigo, sDescricao, sTpMsg, sMsg, sSql) {
    $('#txtCodDataset').val(sCodigo);
    $('#txtDescDataset').val(sDescricao);
    $('#rgTpMensagem').val(sTpMsg).change();
    $('#txtMensagem').val(sMsg);
    $('#txtSelect').val(sSql);

    $('#modalDataset').modal('show');
  }

  function addDataset(sCodigo, sDescricao, sTpMsg, sMsg, sSql) {
    const dados = $('#tabelaDataset').DataTable().rows().data().toArray();
    const indice = dados.findIndex((dataSet) => dataSet.ID_DATASET == sCodigo);

    sSql = sSql.replaceAll('\n', ' ');
    if (indice != -1) {
      const dadosDataset = $('#tabelaDataset').DataTable().row(indice).data();
      dadosDataset.DESCRICAO = sDescricao;
      dadosDataset.MENSAGEM = sMsg;
      dadosDataset.SQL = sSql;
      dadosDataset.TIPO_MSG = sTpMsg;
      $('#tabelaDataset').DataTable().row(indice).data(dadosDataset).draw(false);

    } else {
      $('#tabelaDataset').DataTable().row.add({
        ID_DATASET: sCodigo,
        DESCRICAO: sDescricao,
        OPCOES: retornaBotaoOpcoes(),
        SQL: sSql,
        MENSAGEM: sMsg,
        TIPO_MSG: sTpMsg
      }).draw(false);
    }

    $('#modalDataset').modal('hide');
    limpaCampos();
  }

  function criaTabelaDataSet() {
    let dataSetCols = [
      { 'title': 'ID_DATASET', 'data': 'ID_DATASET', 'width': '100px' },
      { 'title': 'DESCRICAO', 'data': 'DESCRICAO' },
      { 'title': 'OPCOES', 'data': 'OPCOES', 'width': '130px' },
      { 'title': 'SQL', 'data': 'SQL' },
      { 'title': 'MENSAGEM', 'data': 'MENSAGEM' },
      { 'title': 'TIPO_MSG', 'data': 'TIPO_MSG' }
    ];
    criaDataTablePadrao('#tabelaDataset', false, false, false, false, true, false, '300px', null, dataSetCols, [3, 4, 5]);
  }

  function excluiDataset(element) {
    $('#tabelaDataset').DataTable().row(element.parents('tr')).remove().draw(false);

    $('#tabelaDataset').DataTable().rows().data().map((element, index) => {
      element.ID_DATASET = index + 1;
      $('#tabelaDataset').DataTable().row(index).data(element).draw(false);
    });
  }

  function retornaBotaoOpcoes() {
    return (
      '<div class="divBtnOpcoes"> ' +
      '    <button class="botaoOpcoes" type="button" title="Editar" id="btnEditar"><span class="fas fa-edit" style="color:green"></span></button>      ' +
      '    <button class="botaoOpcoes" type="button" title="Excluir" id="btnExcluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
      '   </div>'
    );
  }

  function limpaCampos() {
    $('#txtCodDataset').val('');
    $('#txtDescDataset').val('');
    $('#rgTpMensagem').val('A').change();
    $('#txtMensagem').val('');
    $('#txtSelect').val('');
  }

  async function carregaDados(sRegra) {
    if ((sRegra == '') || (sRegra == 'create')) {
      return;
    }

    $.LoadingOverlay('show');
    try {

      const pesquisaParam = {
        tabela: 'VENDA_TIPO',
        camposSelect: [
          'VENDA_TIPO.ID', 'VENDA_TIPO.DESCRICAO', 'VENDA_TIPO.ESTOQUE', 'VENDA_TIPO.FECHA_VENDA', 'VENDA_TIPO.EXCLUSAO_ITEM',
          'DATASET_REGRA.ID_DATASET', 'DATASET_REGRA.DESCRICAO DESC_DATASET', 'DATASET_REGRA.SQL', 'DATASET_REGRA.MENSAGEM',
          'DATASET_REGRA.TIPO_MSG', 'VENDA_TIPO.CONSIGNADO', 'VENDA_TIPO.TABELA', 'VENDA_TIPO.MOEDA', 'VENDA_TIPO.VENDA_PENDENTE'
        ],
        leftJoin: [
          { tabela: 'DATASET_REGRA', condicao: 'DATASET_REGRA.ID_REGRA = VENDA_TIPO.ID' }
        ],
        where: [`VENDA_TIPO.ID = ${sRegra}`]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      insereValor('#txtCodigo', sRegra);
      insereValor('#txtDescricao', jsonStr[0].DESCRICAO);
      insereValor('#txtTabelaPreco', jsonStr[0].TABELA, { tabela: 'REGIAO', campoBusca: 'DESCRICAO', campoWhere: 'REGIAO', valorWhere: jsonStr[0].TABELA });

      $('#checkEstoque').prop('checked', jsonStr[0].ESTOQUE == 'S');
      $('#checkFechaVenda').prop('checked', jsonStr[0].FECHA_VENDA == 'S');
      $('#checkConsignado').prop('checked', jsonStr[0].CONSIGNADO == 'S');
      $('#dropdown').val(jsonStr[0].EXCLUSAO_ITEM ?? 0);
      $('#dropdownvendapendente').val(jsonStr[0].VENDA_PENDENTE ?? 0);
      if (jsonStr[0].MOEDA) {
        const responseMoeda = await requisicao("GET", "/sisplan/funcoes/v1/pesquisa?", `JSON={"tabela": "MOEDA", "camposSelect": ["CODMOE", "DESCRICAO"], "where": ["CODMOE IN (${jsonStr[0].MOEDA})"]}`)

        if (!responseMoeda) {
          return;
        }

        const jsonMoeda = await responseMoeda.json();
        if (responseMoeda.status != 200) {
          msgAlerta(jsonMoeda.RESULT[0].mensagem);
          return;
        }

        await insereValorPesquisaVarios('txtMoeda', 'CODMOE', 'DESCRICAO', jsonMoeda.RESULT[0]);
      }

      if (!jsonStr[0].ID_DATASET) {
        return;
      }

      jsonStr.map((element) => {
        addDataset(element.ID_DATASET, element.DESC_DATASET, element.TIPO_MSG, element.MENSAGEM, element.SQL);
      });

    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function gravaRegraVenda() {
    $.LoadingOverlay('show');
    try {

      const codigoTipo = $('#txtCodigo').val() != '' ? $('#txtCodigo').val() : 0

      let arrDataSets = [];
      $('#tabelaDataset').DataTable().rows().data().map((element) => {
        arrDataSets.push({
          ID_REGRA: codigoTipo,
          ID_DATASET: element.ID_DATASET,
          DESCRICAO: element.DESCRICAO,
          SQL: element.SQL,
          MENSAGEM: element.MENSAGEM,
          TIPO_MSG: element.TIPO_MSG,
          IDENTIFICADOR: 'CLIENTE'
        });
      });

      const tipoVenda = {
        ID: codigoTipo,
        DESCRICAO: $('#txtDescricao').val().toUpperCase(),
        TABELA: pegaChave('#txtTabelaPreco'),
        MOEDA: await formataListas($('#txtMoeda').val().toString()),
        ESTOQUE: $('#checkEstoque').is(':checked') ? 'S' : 'N',
        FECHA_VENDA: $('#checkFechaVenda').is(':checked') ? 'S' : 'N',
        EXCLUSAO_ITEM: $('#dropdown').val(),
        VENDA_PENDENTE: $('#dropdownvendapendente').val(),
        CONSIGNADO: $('#checkConsignado').is(':checked') ? 'S' : 'N',
        DATASETS: arrDataSets
      };

      const response = await requisicao('POST', '/sisplan/cadastros/v1/vendatipo?', '', JSON.stringify(tipoVenda));

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      if (response.status != 200) {
        $.LoadingOverlay('hide');
        const jsonStr = await response.json();
        msgErro(jsonStr.mensagem);
        return;
      }

      criaMensagemSucesso('Cadastro efetuado com sucesso!', () => { window.location.href = `${BASE_URI}/tipovenda`; });
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $(".txtMoeda").click();
  $(".txtMoeda").click();

});
