function setCookie(cname, cvalue, exdays) {
    if (['idMaquina', 'serie_ecf', 'enviando_comando'].includes(cname)) {
        var d = new Date();
        d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
        var expires = "expires=" + d.toUTCString();
        document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
    } else {
        sessionStorage.setItem(cname, cvalue);
    }
}

function getCookie(cname) {
    if (['idMaquina', 'serie_ecf', 'enviando_comando'].includes(cname)) {
        var name = cname + "=";
        var decodedCookie = decodeURIComponent(document.cookie);
        var ca = decodedCookie.split(';');
        for (var i = 0; i < ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0) == ' ') {
                c = c.substring(1);
            }
            if (c.indexOf(name) == 0) {
                return c.substring(name.length, c.length);
            }
        }
        return "";
    } else {
        const localVar = sessionStorage.getItem(cname);
        if (localVar === null) {
            return '';
        } else {
            return localVar;
        }
    }
}

function deleteCookie(cname) {
    sessionStorage.removeItem(cname);
}